dnl Some useful autoconf macros
dnl
dnl This file is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU Lesser General Public License for more details.
dnl
dnl You should have received a copy of the GNU Lesser General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
dnl
dnl Copyright (C) 2000 Antoine Mine'



dnl ********
dnl Inlining (borrowed from glib's configure.in)
dnl ********

dnl MY_C_INLINE
dnl -----------
dnl set my_cv_hasinline, my_cv_has__inline and my_cv_has__inline__ if
dnl the C compiler supports inline, __inline or __inline__

AC_DEFUN(MY_C_INLINE,[
	AC_CACHE_CHECK(for __inline, my_cv_has__inline,
	[AC_TRY_COMPILE(,[
		__inline int foo () { return 0; }
		int main () { return foo (); }
	        ], my_cv_has__inline=yes, my_cv_has__inline=no)])

	AC_CACHE_CHECK(for __inline__, my_cv_has__inline__,
	[AC_TRY_COMPILE(,[
	        __inline__ int foo () { return 0; }
	        int main () { return foo (); }
	        ],my_cv_has__inline__=yes, my_cv_has__inline__=no)])

	AC_CACHE_CHECK(for inline, my_cv_hasinline,
	[AC_TRY_COMPILE(,[
	        inline int foo () { return 0; }
	        int main () { return foo (); }
	        ],my_cv_hasinline=yes,my_cv_hasinline=no)])
])


dnl ************************
dnl Assembly langage support
dnl ************************


dnl MY_TRY_AS(asm program,action if sucess,action if failure)
dnl ---------------------------------------------------------
dnl try to compile an assembly program
dnl you should have called MY_PROG_AS before

AC_DEFUN(MY_TRY_AS,[
	cat > conftest.s <<__EOF
$1
__EOF
	my_asm='$AS $ASFLAGS conftest.s -o conftest.${ac_objext} 1>&5'
	if { (eval echo configure:__oline__: \"$my_asm\") 1>&5; (eval $my_asm) 2>&5; };
	then
		rm -rf conftest*
		$2
	else
		echo "configure: failed program was:" >&5
		cat conftest.s >&5
		rm -rf conftest*
		$3
	fi
	rm -rf conftest*
])



dnl MY_RUN_AS(asm program,action if sucess,action if failure)
dnl ---------------------------------------------------------
dnl try to compile, link and execute an assembly program
dnl you should have called MY_PROG_AS before

AC_DEFUN(MY_RUN_AS,[
	cat > conftest.s <<__EOF
.globl main
main:
$1
__EOF
	my_asm='$AS $ASFLAGS conftest.s -o conftest.${ac_objext} 1>&5; ${CC-cc} $LDFLAGS conftest.${ac_objext} -o conftest${ac_exeext} 1>&5'
	if { (eval echo configure:__oline__: \"$my_asm\") 1>&5; (eval $my_asm) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
	then
		rm -rf conftest*
		$2
	else
		echo "configure: failed program was:" >&5
		cat conftest.s >&5
		rm -rf conftest*
		$3
	fi
	rm -rf conftest*
])



dnl MY_PROG_AS
dnl ----------
dnl set my_cv_as_working to yes if a working assembler is found
dnl set AS to point to the assembler
dnl you can then use "$AS $ASFLAGS toto.s -o toto.o" in your Makefile

AC_DEFUN(MY_PROG_AS,[
	if test x$AS = x; then
		AS="${CC-cc} -c"
	fi
	AC_SUBST(AS)
	AC_SUBST(ASFLAGS)
	AC_CACHE_CHECK(whether the assembler ($AS $ASFLAGS) works ............,
		my_cv_as_working,
		[MY_TRY_AS(,my_cv_as_working=yes,my_cv_as_working=no)])
])



dnl ***********
dnl MMX support
dnl ***********


dnl MY_AS_MMX
dnl ---------
dnl set my_cv_as_has_mmx if the assembler supports MMX instructions
dnl set my_cv_mmx_working if the host can execute MMX instructions
dnl you should have called MY_PROG_AS before

dnl Now inspired from mmx.h "MultiMedia eXtensions GCC interface library"
dnl First see if mmx instructions are supported by the assembler.
dnl Then try to find out wheather the host supports cpuid and mmx.

AC_DEFUN(MY_AS_MMX,[
	case $target in
	i?86*)
		AC_CACHE_CHECK(whether the assembler ($AS) supports MMX,
		my_cv_as_has_mmx,
		[MY_TRY_AS([
			cpuid
			psubusb %mm0, %mm0
		],my_cv_as_has_mmx=yes,my_cv_as_has_mmx=no)])

		AC_CACHE_CHECK(whether MMX instructions are working on host,
		my_cv_mmx_working,
		[MY_RUN_AS([
			pushl %ebx	
			pushf
			popl %eax
			orl  $ 0x200000, %eax
			push %eax
			popf
			pushf
			popl %eax
			testl $ 0x200000, %eax
			jz   no_mmx

			movl $ 1, %eax
			cpuid
			testl $ 0x800000, %edx
			jnz mmx

			no_mmx:
			movl $ 1, %eax
			popl %ebx
			ret
			mmx:
			movl $ 0, %eax
			popl %ebx
			ret
		],my_cv_mmx_working=yes,my_cv_mmx_working=no)]);;
	*) my_cv_as_has_mmx=no
	   my_cv_mmx_working=no;;
	esac
])



dnl ****************
dnl FireWire support
dnl ****************

dnl MY_FIREWIRE
dnl set my_cv_has_firewire if the host supports firewire device

AC_DEFUN(MY_FIREWIRE,[
	AC_CACHE_CHECK(whether the host supports firewire,
	my_cv_has_firewire,
	[
	if test -b /dev/raw1394; 
	then my_cy_has_firewire=yes
	else my_cv_has_firewire=no
	fi
	])
])



dnl ******************
dnl Compilation switch
dnl ******************


dnl MY_C_SWITCH(switch)
dnl -------------------
dnl try to compile and link a simple C program with the switch compile switch
dnl "${CC-cc} $CFLAGS $1 conftest.c -o conftest"
dnl sets my_cc_switch to switch if it worked
dnl my_cc_switch is not modified elsewhere

AC_DEFUN(MY_C_SWITCH,[
#	AC_MSG_CHECKING(for $1 as C compilation switch)
	cat > conftest.c <<__EOF
int main() { return 0;}
__EOF
	my_c='${CC-cc} $CFLAGS $1 conftest.c -o conftest${ac_exeext}'
	(eval echo configure:__oline__: \"$my_c\") 1>&5
	(eval $my_c 1>/dev/null 2>conftest.log)
	cat conftest.log 1>&5
	if grep <conftest.log "option" >/dev/null
	then
		my_cc_switch="$my_cc_switch"
#		AC_MSG_RESULT(no)
	else	
		my_cc_switch="$1"
#		AC_MSG_RESULT(yes)
	fi
	rm -rf conftest*
])



dnl MY_C_COMMENT
dnl ------------
dnl set my_cv_comment to the C compiler flag needed to support C++-style 
dnl comments

AC_DEFUN(MY_C_COMMENT,[
	AC_CACHE_VAL(my_cv_comment,[
	my_cc_switch=
	case ${CC-cc} in
	cc) MY_C_SWITCH(-xCC);;
	esac
	my_cv_comment=$my_cc_switch
	])
	echo "C++-style comment flag ............................ $my_cv_comment"
])


dnl MY_C_OPTIM
dnl ----------
dnl set my_cv_optim to the C compiler optimizing switches

AC_DEFUN(MY_C_OPTIM,[
	AC_CACHE_VAL(my_cv_optim,[

	my_cc_switch=

	MY_C_SWITCH(-O)   # everybody likes this
	MY_C_SWITCH(-O2)  # seems common


	case ${CC-cc} in
	gcc)
	# gcc
	MY_C_SWITCH(-O3 -ffast-math -funroll-loops -fstrength-reduce) # for gcc
	my_bak_switch=$my_cc_switch
	case $target in   # intel gcc
	i686*)  MY_C_SWITCH($my_bak_switch -m486)	
		MY_C_SWITCH($my_bak_switch -march=i486)
		MY_C_SWITCH($my_bak_switch -march=i586);;
# MY_C_SWITCH($my_bak_switch -march=i686);; 
	i586*) 	MY_C_SWITCH($my_bak_switch -m486)	
		MY_C_SWITCH($my_bak_switch -march=i486)
		MY_C_SWITCH($my_bak_switch -march=i586);; 
	i486*) 	MY_C_SWITCH($my_bak_switch -m486)	
		MY_C_SWITCH($my_bak_switch -march=i486);; 
	esac;;
	*)
	# other platforms
	case $target in
	*sparc*solaris*) MY_C_SWITCH(-xO4 -fsimple=2 -dalign -fsingle -xlibmil);; # cc
	i?86*solaris*) MY_C_SWITCH(-xO4 -nofstore -fsingle -xlibmil);; # cc
	*solaris*) MY_C_SWITCH(-xO4);; # cc
	*sunos*) MY_C_SWITCH(-fast -native -O4 -bsdmalloc)  # acc
		 MY_C_SWITCH(-O4 -dalign);; # cc
	*irix*5.*)  MY_C_SWITCH(-O2 -sopt,-r=3,-so=4,-o=5,-lo=s);; # cc
	*irix*6.*)  MY_C_SWITCH(-O2 -n32 -OPT:roundoff=3:IEEE_arithmetic=3);; # cc
	esac;;
	esac
	my_cv_optim=$my_cc_switch])
	echo "C optimization switchs ............................ $my_cv_optim"
])



dnl ***********
dnl Link switch
dnl ***********


dnl MY_LD_SWITCH(switch)
dnl --------------------
dnl try to compile and link a simple C program with the switch link switch
dnl "${CC-cc} $LDFLAGS $1 conftest.o -o conftest"
dnl set my_ld_switch to switch if it worked
dnl my_ld_switch is not modified elsewhere

AC_DEFUN(MY_LD_SWITCH,[
#	AC_MSG_CHECKING(for $1 as link (${CC-cc} $LDSWITCH) switch)
	cat > conftest.c <<__EOF
int main() { return 0;}
__EOF
	my_c='${CC-cc} $CCFLAGS -c conftest.c -o conftest.${ac_objext}; ${CC-cc} $1 $LDFLAGS conftest.${ac_objext} -o conftest${ac_exeext}'

	(eval echo configure:__oline__: \"$my_c\") 1>&5
	(eval $my_c 1>/dev/null 2>conftest.log)
	cat conftest.log 1>&5
	if grep <conftest.log "option" >/dev/null
	then
		my_ld_switch="$my_ld_switch"
#		AC_MSG_RESULT(no)
	else
		my_ld_switch="$1"
#		AC_MSG_RESULT(yes)
	fi
	rm -rf conftest*
])



dnl MY_SHARED
dnl ------------
dnl set my_cv_cc_shared and  my_cv_ld_shared to the switch needed by CC
dnl in order to compile and link shared libraries
dnl my_cv_ld_shared is set to unknown if it doesn't know how
dnl set my_cv_export to the switch needed by CC in order to build an
dnl executable that exports its symbol to any shared library it opens
dnl at run-time with dlopen

AC_DEFUN(MY_SHARED,[
	AC_CACHE_VAL(my_cv_cc_shared,[
	my_cc_switch=
	MY_C_SWITCH(-KPIC)
	MY_C_SWITCH(-fpic)
	my_cv_cc_shared=$my_cc_switch])
	echo "compile switch for shared library ................. $my_cv_cc_shared"
	AC_CACHE_VAL(my_cv_ld_shared,[
	my_ld_switch=unknown
	MY_LD_SWITCH(-G)
	MY_LD_SWITCH(-shared)
	my_cv_ld_shared=$my_ld_switch])
	echo "link switch for shared library ................... $my_cv_ld_shared"
	AC_CACHE_VAL(my_cv_export,[
	my_ld_switch=
	MY_LD_SWITCH(-rdynamic)
	my_cv_export=$my_ld_switch])
	echo "executable export siwtch ......................... $my_cv_export"
])



dnl MY_PTHREAD
dnl ----------
dnl set my_cv_cc_pthread and my_cv_ld_pthread to the switch needed by CC in 
dnl order to compile and link a program with pthreads
dnl you may still need to add the pthread library (use AC_SEARCH_LIBS)


AC_DEFUN(MY_PTHREAD,[
	AC_CACHE_VAL(my_cv_cc_pthread,[
	my_cc_switch=
	case $target in
	*freebsd*) MY_C_SWITCH(-D_THREAD_SAFE);;
	*solaris*)
		case ${CC-cc} in
		cc) MY_C_SWITCH(-mt);;
		esac;;
	esac
	my_cv_cc_pthread=$my_cc_switch])
	echo "compile switch for pthreads ....................... $my_cv_cc_pthread"
	AC_CACHE_VAL(my_cv_ld_pthread,[
	my_ld_switch=
	case $target in
	*freebsd*) MY_LD_SWITCH(-pthread);;
	esac
	my_cv_ld_pthread=$my_ld_switch])
	echo "link switch for pthreads ......................... $my_cv_ld_pthread"
])



dnl MY_GLIB
dnl -------
dnl set my_cv_glib_config to the name of the `glib-config` program

AC_DEFUN(MY_GLIB,[
	AC_CACHE_VAL(my_cv_glib_config,[
	my_cv_glib_config=unknown

	if eval glib-config-2.0 --version 2>/dev/null >/dev/null; then 
		my_cv_glib_config="glib-config-2.0"
	else
	if eval glib12-config --version 2>/dev/null >/dev/null; then 
		my_cv_glib_config="glib12-config"
	else
	if eval glib-config --version 2>/dev/null >/dev/null; then 
		my_cv_glib_config="glib-config"
	else
		echo "Glib needed."
		exit
	fi
	fi
	fi
	])
	echo "glib-config program ............................... $my_cv_glib_config"
])

