//
// $Id: PairTest.m,v 1.13 2007/03/06 20:42:21 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "PairTest.h"
#import <ObjectiveLib/Text.h>
#import <ObjectiveLib/DataOutStream.h>
#import <ObjectiveLib/DataInStream.h>
#import <ObjectiveLib/ObjectOutStream.h>
#import <ObjectiveLib/ObjectInStream.h>
#import "Number.h"
#if defined(OL_NO_OPENSTEP)
#import <ObjectiveLib/Reaper.h>
#else
#import <ObjectiveLib/Pair.h>
#import <Foundation/NSString.h>
#import <Foundation/NSArchiver.h>
#if defined(HAVE_KEYED_ARCHIVES)
#import <Foundation/NSKeyedArchiver.h>
#endif
#import <Foundation/NSData.h>
#import <Foundation/NSValue.h>
#endif
#if defined(__NEXT_RUNTIME__)
#import <objc/objc-class.h>
#endif

@implementation PairTest

#if !defined(OL_NO_OPENSTEP)
- (void) testCoding
{
    NSArchiver* archiver;
    NSNumber* one;
    NSMutableData* data;
    NSData* archData;
    OLPair* p;

    data = [[NSMutableData alloc] initWithCapacity: 50];
    archiver = [[NSArchiver alloc] initForWritingWithMutableData: data];
    one = [[NSNumber alloc] initWithInt: 1];
    p = [[OLPair alloc] initWithFirst: one second: @"one"];
    [one RELEASE];
    [archiver encodeRootObject: p];
    [archiver RELEASE];
    [p RELEASE];
    p = [NSUnarchiver unarchiveObjectWithData: data];
    [data RELEASE];
    if ([[p first] intValue] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %i", [[p first] intValue]];
    }
    if (![[p second] isEqual: @"one"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"one\", but got \"%s\"", [[p second] cString]];
    }
#if defined(HAVE_KEYED_ARCHIVES)
    one = [[NSNumber alloc] initWithInt: 2];
    [p setFirst: one];
    [one RELEASE];
    [p setSecond: @"two"];
    archData = [NSKeyedArchiver archivedDataWithRootObject: p];
    p = [NSKeyedUnarchiver unarchiveObjectWithData: archData];
    if ([[p first] intValue] != 2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2, but got %i", [[p first] intValue]];
    }
    if (![[p second] isEqual: @"two"])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"two\", but got \"%s\"", [[p second] cString]];
    }
#endif
}
#endif

- (void) testPairs
{
    CONSTSTR* one = @"one";
    CONSTSTR* two = @"two";
    OLPair* p;
    OLPair* p2;

    p = [[OLPair alloc] initWithFirst: one second: two];
    if (![[p first] isEqual: one])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"one\", but got \"%s\"", [[p first] cString]];
    }
    [p setFirst: two];
    if (![[p first] isEqual: two])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"two\", but got \"%s\"", [[p first] cString]];
    }
    [p setFirst: one];
    if (![[p second] isEqual: two])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"two\", but got \"%s\"", [[p first] cString]];
    }
    [p setSecond: one];
    if (![[p second] isEqual: one])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"one\", but got \"%s\"", [[p first] cString]];
    }
    [p setSecond: two];
    p2 = [p copy];
    if (![[p2 first] isEqual: one])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"one\", but got \"%s\"", [[p2 first] cString]];
    }
    if (![[p2 second] isEqual: two])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"two\", but got \"%s\"", [[p2 first] cString]];
    }
    if (![p isEqual: p2])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The pairs should be equal"];
    }
    [p RELEASE];
    [p2 RELEASE];
}

- (void) testStreaming
{
    OLDataOutStream* dout;
    OLObjectOutStream* oout;
    OLObjectInStream* oin;
    OLPair* pair;
    OLPair* readPair;

    dout = REAP([OLDataOutStream stream]);
    oout = REAP([OLObjectOutStream streamWithOutStream: dout]);
    pair = [[OLPair alloc] initWithFirst: REAP([OLNumber numberWithInt: 1])
        second: REAP([OLText textWithCString: "one"])];
    [oout writeObject: pair];
    oin = REAP([OLObjectInStream streamWithInStream:
        REAP([OLDataInStream streamWithBytes: [dout bytes] count: [dout count]])]);
    readPair = REAP([oin readObject]);
    if (![readPair IS_MEMBER_OF: [OLPair class]])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected OLPair class, but got %s", ((Class)[readPair class])->name];
    }
    if ([[readPair first] intValue] != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %i", [[readPair first] intValue]];
    }
    if (![[readPair second] isEqual: REAP([OLText textWithCString: "one"])])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"one\", but got \"%s\"", [[readPair second] cString]];
    }
    if (![readPair isEqual: pair])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The pairs should be equal"];
    }
    [pair RELEASE];
}

@end
