//
// $Id: ObjectStreamTest.m,v 1.13 2007/03/28 03:16:53 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "ObjectStreamTest.h"
#import "Random.h"
#import <ObjectiveLib/DataOutStream.h>
#import <ObjectiveLib/DataInStream.h>
#import <ObjectiveLib/ObjectOutStream.h>
#import <ObjectiveLib/ObjectInStream.h>
#import <ObjectiveLib/Vector.h>
#import "Number.h"
#if defined(OL_NO_OPENSTEP)
#import <ObjectiveLib/Exception.h>
#import <ObjectiveLib/Reaper.h>
#else
#import <Foundation/NSException.h>
#import <Foundation/NSData.h>
#import <Foundation/NSValue.h>
#import <Foundation/NSString.h>
#endif
#if defined(__NEXT_RUNTIME__)
#import <objc/objc-class.h>
#endif
#import <string.h>
#import <stdlib.h>

@implementation ObjectStreamTest

- (void) testConvenienceAllocators
{
    OLDataOutStream* dout;
    OLObjectOutStream* oout;
    OLObjectInStream* oin;
    OLNumber* num;

    dout = REAP([OLDataOutStream stream]);
    oout = REAP([OLObjectOutStream streamWithOutStream: dout]);
    [oout writeObject: REAP([OLNumber numberWithInt: 75])];
    [oout close];
    oin = REAP([OLObjectInStream streamWithInStream:
        REAP([OLDataInStream streamWithBytes: [dout bytes] count: [dout count]])]);
    num = REAP([oin readObject]);
    if ([num intValue] != 75)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 75, but got %i", [num intValue]];
    }
}

#if !defined(OL_NO_OPENSTEP)
- (void) testEncodeBytes
{
    OLDataOutStream* dout;
    OLDataInStream* din;
    OLObjectOutStream* oout;
    OLObjectInStream* oin;
    uint8_t buf[10000];
    unsigned retLength;
    int i;
    uint8_t* retBuf = NULL;


    for (i = 0; i < 10000; i++)
        buf[i] = i % 256;
    dout = [[OLDataOutStream alloc] init];
    oout = [[OLObjectOutStream alloc] initWithOutStream: dout];
    TRY
        [oout encodeBytes: buf length: 10000];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    din = [[OLDataInStream alloc] initWithDataObject: [dout data]];
    [dout RELEASE];
    [oout RELEASE];
    oin = [[OLObjectInStream alloc] initWithInStream: din];
    TRY
        retBuf = [oin decodeBytesWithReturnedLength: &retLength];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    if (retLength != 10000)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 10000, but got %u", retLength];
    }
    if (memcmp(buf, retBuf, 10000) != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The arrays should be equal"];
    }
    [din RELEASE];
    [oin RELEASE];
}

- (void) testEncodeDataObject
{
    OLDataOutStream* dout;
    OLDataInStream* din;
    OLObjectOutStream* oout;
    OLObjectInStream* oin;
    NSMutableData* data;
    NSData* retData = nil;
    int i;
    uint8_t byte;

    data = [[NSMutableData alloc] init];
    for (i = 0; i < 100000; i++)
    {
        byte = OLRandom() % 256;
        [data appendBytes: &byte length: 1];
    }
    dout = [[OLDataOutStream alloc] init];
    oout = [[OLObjectOutStream alloc] initWithOutStream: dout];
    TRY
        [oout encodeDataObject: data];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    din = [[OLDataInStream alloc] initWithDataObject: [dout data]];
    [dout RELEASE];
    [oout RELEASE];
    oin = [[OLObjectInStream alloc] initWithInStream: din];
    TRY
        retData = [oin decodeDataObject];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    if (![data isEqual: retData])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The objects should be equal"];
    }
    [data RELEASE];
    [din RELEASE];
    [oin RELEASE];
}

- (void) testEncodeObjCTypes
{
    OLDataOutStream* dout;
    OLDataInStream* din;
    OLObjectOutStream* oout;
    OLObjectInStream* oin;
    char ch;
    short sh;
    int i;
    long l;
    long long ll;
    float f;
    double d;
    SEL s;
    char* str;
    uint8_t arr[] = { 0, 1, 2, 3 };
    int* pi;
    typedef struct __StructOne
    {
        int one;
        long two;
    } StructOne;
    typedef struct __StructTwo
    {
        struct __StructOne sone;
        float flt;
        double dbl;
    } StructTwo;
    struct __StructTwo s2;
    uint8_t readArr[4];

    dout = [[OLDataOutStream alloc] init];
    oout = [[OLObjectOutStream alloc] initWithOutStream: dout];
    ch = 42;
    [self logMessage: "Encoding: %s", @encode(char)];
    TRY
        [oout encodeValueOfObjCType: @encode(char) at: &ch];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    sh = 30000;
    [self logMessage: "Encoding: %s", @encode(short)];
    TRY
        [oout encodeValueOfObjCType: @encode(short) at: &sh];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    i = 1000000000;
    [self logMessage: "Encoding: %s", @encode(int)];
    TRY
        [oout encodeValueOfObjCType: @encode(int) at: &i];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    l = 1000000001L;
    [self logMessage: "Encoding: %s", @encode(long)];
    TRY
        [oout encodeValueOfObjCType: @encode(long) at: &l];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    ll = 5000000000LL;
    [self logMessage: "Encoding: %s", @encode(long long)];
    TRY
        [oout encodeValueOfObjCType: @encode(long long) at: &ll];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    f = 2.5;
    [self logMessage: "Encoding: %s", @encode(float)];
    TRY
        [oout encodeValueOfObjCType: @encode(float) at: &f];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    d = 4.2;
    [self logMessage: "Encoding: %s", @encode(double)];
    TRY
        [oout encodeValueOfObjCType: @encode(double) at: &d];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    s = @selector(testEncodeObjCTypes);
    [self logMessage: "Encoding: %s", @encode(SEL)];
    TRY
        [oout encodeValueOfObjCType: @encode(SEL) at: &s];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    str = "My dog has fleas";
    [self logMessage: "Encoding: %s", @encode(char*)];
    TRY
        [oout encodeValueOfObjCType: @encode(char*) at: &str];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    [self logMessage: "Encoding: %s", @encode(uint8_t[4])];
    TRY
        [oout encodeValueOfObjCType: @encode(uint8_t[4]) at: &arr];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    pi = &i;
    [self logMessage: "Encoding: %s", @encode(int*)];
    TRY
        [oout encodeValueOfObjCType: @encode(int*) at: &pi];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    s2.sone.one = 1;
    s2.sone.two = 2;
    s2.flt = 1.5;
    s2.dbl = 2.5;
    [self logMessage: "Encoding: %s", @encode(StructTwo)];
    TRY
        [oout encodeValueOfObjCType: @encode(StructTwo) at: &s2];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    din = [[OLDataInStream alloc] initWithDataObject: [dout data]];
    [dout RELEASE];
    [oout RELEASE];
    oin = [[OLObjectInStream alloc] initWithInStream: din];
    ch = 0;
    TRY
        [oin decodeValueOfObjCType: @encode(char) at: &ch];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    if (ch != 42)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 42, but got %i", ch];
    }
    sh = 0;
    TRY
        [oin decodeValueOfObjCType: @encode(short) at: &sh];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    if (sh != 30000)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 30000, but got %i", sh];
    }
    i = 0;
    TRY
        [oin decodeValueOfObjCType: @encode(int) at: &i];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    if (i != 1000000000)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1000000000, but got %i", i];
    }
    l = 0;
    TRY
        [oin decodeValueOfObjCType: @encode(long) at: &l];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    if (l != 1000000001)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1000000001, but got %li", l];
    }
    ll = 0;
    TRY
        [oin decodeValueOfObjCType: @encode(long long) at: &ll];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    if (ll != 5000000000LL)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 5000000000, but got %lli", ll];
    }
    f = 0.0;
    TRY
        [oin decodeValueOfObjCType: @encode(float) at: &f];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    if (f != 2.5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2.5, but got %g", f];
    }
    d = 0.0;
    TRY
        [oin decodeValueOfObjCType: @encode(double) at: &d];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    if (d != 4.2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 4.2, but got %g", d];
    }
    s = NULL;
    TRY
        [oin decodeValueOfObjCType: @encode(SEL) at: &s];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
#if defined(__NEXT_RUNTIME__)
    if (s != @selector(testEncodeObjCTypes))
#else
    if (!sel_eq(s, @selector(testEncodeObjCTypes)))
#endif
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The selector is not the same"];
    }
    TRY
        [oin decodeValueOfObjCType: @encode(char*) at: &str];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    if (strcmp(str, "My dog has fleas") != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"My dog has fleas\", but got \"%s\"", str];
    }
#if defined(__NEXT_RUNTIME__)
    free(str);
#endif
    TRY
        [oin decodeValueOfObjCType: @encode(uint8_t[4]) at: &readArr];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    if (memcmp(arr, readArr, 4) != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The arrays should be equal"];
    }
    TRY
        [oin decodeValueOfObjCType: @encode(int*) at: &pi];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    if (*pi != 1000000000)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1000000000, but got %i", *pi];
    }
#if defined(__NEXT_RUNTIME__)
    free(pi);
#endif
    s2.sone.one = 0;
    s2.sone.two = 0;
    s2.flt = 0.0;
    s2.dbl = 0.0;
    TRY
        [oin decodeValueOfObjCType: @encode(StructTwo) at: &s2];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    if (s2.sone.one != 1)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1, but got %i", s2.sone.one];
    }
    if (s2.sone.two != 2)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2, but got %li", s2.sone.two];
    }
    if (s2.flt != 1.5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 1.2, but got %g", s2.flt];
    }
    if (s2.dbl != 2.5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2.1, but got %g", s2.dbl];
    }
    [din RELEASE];
    [oin RELEASE];
}
#endif

- (void) testObjectReadWrite
{
    OLDataOutStream* dout;
    OLObjectOutStream* oout;
    OLDataInStream* din;
    OLObjectInStream* oin;
    OLText* readStr;
    OLText* writtenStr;
    OLNumber* num;
    int i = 0;
    int j;
    OLVector* nums;
    OLVector* written;
    id read;

    dout = [[OLDataOutStream alloc] init];
    oout = [[OLObjectOutStream alloc] initWithOutStream: dout];
    writtenStr = [[OLText alloc] initWithCString: "My dog has fleas"];
    TRY
        [oout writeObject: writtenStr];
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught %s: %s",
            EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    din = [[OLDataInStream alloc] initWithBytes: [dout bytes] count: [dout count]];
    [dout RELEASE];
    [oout RELEASE];
    oin = [[OLObjectInStream alloc] initWithInStream: din];
    readStr = REAP([oin readObject]);
    if (![readStr isEqual: writtenStr])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"My dog has fleas\", but got \"%s\"",
            [readStr cString]];
    }
    [din RELEASE];
    [oin RELEASE];
    [writtenStr RELEASE];
    dout = [[OLDataOutStream alloc] init];
    oout = [[OLObjectOutStream alloc] initWithOutStream: dout];
    nums = [[OLVector alloc] init];
    written = [[OLVector alloc] init];
    TRY
        for (i = 0; i < 10000; i++)
        {
                if ((i - 3) > 0)
                {
                    for (j = 0; j < 3; j++)
                    {
                        [written pushBack: [nums at: j]];
                        [oout writeObject: [written back]];
                    }
                    for (j = 2; j >= 1; j--)
                    {
                        [written pushBack: [nums at: [nums size] - j]];
                        [oout writeObject: [written back]];
                    }
                }
                num = [[OLNumber alloc] initWithInt: i];
                [nums pushBack: num];
                [written pushBack: num];
                [oout writeObject: [written back]];
                [num RELEASE];
        }
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught (at index %i) %s: %s",
            i, EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    [nums RELEASE];
    [self logMessage: "Wrote %u objects", [written size]];
    din = [[OLDataInStream alloc] initWithBytes: [dout bytes] count: [dout count]];
    [dout RELEASE];
    [oout RELEASE];
    oin = [[OLObjectInStream alloc] initWithInStream: din];
    TRY
        for (i = 0; i < 10000; i++)
        {
            read = REAP([oin readObject]);
            if (![read isEqual: [written at: i]])
            {
                [self errInFile: __FILE__ line: __LINE__
                    format: "Expected %i, but got %i",
                    [[written at: i] intValue],
                    [read intValue]];
            }
        }
    CATCH
        [self errInFile: __FILE__ line: __LINE__
            format: "Caught (at index %i) %s: %s",
            i, EXCEPTION_NAME, EXCEPTION_MESSAGE];
    END_CATCH
    [written RELEASE];
    [din RELEASE];
    [oin RELEASE];
}

- (void) testPrimitiveReadWrite
{
    OLDataOutStream* dout;
    OLObjectOutStream* oout;
    OLDataInStream* din;
    OLObjectInStream* oin;
    uint8_t bytes[] = { 0, 1, 2, 3 };
    uint8_t bytes2[4];
    uint8_t i8;
    uint16_t i16;
    uint32_t i32;
    uint64_t i64;
    int i;
    double d;
    float f;

    dout = [[OLDataOutStream alloc] init];
    oout = [[OLObjectOutStream alloc] initWithOutStream: dout];
    [oout writeBool: YES];
    [oout writeBool: NO];
    [oout writeByte: 42];
    [oout writeBytes: bytes count: 4];
    [oout writeDouble: 2.7];
    [oout writeFloat: 3.5];
    [oout writeInt: 74550];
    [oout writeInt16: 200];
    [oout writeInt32: 100000];
    [oout writeInt64: 5000000000LL];
    din = [[OLDataInStream alloc] initWithBytes: [dout bytes] count: [dout count]];
    [dout RELEASE];
    [oout RELEASE];
    oin = [[OLObjectInStream alloc] initWithInStream: din];
    if (![oin readBool])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected YES, but got NO"];
    }
    if ([oin readBool])
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected NO, but got YES"];
    }
    i8 = [oin readByte];
    if (i8 != 42)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 42, but got %i", i8];
    }
    i = [oin readBytes: bytes2 count: 4];
    if (i != 4)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 4, but got %i", i];
    }
    for (i = 0; i < 4; i++)
    {
        if (bytes[i] != bytes2[i])
        {
            [self errInFile: __FILE__ line: __LINE__
                format: "Expected %i, but got %i", bytes[i], bytes2[i]];
        }
    }
    d = [oin readDouble];
    if (d != 2.7)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 2.7, but got %g", d];
    }
    f = [oin readFloat];
    if (f != 3.5)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 3.5, but got %g", f];
    }
    i = [oin readInt];
    if (i != 74550)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 74550, but got %i", i];
    }
    i16 = [oin readInt16];
    if (i16 != 200)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 200, but got %i", i16];
    }
    i32 = [oin readInt32];
    if (i32 != 100000)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 100000, but got %i", i32];
    }
    i64 = [oin readInt64];
    if (i64 != 5000000000LL)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 5000000000, but got %lli", i64];
    }
    [din RELEASE];
    [oin RELEASE];
}

@end
