//
// $Id: Number.h,v 1.5 2007/03/06 20:42:21 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import <ObjectiveLib/ObjectBase.h>
#import <ObjectiveLib/Streamable.h>
#import <ObjectiveLib/Text.h>
#import <ObjectiveLib/Arithmetic.h>

#if !defined(OL_NO_OPENSTEP)
@class NSCoder;
#endif

typedef union
{
    BOOL        boolValue;
    int         intValue;
    unsigned    unsignedIntValue;
    double      doubleValue;
} OLNumberBlob;

typedef enum
{
    NumberType_Bool,
    NumberType_Double,
    NumberType_Int,
    NumberType_UnsignedInt
} OLNumberType;

@interface OLNumber :
#if defined(OL_NO_OPENSTEP)
    Object
#else
    NSObject
#endif
    <OLArithmetic>
{
@protected
    OLNumberBlob    blob;
    OLNumberType    type;
}

+ (id) numberWithBool: (BOOL)b;
+ (id) numberWithDouble: (double)d;
+ (id) numberWithInt: (int)i;

- (id) initWithBool: (BOOL)bul;
#if !defined(OL_NO_OPENSTEP)
- (id) initWithCoder: (NSCoder*)decoder;
#endif
- (id) initWithDouble: (double)dbl;
- (id) initWithInt: (int)i;
- (id) initWithObjectInStream: (OLObjectInStream*)stream;
- (id) initWithUnsignedInt: (unsigned)i;

- (id) arithmeticAdd: (id)value;
- (id) arithmeticDivideBy: (id)value;
- (id) arithmeticModulus: (id)value;
- (id) arithmeticMultiply: (id)value;
- (id) arithmeticNegate;
- (id) arithmeticSubtract: (id)value;
- (BOOL) boolValue;
- (int) compare: (id)other;
#if defined(OL_NO_OPENSTEP)
- (id) copy;
#else
- (id) copyWithZone: (NSZone*)zone;
#endif
- (double) doubleValue;
#if !defined(OL_NO_OPENSTEP)
- (void) encodeWithCoder: (NSCoder*)encoder;
#endif
- (unsigned) hash;
- (int) intValue;
- (BOOL) isEqual: (id)other;
- (OLText*) toText;
- (unsigned) unsignedIntValue;
- (void) writeSelfToStream: (OLObjectOutStream*)stream;

@end
