//
// $Id: LayeredStreamTest.m,v 1.6 2007/03/06 20:42:21 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "LayeredStreamTest.h"
#import "Number.h"
#import <ObjectiveLib/DataInStream.h>
#import <ObjectiveLib/DataOutStream.h>
#import <ObjectiveLib/ObjectInStream.h>
#import <ObjectiveLib/ObjectOutStream.h>
#if defined(OL_NO_OPENSTEP)
#import <ObjectiveLib/Reaper.h>
#endif
#if defined(__NEXT_RUNTIME__)
#define objc_get_class objc_getClass
#else
#import <objc/objc-api.h>
#endif

@implementation LayeredStreamTest

#define LST_SUCCESS 1000000

- (int) readData: (OLInStream*)stream
{
    int i;

    if ([stream IS_MEMBER_OF: [OLObjectInStream class]])
    {
        for (i = 0; i < 50000; i++)
        {
            if ([REAP([(OLObjectInStream*)stream readObject]) intValue] != i)
                return i;
        }
    }
    else
    {
        for (i = 0; i < 1000000; i++)
        {
            if ([stream readInt] != i)
                return i;
        }
    }
    return LST_SUCCESS;
}

- (void) runTestStreams: (const char**)streams
{
    OLDataOutStream* dout;
    OLOutStream* topOut;
    OLInStream* topIn;
    int i;
    int rc;
    unsigned count;
    const char* cur;
    char buf[256];

    for (count = 0, cur = streams[0]; cur != NULL; count++, cur = streams[count]);

    dout = REAP([OLDataOutStream stream]);
    topOut = dout;
    for (i = 0; i < count; i++)
    {
        sprintf(buf, "OL%sOutStream", streams[i]);
        topOut = REAP([objc_get_class(buf) streamWithOutStream: topOut]);
    }
    [self writeData: topOut];
    topIn = REAP([OLDataInStream streamWithBytes: [dout bytes] count: [dout count]]);
    for (i = 0; i < count; i++)
    {
        sprintf(buf, "OL%sInStream", streams[i]);
        topIn = REAP([objc_get_class(buf) streamWithInStream: topIn]);
    }
    rc = [self readData: topIn];
    if (rc != LST_SUCCESS)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Error reading data at index %i", rc];
    }
}

- (void) testBufferingObject
{
    const char* streams[] = { "Buffering", "Object", NULL };
    [self runTestStreams: streams];
}

- (void) testObjectBuffering
{
    const char* streams[] = { "Object", "Buffering", NULL };
    [self runTestStreams: streams];
}

#if defined(HAVE_BZLIB)

- (void) testBufferingBzlib
{
    const char* streams[] = { "Buffering", "Bzlib", NULL };
    [self runTestStreams: streams];
}

- (void) testBzlibBuffering
{
    const char* streams[] = { "Bzlib", "Buffering", NULL };
    [self runTestStreams: streams];
}

- (void) testBzlibBufferingObject
{
    const char* streams[] = { "Bzlib", "Buffering", "Object", NULL };
    [self runTestStreams: streams];
}

#endif

#if defined(HAVE_ZLIB)

- (void) testBufferingGzip
{
    const char* streams[] = { "Buffering", "Gzip", NULL };
    [self runTestStreams: streams];
}

- (void) testBufferingZlib
{
    const char* streams[] = { "Buffering", "Zlib", NULL };
    [self runTestStreams: streams];
}

- (void) testGzipBuffering
{
    const char* streams[] = { "Gzip", "Buffering", NULL };
    [self runTestStreams: streams];
}

- (void) testGzipBufferingObject
{
    const char* streams[] = { "Gzip", "Buffering", "Object", NULL };
    [self runTestStreams: streams];
}

- (void) testZlibBuffering
{
    const char* streams[] = { "Zlib", "Buffering", NULL };
    [self runTestStreams: streams];
}

- (void) testZlibBufferingObject
{
    const char* streams[] = { "Zlib", "Buffering", "Object", NULL };
    [self runTestStreams: streams];
}

#endif

- (void) writeData: (OLOutStream*)stream
{
    int i;

    if ([stream IS_MEMBER_OF: [OLObjectOutStream class]])
    {
        for (i = 0; i < 50000; i++)
            [(OLObjectOutStream*)stream writeObject: REAP([OLNumber numberWithInt: i])];
    }
    else
    {
        for (i = 0; i < 1000000; i++)
            [stream writeInt: i];
    }
    [stream close];
}

@end
