//
// $Id: FileStreamTest.m,v 1.9 2007/04/15 23:33:01 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "FileStreamTest.h"
#import <ObjectiveLib/FileOutStream.h>
#import <ObjectiveLib/FileInStream.h>
#if defined(OL_NO_OPENSTEP)
#import <ObjectiveLib/Reaper.h>
#else
#import <Foundation/NSString.h>
#endif
#import <string.h>
#import <unistd.h>
#import <limits.h>

@implementation FileStreamTest

- (void) testConvenienceAllocators
{
    OLFileOutStream* fout;
    OLFileInStream* fin;
    uint32_t val;

    fout = REAP([OLFileOutStream streamWithPath: "allocateme.filetest"]);
    [fout writeInt32: 32];
    [fout close];
    fin = REAP([OLFileInStream streamWithPath: "allocateme.filetest"]);
    val = [fin readInt32];
    if (val != 32)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 32, but got %u", val];
    }
    unlink("allocateme.filetest");
}

- (void) testFileStreams
{
    OLFileOutStream* fout;
    OLFileInStream* fin;
    unsigned streamCount;
    uint8_t readBuf[100];

    fout = [[OLFileOutStream alloc] initWithPath: "howdy.filetest"];
    streamCount = [fout writeBytes: (const uint8_t*)"my dog has fleas" count: 16];
    if (streamCount != 16)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 16, but got %u", streamCount];
    }
    [fout RELEASE];
    fout = [[OLFileOutStream alloc] initWithPath: "howdy.filetest" append: YES];
    streamCount = [fout writeBytes: (const uint8_t*)" and so do I" count: 12];
    if (streamCount != 12)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 12, but got %u", streamCount];
    }
    // Check to make sure the combination of close and RELEASE also works
    [fout close];
#if defined(OL_WINDOWS)
    if ([fout fileDescriptor] != INVALID_HANDLE_VALUE)
#else
    if ([fout fileDescriptor] >= 0)
#endif
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "The file descriptor should be invalid. Got %i",
            [fout fileDescriptor]];
    }
    [fout RELEASE];
    fin = [[OLFileInStream alloc] initWithPath: "howdy.filetest"];
    streamCount = [fin readBytes: readBuf count: 28];
    if (streamCount == UINT_MAX)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Should not have received end-of-file"];
    }
    else if (streamCount != 28)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected 28, but got %u", streamCount];
    }
    readBuf[streamCount] = 0;
    if (strcmp("my dog has fleas and so do I", (char*)readBuf) != 0)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected \"my dog has fleas and so do I\", but got \"%s\"", readBuf];
    }
    streamCount = [fin readBytes: readBuf count: 100];
    if (streamCount != UINT_MAX)
    {
        [self errInFile: __FILE__ line: __LINE__
            format: "Expected end-of-file"];
    }
    [fin RELEASE];
    unlink("howdy.filetest");
}

@end
