// $Id: CompositeUnitTest.m,v 1.12 2007/03/06 20:42:21 will_mason Exp $
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "CompositeUnitTest.h"
#import <string.h>
#if defined(__NEXT_RUNTIME__)
#import <objc/objc-class.h>
#endif

static BOOL parseName(const char* name, char* cls, char* mtd)
{
    int rc;

    rc = sscanf(name, " [ %s %[^]] ", cls, mtd);

    if (rc != 2)
    {
        strcpy(mtd, name);
        return NO;
    }
    return YES;
}

@implementation CompositeUnitTest

- (id) init
{
    return [self initWithOut: stdout err: stderr];
}

- (id) initWithOut: (FILE*)o err: (FILE*)e
{
    [super initWithOut: o err: e];
    unitTests = [[OLVector alloc] initWithCapacity: 32];
    return self;
}

#if defined(OL_NO_OPENSTEP)
- (id) free
#else
- (void) dealloc
#endif
{
    [unitTests RELEASE];
	SUPER_FREE;
}

- (void) addUnitTest: (UnitTest*)test
{
    [test setStreamOut: [self outStream] err: [self errStream]];
    [unitTests pushBack: test];
}

- (int) errorCount
{
    int count = [super errorCount];
    unsigned i;

    for (i = 0; i < [unitTests size]; i++)
        count += [[unitTests at: i] errorCount];
    return count;
}

- (BOOL) hasTestWithName: (const char*)test
{
    char cls[512];
    char mtd[512];
    BOOL result;
    id lookedUp;

    if (parseName(test, cls, mtd))
    {
        lookedUp = [self lookUpTestWithClass: cls name: mtd];
        result = (lookedUp == nil) ? NO : YES;
        FREE_AUTO(lookedUp);
        return result;
    }
    else
    {
        return [super hasTestWithName: mtd];
    }
}

- (void) listFailedTestsToStream: (FILE*)stream delimiter: (char)delim
{
    int i;
    int count = [unitTests size];
    int last = count - 1;

    [super listFailedTestsToStream: stream delimiter: delim];
    for (i = 0; i < count; i++)
    {
        [[unitTests at: i] listFailedTestsToStream: stream delimiter: delim];
        if (i != last)
            fputc(delim, stream);
    }
}

- (OLPair*) lookUpTestWithClass: (const char*)cls name: (const char*)name
{
    id current;
    Class myClass = [self class];
    id found;
    unsigned i;

    if (strcmp(myClass->name, cls) == 0)
        return [super lookUpTestWithName: name];
    for (i = 0; i < [unitTests size]; i++)
    {
		current = [unitTests at: i];
        if ([[unitTests at: i] IS_KIND_OF: myClass])
            found = [current lookUpTestWithClass: cls name: name];
        else
            found = [current lookUpTestWithName: name];
        if (found != nil)
        {
            if ([found IS_MEMBER_OF: [OLPair class]])
                return found;
            else
                return AUTORELEASE([[OLPair alloc] initWithFirst: current second: found]);
        }
    }
    return nil;
}

- (void) removeAllUnitTests
{
    [unitTests clear];
}

- (void) runAllTests
{
    unsigned i;

    [super runAllTests];
    for (i = 0; i < [unitTests size]; i++)
        [[unitTests at: i] runAllTests];
}

- (BOOL) runTestWithName: (const char*)name
{
    id current;
    char cls[512];
    char mtd[512];

    if (parseName(name, cls, mtd))
    {
        current = [self lookUpTestWithClass: cls name: mtd];
        if (current != nil)
        {
            [[current first] runTest: [current second]];
            FREE_AUTO(current);
            return YES;
        }
        else
        {
            return NO;
        }
    }
    else
    {
        return [super runTestWithName: name];
    }
}

- (void) setStreamOut: (FILE*)o err: (FILE*)e
{
    unsigned i;

    for (i = 0; i < [unitTests size]; i++)
        [[unitTests at: i] setStreamOut: o err: e];
}

- (int) testCount
{
    int count = [super testCount];
    unsigned i;

    for (i = 0; i < [unitTests size]; i++)
        count += [[unitTests at: i] testCount];
    return count;
}

- (OLVector*) testListQualified: (BOOL)flag
{
    OLVector* allTests;
    OLVector* tmp;
    OLArrayIterator* allEnd;
    OLArrayIterator* curBegin;
    OLArrayIterator* curEnd;
    unsigned i;

    tmp = [super testListQualified: flag];
    allTests = [[OLVector alloc] initWithVector: tmp];
    FREE_AUTO(tmp);
    for (i = 0; i < [unitTests size]; i++)
    {
        tmp = [[unitTests at: i] testListQualified: flag];
        allEnd = [allTests end];
        curBegin = [tmp begin];
        curEnd = [tmp end];
        [allTests insertAt: allEnd from: curBegin to: curEnd];
        FREE_AUTO(curEnd);
        FREE_AUTO(curBegin);
        FREE_AUTO(allEnd);
        FREE_AUTO(tmp);
    }
    return AUTORELEASE(allTests);
}

@end
