//
// $Id: HashTable.h,v 1.16 2007/03/06 20:42:19 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#if !defined(HASHTABLE_OL_GUARD)
#define HASHTABLE_OL_GUARD

#include "Iterator.h"
#include "Vector.h"
#include "Functional.h"
#include "Pair.h"

typedef struct _OLHashTableNode
{
    struct _OLHashTableNode*    next;
    id                          value;
} OLHashTableNode;

@interface OLHashTable :
#if defined(OL_NO_OPENSTEP)
    Object
#else
    NSObject <NSCopying>
#endif
{
@protected
    OLVector*                       buckets;
#if defined(OL_NO_OPENSTEP)
    Object<OLBoolBinaryFunction>*   keyEqual;
#else
    NSObject<OLBoolBinaryFunction>* keyEqual;
#endif
    unsigned                        numElements;
}

- (id) initWithHashTable: (OLHashTable*)right;
#if defined(OL_NO_OPENSTEP)
- (id) initWithSize: (unsigned)sz equalFunc: (Object<OLBoolBinaryFunction>*)eq;
#else
- (id) initWithSize: (unsigned)sz equalFunc: (NSObject<OLBoolBinaryFunction>*)eq;
#endif
#if defined(OL_NO_OPENSTEP)
- (id) free;
#else
- (void) dealloc;
#endif

- (void) assign: (OLHashTable*)right;
- (OLHashIterator*) begin;
- (OLHashIterator*) beginImpl;
- (unsigned) bucketOfKey: (id)key;
- (unsigned) bucketOfKey: (id)key size: (unsigned)sz;
- (unsigned) bucketOfValue: (id)value;
- (unsigned) bucketOfValue: (id)value size: (unsigned)sz;
- (void) clear;
- (int) compare: (id)other;
#if defined(OL_NO_OPENSTEP)
- (id) copy;
#else
- (id) copyWithZone: (NSZone*)zone;
#endif
- (unsigned) count: (id)key;
- (void) destroyNode: (OLHashTableNode*)node;
- (BOOL) empty;
- (OLHashIterator*) end;
- (OLHashIterator*) endImpl;
- (OLPair*) equalRange: (id)key;
- (void) equalRangeImpl: (id)key first: (OLHashTableNode**)firstOut last: (OLHashTableNode**)lastOut;
- (void) erase: (OLHashIterator*)where;
- (void) eraseBucket: (unsigned)num from: (OLHashTableNode*)first to: (OLHashTableNode*)last;
- (void) eraseBucket: (unsigned)num to: (OLHashTableNode*)last;
- (void) eraseFrom: (OLHashIterator*)first to: (OLHashIterator*)last;
- (unsigned) eraseKey: (id)key;
- (OLHashIterator*) find: (id)key;
- (OLHashTableNode*) findImpl: (id)key;
- (OLHashIterator*) insertEqual: (id)value;
- (void) insertEqualFrom: (OLForwardIterator*)first to: (OLForwardIterator*)last;
- (OLHashIterator*) insertEqualImpl: (id)value needItor: (BOOL)needItor;
- (OLPair*) insertUnique: (id)value;
- (void) insertUniqueFrom: (OLForwardIterator*)first to: (OLForwardIterator*)last;
- (OLPair*) insertUniqueImpl: (id)value needPair: (BOOL)needPair;
- (BOOL) isEqualNonUnique: (id)object;
- (BOOL) isEqualUnique: (id)object;
#if defined(OL_NO_OPENSTEP)
- (Object<OLBoolBinaryFunction>*) keyEqual;
#else
- (NSObject<OLBoolBinaryFunction>*) keyEqual;
#endif
- (id) keyOfValue: (id)value;
- (unsigned) maxSize;
- (unsigned) nextSize: (unsigned)n;
- (OLHashTableNode*) newNode: (id)value;
- (void) resize: (unsigned)hint;
- (unsigned) size;
- (OLHashTableNode*) skipToNext: (id)value;
- (void) swap: (OLHashTable*)right;
- (unsigned) tableSize;
- (id) valueOfValue: (id)value;

@end

@interface OLHashTableMap : OLHashTable
{
}

- (void) assignEqualKey: (id)key value: (id)val;
- (void) assignUniqueKey: (id)key value: (id)val;
- (id) findValue: (id)key;
- (id) keyOfValue: (id)value;
- (id) valueOfValue: (id)value;

@end

#endif
