//
// $Id: HashFunction.c,v 1.3 2007/04/15 23:32:57 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#include "Config.h"
#include "ConfigPrivate.h"
#if defined(OL_HAVE_INTTYPES_H)
#include <inttypes.h>
#endif
#include <stddef.h>

#if defined(OL_X86_HARDWARE)
#define OL_GET_16(d) (*((const uint16_t*)(d)))
#else
#define OL_GET_16(d) ((((const uint8_t*)(d))[1] << UINT32_C(8)) + \
                       ((const uint8_t*)(d))[0])
#endif
         
uint32_t OLHash(const uint8_t* data, unsigned length)
{
    uint32_t hash = 0;
    uint32_t tmp;
    int rem;

    if (length > 0 && data != NULL)
    {
        rem = length & 3;
        length >>= 2;
        for ( ; length > 0; length--)
        {
            hash += OL_GET_16(data);
            tmp = (OL_GET_16(data + 2) << 11) ^ hash;
            hash = (hash << 16) ^ tmp;
            data += 4;
            hash += hash >> 11;
        }
        switch (rem)
        {
        case 3:
            hash += OL_GET_16(data);
            hash ^= hash << 16;
            hash ^= data[2] << 18;
            hash += hash >> 11;
            break;
        case 2:
            hash += OL_GET_16(data);
            hash ^= hash << 11;
            hash += hash >> 17;
            break;
        case 1:
            hash += *data;
            hash ^= hash << 10;
            hash += hash >> 1;
            break;
        }

        hash ^= hash << 3;
        hash += hash >> 5;
        hash ^= hash << 2;
        hash += hash >> 15;
        hash ^= hash << 10;
    }
    return hash;
}

