//
// $Id: Exception.m,v 1.6 2007/03/28 03:16:51 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "Exception.h"
#import "Macros.h"
#import "RunTime.h"
#import "Text.h"
#import "Exception.h"
#import "Synchronization.h"
#import <string.h>
#import <stdio.h>
#include <stdlib.h>

OLConstantString* const OLGenericException = @"OLGenericException";
OLConstantString* const OLInvalidArgumentException = @"OLInvalidArgumentException";

static OLThreadDataKey __catchInfoKey;
static OLOnceControl __exceptionOnce = OL_ONCE_INIT;

static void __initializeCatchInfoKey()
{
    OLCreateThreadDataKey(&__catchInfoKey);
}

void OLPushCatchInfo(OLCatchInfo* info)
{
    OLOnce(&__exceptionOnce, __initializeCatchInfoKey);
    info->next = OLGetThreadData(__catchInfoKey);
    OLSetThreadData(__catchInfoKey, info);
}

void OLPopCatchInfo()
{
    OLSetThreadData(__catchInfoKey,
        ((OLCatchInfo*)OLGetThreadData(__catchInfoKey))->next);
}

@implementation OLException

+ (void) raiseType: (const char*)nm message: (const char*)msg, ...
{
    va_list vargs;
    OLException* e;

    va_start(vargs, msg);
    e = [[OLException alloc] initWithType: nm message: msg arguments: vargs];
    va_end(vargs);
    [e raise];
}

+ (void) raiseTypeString: (OLConstantString*)nm messageString: (OLConstantString*)msg, ...
{
    va_list vargs;
    OLException* e;

    va_start(vargs, msg);
    e = [[OLException alloc]
        initWithType: [nm cString] message: [msg cString] arguments: vargs];
    va_end(vargs);
    [e raise];
}

- (id) initWithType: (const char*)nm message: (const char*)msg, ...
{
    va_list vargs;

    va_start(vargs, msg);
    [self initWithType: nm message: msg arguments: vargs];
    va_end(vargs);
    return self;
}

- (id) initWithType: (const char*)nm message: (const char*)msg arguments: (va_list)args
{
    char buf[1024];
    unsigned len;

    [super init];
    type = objc_malloc(strlen(nm) + 1);
    strcpy(type, nm);
    len = vsnprintf(buf, 1024, msg, args);
    message = objc_malloc(len + 1);
    if (len >= 1024)
        vsnprintf(message, len + 1, msg, args);
    else
        strcpy(message, buf);
    return self;
}

- (id) free
{
    objc_free(type);
    objc_free(message);
    SUPER_FREE;
}

- (const char*) message
{
    return message;
}

- (const char*) type
{
    return type;
}

- (void) raise
{
    OLCatchInfo* info;

    info = OLGetThreadData(__catchInfoKey);
    if (info == NULL)
    {
        fprintf(stderr, "*** Uncaught exception: %s - %s\n", type, message);
        fflush(stderr);
        abort();
    }
    OLPopCatchInfo();
    info->exception = self;
    longjmp(info->jumpInfo, 1);
}

@end
