//
// $Id: ByteOrder.h,v 1.8 2007/03/08 19:59:21 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#if !defined(BYTEORDER_OL_GUARD)
#define BYTEORDER_OL_GUARD

#include <ObjectiveLib/Config.h>
#if defined(OL_HAVE_INTTYPES_H)
#include <inttypes.h>
#else
#include <stdint.h>
#endif

#if defined(OL_BIG_ENDIAN)

#define H16_TO_N(val) val
#define H32_TO_N(val) val
#define H64_TO_N(val) val
#define N16_TO_H(val) val
#define N32_TO_H(val) val
#define N64_TO_H(val) val
#define H16_TO_L(val) OLSwap16(val)
#define H32_TO_L(val) OLSwap32(val)
#define L16_TO_H(val) OLSwap16(val)
#define L32_TO_H(val) OLSwap32(val)

#else

#define H16_TO_N(val) OLSwap16(val)
#define H32_TO_N(val) OLSwap32(val)
#define H64_TO_N(val) OLSwap64(val)
#define N16_TO_H(val) OLSwap16(val)
#define N32_TO_H(val) OLSwap32(val)
#define N64_TO_H(val) OLSwap64(val)
#define H16_TO_L(val) val
#define H32_TO_L(val) val
#define L16_TO_H(val) val
#define L32_TO_H(val) val

#endif

static inline uint16_t OLSwap16(uint16_t val)
{
    union OLSwappable16
    {
        uint16_t    value;
        uint8_t     bytes[2];
    } result = (union OLSwappable16)val;
    OL_FAST_SWAP(result.bytes[0], result.bytes[1]);
    return result.value;
}

static inline uint32_t OLSwap32(uint32_t val)
{
    union OLSwappable32
    {
        uint32_t    value;
        uint8_t     bytes[4];
    } result = (union OLSwappable32)val;
    OL_FAST_SWAP(result.bytes[0], result.bytes[3]);
    OL_FAST_SWAP(result.bytes[1], result.bytes[2]);
    return result.value;
}

static inline uint64_t OLSwap64(uint64_t val)
{
    union OLSwappable64
    {
        uint64_t    value;
        uint8_t     bytes[8];
    } result = (union OLSwappable64)val;
    OL_FAST_SWAP(result.bytes[0], result.bytes[7]);
    OL_FAST_SWAP(result.bytes[1], result.bytes[6]);
    OL_FAST_SWAP(result.bytes[2], result.bytes[5]);
    OL_FAST_SWAP(result.bytes[3], result.bytes[4]);
    return result.value;
}

#endif
