//
// $Id: BufferingInStream.m,v 1.9 2007/03/06 20:42:19 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#import "BufferingInStream.h"
#import "InStreamPackage.h"
#import "Macros.h"
#import "RunTime.h"
#import <string.h>
#import <limits.h>
#import <stdlib.h>

#define FREE_MY_RESOURCES \
    [self close]; \
    objc_free(buffer)

@implementation OLBufferingInStream

+ (id) streamWithInStream: (OLInStream*)underStream
{
    OL_BEGIN_AUTO_CTOR(OLBufferingInStream)
        initWithInStream: underStream
    OL_END_AUTO_CTOR;
}

- (id) initWithInStream: (OLInStream*)underStream
{
    return [self initWithInStream: underStream bufferSize: 32 * 1024];
}

- (id) initWithInStream: (OLInStream*)underStream bufferSize: (unsigned)size
{
    [super initWithInStream: underStream];
    buffer = objc_malloc(size);
    capacity = size;
    position = currentCount = 0;
    return self;
}

#if !defined(OL_NO_OPENSTEP)
- (void) dealloc
{
	FREE_MY_RESOURCES;
	SUPER_FREE;
}
#endif

#if defined(OL_NO_OPENSTEP)
- (void) freeStreamResources
{
	FREE_MY_RESOURCES;
	[super freeStreamResources];
}
#endif

- (uint8_t) readByte
{
    uint8_t byteRead;

    if (position != currentCount)
        byteRead = buffer[position++];
    else
        [self completelyReadBytes: &byteRead count: 1];
    return byteRead;
}

- (unsigned) readBytes: (uint8_t*)dest count: (unsigned)max
{
    unsigned available = currentCount - position;
    unsigned numRead;
    unsigned cur;

    if (max >= capacity)
    {
        if (available != 0)
            memcpy(dest, buffer + position, available);
        currentCount = position = 0;
        numRead = available;
        while (numRead < max)
        {
            cur = [stream readBytes: dest + numRead count: max - numRead];
            if (cur == UINT_MAX)
                break;
            numRead += cur;
        }
        if (available == 0 && numRead == 0)
            numRead = UINT_MAX;
    }
    else
    {
        if (available < max)
        {
            if (available != 0)
                memmove(buffer, buffer + position, available);
            position = 0;
            currentCount = available;
            while (currentCount < capacity)
            {
                numRead = [stream readBytes: buffer + currentCount count: capacity - currentCount];
                if (numRead == UINT_MAX)
                    break;
                currentCount += numRead;
            }
            available = currentCount;
        }
        if (currentCount == 0)
        {
            numRead = UINT_MAX;
        }
        else
        {
            numRead = MIN(available, max);
            memcpy(dest, buffer + position, numRead);
            position += numRead;
        }
    }
    return numRead;
}

@end
