/* Generated by re2c 0.15.3 on Fri Mar  8 21:20:07 2019 */
/**

	MultiMarkdown -- Lightweight markup processor to produce HTML, LaTeX, and more.

	@file opml-lexer.c

	@brief Tokenize OPML file for parsing


	@author	Fletcher T. Penney
	@bug

**/

/*

	Copyright © 2016 - 2019 Fletcher T. Penney.


	The `MultiMarkdown 6` project is released under the MIT License..

	GLibFacade.c and GLibFacade.h are from the MultiMarkdown v4 project:

		https://github.com/fletcher/MultiMarkdown-4/

	MMD 4 is released under both the MIT License and GPL.


	CuTest is released under the zlib/libpng license. See CuTest.c for the
	text of the license.

	uthash library:
		Copyright (c) 2005-2016, Troy D. Hanson

		Licensed under Revised BSD license

	miniz library:
		Copyright 2013-2014 RAD Game Tools and Valve Software
		Copyright 2010-2014 Rich Geldreich and Tenacious Software LLC

		Licensed under the MIT license

	argtable3 library:
		Copyright (C) 1998-2001,2003-2011,2013 Stewart Heitmann
		<sheitmann@users.sourceforge.net>
		All rights reserved.

		Licensed under the Revised BSD License


	## The MIT License ##

	Permission is hereby granted, free of charge, to any person obtaining
	a copy of this software and associated documentation files (the
	"Software"), to deal in the Software without restriction, including
	without limitation the rights to use, copy, modify, merge, publish,
	distribute, sublicense, and/or sell copies of the Software, and to
	permit persons to whom the Software is furnished to do so, subject to
	the following conditions:

	The above copyright notice and this permission notice shall be
	included in all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
	EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
	IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
	CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
	TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
	SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


	## Revised BSD License ##

	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions are
	met:
	    * Redistributions of source code must retain the above copyright
	      notice, this list of conditions and the following disclaimer.
	    * Redistributions in binary form must reproduce the above
	      copyright notice, this list of conditions and the following
	      disclaimer in the documentation and/or other materials provided
	      with the distribution.
	    * Neither the name of the <organization> nor the
	      names of its contributors may be used to endorse or promote
	      products derived from this software without specific prior
	      written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
	A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT
	HOLDER> BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
	EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES LOSS OF USE, DATA, OR
	PROFITS OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
	LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
	NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
	SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


*/

#include <stdlib.h>

#include "itmz-lexer.h"
#include "itmz-parser.h"


// Basic scanner struct

#define YYCTYPE		unsigned char
#define YYCURSOR	s->cur
#define YYMARKER	s->ptr
#define YYCTXMARKER	s->ctx

int itmz_scan(Scanner * s, const char * stop) {

scan:

	if (s->cur >= stop) {
		return 0;
	}

	s->start = s->cur;


	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy4;

			case '\r':
				goto yy6;

			case '<':
				goto yy7;

			default:
				goto yy2;
		}

yy2:
		++YYCURSOR;
yy3: {
			goto scan;
		}
yy4:
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy5045;
yy5: {
			return ITMZ_WSNL;
		}
yy6:
		yych = *++YYCURSOR;
		goto yy5045;
yy7:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);

		switch (yych) {
			case '/':
				goto yy8;

			case 'I':
			case 'i':
				goto yy12;

			case 'R':
			case 'r':
				goto yy10;

			case 'T':
			case 't':
				goto yy11;

			default:
				goto yy3;
		}

yy8:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'I':
			case 'i':
				goto yy5008;

			case 'R':
			case 'r':
				goto yy5010;

			case 'T':
			case 't':
				goto yy5009;

			default:
				goto yy9;
		}

yy9:
		YYCURSOR = YYMARKER;

		switch (yyaccept) {
			case 0:
				goto yy3;

			case 1:
				goto yy41;

			default:
				goto yy43;
		}

yy10:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy4994;

			default:
				goto yy9;
		}

yy11:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'O':
			case 'o':
				goto yy24;

			default:
				goto yy9;
		}

yy12:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy13;

			default:
				goto yy9;
		}

yy13:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'H':
			case 'h':
				goto yy14;

			default:
				goto yy9;
		}

yy14:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'O':
			case 'o':
				goto yy15;

			default:
				goto yy9;
		}

yy15:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'U':
			case 'u':
				goto yy16;

			default:
				goto yy9;
		}

yy16:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy17;

			default:
				goto yy9;
		}

yy17:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'H':
			case 'h':
				goto yy18;

			default:
				goto yy9;
		}

yy18:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy19;

			default:
				goto yy9;
		}

yy19:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'S':
			case 's':
				goto yy20;

			default:
				goto yy9;
		}

yy20:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '>':
				goto yy22;

			default:
				goto yy20;
		}

yy22:
		++YYCURSOR;
		{
			return ITMZ_ITHOUGHTS_OPEN;
		}
yy24:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'P':
			case 'p':
				goto yy25;

			default:
				goto yy9;
		}

yy25:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'I':
			case 'i':
				goto yy26;

			default:
				goto yy9;
		}

yy26:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'C':
			case 'c':
				goto yy27;

			default:
				goto yy9;
		}

yy27:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy29;

			case '\r':
				goto yy31;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy34;

			case 'S':
			case 's':
				goto yy28;

			case 'T':
			case 't':
				goto yy33;

			default:
				goto yy37;
		}

yy28:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy44;

			case '\r':
				goto yy46;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy34;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '=':
				goto yy50;

			case '>':
				goto yy4992;

			case 'T':
			case 't':
				goto yy52;

			default:
				goto yy37;
		}

yy29:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy29;

			case '\r':
				goto yy31;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy34;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy33;

			default:
				goto yy36;
		}

yy31:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy29;

			case '\r':
				goto yy31;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy34;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy33;

			default:
				goto yy36;
		}

yy33:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy44;

			case '\r':
				goto yy46;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy34;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '=':
				goto yy50;

			case 'E':
			case 'e':
				goto yy3154;

			case 'T':
			case 't':
				goto yy52;

			default:
				goto yy37;
		}

yy34:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy44;

			case '\r':
				goto yy46;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy34;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '=':
				goto yy50;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy52;

			default:
				goto yy36;
		}

yy36:
		++YYCURSOR;
		yych = *YYCURSOR;
yy37:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy38:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '/':
				goto yy38;

			case '>':
				goto yy42;

			default:
				goto yy36;
		}

yy40:
		++YYCURSOR;
yy41: {
			return ITMZ_TOPIC_OPEN;
		}
yy42:
		++YYCURSOR;
yy43: {
			return ITMZ_TOPIC_SELF_CLOSE;
		}
yy44:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy44;

			case '\r':
				goto yy46;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy50;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy3085;

			default:
				goto yy36;
		}

yy46:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy44;

			case '\r':
				goto yy46;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy50;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy3085;

			default:
				goto yy36;
		}

yy48:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy53;

			case '\r':
				goto yy55;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '/':
				goto yy38;

			case '=':
				goto yy57;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy60;

			default:
				goto yy36;
		}

yy50:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy50;

			case '\r':
				goto yy3002;

			case '"':
				goto yy3004;

			case '\'':
				goto yy3006;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy52:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy53;

			case '\r':
				goto yy55;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '=':
				goto yy57;

			case 'E':
			case 'e':
				goto yy59;

			case 'T':
			case 't':
				goto yy60;

			default:
				goto yy37;
		}

yy53:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy53;

			case '\r':
				goto yy55;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy57;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy85;

			default:
				goto yy36;
		}

yy55:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy53;

			case '\r':
				goto yy55;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy57;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy85;

			default:
				goto yy36;
		}

yy57:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy57;

			case '\r':
				goto yy3000;

			case '"':
				goto yy1302;

			case '\'':
				goto yy74;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy59:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy53;

			case '\r':
				goto yy55;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy48;

			case '=':
				goto yy57;

			case 'T':
			case 't':
				goto yy60;

			case 'X':
			case 'x':
				goto yy1867;

			default:
				goto yy37;
		}

yy60:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy53;

			case '\r':
				goto yy55;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '/':
				goto yy38;

			case '=':
				goto yy57;

			case '>':
				goto yy40;

			case 'E':
			case 'e':
				goto yy62;

			case 'T':
			case 't':
				goto yy60;

			default:
				goto yy36;
		}

yy62:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy53;

			case '\r':
				goto yy55;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy48;

			case '/':
				goto yy38;

			case '=':
				goto yy57;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy60;

			case 'X':
			case 'x':
				goto yy63;

			default:
				goto yy36;
		}

yy63:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy53;

			case '\r':
				goto yy55;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '/':
				goto yy38;

			case '=':
				goto yy57;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy64;

			default:
				goto yy36;
		}

yy64:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy65;

			case '\r':
				goto yy67;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '/':
				goto yy38;

			case '=':
				goto yy69;

			case '>':
				goto yy40;

			case 'E':
			case 'e':
				goto yy62;

			case 'T':
			case 't':
				goto yy60;

			default:
				goto yy36;
		}

yy65:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy65;

			case '\r':
				goto yy67;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy69;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy85;

			default:
				goto yy36;
		}

yy67:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy65;

			case '\r':
				goto yy67;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy69;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy85;

			default:
				goto yy36;
		}

yy69:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy69;

			case '\r':
				goto yy71;

			case '"':
				goto yy73;

			case '\'':
				goto yy74;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy71:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy69;

			case '\r':
				goto yy71;

			case '"':
				goto yy73;

			case '\'':
				goto yy74;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy73:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1304;

			default:
				goto yy1303;
		}

yy74:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy79;

			case '/':
				goto yy76;

			case '>':
				goto yy78;

			default:
				goto yy74;
		}

yy76:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy79;

			case '/':
				goto yy76;

			case '>':
				goto yy1301;

			default:
				goto yy74;
		}

yy78:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy929;
yy79:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy79;

			case '\r':
				goto yy81;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy85;

			default:
				goto yy36;
		}

yy81:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy79;

			case '\r':
				goto yy81;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy85;

			default:
				goto yy36;
		}

yy83:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy89;

			case '\r':
				goto yy91;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '/':
				goto yy38;

			case '=':
				goto yy93;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy87;

			default:
				goto yy36;
		}

yy85:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy89;

			case '\r':
				goto yy91;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy93;

			case 'E':
			case 'e':
				goto yy86;

			case 'T':
			case 't':
				goto yy87;

			default:
				goto yy37;
		}

yy86:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy89;

			case '\r':
				goto yy91;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy93;

			case 'T':
			case 't':
				goto yy87;

			case 'X':
			case 'x':
				goto yy563;

			default:
				goto yy37;
		}

yy87:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy89;

			case '\r':
				goto yy91;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '/':
				goto yy38;

			case '=':
				goto yy93;

			case '>':
				goto yy40;

			case 'E':
			case 'e':
				goto yy339;

			case 'T':
			case 't':
				goto yy87;

			default:
				goto yy36;
		}

yy89:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy89;

			case '\r':
				goto yy91;

			case '/':
				goto yy38;

			case '=':
				goto yy93;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy108;

			default:
				goto yy36;
		}

yy91:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy89;

			case '\r':
				goto yy91;

			case '/':
				goto yy38;

			case '=':
				goto yy93;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy108;

			default:
				goto yy36;
		}

yy93:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy93;

			case '\r':
				goto yy95;

			case '"':
				goto yy97;

			case '\'':
				goto yy99;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy95:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy93;

			case '\r':
				goto yy95;

			case '"':
				goto yy97;

			case '\'':
				goto yy99;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy97:
		++YYCURSOR;
		yych = *YYCURSOR;
yy98:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy104;

			case '/':
				goto yy333;

			case '>':
				goto yy335;

			default:
				goto yy97;
		}

yy99:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy104;

			case '/':
				goto yy101;

			case '>':
				goto yy103;

			default:
				goto yy99;
		}

yy101:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy104;

			case '/':
				goto yy101;

			case '>':
				goto yy332;

			default:
				goto yy99;
		}

yy103:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy267;
yy104:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy104;

			case '\r':
				goto yy106;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy108;

			default:
				goto yy36;
		}

yy106:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy104;

			case '\r':
				goto yy106;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy108;

			default:
				goto yy36;
		}

yy108:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy109;

			default:
				goto yy37;
		}

yy109:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'X':
			case 'x':
				goto yy110;

			default:
				goto yy37;
		}

yy110:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy111;

			default:
				goto yy37;
		}

yy111:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy111;

			case '\r':
				goto yy113;

			case '/':
				goto yy38;

			case '=':
				goto yy115;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy113:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy111;

			case '\r':
				goto yy113;

			case '/':
				goto yy38;

			case '=':
				goto yy115;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy115:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy115;

			case '\r':
				goto yy117;

			case '"':
				goto yy119;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy117:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy115;

			case '\r':
				goto yy117;

			case '"':
				goto yy119;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy119:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy120;

			default:
				goto yy37;
		}

yy120:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy121;

			default:
				goto yy37;
		}

yy121:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy122;

			default:
				goto yy37;
		}

yy122:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy123;

			default:
				goto yy37;
		}

yy123:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy124;

			default:
				goto yy37;
		}

yy124:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy125;

			default:
				goto yy37;
		}

yy125:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy126;

			default:
				goto yy37;
		}

yy126:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy127;

			default:
				goto yy37;
		}

yy127:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy128;

			case 'P':
			case 'p':
				goto yy129;

			default:
				goto yy37;
		}

yy128:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy197;

			default:
				goto yy37;
		}

yy129:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy130;

			default:
				goto yy37;
		}

yy130:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy131;

			default:
				goto yy37;
		}

yy131:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy132;

			default:
				goto yy37;
		}

yy132:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy133;

			default:
				goto yy37;
		}

yy133:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy134;

			default:
				goto yy37;
		}

yy134:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy135;

			default:
				goto yy37;
		}

yy135:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy136;

			default:
				goto yy37;
		}

yy136:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy137;

			default:
				goto yy37;
		}

yy137:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy138;

			default:
				goto yy37;
		}

yy138:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy139;

			default:
				goto yy37;
		}

yy139:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy140;

			default:
				goto yy37;
		}

yy140:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy141;

			default:
				goto yy37;
		}

yy141:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy142;

			default:
				goto yy37;
		}

yy142:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy143;

			default:
				goto yy37;
		}

yy143:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy144;

			default:
				goto yy37;
		}

yy144:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy145;

			default:
				goto yy37;
		}

yy145:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy146;

			case '\r':
				goto yy148;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy150;

			case '>':
				goto yy152;

			default:
				goto yy37;
		}

yy146:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy146;

			case '\r':
				goto yy148;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy150;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy148:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy146;

			case '\r':
				goto yy148;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy150;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy150:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy154;

			case '\r':
				goto yy156;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy150;

			case '/':
				goto yy38;

			case '=':
				goto yy158;

			case '>':
				goto yy152;

			default:
				goto yy36;
		}

yy152:
		++YYCURSOR;
yy153: {
			return ITMZ_TOPIC_PREAMBLE;
		}
yy154:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy154;

			case '\r':
				goto yy156;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy150;

			case '=':
				goto yy158;

			case '>':
				goto yy152;

			default:
				goto yy36;
		}

yy156:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy154;

			case '\r':
				goto yy156;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy150;

			case '=':
				goto yy158;

			case '>':
				goto yy152;

			default:
				goto yy36;
		}

yy158:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy158;

			case '\r':
				goto yy160;

			case '"':
				goto yy162;

			case '\'':
				goto yy164;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy160:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy158;

			case '\r':
				goto yy160;

			case '"':
				goto yy162;

			case '\'':
				goto yy164;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy162:
		++YYCURSOR;
		yych = *YYCURSOR;
yy163:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy167;

			case '/':
				goto yy194;

			case '>':
				goto yy193;

			default:
				goto yy162;
		}

yy164:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy167;

			case '/':
				goto yy169;

			case '>':
				goto yy166;

			default:
				goto yy164;
		}

yy166:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy175;
yy167:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy167;

			case '\r':
				goto yy191;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy150;

			case '>':
				goto yy152;

			default:
				goto yy36;
		}

yy169:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy167;

			case '/':
				goto yy169;

			case '>':
				goto yy171;

			default:
				goto yy164;
		}

yy171:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy175;
yy172:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy172;

			case '\r':
				goto yy176;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy179;

			case '>':
				goto yy178;

			default:
				goto yy9;
		}

yy174:
		++YYCURSOR;
		yych = *YYCURSOR;
yy175:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy172;

			default:
				goto yy174;
		}

yy176:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy172;

			case '\r':
				goto yy176;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy179;

			case '>':
				goto yy178;

			default:
				goto yy9;
		}

yy178:
		yych = *++YYCURSOR;
		goto yy153;
yy179:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy181;

			case '\r':
				goto yy183;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy179;

			case '=':
				goto yy185;

			case '>':
				goto yy178;

			default:
				goto yy9;
		}

yy181:
		++YYCURSOR;
		yych = *YYCURSOR;
yy182:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy181;

			case '\r':
				goto yy183;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy179;

			case '=':
				goto yy185;

			case '>':
				goto yy178;

			default:
				goto yy9;
		}

yy183:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy181;

			case '\r':
				goto yy183;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy179;

			case '=':
				goto yy185;

			case '>':
				goto yy178;

			default:
				goto yy9;
		}

yy185:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy185;

			case '\r':
				goto yy187;

			case '"':
				goto yy189;

			case '\'':
				goto yy174;

			default:
				goto yy9;
		}

yy187:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy185;

			case '\r':
				goto yy187;

			case '"':
				goto yy189;

			case '\'':
				goto yy174;

			default:
				goto yy9;
		}

yy189:
		++YYCURSOR;
		yych = *YYCURSOR;
yy190:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy172;

			default:
				goto yy189;
		}

yy191:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy167;

			case '\r':
				goto yy191;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy150;

			case '>':
				goto yy152;

			default:
				goto yy36;
		}

yy193:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy190;
yy194:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy167;

			case '/':
				goto yy194;

			case '>':
				goto yy196;

			default:
				goto yy162;
		}

yy196:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy190;
yy197:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy198;

			default:
				goto yy37;
		}

yy198:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy199;

			default:
				goto yy37;
		}

yy199:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy200;

			default:
				goto yy37;
		}

yy200:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy201;

			default:
				goto yy37;
		}

yy201:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy202;

			default:
				goto yy37;
		}

yy202:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy203;

			default:
				goto yy37;
		}

yy203:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy204;

			default:
				goto yy37;
		}

yy204:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy205;

			default:
				goto yy37;
		}

yy205:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy206;

			default:
				goto yy37;
		}

yy206:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy207;

			default:
				goto yy37;
		}

yy207:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy208;

			default:
				goto yy37;
		}

yy208:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy209;

			default:
				goto yy37;
		}

yy209:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy210;

			default:
				goto yy37;
		}

yy210:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy211;

			default:
				goto yy37;
		}

yy211:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy212;

			default:
				goto yy37;
		}

yy212:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy213;

			case '\r':
				goto yy215;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy217;

			case '>':
				goto yy219;

			default:
				goto yy37;
		}

yy213:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy213;

			case '\r':
				goto yy215;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy217;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy215:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy213;

			case '\r':
				goto yy215;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy217;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy217:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy221;

			case '\r':
				goto yy223;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy217;

			case '/':
				goto yy38;

			case '=':
				goto yy225;

			case '>':
				goto yy219;

			default:
				goto yy36;
		}

yy219:
		++YYCURSOR;
yy220: {
			return ITMZ_TOPIC_METADATA;
		}
yy221:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy221;

			case '\r':
				goto yy223;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy217;

			case '=':
				goto yy225;

			case '>':
				goto yy219;

			default:
				goto yy36;
		}

yy223:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy221;

			case '\r':
				goto yy223;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy217;

			case '=':
				goto yy225;

			case '>':
				goto yy219;

			default:
				goto yy36;
		}

yy225:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy225;

			case '\r':
				goto yy227;

			case '"':
				goto yy229;

			case '\'':
				goto yy231;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy227:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy225;

			case '\r':
				goto yy227;

			case '"':
				goto yy229;

			case '\'':
				goto yy231;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy229:
		++YYCURSOR;
		yych = *YYCURSOR;
yy230:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy234;

			case '/':
				goto yy261;

			case '>':
				goto yy260;

			default:
				goto yy229;
		}

yy231:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy234;

			case '/':
				goto yy236;

			case '>':
				goto yy233;

			default:
				goto yy231;
		}

yy233:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy242;
yy234:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy234;

			case '\r':
				goto yy258;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy217;

			case '>':
				goto yy219;

			default:
				goto yy36;
		}

yy236:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy234;

			case '/':
				goto yy236;

			case '>':
				goto yy238;

			default:
				goto yy231;
		}

yy238:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy242;
yy239:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy239;

			case '\r':
				goto yy243;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy246;

			case '>':
				goto yy245;

			default:
				goto yy9;
		}

yy241:
		++YYCURSOR;
		yych = *YYCURSOR;
yy242:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy239;

			default:
				goto yy241;
		}

yy243:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy239;

			case '\r':
				goto yy243;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy246;

			case '>':
				goto yy245;

			default:
				goto yy9;
		}

yy245:
		yych = *++YYCURSOR;
		goto yy220;
yy246:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy248;

			case '\r':
				goto yy250;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy246;

			case '=':
				goto yy252;

			case '>':
				goto yy245;

			default:
				goto yy9;
		}

yy248:
		++YYCURSOR;
		yych = *YYCURSOR;
yy249:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy248;

			case '\r':
				goto yy250;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy246;

			case '=':
				goto yy252;

			case '>':
				goto yy245;

			default:
				goto yy9;
		}

yy250:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy248;

			case '\r':
				goto yy250;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy246;

			case '=':
				goto yy252;

			case '>':
				goto yy245;

			default:
				goto yy9;
		}

yy252:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy252;

			case '\r':
				goto yy254;

			case '"':
				goto yy256;

			case '\'':
				goto yy241;

			default:
				goto yy9;
		}

yy254:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy252;

			case '\r':
				goto yy254;

			case '"':
				goto yy256;

			case '\'':
				goto yy241;

			default:
				goto yy9;
		}

yy256:
		++YYCURSOR;
		yych = *YYCURSOR;
yy257:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy239;

			default:
				goto yy256;
		}

yy258:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy234;

			case '\r':
				goto yy258;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy217;

			case '>':
				goto yy219;

			default:
				goto yy36;
		}

yy260:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy257;
yy261:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy234;

			case '/':
				goto yy261;

			case '>':
				goto yy263;

			default:
				goto yy229;
		}

yy263:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy257;
yy264:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy264;

			case '\r':
				goto yy268;

			case 'T':
			case 't':
				goto yy270;

			default:
				goto yy9;
		}

yy266:
		++YYCURSOR;
		yych = *YYCURSOR;
yy267:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy264;

			default:
				goto yy266;
		}

yy268:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy264;

			case '\r':
				goto yy268;

			case 'T':
			case 't':
				goto yy270;

			default:
				goto yy9;
		}

yy270:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy271;

			default:
				goto yy9;
		}

yy271:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'X':
			case 'x':
				goto yy272;

			default:
				goto yy9;
		}

yy272:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy273;

			default:
				goto yy9;
		}

yy273:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy273;

			case '\r':
				goto yy275;

			case '=':
				goto yy277;

			default:
				goto yy9;
		}

yy275:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy273;

			case '\r':
				goto yy275;

			case '=':
				goto yy277;

			default:
				goto yy9;
		}

yy277:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy277;

			case '\r':
				goto yy279;

			case '"':
				goto yy281;

			default:
				goto yy9;
		}

yy279:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy277;

			case '\r':
				goto yy279;

			case '"':
				goto yy281;

			default:
				goto yy9;
		}

yy281:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy282;

			default:
				goto yy9;
		}

yy282:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy283;

			default:
				goto yy9;
		}

yy283:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy284;

			default:
				goto yy9;
		}

yy284:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy285;

			default:
				goto yy9;
		}

yy285:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy286;

			default:
				goto yy9;
		}

yy286:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy287;

			default:
				goto yy9;
		}

yy287:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy288;

			default:
				goto yy9;
		}

yy288:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy289;

			default:
				goto yy9;
		}

yy289:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy291;

			case 'P':
			case 'p':
				goto yy290;

			default:
				goto yy9;
		}

yy290:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy312;

			default:
				goto yy9;
		}

yy291:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy292;

			default:
				goto yy9;
		}

yy292:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy293;

			default:
				goto yy9;
		}

yy293:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy294;

			default:
				goto yy9;
		}

yy294:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy295;

			default:
				goto yy9;
		}

yy295:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy296;

			default:
				goto yy9;
		}

yy296:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy297;

			default:
				goto yy9;
		}

yy297:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy298;

			default:
				goto yy9;
		}

yy298:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy299;

			default:
				goto yy9;
		}

yy299:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy300;

			default:
				goto yy9;
		}

yy300:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy301;

			default:
				goto yy9;
		}

yy301:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy302;

			default:
				goto yy9;
		}

yy302:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy303;

			default:
				goto yy9;
		}

yy303:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy304;

			default:
				goto yy9;
		}

yy304:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy305;

			default:
				goto yy9;
		}

yy305:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy306;

			default:
				goto yy9;
		}

yy306:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy307;

			default:
				goto yy9;
		}

yy307:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy245;

			default:
				goto yy309;
		}

yy308:
		++YYCURSOR;
		yych = *YYCURSOR;
yy309:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy308;

			case '\r':
				goto yy310;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy246;

			default:
				goto yy9;
		}

yy310:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy308;

			case '\r':
				goto yy310;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy246;

			default:
				goto yy9;
		}

yy312:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy313;

			default:
				goto yy9;
		}

yy313:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy314;

			default:
				goto yy9;
		}

yy314:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy315;

			default:
				goto yy9;
		}

yy315:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy316;

			default:
				goto yy9;
		}

yy316:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy317;

			default:
				goto yy9;
		}

yy317:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy318;

			default:
				goto yy9;
		}

yy318:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy319;

			default:
				goto yy9;
		}

yy319:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy320;

			default:
				goto yy9;
		}

yy320:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy321;

			default:
				goto yy9;
		}

yy321:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy322;

			default:
				goto yy9;
		}

yy322:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy323;

			default:
				goto yy9;
		}

yy323:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy324;

			default:
				goto yy9;
		}

yy324:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy325;

			default:
				goto yy9;
		}

yy325:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy326;

			default:
				goto yy9;
		}

yy326:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy327;

			default:
				goto yy9;
		}

yy327:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy178;

			default:
				goto yy329;
		}

yy328:
		++YYCURSOR;
		yych = *YYCURSOR;
yy329:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy328;

			case '\r':
				goto yy330;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy179;

			default:
				goto yy9;
		}

yy330:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy328;

			case '\r':
				goto yy330;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy179;

			default:
				goto yy9;
		}

yy332:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy267;
yy333:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy104;

			case '/':
				goto yy333;

			case '>':
				goto yy338;

			default:
				goto yy97;
		}

yy335:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy337;
yy336:
		++YYCURSOR;
		yych = *YYCURSOR;
yy337:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy264;

			default:
				goto yy336;
		}

yy338:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy337;
yy339:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy89;

			case '\r':
				goto yy91;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy83;

			case '/':
				goto yy38;

			case '=':
				goto yy93;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy87;

			case 'X':
			case 'x':
				goto yy340;

			default:
				goto yy36;
		}

yy340:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy89;

			case '\r':
				goto yy91;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '/':
				goto yy38;

			case '=':
				goto yy93;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy341;

			default:
				goto yy36;
		}

yy341:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy342;

			case '\r':
				goto yy344;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '/':
				goto yy38;

			case '=':
				goto yy346;

			case '>':
				goto yy40;

			case 'E':
			case 'e':
				goto yy339;

			case 'T':
			case 't':
				goto yy87;

			default:
				goto yy36;
		}

yy342:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy342;

			case '\r':
				goto yy344;

			case '/':
				goto yy38;

			case '=':
				goto yy346;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy108;

			default:
				goto yy36;
		}

yy344:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy342;

			case '\r':
				goto yy344;

			case '/':
				goto yy38;

			case '=':
				goto yy346;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy108;

			default:
				goto yy36;
		}

yy346:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy346;

			case '\r':
				goto yy348;

			case '"':
				goto yy350;

			case '\'':
				goto yy99;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy348:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy346;

			case '\r':
				goto yy348;

			case '"':
				goto yy350;

			case '\'':
				goto yy99;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy350:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy351;

			default:
				goto yy98;
		}

yy351:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy352;

			default:
				goto yy98;
		}

yy352:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy353;

			default:
				goto yy98;
		}

yy353:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy354;

			default:
				goto yy98;
		}

yy354:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy355;

			default:
				goto yy98;
		}

yy355:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy356;

			default:
				goto yy98;
		}

yy356:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy357;

			default:
				goto yy98;
		}

yy357:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy358;

			default:
				goto yy98;
		}

yy358:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy360;

			case 'P':
			case 'p':
				goto yy359;

			default:
				goto yy98;
		}

yy359:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy485;

			default:
				goto yy98;
		}

yy360:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy361;

			default:
				goto yy98;
		}

yy361:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy362;

			default:
				goto yy98;
		}

yy362:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy363;

			default:
				goto yy98;
		}

yy363:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy364;

			default:
				goto yy98;
		}

yy364:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy365;

			default:
				goto yy98;
		}

yy365:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy366;

			default:
				goto yy98;
		}

yy366:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy367;

			default:
				goto yy98;
		}

yy367:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy368;

			default:
				goto yy98;
		}

yy368:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy369;

			default:
				goto yy98;
		}

yy369:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy370;

			default:
				goto yy98;
		}

yy370:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy371;

			default:
				goto yy98;
		}

yy371:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy372;

			default:
				goto yy98;
		}

yy372:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy373;

			default:
				goto yy98;
		}

yy373:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy374;

			default:
				goto yy98;
		}

yy374:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy375;

			default:
				goto yy98;
		}

yy375:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy376;

			default:
				goto yy98;
		}

yy376:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy377;

			case '\r':
				goto yy379;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy217;

			case '>':
				goto yy219;

			case 'T':
			case 't':
				goto yy381;

			default:
				goto yy37;
		}

yy377:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy377;

			case '\r':
				goto yy379;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy217;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy381;

			default:
				goto yy36;
		}

yy379:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy377;

			case '\r':
				goto yy379;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy217;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy381;

			default:
				goto yy36;
		}

yy381:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy221;

			case '\r':
				goto yy223;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy217;

			case '=':
				goto yy225;

			case '>':
				goto yy219;

			case 'E':
			case 'e':
				goto yy382;

			default:
				goto yy37;
		}

yy382:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy221;

			case '\r':
				goto yy223;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy217;

			case '=':
				goto yy225;

			case '>':
				goto yy219;

			case 'X':
			case 'x':
				goto yy383;

			default:
				goto yy37;
		}

yy383:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy221;

			case '\r':
				goto yy223;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy217;

			case '=':
				goto yy225;

			case '>':
				goto yy219;

			case 'T':
			case 't':
				goto yy384;

			default:
				goto yy37;
		}

yy384:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy385;

			case '\r':
				goto yy387;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy217;

			case '=':
				goto yy389;

			case '>':
				goto yy219;

			default:
				goto yy37;
		}

yy385:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy385;

			case '\r':
				goto yy387;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy217;

			case '=':
				goto yy389;

			case '>':
				goto yy219;

			default:
				goto yy36;
		}

yy387:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy385;

			case '\r':
				goto yy387;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy217;

			case '=':
				goto yy389;

			case '>':
				goto yy219;

			default:
				goto yy36;
		}

yy389:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy389;

			case '\r':
				goto yy391;

			case '"':
				goto yy393;

			case '\'':
				goto yy231;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy391:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy389;

			case '\r':
				goto yy391;

			case '"':
				goto yy393;

			case '\'':
				goto yy231;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy393:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy394;

			default:
				goto yy230;
		}

yy394:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy395;

			default:
				goto yy230;
		}

yy395:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy396;

			default:
				goto yy230;
		}

yy396:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy397;

			default:
				goto yy230;
		}

yy397:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy398;

			default:
				goto yy230;
		}

yy398:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy399;

			default:
				goto yy230;
		}

yy399:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy400;

			default:
				goto yy230;
		}

yy400:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy401;

			default:
				goto yy230;
		}

yy401:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy402;

			case 'P':
			case 'p':
				goto yy403;

			default:
				goto yy230;
		}

yy402:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy470;

			default:
				goto yy230;
		}

yy403:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy404;

			default:
				goto yy230;
		}

yy404:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy405;

			default:
				goto yy230;
		}

yy405:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy406;

			default:
				goto yy230;
		}

yy406:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy407;

			default:
				goto yy230;
		}

yy407:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy408;

			default:
				goto yy230;
		}

yy408:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy409;

			default:
				goto yy230;
		}

yy409:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy410;

			default:
				goto yy230;
		}

yy410:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy411;

			default:
				goto yy230;
		}

yy411:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy412;

			default:
				goto yy230;
		}

yy412:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy413;

			default:
				goto yy230;
		}

yy413:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy414;

			default:
				goto yy230;
		}

yy414:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy415;

			default:
				goto yy230;
		}

yy415:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy416;

			default:
				goto yy230;
		}

yy416:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy417;

			default:
				goto yy230;
		}

yy417:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy418;

			default:
				goto yy230;
		}

yy418:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy419;

			default:
				goto yy230;
		}

yy419:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy420;

			case '\r':
				goto yy422;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy424;

			case '>':
				goto yy426;

			default:
				goto yy37;
		}

yy420:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy420;

			case '\r':
				goto yy422;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy424;

			case '>':
				goto yy219;

			default:
				goto yy36;
		}

yy422:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy420;

			case '\r':
				goto yy422;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy424;

			case '>':
				goto yy219;

			default:
				goto yy36;
		}

yy424:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy427;

			case '\r':
				goto yy429;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy424;

			case '/':
				goto yy38;

			case '=':
				goto yy431;

			case '>':
				goto yy426;

			default:
				goto yy36;
		}

yy426:
		yych = *++YYCURSOR;
		goto yy153;
yy427:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy427;

			case '\r':
				goto yy429;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy424;

			case '=':
				goto yy431;

			case '>':
				goto yy426;

			default:
				goto yy36;
		}

yy429:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy427;

			case '\r':
				goto yy429;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy424;

			case '=':
				goto yy431;

			case '>':
				goto yy426;

			default:
				goto yy36;
		}

yy431:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy431;

			case '\r':
				goto yy433;

			case '"':
				goto yy435;

			case '\'':
				goto yy437;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy433:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy431;

			case '\r':
				goto yy433;

			case '"':
				goto yy435;

			case '\'':
				goto yy437;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy435:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy440;

			case '/':
				goto yy467;

			case '>':
				goto yy466;

			default:
				goto yy435;
		}

yy437:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy440;

			case '/':
				goto yy442;

			case '>':
				goto yy439;

			default:
				goto yy437;
		}

yy439:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy448;
yy440:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy440;

			case '\r':
				goto yy464;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy424;

			case '>':
				goto yy426;

			default:
				goto yy36;
		}

yy442:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy440;

			case '/':
				goto yy442;

			case '>':
				goto yy444;

			default:
				goto yy437;
		}

yy444:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy448;
yy445:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy445;

			case '\r':
				goto yy449;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy452;

			case '>':
				goto yy451;

			default:
				goto yy9;
		}

yy447:
		++YYCURSOR;
		yych = *YYCURSOR;
yy448:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy445;

			default:
				goto yy447;
		}

yy449:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy445;

			case '\r':
				goto yy449;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy452;

			case '>':
				goto yy451;

			default:
				goto yy9;
		}

yy451:
		yych = *++YYCURSOR;
		goto yy153;
yy452:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy454;

			case '\r':
				goto yy456;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy452;

			case '=':
				goto yy458;

			case '>':
				goto yy451;

			default:
				goto yy9;
		}

yy454:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy454;

			case '\r':
				goto yy456;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy452;

			case '=':
				goto yy458;

			case '>':
				goto yy451;

			default:
				goto yy9;
		}

yy456:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy454;

			case '\r':
				goto yy456;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy452;

			case '=':
				goto yy458;

			case '>':
				goto yy451;

			default:
				goto yy9;
		}

yy458:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy458;

			case '\r':
				goto yy460;

			case '"':
				goto yy462;

			case '\'':
				goto yy447;

			default:
				goto yy9;
		}

yy460:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy458;

			case '\r':
				goto yy460;

			case '"':
				goto yy462;

			case '\'':
				goto yy447;

			default:
				goto yy9;
		}

yy462:
		++YYCURSOR;
		yych = *YYCURSOR;
yy463:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy445;

			default:
				goto yy462;
		}

yy464:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy440;

			case '\r':
				goto yy464;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy424;

			case '>':
				goto yy426;

			default:
				goto yy36;
		}

yy466:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy463;
yy467:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy440;

			case '/':
				goto yy467;

			case '>':
				goto yy469;

			default:
				goto yy435;
		}

yy469:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy463;
yy470:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy471;

			default:
				goto yy230;
		}

yy471:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy472;

			default:
				goto yy230;
		}

yy472:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy473;

			default:
				goto yy230;
		}

yy473:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy474;

			default:
				goto yy230;
		}

yy474:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy475;

			default:
				goto yy230;
		}

yy475:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy476;

			default:
				goto yy230;
		}

yy476:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy477;

			default:
				goto yy230;
		}

yy477:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy478;

			default:
				goto yy230;
		}

yy478:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy479;

			default:
				goto yy230;
		}

yy479:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy480;

			default:
				goto yy230;
		}

yy480:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy481;

			default:
				goto yy230;
		}

yy481:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy482;

			default:
				goto yy230;
		}

yy482:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy483;

			default:
				goto yy230;
		}

yy483:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy484;

			default:
				goto yy230;
		}

yy484:
		yych = *++YYCURSOR;
		goto yy230;
yy485:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy486;

			default:
				goto yy98;
		}

yy486:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy487;

			default:
				goto yy98;
		}

yy487:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy488;

			default:
				goto yy98;
		}

yy488:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy489;

			default:
				goto yy98;
		}

yy489:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy490;

			default:
				goto yy98;
		}

yy490:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy491;

			default:
				goto yy98;
		}

yy491:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy492;

			default:
				goto yy98;
		}

yy492:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy493;

			default:
				goto yy98;
		}

yy493:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy494;

			default:
				goto yy98;
		}

yy494:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy495;

			default:
				goto yy98;
		}

yy495:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy496;

			default:
				goto yy98;
		}

yy496:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy497;

			default:
				goto yy98;
		}

yy497:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy498;

			default:
				goto yy98;
		}

yy498:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy499;

			default:
				goto yy98;
		}

yy499:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy500;

			default:
				goto yy98;
		}

yy500:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy501;

			case '\r':
				goto yy503;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy150;

			case '>':
				goto yy152;

			case 'T':
			case 't':
				goto yy505;

			default:
				goto yy37;
		}

yy501:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy501;

			case '\r':
				goto yy503;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy150;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy505;

			default:
				goto yy36;
		}

yy503:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy501;

			case '\r':
				goto yy503;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy150;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy505;

			default:
				goto yy36;
		}

yy505:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy154;

			case '\r':
				goto yy156;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy150;

			case '=':
				goto yy158;

			case '>':
				goto yy152;

			case 'E':
			case 'e':
				goto yy506;

			default:
				goto yy37;
		}

yy506:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy154;

			case '\r':
				goto yy156;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy150;

			case '=':
				goto yy158;

			case '>':
				goto yy152;

			case 'X':
			case 'x':
				goto yy507;

			default:
				goto yy37;
		}

yy507:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy154;

			case '\r':
				goto yy156;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy150;

			case '=':
				goto yy158;

			case '>':
				goto yy152;

			case 'T':
			case 't':
				goto yy508;

			default:
				goto yy37;
		}

yy508:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy509;

			case '\r':
				goto yy511;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy150;

			case '=':
				goto yy513;

			case '>':
				goto yy152;

			default:
				goto yy37;
		}

yy509:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy509;

			case '\r':
				goto yy511;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy150;

			case '=':
				goto yy513;

			case '>':
				goto yy152;

			default:
				goto yy36;
		}

yy511:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy509;

			case '\r':
				goto yy511;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy150;

			case '=':
				goto yy513;

			case '>':
				goto yy152;

			default:
				goto yy36;
		}

yy513:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy513;

			case '\r':
				goto yy515;

			case '"':
				goto yy517;

			case '\'':
				goto yy164;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy515:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy513;

			case '\r':
				goto yy515;

			case '"':
				goto yy517;

			case '\'':
				goto yy164;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy517:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy518;

			default:
				goto yy163;
		}

yy518:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy519;

			default:
				goto yy163;
		}

yy519:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy520;

			default:
				goto yy163;
		}

yy520:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy521;

			default:
				goto yy163;
		}

yy521:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy522;

			default:
				goto yy163;
		}

yy522:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy523;

			default:
				goto yy163;
		}

yy523:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy524;

			default:
				goto yy163;
		}

yy524:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy525;

			default:
				goto yy163;
		}

yy525:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy526;

			case 'P':
			case 'p':
				goto yy527;

			default:
				goto yy163;
		}

yy526:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy543;

			default:
				goto yy163;
		}

yy527:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy528;

			default:
				goto yy163;
		}

yy528:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy529;

			default:
				goto yy163;
		}

yy529:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy530;

			default:
				goto yy163;
		}

yy530:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy531;

			default:
				goto yy163;
		}

yy531:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy532;

			default:
				goto yy163;
		}

yy532:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy533;

			default:
				goto yy163;
		}

yy533:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy534;

			default:
				goto yy163;
		}

yy534:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy535;

			default:
				goto yy163;
		}

yy535:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy536;

			default:
				goto yy163;
		}

yy536:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy537;

			default:
				goto yy163;
		}

yy537:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy538;

			default:
				goto yy163;
		}

yy538:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy539;

			default:
				goto yy163;
		}

yy539:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy540;

			default:
				goto yy163;
		}

yy540:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy541;

			default:
				goto yy163;
		}

yy541:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy542;

			default:
				goto yy163;
		}

yy542:
		yych = *++YYCURSOR;
		goto yy163;
yy543:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy544;

			default:
				goto yy163;
		}

yy544:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy545;

			default:
				goto yy163;
		}

yy545:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy546;

			default:
				goto yy163;
		}

yy546:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy547;

			default:
				goto yy163;
		}

yy547:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy548;

			default:
				goto yy163;
		}

yy548:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy549;

			default:
				goto yy163;
		}

yy549:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy550;

			default:
				goto yy163;
		}

yy550:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy551;

			default:
				goto yy163;
		}

yy551:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy552;

			default:
				goto yy163;
		}

yy552:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy553;

			default:
				goto yy163;
		}

yy553:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy554;

			default:
				goto yy163;
		}

yy554:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy555;

			default:
				goto yy163;
		}

yy555:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy556;

			default:
				goto yy163;
		}

yy556:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy557;

			default:
				goto yy163;
		}

yy557:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy558;

			default:
				goto yy163;
		}

yy558:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy559;

			case '\r':
				goto yy561;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy424;

			case '>':
				goto yy426;

			default:
				goto yy37;
		}

yy559:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy559;

			case '\r':
				goto yy561;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy424;

			case '>':
				goto yy152;

			default:
				goto yy36;
		}

yy561:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy559;

			case '\r':
				goto yy561;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy424;

			case '>':
				goto yy152;

			default:
				goto yy36;
		}

yy563:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy89;

			case '\r':
				goto yy91;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy93;

			case 'T':
			case 't':
				goto yy564;

			default:
				goto yy37;
		}

yy564:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy565;

			case '\r':
				goto yy567;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy569;

			case 'E':
			case 'e':
				goto yy339;

			case 'T':
			case 't':
				goto yy87;

			default:
				goto yy37;
		}

yy565:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy565;

			case '\r':
				goto yy567;

			case '/':
				goto yy38;

			case '=':
				goto yy569;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy108;

			default:
				goto yy36;
		}

yy567:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy565;

			case '\r':
				goto yy567;

			case '/':
				goto yy38;

			case '=':
				goto yy569;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy108;

			default:
				goto yy36;
		}

yy569:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy569;

			case '\r':
				goto yy571;

			case '"':
				goto yy573;

			case '\'':
				goto yy99;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy571:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy569;

			case '\r':
				goto yy571;

			case '"':
				goto yy573;

			case '\'':
				goto yy99;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy573:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy574;

			default:
				goto yy98;
		}

yy574:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy575;

			default:
				goto yy98;
		}

yy575:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy576;

			default:
				goto yy98;
		}

yy576:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy577;

			default:
				goto yy98;
		}

yy577:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy578;

			default:
				goto yy98;
		}

yy578:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy579;

			default:
				goto yy98;
		}

yy579:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy580;

			default:
				goto yy98;
		}

yy580:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy581;

			default:
				goto yy98;
		}

yy581:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy582;

			case 'P':
			case 'p':
				goto yy583;

			default:
				goto yy98;
		}

yy582:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy755;

			default:
				goto yy98;
		}

yy583:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy584;

			default:
				goto yy98;
		}

yy584:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy585;

			default:
				goto yy98;
		}

yy585:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy586;

			default:
				goto yy98;
		}

yy586:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy587;

			default:
				goto yy98;
		}

yy587:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy588;

			default:
				goto yy98;
		}

yy588:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy589;

			default:
				goto yy98;
		}

yy589:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy590;

			default:
				goto yy98;
		}

yy590:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy591;

			default:
				goto yy98;
		}

yy591:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy592;

			default:
				goto yy98;
		}

yy592:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy593;

			default:
				goto yy98;
		}

yy593:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy594;

			default:
				goto yy98;
		}

yy594:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy595;

			default:
				goto yy98;
		}

yy595:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy596;

			default:
				goto yy98;
		}

yy596:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy597;

			default:
				goto yy98;
		}

yy597:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy598;

			default:
				goto yy98;
		}

yy598:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy599;

			default:
				goto yy98;
		}

yy599:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy600;

			case '\r':
				goto yy602;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy606;

			default:
				goto yy37;
		}

yy600:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy600;

			case '\r':
				goto yy602;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy606;

			default:
				goto yy36;
		}

yy602:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy600;

			case '\r':
				goto yy602;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy606;

			default:
				goto yy36;
		}

yy604:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy609;

			case '\r':
				goto yy611;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '/':
				goto yy38;

			case '=':
				goto yy613;

			case '>':
				goto yy607;

			default:
				goto yy36;
		}

yy606:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy609;

			case '\r':
				goto yy611;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '=':
				goto yy613;

			case '>':
				goto yy607;

			case 'E':
			case 'e':
				goto yy615;

			default:
				goto yy37;
		}

yy607:
		++YYCURSOR;
yy608: {
			return ITMZ_TOPIC_PREAMBLE;
		}
yy609:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy609;

			case '\r':
				goto yy611;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '=':
				goto yy613;

			case '>':
				goto yy607;

			default:
				goto yy36;
		}

yy611:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy609;

			case '\r':
				goto yy611;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '=':
				goto yy613;

			case '>':
				goto yy607;

			default:
				goto yy36;
		}

yy613:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy613;

			case '\r':
				goto yy753;

			case '"':
				goto yy656;

			case '\'':
				goto yy627;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy615:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy609;

			case '\r':
				goto yy611;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy604;

			case '=':
				goto yy613;

			case '>':
				goto yy607;

			case 'X':
			case 'x':
				goto yy616;

			default:
				goto yy37;
		}

yy616:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy609;

			case '\r':
				goto yy611;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '=':
				goto yy613;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy617;

			default:
				goto yy37;
		}

yy617:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy618;

			case '\r':
				goto yy620;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '=':
				goto yy622;

			case '>':
				goto yy607;

			default:
				goto yy37;
		}

yy618:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy618;

			case '\r':
				goto yy620;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '=':
				goto yy622;

			case '>':
				goto yy607;

			default:
				goto yy36;
		}

yy620:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy618;

			case '\r':
				goto yy620;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '=':
				goto yy622;

			case '>':
				goto yy607;

			default:
				goto yy36;
		}

yy622:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy622;

			case '\r':
				goto yy624;

			case '"':
				goto yy626;

			case '\'':
				goto yy627;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy624:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy622;

			case '\r':
				goto yy624;

			case '"':
				goto yy626;

			case '\'':
				goto yy627;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy626:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy658;

			default:
				goto yy657;
		}

yy627:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy632;

			case '/':
				goto yy629;

			case '>':
				goto yy631;

			default:
				goto yy627;
		}

yy629:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy632;

			case '/':
				goto yy629;

			case '>':
				goto yy655;

			default:
				goto yy627;
		}

yy631:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy639;
yy632:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy632;

			case '\r':
				goto yy634;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '>':
				goto yy607;

			default:
				goto yy36;
		}

yy634:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy632;

			case '\r':
				goto yy634;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '>':
				goto yy607;

			default:
				goto yy36;
		}

yy636:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy636;

			case '\r':
				goto yy640;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy643;

			case '>':
				goto yy642;

			default:
				goto yy9;
		}

yy638:
		++YYCURSOR;
		yych = *YYCURSOR;
yy639:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy636;

			default:
				goto yy638;
		}

yy640:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy636;

			case '\r':
				goto yy640;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy643;

			case '>':
				goto yy642;

			default:
				goto yy9;
		}

yy642:
		yych = *++YYCURSOR;
		goto yy608;
yy643:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy645;

			case '\r':
				goto yy647;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy643;

			case '=':
				goto yy649;

			case '>':
				goto yy642;

			default:
				goto yy9;
		}

yy645:
		++YYCURSOR;
		yych = *YYCURSOR;
yy646:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy645;

			case '\r':
				goto yy647;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy643;

			case '=':
				goto yy649;

			case '>':
				goto yy642;

			default:
				goto yy9;
		}

yy647:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy645;

			case '\r':
				goto yy647;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy643;

			case '=':
				goto yy649;

			case '>':
				goto yy642;

			default:
				goto yy9;
		}

yy649:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy649;

			case '\r':
				goto yy651;

			case '"':
				goto yy653;

			case '\'':
				goto yy638;

			default:
				goto yy9;
		}

yy651:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy649;

			case '\r':
				goto yy651;

			case '"':
				goto yy653;

			case '\'':
				goto yy638;

			default:
				goto yy9;
		}

yy653:
		++YYCURSOR;
		yych = *YYCURSOR;
yy654:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy636;

			default:
				goto yy653;
		}

yy655:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy639;
yy656:
		++YYCURSOR;
		yych = *YYCURSOR;
yy657:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy632;

			case '/':
				goto yy659;

			case '>':
				goto yy661;

			default:
				goto yy656;
		}

yy658:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy663;

			default:
				goto yy657;
		}

yy659:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy632;

			case '/':
				goto yy659;

			case '>':
				goto yy662;

			default:
				goto yy656;
		}

yy661:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy654;
yy662:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy654;
yy663:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy664;

			default:
				goto yy657;
		}

yy664:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy665;

			default:
				goto yy657;
		}

yy665:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy666;

			default:
				goto yy657;
		}

yy666:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy667;

			default:
				goto yy657;
		}

yy667:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy668;

			default:
				goto yy657;
		}

yy668:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy669;

			default:
				goto yy657;
		}

yy669:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy670;

			case 'P':
			case 'p':
				goto yy671;

			default:
				goto yy657;
		}

yy670:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy687;

			default:
				goto yy657;
		}

yy671:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy672;

			default:
				goto yy657;
		}

yy672:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy673;

			default:
				goto yy657;
		}

yy673:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy674;

			default:
				goto yy657;
		}

yy674:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy675;

			default:
				goto yy657;
		}

yy675:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy676;

			default:
				goto yy657;
		}

yy676:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy677;

			default:
				goto yy657;
		}

yy677:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy678;

			default:
				goto yy657;
		}

yy678:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy679;

			default:
				goto yy657;
		}

yy679:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy680;

			default:
				goto yy657;
		}

yy680:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy681;

			default:
				goto yy657;
		}

yy681:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy682;

			default:
				goto yy657;
		}

yy682:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy683;

			default:
				goto yy657;
		}

yy683:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy684;

			default:
				goto yy657;
		}

yy684:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy685;

			default:
				goto yy657;
		}

yy685:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy686;

			default:
				goto yy657;
		}

yy686:
		yych = *++YYCURSOR;
		goto yy657;
yy687:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy688;

			default:
				goto yy657;
		}

yy688:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy689;

			default:
				goto yy657;
		}

yy689:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy690;

			default:
				goto yy657;
		}

yy690:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy691;

			default:
				goto yy657;
		}

yy691:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy692;

			default:
				goto yy657;
		}

yy692:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy693;

			default:
				goto yy657;
		}

yy693:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy694;

			default:
				goto yy657;
		}

yy694:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy695;

			default:
				goto yy657;
		}

yy695:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy696;

			default:
				goto yy657;
		}

yy696:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy697;

			default:
				goto yy657;
		}

yy697:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy698;

			default:
				goto yy657;
		}

yy698:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy699;

			default:
				goto yy657;
		}

yy699:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy700;

			default:
				goto yy657;
		}

yy700:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy701;

			default:
				goto yy657;
		}

yy701:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy702;

			default:
				goto yy657;
		}

yy702:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy704;

			case '\r':
				goto yy706;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '>':
				goto yy703;

			default:
				goto yy37;
		}

yy703:
		yych = *++YYCURSOR;
		goto yy608;
yy704:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy704;

			case '\r':
				goto yy706;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '>':
				goto yy607;

			default:
				goto yy36;
		}

yy706:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy704;

			case '\r':
				goto yy706;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '>':
				goto yy607;

			default:
				goto yy36;
		}

yy708:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy710;

			case '\r':
				goto yy712;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '/':
				goto yy38;

			case '=':
				goto yy714;

			case '>':
				goto yy703;

			default:
				goto yy36;
		}

yy710:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy710;

			case '\r':
				goto yy712;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '=':
				goto yy714;

			case '>':
				goto yy703;

			default:
				goto yy36;
		}

yy712:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy710;

			case '\r':
				goto yy712;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '=':
				goto yy714;

			case '>':
				goto yy703;

			default:
				goto yy36;
		}

yy714:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy714;

			case '\r':
				goto yy716;

			case '"':
				goto yy718;

			case '\'':
				goto yy720;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy716:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy714;

			case '\r':
				goto yy716;

			case '"':
				goto yy718;

			case '\'':
				goto yy720;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy718:
		++YYCURSOR;
		yych = *YYCURSOR;
yy719:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy725;

			case '/':
				goto yy749;

			case '>':
				goto yy751;

			default:
				goto yy718;
		}

yy720:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy725;

			case '/':
				goto yy722;

			case '>':
				goto yy724;

			default:
				goto yy720;
		}

yy722:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy725;

			case '/':
				goto yy722;

			case '>':
				goto yy748;

			default:
				goto yy720;
		}

yy724:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy732;
yy725:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy725;

			case '\r':
				goto yy727;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '>':
				goto yy703;

			default:
				goto yy36;
		}

yy727:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy725;

			case '\r':
				goto yy727;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '>':
				goto yy703;

			default:
				goto yy36;
		}

yy729:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy729;

			case '\r':
				goto yy733;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy736;

			case '>':
				goto yy735;

			default:
				goto yy9;
		}

yy731:
		++YYCURSOR;
		yych = *YYCURSOR;
yy732:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy729;

			default:
				goto yy731;
		}

yy733:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy729;

			case '\r':
				goto yy733;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy736;

			case '>':
				goto yy735;

			default:
				goto yy9;
		}

yy735:
		yych = *++YYCURSOR;
		goto yy608;
yy736:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy738;

			case '\r':
				goto yy740;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy736;

			case '=':
				goto yy742;

			case '>':
				goto yy735;

			default:
				goto yy9;
		}

yy738:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy738;

			case '\r':
				goto yy740;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy736;

			case '=':
				goto yy742;

			case '>':
				goto yy735;

			default:
				goto yy9;
		}

yy740:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy738;

			case '\r':
				goto yy740;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy736;

			case '=':
				goto yy742;

			case '>':
				goto yy735;

			default:
				goto yy9;
		}

yy742:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy742;

			case '\r':
				goto yy744;

			case '"':
				goto yy746;

			case '\'':
				goto yy731;

			default:
				goto yy9;
		}

yy744:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy742;

			case '\r':
				goto yy744;

			case '"':
				goto yy746;

			case '\'':
				goto yy731;

			default:
				goto yy9;
		}

yy746:
		++YYCURSOR;
		yych = *YYCURSOR;
yy747:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy729;

			default:
				goto yy746;
		}

yy748:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy732;
yy749:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy725;

			case '/':
				goto yy749;

			case '>':
				goto yy752;

			default:
				goto yy718;
		}

yy751:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy747;
yy752:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy747;
yy753:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy613;

			case '\r':
				goto yy753;

			case '"':
				goto yy656;

			case '\'':
				goto yy627;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy755:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy756;

			default:
				goto yy98;
		}

yy756:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy757;

			default:
				goto yy98;
		}

yy757:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy758;

			default:
				goto yy98;
		}

yy758:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy759;

			default:
				goto yy98;
		}

yy759:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy760;

			default:
				goto yy98;
		}

yy760:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy761;

			default:
				goto yy98;
		}

yy761:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy762;

			default:
				goto yy98;
		}

yy762:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy763;

			default:
				goto yy98;
		}

yy763:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy764;

			default:
				goto yy98;
		}

yy764:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy765;

			default:
				goto yy98;
		}

yy765:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy766;

			default:
				goto yy98;
		}

yy766:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy767;

			default:
				goto yy98;
		}

yy767:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy768;

			default:
				goto yy98;
		}

yy768:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy769;

			default:
				goto yy98;
		}

yy769:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy770;

			default:
				goto yy98;
		}

yy770:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy771;

			case '\r':
				goto yy773;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy777;

			default:
				goto yy37;
		}

yy771:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy771;

			case '\r':
				goto yy773;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy777;

			default:
				goto yy36;
		}

yy773:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy771;

			case '\r':
				goto yy773;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy777;

			default:
				goto yy36;
		}

yy775:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy780;

			case '\r':
				goto yy782;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '/':
				goto yy38;

			case '=':
				goto yy784;

			case '>':
				goto yy778;

			default:
				goto yy36;
		}

yy777:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy780;

			case '\r':
				goto yy782;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '=':
				goto yy784;

			case '>':
				goto yy778;

			case 'E':
			case 'e':
				goto yy786;

			default:
				goto yy37;
		}

yy778:
		++YYCURSOR;
yy779: {
			return ITMZ_TOPIC_METADATA;
		}
yy780:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy780;

			case '\r':
				goto yy782;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '=':
				goto yy784;

			case '>':
				goto yy778;

			default:
				goto yy36;
		}

yy782:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy780;

			case '\r':
				goto yy782;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '=':
				goto yy784;

			case '>':
				goto yy778;

			default:
				goto yy36;
		}

yy784:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy784;

			case '\r':
				goto yy924;

			case '"':
				goto yy827;

			case '\'':
				goto yy798;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy786:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy780;

			case '\r':
				goto yy782;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy775;

			case '=':
				goto yy784;

			case '>':
				goto yy778;

			case 'X':
			case 'x':
				goto yy787;

			default:
				goto yy37;
		}

yy787:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy780;

			case '\r':
				goto yy782;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '=':
				goto yy784;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy788;

			default:
				goto yy37;
		}

yy788:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy789;

			case '\r':
				goto yy791;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '=':
				goto yy793;

			case '>':
				goto yy778;

			default:
				goto yy37;
		}

yy789:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy789;

			case '\r':
				goto yy791;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '=':
				goto yy793;

			case '>':
				goto yy778;

			default:
				goto yy36;
		}

yy791:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy789;

			case '\r':
				goto yy791;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '=':
				goto yy793;

			case '>':
				goto yy778;

			default:
				goto yy36;
		}

yy793:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy793;

			case '\r':
				goto yy795;

			case '"':
				goto yy797;

			case '\'':
				goto yy798;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy795:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy793;

			case '\r':
				goto yy795;

			case '"':
				goto yy797;

			case '\'':
				goto yy798;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy797:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy829;

			default:
				goto yy828;
		}

yy798:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy803;

			case '/':
				goto yy800;

			case '>':
				goto yy802;

			default:
				goto yy798;
		}

yy800:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy803;

			case '/':
				goto yy800;

			case '>':
				goto yy826;

			default:
				goto yy798;
		}

yy802:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy810;
yy803:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy803;

			case '\r':
				goto yy805;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '>':
				goto yy778;

			default:
				goto yy36;
		}

yy805:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy803;

			case '\r':
				goto yy805;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '>':
				goto yy778;

			default:
				goto yy36;
		}

yy807:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy807;

			case '\r':
				goto yy811;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy814;

			case '>':
				goto yy813;

			default:
				goto yy9;
		}

yy809:
		++YYCURSOR;
		yych = *YYCURSOR;
yy810:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy807;

			default:
				goto yy809;
		}

yy811:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy807;

			case '\r':
				goto yy811;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy814;

			case '>':
				goto yy813;

			default:
				goto yy9;
		}

yy813:
		yych = *++YYCURSOR;
		goto yy779;
yy814:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy816;

			case '\r':
				goto yy818;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy814;

			case '=':
				goto yy820;

			case '>':
				goto yy813;

			default:
				goto yy9;
		}

yy816:
		++YYCURSOR;
		yych = *YYCURSOR;
yy817:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy816;

			case '\r':
				goto yy818;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy814;

			case '=':
				goto yy820;

			case '>':
				goto yy813;

			default:
				goto yy9;
		}

yy818:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy816;

			case '\r':
				goto yy818;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy814;

			case '=':
				goto yy820;

			case '>':
				goto yy813;

			default:
				goto yy9;
		}

yy820:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy820;

			case '\r':
				goto yy822;

			case '"':
				goto yy824;

			case '\'':
				goto yy809;

			default:
				goto yy9;
		}

yy822:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy820;

			case '\r':
				goto yy822;

			case '"':
				goto yy824;

			case '\'':
				goto yy809;

			default:
				goto yy9;
		}

yy824:
		++YYCURSOR;
		yych = *YYCURSOR;
yy825:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy807;

			default:
				goto yy824;
		}

yy826:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy810;
yy827:
		++YYCURSOR;
		yych = *YYCURSOR;
yy828:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy803;

			case '/':
				goto yy830;

			case '>':
				goto yy832;

			default:
				goto yy827;
		}

yy829:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy834;

			default:
				goto yy828;
		}

yy830:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy803;

			case '/':
				goto yy830;

			case '>':
				goto yy833;

			default:
				goto yy827;
		}

yy832:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy825;
yy833:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy825;
yy834:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy835;

			default:
				goto yy828;
		}

yy835:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy836;

			default:
				goto yy828;
		}

yy836:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy837;

			default:
				goto yy828;
		}

yy837:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy838;

			default:
				goto yy828;
		}

yy838:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy839;

			default:
				goto yy828;
		}

yy839:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy840;

			default:
				goto yy828;
		}

yy840:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy841;

			case 'P':
			case 'p':
				goto yy842;

			default:
				goto yy828;
		}

yy841:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy909;

			default:
				goto yy828;
		}

yy842:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy843;

			default:
				goto yy828;
		}

yy843:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy844;

			default:
				goto yy828;
		}

yy844:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy845;

			default:
				goto yy828;
		}

yy845:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy846;

			default:
				goto yy828;
		}

yy846:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy847;

			default:
				goto yy828;
		}

yy847:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy848;

			default:
				goto yy828;
		}

yy848:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy849;

			default:
				goto yy828;
		}

yy849:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy850;

			default:
				goto yy828;
		}

yy850:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy851;

			default:
				goto yy828;
		}

yy851:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy852;

			default:
				goto yy828;
		}

yy852:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy853;

			default:
				goto yy828;
		}

yy853:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy854;

			default:
				goto yy828;
		}

yy854:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy855;

			default:
				goto yy828;
		}

yy855:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy856;

			default:
				goto yy828;
		}

yy856:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy857;

			default:
				goto yy828;
		}

yy857:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy858;

			default:
				goto yy828;
		}

yy858:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy860;

			case '\r':
				goto yy862;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '>':
				goto yy859;

			default:
				goto yy37;
		}

yy859:
		yych = *++YYCURSOR;
		goto yy779;
yy860:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy860;

			case '\r':
				goto yy862;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '>':
				goto yy778;

			default:
				goto yy36;
		}

yy862:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy860;

			case '\r':
				goto yy862;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '>':
				goto yy778;

			default:
				goto yy36;
		}

yy864:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy866;

			case '\r':
				goto yy868;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '/':
				goto yy38;

			case '=':
				goto yy870;

			case '>':
				goto yy859;

			default:
				goto yy36;
		}

yy866:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy866;

			case '\r':
				goto yy868;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '=':
				goto yy870;

			case '>':
				goto yy859;

			default:
				goto yy36;
		}

yy868:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy866;

			case '\r':
				goto yy868;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '=':
				goto yy870;

			case '>':
				goto yy859;

			default:
				goto yy36;
		}

yy870:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy870;

			case '\r':
				goto yy872;

			case '"':
				goto yy874;

			case '\'':
				goto yy876;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy872:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy870;

			case '\r':
				goto yy872;

			case '"':
				goto yy874;

			case '\'':
				goto yy876;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy874:
		++YYCURSOR;
		yych = *YYCURSOR;
yy875:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy881;

			case '/':
				goto yy905;

			case '>':
				goto yy907;

			default:
				goto yy874;
		}

yy876:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy881;

			case '/':
				goto yy878;

			case '>':
				goto yy880;

			default:
				goto yy876;
		}

yy878:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy881;

			case '/':
				goto yy878;

			case '>':
				goto yy904;

			default:
				goto yy876;
		}

yy880:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy888;
yy881:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy881;

			case '\r':
				goto yy883;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '>':
				goto yy859;

			default:
				goto yy36;
		}

yy883:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy881;

			case '\r':
				goto yy883;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '>':
				goto yy859;

			default:
				goto yy36;
		}

yy885:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy885;

			case '\r':
				goto yy889;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy892;

			case '>':
				goto yy891;

			default:
				goto yy9;
		}

yy887:
		++YYCURSOR;
		yych = *YYCURSOR;
yy888:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy885;

			default:
				goto yy887;
		}

yy889:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy885;

			case '\r':
				goto yy889;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy892;

			case '>':
				goto yy891;

			default:
				goto yy9;
		}

yy891:
		yych = *++YYCURSOR;
		goto yy779;
yy892:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy894;

			case '\r':
				goto yy896;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy892;

			case '=':
				goto yy898;

			case '>':
				goto yy891;

			default:
				goto yy9;
		}

yy894:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy894;

			case '\r':
				goto yy896;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy892;

			case '=':
				goto yy898;

			case '>':
				goto yy891;

			default:
				goto yy9;
		}

yy896:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy894;

			case '\r':
				goto yy896;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy892;

			case '=':
				goto yy898;

			case '>':
				goto yy891;

			default:
				goto yy9;
		}

yy898:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy898;

			case '\r':
				goto yy900;

			case '"':
				goto yy902;

			case '\'':
				goto yy887;

			default:
				goto yy9;
		}

yy900:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy898;

			case '\r':
				goto yy900;

			case '"':
				goto yy902;

			case '\'':
				goto yy887;

			default:
				goto yy9;
		}

yy902:
		++YYCURSOR;
		yych = *YYCURSOR;
yy903:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy885;

			default:
				goto yy902;
		}

yy904:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy888;
yy905:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy881;

			case '/':
				goto yy905;

			case '>':
				goto yy908;

			default:
				goto yy874;
		}

yy907:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy903;
yy908:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy903;
yy909:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy910;

			default:
				goto yy828;
		}

yy910:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy911;

			default:
				goto yy828;
		}

yy911:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy912;

			default:
				goto yy828;
		}

yy912:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy913;

			default:
				goto yy828;
		}

yy913:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy914;

			default:
				goto yy828;
		}

yy914:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy915;

			default:
				goto yy828;
		}

yy915:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy916;

			default:
				goto yy828;
		}

yy916:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy917;

			default:
				goto yy828;
		}

yy917:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy918;

			default:
				goto yy828;
		}

yy918:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy919;

			default:
				goto yy828;
		}

yy919:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy920;

			default:
				goto yy828;
		}

yy920:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy921;

			default:
				goto yy828;
		}

yy921:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy922;

			default:
				goto yy828;
		}

yy922:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy923;

			default:
				goto yy828;
		}

yy923:
		yych = *++YYCURSOR;
		goto yy828;
yy924:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy784;

			case '\r':
				goto yy924;

			case '"':
				goto yy827;

			case '\'':
				goto yy798;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy926:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy926;

			case '\r':
				goto yy930;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy933;

			case 'T':
			case 't':
				goto yy932;

			default:
				goto yy9;
		}

yy928:
		++YYCURSOR;
		yych = *YYCURSOR;
yy929:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy926;

			default:
				goto yy928;
		}

yy930:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy926;

			case '\r':
				goto yy930;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy933;

			case 'T':
			case 't':
				goto yy932;

			default:
				goto yy9;
		}

yy932:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy933;

			case 'E':
			case 'e':
				goto yy1123;

			case 'T':
			case 't':
				goto yy935;

			default:
				goto yy938;
		}

yy933:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy937;

			case '\r':
				goto yy939;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy933;

			case '=':
				goto yy941;

			case 'T':
			case 't':
				goto yy935;

			default:
				goto yy9;
		}

yy935:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy937;

			case '\r':
				goto yy939;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy933;

			case '=':
				goto yy941;

			case 'E':
			case 'e':
				goto yy945;

			case 'T':
			case 't':
				goto yy935;

			default:
				goto yy9;
		}

yy937:
		++YYCURSOR;
		yych = *YYCURSOR;
yy938:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy937;

			case '\r':
				goto yy939;

			case '=':
				goto yy941;

			case 'T':
			case 't':
				goto yy270;

			default:
				goto yy9;
		}

yy939:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy937;

			case '\r':
				goto yy939;

			case '=':
				goto yy941;

			case 'T':
			case 't':
				goto yy270;

			default:
				goto yy9;
		}

yy941:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy941;

			case '\r':
				goto yy943;

			case '"':
				goto yy336;

			case '\'':
				goto yy266;

			default:
				goto yy9;
		}

yy943:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy941;

			case '\r':
				goto yy943;

			case '"':
				goto yy336;

			case '\'':
				goto yy266;

			default:
				goto yy9;
		}

yy945:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy937;

			case '\r':
				goto yy939;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy933;

			case '=':
				goto yy941;

			case 'T':
			case 't':
				goto yy935;

			case 'X':
			case 'x':
				goto yy946;

			default:
				goto yy9;
		}

yy946:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy937;

			case '\r':
				goto yy939;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy933;

			case '=':
				goto yy941;

			case 'T':
			case 't':
				goto yy947;

			default:
				goto yy9;
		}

yy947:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy948;

			case '\r':
				goto yy950;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy933;

			case '=':
				goto yy952;

			case 'E':
			case 'e':
				goto yy945;

			case 'T':
			case 't':
				goto yy935;

			default:
				goto yy9;
		}

yy948:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy948;

			case '\r':
				goto yy950;

			case '=':
				goto yy952;

			case 'T':
			case 't':
				goto yy270;

			default:
				goto yy9;
		}

yy950:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy948;

			case '\r':
				goto yy950;

			case '=':
				goto yy952;

			case 'T':
			case 't':
				goto yy270;

			default:
				goto yy9;
		}

yy952:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy952;

			case '\r':
				goto yy954;

			case '"':
				goto yy956;

			case '\'':
				goto yy266;

			default:
				goto yy9;
		}

yy954:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy952;

			case '\r':
				goto yy954;

			case '"':
				goto yy956;

			case '\'':
				goto yy266;

			default:
				goto yy9;
		}

yy956:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy957;

			default:
				goto yy337;
		}

yy957:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy958;

			default:
				goto yy337;
		}

yy958:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy959;

			default:
				goto yy337;
		}

yy959:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy960;

			default:
				goto yy337;
		}

yy960:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy961;

			default:
				goto yy337;
		}

yy961:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy962;

			default:
				goto yy337;
		}

yy962:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy963;

			default:
				goto yy337;
		}

yy963:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy964;

			default:
				goto yy337;
		}

yy964:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy965;

			case 'P':
			case 'p':
				goto yy966;

			default:
				goto yy337;
		}

yy965:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1045;

			default:
				goto yy337;
		}

yy966:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy967;

			default:
				goto yy337;
		}

yy967:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy968;

			default:
				goto yy337;
		}

yy968:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy969;

			default:
				goto yy337;
		}

yy969:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy970;

			default:
				goto yy337;
		}

yy970:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy971;

			default:
				goto yy337;
		}

yy971:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy972;

			default:
				goto yy337;
		}

yy972:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy973;

			default:
				goto yy337;
		}

yy973:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy974;

			default:
				goto yy337;
		}

yy974:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy975;

			default:
				goto yy337;
		}

yy975:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy976;

			default:
				goto yy337;
		}

yy976:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy977;

			default:
				goto yy337;
		}

yy977:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy978;

			default:
				goto yy337;
		}

yy978:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy979;

			default:
				goto yy337;
		}

yy979:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy980;

			default:
				goto yy337;
		}

yy980:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy981;

			default:
				goto yy337;
		}

yy981:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy982;

			default:
				goto yy337;
		}

yy982:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy178;

			default:
				goto yy984;
		}

yy983:
		++YYCURSOR;
		yych = *YYCURSOR;
yy984:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy983;

			case '\r':
				goto yy985;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy179;

			case 'T':
			case 't':
				goto yy987;

			default:
				goto yy9;
		}

yy985:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy983;

			case '\r':
				goto yy985;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy179;

			case 'T':
			case 't':
				goto yy987;

			default:
				goto yy9;
		}

yy987:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy179;

			case 'E':
			case 'e':
				goto yy988;

			default:
				goto yy182;
		}

yy988:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy179;

			case 'X':
			case 'x':
				goto yy989;

			default:
				goto yy182;
		}

yy989:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy179;

			case 'T':
			case 't':
				goto yy990;

			default:
				goto yy182;
		}

yy990:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy179;

			default:
				goto yy992;
		}

yy991:
		++YYCURSOR;
		yych = *YYCURSOR;
yy992:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy991;

			case '\r':
				goto yy993;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy179;

			case '=':
				goto yy995;

			case '>':
				goto yy178;

			default:
				goto yy9;
		}

yy993:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy991;

			case '\r':
				goto yy993;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy179;

			case '=':
				goto yy995;

			case '>':
				goto yy178;

			default:
				goto yy9;
		}

yy995:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy995;

			case '\r':
				goto yy997;

			case '"':
				goto yy999;

			case '\'':
				goto yy174;

			default:
				goto yy9;
		}

yy997:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy995;

			case '\r':
				goto yy997;

			case '"':
				goto yy999;

			case '\'':
				goto yy174;

			default:
				goto yy9;
		}

yy999:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1000;

			default:
				goto yy190;
		}

yy1000:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1001;

			default:
				goto yy190;
		}

yy1001:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1002;

			default:
				goto yy190;
		}

yy1002:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1003;

			default:
				goto yy190;
		}

yy1003:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1004;

			default:
				goto yy190;
		}

yy1004:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1005;

			default:
				goto yy190;
		}

yy1005:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1006;

			default:
				goto yy190;
		}

yy1006:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1007;

			default:
				goto yy190;
		}

yy1007:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1009;

			case 'P':
			case 'p':
				goto yy1008;

			default:
				goto yy190;
		}

yy1008:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy1030;

			default:
				goto yy190;
		}

yy1009:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1010;

			default:
				goto yy190;
		}

yy1010:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1011;

			default:
				goto yy190;
		}

yy1011:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1012;

			default:
				goto yy190;
		}

yy1012:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy1013;

			default:
				goto yy190;
		}

yy1013:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1014;

			default:
				goto yy190;
		}

yy1014:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1015;

			default:
				goto yy190;
		}

yy1015:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1016;

			default:
				goto yy190;
		}

yy1016:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1017;

			default:
				goto yy190;
		}

yy1017:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1018;

			default:
				goto yy190;
		}

yy1018:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1019;

			default:
				goto yy190;
		}

yy1019:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1020;

			default:
				goto yy190;
		}

yy1020:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1021;

			default:
				goto yy190;
		}

yy1021:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1022;

			default:
				goto yy190;
		}

yy1022:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1023;

			default:
				goto yy190;
		}

yy1023:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1024;

			default:
				goto yy190;
		}

yy1024:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy1025;

			default:
				goto yy190;
		}

yy1025:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy451;

			default:
				goto yy1027;
		}

yy1026:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1027:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1026;

			case '\r':
				goto yy1028;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy452;

			case '>':
				goto yy178;

			default:
				goto yy9;
		}

yy1028:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1026;

			case '\r':
				goto yy1028;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy452;

			case '>':
				goto yy178;

			default:
				goto yy9;
		}

yy1030:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1031;

			default:
				goto yy190;
		}

yy1031:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1032;

			default:
				goto yy190;
		}

yy1032:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1033;

			default:
				goto yy190;
		}

yy1033:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy1034;

			default:
				goto yy190;
		}

yy1034:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1035;

			default:
				goto yy190;
		}

yy1035:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1036;

			default:
				goto yy190;
		}

yy1036:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1037;

			default:
				goto yy190;
		}

yy1037:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1038;

			default:
				goto yy190;
		}

yy1038:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1039;

			default:
				goto yy190;
		}

yy1039:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1040;

			default:
				goto yy190;
		}

yy1040:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1041;

			default:
				goto yy190;
		}

yy1041:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1042;

			default:
				goto yy190;
		}

yy1042:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1043;

			default:
				goto yy190;
		}

yy1043:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1044;

			default:
				goto yy190;
		}

yy1044:
		yych = *++YYCURSOR;
		goto yy190;
yy1045:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1046;

			default:
				goto yy337;
		}

yy1046:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1047;

			default:
				goto yy337;
		}

yy1047:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy1048;

			default:
				goto yy337;
		}

yy1048:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1049;

			default:
				goto yy337;
		}

yy1049:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1050;

			default:
				goto yy337;
		}

yy1050:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1051;

			default:
				goto yy337;
		}

yy1051:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1052;

			default:
				goto yy337;
		}

yy1052:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1053;

			default:
				goto yy337;
		}

yy1053:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1054;

			default:
				goto yy337;
		}

yy1054:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1055;

			default:
				goto yy337;
		}

yy1055:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1056;

			default:
				goto yy337;
		}

yy1056:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1057;

			default:
				goto yy337;
		}

yy1057:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1058;

			default:
				goto yy337;
		}

yy1058:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1059;

			default:
				goto yy337;
		}

yy1059:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy1060;

			default:
				goto yy337;
		}

yy1060:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy245;

			default:
				goto yy1062;
		}

yy1061:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1062:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1061;

			case '\r':
				goto yy1063;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy246;

			case 'T':
			case 't':
				goto yy1065;

			default:
				goto yy9;
		}

yy1063:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1061;

			case '\r':
				goto yy1063;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy246;

			case 'T':
			case 't':
				goto yy1065;

			default:
				goto yy9;
		}

yy1065:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy246;

			case 'E':
			case 'e':
				goto yy1066;

			default:
				goto yy249;
		}

yy1066:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy246;

			case 'X':
			case 'x':
				goto yy1067;

			default:
				goto yy249;
		}

yy1067:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy246;

			case 'T':
			case 't':
				goto yy1068;

			default:
				goto yy249;
		}

yy1068:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy246;

			default:
				goto yy1070;
		}

yy1069:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1070:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1069;

			case '\r':
				goto yy1071;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy246;

			case '=':
				goto yy1073;

			case '>':
				goto yy245;

			default:
				goto yy9;
		}

yy1071:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1069;

			case '\r':
				goto yy1071;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy246;

			case '=':
				goto yy1073;

			case '>':
				goto yy245;

			default:
				goto yy9;
		}

yy1073:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1073;

			case '\r':
				goto yy1075;

			case '"':
				goto yy1077;

			case '\'':
				goto yy241;

			default:
				goto yy9;
		}

yy1075:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1073;

			case '\r':
				goto yy1075;

			case '"':
				goto yy1077;

			case '\'':
				goto yy241;

			default:
				goto yy9;
		}

yy1077:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1078;

			default:
				goto yy257;
		}

yy1078:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1079;

			default:
				goto yy257;
		}

yy1079:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1080;

			default:
				goto yy257;
		}

yy1080:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1081;

			default:
				goto yy257;
		}

yy1081:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1082;

			default:
				goto yy257;
		}

yy1082:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1083;

			default:
				goto yy257;
		}

yy1083:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1084;

			default:
				goto yy257;
		}

yy1084:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1085;

			default:
				goto yy257;
		}

yy1085:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1087;

			case 'P':
			case 'p':
				goto yy1086;

			default:
				goto yy257;
		}

yy1086:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy1103;

			default:
				goto yy257;
		}

yy1087:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1088;

			default:
				goto yy257;
		}

yy1088:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1089;

			default:
				goto yy257;
		}

yy1089:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1090;

			default:
				goto yy257;
		}

yy1090:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy1091;

			default:
				goto yy257;
		}

yy1091:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1092;

			default:
				goto yy257;
		}

yy1092:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1093;

			default:
				goto yy257;
		}

yy1093:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1094;

			default:
				goto yy257;
		}

yy1094:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1095;

			default:
				goto yy257;
		}

yy1095:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1096;

			default:
				goto yy257;
		}

yy1096:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1097;

			default:
				goto yy257;
		}

yy1097:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1098;

			default:
				goto yy257;
		}

yy1098:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1099;

			default:
				goto yy257;
		}

yy1099:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1100;

			default:
				goto yy257;
		}

yy1100:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1101;

			default:
				goto yy257;
		}

yy1101:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1102;

			default:
				goto yy257;
		}

yy1102:
		yych = *++YYCURSOR;
		goto yy257;
yy1103:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1104;

			default:
				goto yy257;
		}

yy1104:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1105;

			default:
				goto yy257;
		}

yy1105:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1106;

			default:
				goto yy257;
		}

yy1106:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy1107;

			default:
				goto yy257;
		}

yy1107:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1108;

			default:
				goto yy257;
		}

yy1108:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1109;

			default:
				goto yy257;
		}

yy1109:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1110;

			default:
				goto yy257;
		}

yy1110:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1111;

			default:
				goto yy257;
		}

yy1111:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1112;

			default:
				goto yy257;
		}

yy1112:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1113;

			default:
				goto yy257;
		}

yy1113:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1114;

			default:
				goto yy257;
		}

yy1114:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1115;

			default:
				goto yy257;
		}

yy1115:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1116;

			default:
				goto yy257;
		}

yy1116:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1117;

			default:
				goto yy257;
		}

yy1117:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy1118;

			default:
				goto yy257;
		}

yy1118:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy451;

			default:
				goto yy1120;
		}

yy1119:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1120:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1119;

			case '\r':
				goto yy1121;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy452;

			case '>':
				goto yy245;

			default:
				goto yy9;
		}

yy1121:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1119;

			case '\r':
				goto yy1121;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy452;

			case '>':
				goto yy245;

			default:
				goto yy9;
		}

yy1123:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy933;

			case 'T':
			case 't':
				goto yy935;

			case 'X':
			case 'x':
				goto yy1124;

			default:
				goto yy938;
		}

yy1124:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy933;

			case 'T':
			case 't':
				goto yy1125;

			default:
				goto yy938;
		}

yy1125:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy933;

			case 'E':
			case 'e':
				goto yy945;

			case 'T':
			case 't':
				goto yy935;

			default:
				goto yy1127;
		}

yy1126:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1127:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1126;

			case '\r':
				goto yy1128;

			case '=':
				goto yy1130;

			case 'T':
			case 't':
				goto yy270;

			default:
				goto yy9;
		}

yy1128:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1126;

			case '\r':
				goto yy1128;

			case '=':
				goto yy1130;

			case 'T':
			case 't':
				goto yy270;

			default:
				goto yy9;
		}

yy1130:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1130;

			case '\r':
				goto yy1132;

			case '"':
				goto yy1134;

			case '\'':
				goto yy266;

			default:
				goto yy9;
		}

yy1132:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1130;

			case '\r':
				goto yy1132;

			case '"':
				goto yy1134;

			case '\'':
				goto yy266;

			default:
				goto yy9;
		}

yy1134:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1135;

			default:
				goto yy337;
		}

yy1135:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1136;

			default:
				goto yy337;
		}

yy1136:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1137;

			default:
				goto yy337;
		}

yy1137:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1138;

			default:
				goto yy337;
		}

yy1138:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1139;

			default:
				goto yy337;
		}

yy1139:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1140;

			default:
				goto yy337;
		}

yy1140:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1141;

			default:
				goto yy337;
		}

yy1141:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1142;

			default:
				goto yy337;
		}

yy1142:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1144;

			case 'P':
			case 'p':
				goto yy1143;

			default:
				goto yy337;
		}

yy1143:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy1223;

			default:
				goto yy337;
		}

yy1144:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1145;

			default:
				goto yy337;
		}

yy1145:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1146;

			default:
				goto yy337;
		}

yy1146:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1147;

			default:
				goto yy337;
		}

yy1147:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy1148;

			default:
				goto yy337;
		}

yy1148:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1149;

			default:
				goto yy337;
		}

yy1149:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1150;

			default:
				goto yy337;
		}

yy1150:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1151;

			default:
				goto yy337;
		}

yy1151:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1152;

			default:
				goto yy337;
		}

yy1152:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1153;

			default:
				goto yy337;
		}

yy1153:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1154;

			default:
				goto yy337;
		}

yy1154:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1155;

			default:
				goto yy337;
		}

yy1155:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1156;

			default:
				goto yy337;
		}

yy1156:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1157;

			default:
				goto yy337;
		}

yy1157:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1158;

			default:
				goto yy337;
		}

yy1158:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1159;

			default:
				goto yy337;
		}

yy1159:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy1160;

			default:
				goto yy337;
		}

yy1160:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy813;

			default:
				goto yy1162;
		}

yy1161:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1162:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1161;

			case '\r':
				goto yy1163;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy814;

			case 'T':
			case 't':
				goto yy1165;

			default:
				goto yy9;
		}

yy1163:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1161;

			case '\r':
				goto yy1163;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy814;

			case 'T':
			case 't':
				goto yy1165;

			default:
				goto yy9;
		}

yy1165:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy814;

			case 'E':
			case 'e':
				goto yy1166;

			default:
				goto yy817;
		}

yy1166:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy814;

			case 'X':
			case 'x':
				goto yy1167;

			default:
				goto yy817;
		}

yy1167:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy814;

			case 'T':
			case 't':
				goto yy1168;

			default:
				goto yy817;
		}

yy1168:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy814;

			default:
				goto yy1170;
		}

yy1169:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1170:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1169;

			case '\r':
				goto yy1171;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy814;

			case '=':
				goto yy1173;

			case '>':
				goto yy813;

			default:
				goto yy9;
		}

yy1171:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1169;

			case '\r':
				goto yy1171;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy814;

			case '=':
				goto yy1173;

			case '>':
				goto yy813;

			default:
				goto yy9;
		}

yy1173:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1173;

			case '\r':
				goto yy1175;

			case '"':
				goto yy1177;

			case '\'':
				goto yy809;

			default:
				goto yy9;
		}

yy1175:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1173;

			case '\r':
				goto yy1175;

			case '"':
				goto yy1177;

			case '\'':
				goto yy809;

			default:
				goto yy9;
		}

yy1177:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1178;

			default:
				goto yy825;
		}

yy1178:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1179;

			default:
				goto yy825;
		}

yy1179:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1180;

			default:
				goto yy825;
		}

yy1180:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1181;

			default:
				goto yy825;
		}

yy1181:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1182;

			default:
				goto yy825;
		}

yy1182:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1183;

			default:
				goto yy825;
		}

yy1183:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1184;

			default:
				goto yy825;
		}

yy1184:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1185;

			default:
				goto yy825;
		}

yy1185:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1186;

			case 'P':
			case 'p':
				goto yy1187;

			default:
				goto yy825;
		}

yy1186:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1208;

			default:
				goto yy825;
		}

yy1187:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy1188;

			default:
				goto yy825;
		}

yy1188:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1189;

			default:
				goto yy825;
		}

yy1189:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1190;

			default:
				goto yy825;
		}

yy1190:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1191;

			default:
				goto yy825;
		}

yy1191:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy1192;

			default:
				goto yy825;
		}

yy1192:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1193;

			default:
				goto yy825;
		}

yy1193:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1194;

			default:
				goto yy825;
		}

yy1194:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1195;

			default:
				goto yy825;
		}

yy1195:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1196;

			default:
				goto yy825;
		}

yy1196:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1197;

			default:
				goto yy825;
		}

yy1197:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1198;

			default:
				goto yy825;
		}

yy1198:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1199;

			default:
				goto yy825;
		}

yy1199:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1200;

			default:
				goto yy825;
		}

yy1200:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1201;

			default:
				goto yy825;
		}

yy1201:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1202;

			default:
				goto yy825;
		}

yy1202:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy1203;

			default:
				goto yy825;
		}

yy1203:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy891;

			default:
				goto yy1205;
		}

yy1204:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1205:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1204;

			case '\r':
				goto yy1206;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy892;

			case '>':
				goto yy813;

			default:
				goto yy9;
		}

yy1206:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1204;

			case '\r':
				goto yy1206;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy892;

			case '>':
				goto yy813;

			default:
				goto yy9;
		}

yy1208:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1209;

			default:
				goto yy825;
		}

yy1209:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1210;

			default:
				goto yy825;
		}

yy1210:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy1211;

			default:
				goto yy825;
		}

yy1211:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1212;

			default:
				goto yy825;
		}

yy1212:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1213;

			default:
				goto yy825;
		}

yy1213:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1214;

			default:
				goto yy825;
		}

yy1214:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1215;

			default:
				goto yy825;
		}

yy1215:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1216;

			default:
				goto yy825;
		}

yy1216:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1217;

			default:
				goto yy825;
		}

yy1217:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1218;

			default:
				goto yy825;
		}

yy1218:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1219;

			default:
				goto yy825;
		}

yy1219:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1220;

			default:
				goto yy825;
		}

yy1220:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1221;

			default:
				goto yy825;
		}

yy1221:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1222;

			default:
				goto yy825;
		}

yy1222:
		yych = *++YYCURSOR;
		goto yy825;
yy1223:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1224;

			default:
				goto yy337;
		}

yy1224:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1225;

			default:
				goto yy337;
		}

yy1225:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1226;

			default:
				goto yy337;
		}

yy1226:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy1227;

			default:
				goto yy337;
		}

yy1227:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1228;

			default:
				goto yy337;
		}

yy1228:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1229;

			default:
				goto yy337;
		}

yy1229:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1230;

			default:
				goto yy337;
		}

yy1230:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1231;

			default:
				goto yy337;
		}

yy1231:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1232;

			default:
				goto yy337;
		}

yy1232:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1233;

			default:
				goto yy337;
		}

yy1233:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1234;

			default:
				goto yy337;
		}

yy1234:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1235;

			default:
				goto yy337;
		}

yy1235:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1236;

			default:
				goto yy337;
		}

yy1236:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1237;

			default:
				goto yy337;
		}

yy1237:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy1238;

			default:
				goto yy337;
		}

yy1238:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy642;

			default:
				goto yy1240;
		}

yy1239:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1240:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1239;

			case '\r':
				goto yy1241;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy643;

			case 'T':
			case 't':
				goto yy1243;

			default:
				goto yy9;
		}

yy1241:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1239;

			case '\r':
				goto yy1241;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy643;

			case 'T':
			case 't':
				goto yy1243;

			default:
				goto yy9;
		}

yy1243:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy643;

			case 'E':
			case 'e':
				goto yy1244;

			default:
				goto yy646;
		}

yy1244:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy643;

			case 'X':
			case 'x':
				goto yy1245;

			default:
				goto yy646;
		}

yy1245:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy643;

			case 'T':
			case 't':
				goto yy1246;

			default:
				goto yy646;
		}

yy1246:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy643;

			default:
				goto yy1248;
		}

yy1247:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1248:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1247;

			case '\r':
				goto yy1249;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy643;

			case '=':
				goto yy1251;

			case '>':
				goto yy642;

			default:
				goto yy9;
		}

yy1249:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1247;

			case '\r':
				goto yy1249;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy643;

			case '=':
				goto yy1251;

			case '>':
				goto yy642;

			default:
				goto yy9;
		}

yy1251:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1251;

			case '\r':
				goto yy1253;

			case '"':
				goto yy1255;

			case '\'':
				goto yy638;

			default:
				goto yy9;
		}

yy1253:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1251;

			case '\r':
				goto yy1253;

			case '"':
				goto yy1255;

			case '\'':
				goto yy638;

			default:
				goto yy9;
		}

yy1255:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1256;

			default:
				goto yy654;
		}

yy1256:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1257;

			default:
				goto yy654;
		}

yy1257:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1258;

			default:
				goto yy654;
		}

yy1258:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1259;

			default:
				goto yy654;
		}

yy1259:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1260;

			default:
				goto yy654;
		}

yy1260:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1261;

			default:
				goto yy654;
		}

yy1261:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1262;

			default:
				goto yy654;
		}

yy1262:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1263;

			default:
				goto yy654;
		}

yy1263:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1264;

			case 'P':
			case 'p':
				goto yy1265;

			default:
				goto yy654;
		}

yy1264:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1281;

			default:
				goto yy654;
		}

yy1265:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy1266;

			default:
				goto yy654;
		}

yy1266:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1267;

			default:
				goto yy654;
		}

yy1267:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1268;

			default:
				goto yy654;
		}

yy1268:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1269;

			default:
				goto yy654;
		}

yy1269:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy1270;

			default:
				goto yy654;
		}

yy1270:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1271;

			default:
				goto yy654;
		}

yy1271:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1272;

			default:
				goto yy654;
		}

yy1272:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1273;

			default:
				goto yy654;
		}

yy1273:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1274;

			default:
				goto yy654;
		}

yy1274:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1275;

			default:
				goto yy654;
		}

yy1275:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1276;

			default:
				goto yy654;
		}

yy1276:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1277;

			default:
				goto yy654;
		}

yy1277:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1278;

			default:
				goto yy654;
		}

yy1278:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1279;

			default:
				goto yy654;
		}

yy1279:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1280;

			default:
				goto yy654;
		}

yy1280:
		yych = *++YYCURSOR;
		goto yy654;
yy1281:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1282;

			default:
				goto yy654;
		}

yy1282:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1283;

			default:
				goto yy654;
		}

yy1283:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy1284;

			default:
				goto yy654;
		}

yy1284:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1285;

			default:
				goto yy654;
		}

yy1285:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1286;

			default:
				goto yy654;
		}

yy1286:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1287;

			default:
				goto yy654;
		}

yy1287:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1288;

			default:
				goto yy654;
		}

yy1288:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1289;

			default:
				goto yy654;
		}

yy1289:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1290;

			default:
				goto yy654;
		}

yy1290:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1291;

			default:
				goto yy654;
		}

yy1291:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1292;

			default:
				goto yy654;
		}

yy1292:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1293;

			default:
				goto yy654;
		}

yy1293:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1294;

			default:
				goto yy654;
		}

yy1294:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1295;

			default:
				goto yy654;
		}

yy1295:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy1296;

			default:
				goto yy654;
		}

yy1296:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy735;

			default:
				goto yy1298;
		}

yy1297:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1298:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1297;

			case '\r':
				goto yy1299;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy736;

			case '>':
				goto yy642;

			default:
				goto yy9;
		}

yy1299:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1297;

			case '\r':
				goto yy1299;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy736;

			case '>':
				goto yy642;

			default:
				goto yy9;
		}

yy1301:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy929;
yy1302:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1303:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy79;

			case '/':
				goto yy1305;

			case '>':
				goto yy1307;

			default:
				goto yy1302;
		}

yy1304:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1311;

			default:
				goto yy1303;
		}

yy1305:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy79;

			case '/':
				goto yy1305;

			case '>':
				goto yy1310;

			default:
				goto yy1302;
		}

yy1307:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy1309;
yy1308:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1309:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy926;

			default:
				goto yy1308;
		}

yy1310:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy1309;
yy1311:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1312;

			default:
				goto yy1303;
		}

yy1312:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1313;

			default:
				goto yy1303;
		}

yy1313:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1314;

			default:
				goto yy1303;
		}

yy1314:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1315;

			default:
				goto yy1303;
		}

yy1315:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1316;

			default:
				goto yy1303;
		}

yy1316:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1317;

			default:
				goto yy1303;
		}

yy1317:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1318;

			case 'P':
			case 'p':
				goto yy1319;

			default:
				goto yy1303;
		}

yy1318:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1643;

			default:
				goto yy1303;
		}

yy1319:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy1320;

			default:
				goto yy1303;
		}

yy1320:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1321;

			default:
				goto yy1303;
		}

yy1321:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1322;

			default:
				goto yy1303;
		}

yy1322:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1323;

			default:
				goto yy1303;
		}

yy1323:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy1324;

			default:
				goto yy1303;
		}

yy1324:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1325;

			default:
				goto yy1303;
		}

yy1325:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1326;

			default:
				goto yy1303;
		}

yy1326:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1327;

			default:
				goto yy1303;
		}

yy1327:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1328;

			default:
				goto yy1303;
		}

yy1328:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1329;

			default:
				goto yy1303;
		}

yy1329:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1330;

			default:
				goto yy1303;
		}

yy1330:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1331;

			default:
				goto yy1303;
		}

yy1331:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1332;

			default:
				goto yy1303;
		}

yy1332:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1333;

			default:
				goto yy1303;
		}

yy1333:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1334;

			default:
				goto yy1303;
		}

yy1334:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy1335;

			default:
				goto yy1303;
		}

yy1335:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1336;

			case '\r':
				goto yy1338;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1340;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy1342;

			default:
				goto yy37;
		}

yy1336:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1336;

			case '\r':
				goto yy1338;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1340;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy1342;

			default:
				goto yy36;
		}

yy1338:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1336;

			case '\r':
				goto yy1338;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1340;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy1342;

			default:
				goto yy36;
		}

yy1340:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1346;

			case '\r':
				goto yy1348;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1340;

			case '/':
				goto yy38;

			case '=':
				goto yy1350;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy1344;

			default:
				goto yy36;
		}

yy1342:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1346;

			case '\r':
				goto yy1348;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1340;

			case '=':
				goto yy1350;

			case '>':
				goto yy607;

			case 'E':
			case 'e':
				goto yy1343;

			case 'T':
			case 't':
				goto yy1344;

			default:
				goto yy37;
		}

yy1343:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1346;

			case '\r':
				goto yy1348;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy1340;

			case '=':
				goto yy1350;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy1344;

			case 'X':
			case 'x':
				goto yy1488;

			default:
				goto yy37;
		}

yy1344:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1346;

			case '\r':
				goto yy1348;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1340;

			case '/':
				goto yy38;

			case '=':
				goto yy1350;

			case '>':
				goto yy607;

			case 'E':
			case 'e':
				goto yy1378;

			case 'T':
			case 't':
				goto yy1344;

			default:
				goto yy36;
		}

yy1346:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1346;

			case '\r':
				goto yy1348;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '=':
				goto yy1350;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy606;

			default:
				goto yy36;
		}

yy1348:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1346;

			case '\r':
				goto yy1348;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '=':
				goto yy1350;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy606;

			default:
				goto yy36;
		}

yy1350:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1350;

			case '\r':
				goto yy1352;

			case '"':
				goto yy1354;

			case '\'':
				goto yy1356;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1352:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1350;

			case '\r':
				goto yy1352;

			case '"':
				goto yy1354;

			case '\'':
				goto yy1356;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1354:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1355:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy1361;

			case '/':
				goto yy1372;

			case '>':
				goto yy1374;

			default:
				goto yy1354;
		}

yy1356:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy1361;

			case '/':
				goto yy1358;

			case '>':
				goto yy1360;

			default:
				goto yy1356;
		}

yy1358:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy1361;

			case '/':
				goto yy1358;

			case '>':
				goto yy1371;

			default:
				goto yy1356;
		}

yy1360:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy1368;
yy1361:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1361;

			case '\r':
				goto yy1363;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy606;

			default:
				goto yy36;
		}

yy1363:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1361;

			case '\r':
				goto yy1363;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy606;

			default:
				goto yy36;
		}

yy1365:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1365;

			case '\r':
				goto yy1369;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy643;

			case '>':
				goto yy642;

			case 'T':
			case 't':
				goto yy1243;

			default:
				goto yy9;
		}

yy1367:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1368:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy1365;

			default:
				goto yy1367;
		}

yy1369:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1365;

			case '\r':
				goto yy1369;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy643;

			case '>':
				goto yy642;

			case 'T':
			case 't':
				goto yy1243;

			default:
				goto yy9;
		}

yy1371:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy1368;
yy1372:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy1361;

			case '/':
				goto yy1372;

			case '>':
				goto yy1377;

			default:
				goto yy1354;
		}

yy1374:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy1376;
yy1375:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1376:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy1365;

			default:
				goto yy1375;
		}

yy1377:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy1376;
yy1378:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1346;

			case '\r':
				goto yy1348;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy1340;

			case '/':
				goto yy38;

			case '=':
				goto yy1350;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy1344;

			case 'X':
			case 'x':
				goto yy1379;

			default:
				goto yy36;
		}

yy1379:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1346;

			case '\r':
				goto yy1348;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1340;

			case '/':
				goto yy38;

			case '=':
				goto yy1350;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy1380;

			default:
				goto yy36;
		}

yy1380:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1381;

			case '\r':
				goto yy1383;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1340;

			case '/':
				goto yy38;

			case '=':
				goto yy1385;

			case '>':
				goto yy607;

			case 'E':
			case 'e':
				goto yy1378;

			case 'T':
			case 't':
				goto yy1344;

			default:
				goto yy36;
		}

yy1381:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1381;

			case '\r':
				goto yy1383;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '=':
				goto yy1385;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy606;

			default:
				goto yy36;
		}

yy1383:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1381;

			case '\r':
				goto yy1383;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '=':
				goto yy1385;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy606;

			default:
				goto yy36;
		}

yy1385:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1385;

			case '\r':
				goto yy1387;

			case '"':
				goto yy1389;

			case '\'':
				goto yy1356;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1387:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1385;

			case '\r':
				goto yy1387;

			case '"':
				goto yy1389;

			case '\'':
				goto yy1356;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1389:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1390;

			default:
				goto yy1355;
		}

yy1390:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1391;

			default:
				goto yy1355;
		}

yy1391:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1392;

			default:
				goto yy1355;
		}

yy1392:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1393;

			default:
				goto yy1355;
		}

yy1393:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1394;

			default:
				goto yy1355;
		}

yy1394:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1395;

			default:
				goto yy1355;
		}

yy1395:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1396;

			default:
				goto yy1355;
		}

yy1396:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1397;

			default:
				goto yy1355;
		}

yy1397:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1398;

			case 'P':
			case 'p':
				goto yy1399;

			default:
				goto yy1355;
		}

yy1398:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1415;

			default:
				goto yy1355;
		}

yy1399:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy1400;

			default:
				goto yy1355;
		}

yy1400:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1401;

			default:
				goto yy1355;
		}

yy1401:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1402;

			default:
				goto yy1355;
		}

yy1402:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1403;

			default:
				goto yy1355;
		}

yy1403:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy1404;

			default:
				goto yy1355;
		}

yy1404:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1405;

			default:
				goto yy1355;
		}

yy1405:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1406;

			default:
				goto yy1355;
		}

yy1406:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1407;

			default:
				goto yy1355;
		}

yy1407:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1408;

			default:
				goto yy1355;
		}

yy1408:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1409;

			default:
				goto yy1355;
		}

yy1409:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1410;

			default:
				goto yy1355;
		}

yy1410:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1411;

			default:
				goto yy1355;
		}

yy1411:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1412;

			default:
				goto yy1355;
		}

yy1412:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1413;

			default:
				goto yy1355;
		}

yy1413:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1414;

			default:
				goto yy1355;
		}

yy1414:
		yych = *++YYCURSOR;
		goto yy1355;
yy1415:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1416;

			default:
				goto yy1355;
		}

yy1416:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1417;

			default:
				goto yy1355;
		}

yy1417:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy1418;

			default:
				goto yy1355;
		}

yy1418:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1419;

			default:
				goto yy1355;
		}

yy1419:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1420;

			default:
				goto yy1355;
		}

yy1420:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1421;

			default:
				goto yy1355;
		}

yy1421:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1422;

			default:
				goto yy1355;
		}

yy1422:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1423;

			default:
				goto yy1355;
		}

yy1423:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1424;

			default:
				goto yy1355;
		}

yy1424:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1425;

			default:
				goto yy1355;
		}

yy1425:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1426;

			default:
				goto yy1355;
		}

yy1426:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1427;

			default:
				goto yy1355;
		}

yy1427:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1428;

			default:
				goto yy1355;
		}

yy1428:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1429;

			default:
				goto yy1355;
		}

yy1429:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy1430;

			default:
				goto yy1355;
		}

yy1430:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1431;

			case '\r':
				goto yy1433;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '>':
				goto yy703;

			case 'T':
			case 't':
				goto yy1435;

			default:
				goto yy37;
		}

yy1431:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1431;

			case '\r':
				goto yy1433;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy1435;

			default:
				goto yy36;
		}

yy1433:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1431;

			case '\r':
				goto yy1433;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy1435;

			default:
				goto yy36;
		}

yy1435:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy710;

			case '\r':
				goto yy712;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '=':
				goto yy714;

			case '>':
				goto yy703;

			case 'E':
			case 'e':
				goto yy1436;

			default:
				goto yy37;
		}

yy1436:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy710;

			case '\r':
				goto yy712;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy708;

			case '=':
				goto yy714;

			case '>':
				goto yy703;

			case 'X':
			case 'x':
				goto yy1437;

			default:
				goto yy37;
		}

yy1437:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy710;

			case '\r':
				goto yy712;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '=':
				goto yy714;

			case '>':
				goto yy703;

			case 'T':
			case 't':
				goto yy1438;

			default:
				goto yy37;
		}

yy1438:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1439;

			case '\r':
				goto yy1441;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '=':
				goto yy1443;

			case '>':
				goto yy703;

			default:
				goto yy37;
		}

yy1439:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1439;

			case '\r':
				goto yy1441;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '=':
				goto yy1443;

			case '>':
				goto yy703;

			default:
				goto yy36;
		}

yy1441:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1439;

			case '\r':
				goto yy1441;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '=':
				goto yy1443;

			case '>':
				goto yy703;

			default:
				goto yy36;
		}

yy1443:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1443;

			case '\r':
				goto yy1445;

			case '"':
				goto yy1447;

			case '\'':
				goto yy720;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1445:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1443;

			case '\r':
				goto yy1445;

			case '"':
				goto yy1447;

			case '\'':
				goto yy720;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1447:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1448;

			default:
				goto yy719;
		}

yy1448:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1449;

			default:
				goto yy719;
		}

yy1449:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1450;

			default:
				goto yy719;
		}

yy1450:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1451;

			default:
				goto yy719;
		}

yy1451:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1452;

			default:
				goto yy719;
		}

yy1452:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1453;

			default:
				goto yy719;
		}

yy1453:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1454;

			default:
				goto yy719;
		}

yy1454:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1455;

			default:
				goto yy719;
		}

yy1455:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1456;

			case 'P':
			case 'p':
				goto yy1457;

			default:
				goto yy719;
		}

yy1456:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1473;

			default:
				goto yy719;
		}

yy1457:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy1458;

			default:
				goto yy719;
		}

yy1458:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1459;

			default:
				goto yy719;
		}

yy1459:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1460;

			default:
				goto yy719;
		}

yy1460:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1461;

			default:
				goto yy719;
		}

yy1461:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy1462;

			default:
				goto yy719;
		}

yy1462:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1463;

			default:
				goto yy719;
		}

yy1463:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1464;

			default:
				goto yy719;
		}

yy1464:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1465;

			default:
				goto yy719;
		}

yy1465:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1466;

			default:
				goto yy719;
		}

yy1466:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1467;

			default:
				goto yy719;
		}

yy1467:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1468;

			default:
				goto yy719;
		}

yy1468:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1469;

			default:
				goto yy719;
		}

yy1469:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1470;

			default:
				goto yy719;
		}

yy1470:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1471;

			default:
				goto yy719;
		}

yy1471:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1472;

			default:
				goto yy719;
		}

yy1472:
		yych = *++YYCURSOR;
		goto yy719;
yy1473:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1474;

			default:
				goto yy719;
		}

yy1474:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1475;

			default:
				goto yy719;
		}

yy1475:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy1476;

			default:
				goto yy719;
		}

yy1476:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1477;

			default:
				goto yy719;
		}

yy1477:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1478;

			default:
				goto yy719;
		}

yy1478:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1479;

			default:
				goto yy719;
		}

yy1479:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1480;

			default:
				goto yy719;
		}

yy1480:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1481;

			default:
				goto yy719;
		}

yy1481:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1482;

			default:
				goto yy719;
		}

yy1482:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1483;

			default:
				goto yy719;
		}

yy1483:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1484;

			default:
				goto yy719;
		}

yy1484:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1485;

			default:
				goto yy719;
		}

yy1485:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1486;

			default:
				goto yy719;
		}

yy1486:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1487;

			default:
				goto yy719;
		}

yy1487:
		yych = *++YYCURSOR;
		goto yy719;
yy1488:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1346;

			case '\r':
				goto yy1348;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1340;

			case '=':
				goto yy1350;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy1489;

			default:
				goto yy37;
		}

yy1489:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1490;

			case '\r':
				goto yy1492;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1340;

			case '=':
				goto yy1494;

			case '>':
				goto yy607;

			case 'E':
			case 'e':
				goto yy1378;

			case 'T':
			case 't':
				goto yy1344;

			default:
				goto yy37;
		}

yy1490:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1490;

			case '\r':
				goto yy1492;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '=':
				goto yy1494;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy606;

			default:
				goto yy36;
		}

yy1492:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1490;

			case '\r':
				goto yy1492;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '=':
				goto yy1494;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy606;

			default:
				goto yy36;
		}

yy1494:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1494;

			case '\r':
				goto yy1496;

			case '"':
				goto yy1498;

			case '\'':
				goto yy1356;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1496:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1494;

			case '\r':
				goto yy1496;

			case '"':
				goto yy1498;

			case '\'':
				goto yy1356;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1498:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1499;

			default:
				goto yy1355;
		}

yy1499:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1500;

			default:
				goto yy1355;
		}

yy1500:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1501;

			default:
				goto yy1355;
		}

yy1501:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1502;

			default:
				goto yy1355;
		}

yy1502:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1503;

			default:
				goto yy1355;
		}

yy1503:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1504;

			default:
				goto yy1355;
		}

yy1504:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1505;

			default:
				goto yy1355;
		}

yy1505:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1506;

			default:
				goto yy1355;
		}

yy1506:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1507;

			case 'P':
			case 'p':
				goto yy1508;

			default:
				goto yy1355;
		}

yy1507:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1524;

			default:
				goto yy1355;
		}

yy1508:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy1509;

			default:
				goto yy1355;
		}

yy1509:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1510;

			default:
				goto yy1355;
		}

yy1510:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1511;

			default:
				goto yy1355;
		}

yy1511:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1512;

			default:
				goto yy1355;
		}

yy1512:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy1513;

			default:
				goto yy1355;
		}

yy1513:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1514;

			default:
				goto yy1355;
		}

yy1514:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1515;

			default:
				goto yy1355;
		}

yy1515:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1516;

			default:
				goto yy1355;
		}

yy1516:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1517;

			default:
				goto yy1355;
		}

yy1517:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1518;

			default:
				goto yy1355;
		}

yy1518:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1519;

			default:
				goto yy1355;
		}

yy1519:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1520;

			default:
				goto yy1355;
		}

yy1520:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1521;

			default:
				goto yy1355;
		}

yy1521:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1522;

			default:
				goto yy1355;
		}

yy1522:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1523;

			default:
				goto yy1355;
		}

yy1523:
		yych = *++YYCURSOR;
		goto yy1355;
yy1524:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1525;

			default:
				goto yy1355;
		}

yy1525:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1526;

			default:
				goto yy1355;
		}

yy1526:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy1527;

			default:
				goto yy1355;
		}

yy1527:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1528;

			default:
				goto yy1355;
		}

yy1528:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1529;

			default:
				goto yy1355;
		}

yy1529:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1530;

			default:
				goto yy1355;
		}

yy1530:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1531;

			default:
				goto yy1355;
		}

yy1531:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1532;

			default:
				goto yy1355;
		}

yy1532:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1533;

			default:
				goto yy1355;
		}

yy1533:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1534;

			default:
				goto yy1355;
		}

yy1534:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1535;

			default:
				goto yy1355;
		}

yy1535:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1536;

			default:
				goto yy1355;
		}

yy1536:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1537;

			default:
				goto yy1355;
		}

yy1537:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1538;

			default:
				goto yy1355;
		}

yy1538:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy1539;

			default:
				goto yy1355;
		}

yy1539:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1540;

			case '\r':
				goto yy1542;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '>':
				goto yy1544;

			case 'T':
			case 't':
				goto yy1547;

			default:
				goto yy37;
		}

yy1540:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1540;

			case '\r':
				goto yy1542;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy1547;

			default:
				goto yy36;
		}

yy1542:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1540;

			case '\r':
				goto yy1542;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy1547;

			default:
				goto yy36;
		}

yy1544:
		yych = *++YYCURSOR;
		goto yy608;
yy1545:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1548;

			case '\r':
				goto yy1550;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '/':
				goto yy38;

			case '=':
				goto yy1552;

			case '>':
				goto yy1544;

			default:
				goto yy36;
		}

yy1547:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1548;

			case '\r':
				goto yy1550;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '=':
				goto yy1552;

			case '>':
				goto yy1544;

			case 'E':
			case 'e':
				goto yy1554;

			default:
				goto yy37;
		}

yy1548:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1548;

			case '\r':
				goto yy1550;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '=':
				goto yy1552;

			case '>':
				goto yy1544;

			default:
				goto yy36;
		}

yy1550:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1548;

			case '\r':
				goto yy1550;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '=':
				goto yy1552;

			case '>':
				goto yy1544;

			default:
				goto yy36;
		}

yy1552:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1552;

			case '\r':
				goto yy1641;

			case '"':
				goto yy1595;

			case '\'':
				goto yy1566;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1554:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1548;

			case '\r':
				goto yy1550;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy1545;

			case '=':
				goto yy1552;

			case '>':
				goto yy1544;

			case 'X':
			case 'x':
				goto yy1555;

			default:
				goto yy37;
		}

yy1555:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1548;

			case '\r':
				goto yy1550;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '=':
				goto yy1552;

			case '>':
				goto yy1544;

			case 'T':
			case 't':
				goto yy1556;

			default:
				goto yy37;
		}

yy1556:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1557;

			case '\r':
				goto yy1559;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '=':
				goto yy1561;

			case '>':
				goto yy1544;

			default:
				goto yy37;
		}

yy1557:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1557;

			case '\r':
				goto yy1559;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '=':
				goto yy1561;

			case '>':
				goto yy1544;

			default:
				goto yy36;
		}

yy1559:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1557;

			case '\r':
				goto yy1559;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '=':
				goto yy1561;

			case '>':
				goto yy1544;

			default:
				goto yy36;
		}

yy1561:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1561;

			case '\r':
				goto yy1563;

			case '"':
				goto yy1565;

			case '\'':
				goto yy1566;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1563:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1561;

			case '\r':
				goto yy1563;

			case '"':
				goto yy1565;

			case '\'':
				goto yy1566;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1565:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1597;

			default:
				goto yy1596;
		}

yy1566:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy1571;

			case '/':
				goto yy1568;

			case '>':
				goto yy1570;

			default:
				goto yy1566;
		}

yy1568:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy1571;

			case '/':
				goto yy1568;

			case '>':
				goto yy1594;

			default:
				goto yy1566;
		}

yy1570:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy1578;
yy1571:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1571;

			case '\r':
				goto yy1573;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '>':
				goto yy1544;

			default:
				goto yy36;
		}

yy1573:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1571;

			case '\r':
				goto yy1573;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '>':
				goto yy1544;

			default:
				goto yy36;
		}

yy1575:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1575;

			case '\r':
				goto yy1579;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1582;

			case '>':
				goto yy1581;

			default:
				goto yy9;
		}

yy1577:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1578:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy1575;

			default:
				goto yy1577;
		}

yy1579:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1575;

			case '\r':
				goto yy1579;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1582;

			case '>':
				goto yy1581;

			default:
				goto yy9;
		}

yy1581:
		yych = *++YYCURSOR;
		goto yy608;
yy1582:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1584;

			case '\r':
				goto yy1586;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1582;

			case '=':
				goto yy1588;

			case '>':
				goto yy1581;

			default:
				goto yy9;
		}

yy1584:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1584;

			case '\r':
				goto yy1586;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1582;

			case '=':
				goto yy1588;

			case '>':
				goto yy1581;

			default:
				goto yy9;
		}

yy1586:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1584;

			case '\r':
				goto yy1586;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1582;

			case '=':
				goto yy1588;

			case '>':
				goto yy1581;

			default:
				goto yy9;
		}

yy1588:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1588;

			case '\r':
				goto yy1590;

			case '"':
				goto yy1592;

			case '\'':
				goto yy1577;

			default:
				goto yy9;
		}

yy1590:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1588;

			case '\r':
				goto yy1590;

			case '"':
				goto yy1592;

			case '\'':
				goto yy1577;

			default:
				goto yy9;
		}

yy1592:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1593:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy1575;

			default:
				goto yy1592;
		}

yy1594:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy1578;
yy1595:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1596:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy1571;

			case '/':
				goto yy1598;

			case '>':
				goto yy1600;

			default:
				goto yy1595;
		}

yy1597:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1602;

			default:
				goto yy1596;
		}

yy1598:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy1571;

			case '/':
				goto yy1598;

			case '>':
				goto yy1601;

			default:
				goto yy1595;
		}

yy1600:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy1593;
yy1601:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy1593;
yy1602:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1603;

			default:
				goto yy1596;
		}

yy1603:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1604;

			default:
				goto yy1596;
		}

yy1604:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1605;

			default:
				goto yy1596;
		}

yy1605:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1606;

			default:
				goto yy1596;
		}

yy1606:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1607;

			default:
				goto yy1596;
		}

yy1607:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1608;

			default:
				goto yy1596;
		}

yy1608:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1609;

			case 'P':
			case 'p':
				goto yy1610;

			default:
				goto yy1596;
		}

yy1609:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1626;

			default:
				goto yy1596;
		}

yy1610:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy1611;

			default:
				goto yy1596;
		}

yy1611:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1612;

			default:
				goto yy1596;
		}

yy1612:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1613;

			default:
				goto yy1596;
		}

yy1613:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1614;

			default:
				goto yy1596;
		}

yy1614:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy1615;

			default:
				goto yy1596;
		}

yy1615:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1616;

			default:
				goto yy1596;
		}

yy1616:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1617;

			default:
				goto yy1596;
		}

yy1617:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1618;

			default:
				goto yy1596;
		}

yy1618:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1619;

			default:
				goto yy1596;
		}

yy1619:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1620;

			default:
				goto yy1596;
		}

yy1620:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1621;

			default:
				goto yy1596;
		}

yy1621:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1622;

			default:
				goto yy1596;
		}

yy1622:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1623;

			default:
				goto yy1596;
		}

yy1623:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1624;

			default:
				goto yy1596;
		}

yy1624:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1625;

			default:
				goto yy1596;
		}

yy1625:
		yych = *++YYCURSOR;
		goto yy1596;
yy1626:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1627;

			default:
				goto yy1596;
		}

yy1627:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1628;

			default:
				goto yy1596;
		}

yy1628:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy1629;

			default:
				goto yy1596;
		}

yy1629:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1630;

			default:
				goto yy1596;
		}

yy1630:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1631;

			default:
				goto yy1596;
		}

yy1631:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1632;

			default:
				goto yy1596;
		}

yy1632:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1633;

			default:
				goto yy1596;
		}

yy1633:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1634;

			default:
				goto yy1596;
		}

yy1634:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1635;

			default:
				goto yy1596;
		}

yy1635:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1636;

			default:
				goto yy1596;
		}

yy1636:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1637;

			default:
				goto yy1596;
		}

yy1637:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1638;

			default:
				goto yy1596;
		}

yy1638:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1639;

			default:
				goto yy1596;
		}

yy1639:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1640;

			default:
				goto yy1596;
		}

yy1640:
		yych = *++YYCURSOR;
		goto yy1596;
yy1641:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1552;

			case '\r':
				goto yy1641;

			case '"':
				goto yy1595;

			case '\'':
				goto yy1566;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1643:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1644;

			default:
				goto yy1303;
		}

yy1644:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1645;

			default:
				goto yy1303;
		}

yy1645:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy1646;

			default:
				goto yy1303;
		}

yy1646:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1647;

			default:
				goto yy1303;
		}

yy1647:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1648;

			default:
				goto yy1303;
		}

yy1648:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1649;

			default:
				goto yy1303;
		}

yy1649:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1650;

			default:
				goto yy1303;
		}

yy1650:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1651;

			default:
				goto yy1303;
		}

yy1651:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1652;

			default:
				goto yy1303;
		}

yy1652:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1653;

			default:
				goto yy1303;
		}

yy1653:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1654;

			default:
				goto yy1303;
		}

yy1654:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1655;

			default:
				goto yy1303;
		}

yy1655:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1656;

			default:
				goto yy1303;
		}

yy1656:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1657;

			default:
				goto yy1303;
		}

yy1657:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy1658;

			default:
				goto yy1303;
		}

yy1658:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1659;

			case '\r':
				goto yy1661;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1663;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy1665;

			default:
				goto yy37;
		}

yy1659:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1659;

			case '\r':
				goto yy1661;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1663;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy1665;

			default:
				goto yy36;
		}

yy1661:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1659;

			case '\r':
				goto yy1661;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1663;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy1665;

			default:
				goto yy36;
		}

yy1663:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1669;

			case '\r':
				goto yy1671;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1663;

			case '/':
				goto yy38;

			case '=':
				goto yy1673;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy1667;

			default:
				goto yy36;
		}

yy1665:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1669;

			case '\r':
				goto yy1671;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1663;

			case '=':
				goto yy1673;

			case '>':
				goto yy778;

			case 'E':
			case 'e':
				goto yy1666;

			case 'T':
			case 't':
				goto yy1667;

			default:
				goto yy37;
		}

yy1666:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1669;

			case '\r':
				goto yy1671;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy1663;

			case '=':
				goto yy1673;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy1667;

			case 'X':
			case 'x':
				goto yy1811;

			default:
				goto yy37;
		}

yy1667:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1669;

			case '\r':
				goto yy1671;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1663;

			case '/':
				goto yy38;

			case '=':
				goto yy1673;

			case '>':
				goto yy778;

			case 'E':
			case 'e':
				goto yy1701;

			case 'T':
			case 't':
				goto yy1667;

			default:
				goto yy36;
		}

yy1669:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1669;

			case '\r':
				goto yy1671;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '=':
				goto yy1673;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy777;

			default:
				goto yy36;
		}

yy1671:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1669;

			case '\r':
				goto yy1671;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '=':
				goto yy1673;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy777;

			default:
				goto yy36;
		}

yy1673:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1673;

			case '\r':
				goto yy1675;

			case '"':
				goto yy1677;

			case '\'':
				goto yy1679;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1675:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1673;

			case '\r':
				goto yy1675;

			case '"':
				goto yy1677;

			case '\'':
				goto yy1679;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1677:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1678:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy1684;

			case '/':
				goto yy1695;

			case '>':
				goto yy1697;

			default:
				goto yy1677;
		}

yy1679:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy1684;

			case '/':
				goto yy1681;

			case '>':
				goto yy1683;

			default:
				goto yy1679;
		}

yy1681:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy1684;

			case '/':
				goto yy1681;

			case '>':
				goto yy1694;

			default:
				goto yy1679;
		}

yy1683:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy1691;
yy1684:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1684;

			case '\r':
				goto yy1686;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy777;

			default:
				goto yy36;
		}

yy1686:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1684;

			case '\r':
				goto yy1686;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy777;

			default:
				goto yy36;
		}

yy1688:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1688;

			case '\r':
				goto yy1692;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy814;

			case '>':
				goto yy813;

			case 'T':
			case 't':
				goto yy1165;

			default:
				goto yy9;
		}

yy1690:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1691:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy1688;

			default:
				goto yy1690;
		}

yy1692:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1688;

			case '\r':
				goto yy1692;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy814;

			case '>':
				goto yy813;

			case 'T':
			case 't':
				goto yy1165;

			default:
				goto yy9;
		}

yy1694:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy1691;
yy1695:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy1684;

			case '/':
				goto yy1695;

			case '>':
				goto yy1700;

			default:
				goto yy1677;
		}

yy1697:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy1699;
yy1698:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1699:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy1688;

			default:
				goto yy1698;
		}

yy1700:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy1699;
yy1701:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1669;

			case '\r':
				goto yy1671;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy1663;

			case '/':
				goto yy38;

			case '=':
				goto yy1673;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy1667;

			case 'X':
			case 'x':
				goto yy1702;

			default:
				goto yy36;
		}

yy1702:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1669;

			case '\r':
				goto yy1671;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1663;

			case '/':
				goto yy38;

			case '=':
				goto yy1673;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy1703;

			default:
				goto yy36;
		}

yy1703:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1704;

			case '\r':
				goto yy1706;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1663;

			case '/':
				goto yy38;

			case '=':
				goto yy1708;

			case '>':
				goto yy778;

			case 'E':
			case 'e':
				goto yy1701;

			case 'T':
			case 't':
				goto yy1667;

			default:
				goto yy36;
		}

yy1704:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1704;

			case '\r':
				goto yy1706;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '=':
				goto yy1708;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy777;

			default:
				goto yy36;
		}

yy1706:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1704;

			case '\r':
				goto yy1706;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '=':
				goto yy1708;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy777;

			default:
				goto yy36;
		}

yy1708:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1708;

			case '\r':
				goto yy1710;

			case '"':
				goto yy1712;

			case '\'':
				goto yy1679;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1710:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1708;

			case '\r':
				goto yy1710;

			case '"':
				goto yy1712;

			case '\'':
				goto yy1679;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1712:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1713;

			default:
				goto yy1678;
		}

yy1713:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1714;

			default:
				goto yy1678;
		}

yy1714:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1715;

			default:
				goto yy1678;
		}

yy1715:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1716;

			default:
				goto yy1678;
		}

yy1716:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1717;

			default:
				goto yy1678;
		}

yy1717:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1718;

			default:
				goto yy1678;
		}

yy1718:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1719;

			default:
				goto yy1678;
		}

yy1719:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1720;

			default:
				goto yy1678;
		}

yy1720:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1721;

			case 'P':
			case 'p':
				goto yy1722;

			default:
				goto yy1678;
		}

yy1721:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1796;

			default:
				goto yy1678;
		}

yy1722:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy1723;

			default:
				goto yy1678;
		}

yy1723:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1724;

			default:
				goto yy1678;
		}

yy1724:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1725;

			default:
				goto yy1678;
		}

yy1725:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1726;

			default:
				goto yy1678;
		}

yy1726:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy1727;

			default:
				goto yy1678;
		}

yy1727:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1728;

			default:
				goto yy1678;
		}

yy1728:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1729;

			default:
				goto yy1678;
		}

yy1729:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1730;

			default:
				goto yy1678;
		}

yy1730:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1731;

			default:
				goto yy1678;
		}

yy1731:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1732;

			default:
				goto yy1678;
		}

yy1732:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1733;

			default:
				goto yy1678;
		}

yy1733:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1734;

			default:
				goto yy1678;
		}

yy1734:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1735;

			default:
				goto yy1678;
		}

yy1735:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1736;

			default:
				goto yy1678;
		}

yy1736:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1737;

			default:
				goto yy1678;
		}

yy1737:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy1738;

			default:
				goto yy1678;
		}

yy1738:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1739;

			case '\r':
				goto yy1741;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '>':
				goto yy859;

			case 'T':
			case 't':
				goto yy1743;

			default:
				goto yy37;
		}

yy1739:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1739;

			case '\r':
				goto yy1741;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy1743;

			default:
				goto yy36;
		}

yy1741:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1739;

			case '\r':
				goto yy1741;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy1743;

			default:
				goto yy36;
		}

yy1743:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy866;

			case '\r':
				goto yy868;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '=':
				goto yy870;

			case '>':
				goto yy859;

			case 'E':
			case 'e':
				goto yy1744;

			default:
				goto yy37;
		}

yy1744:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy866;

			case '\r':
				goto yy868;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy864;

			case '=':
				goto yy870;

			case '>':
				goto yy859;

			case 'X':
			case 'x':
				goto yy1745;

			default:
				goto yy37;
		}

yy1745:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy866;

			case '\r':
				goto yy868;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '=':
				goto yy870;

			case '>':
				goto yy859;

			case 'T':
			case 't':
				goto yy1746;

			default:
				goto yy37;
		}

yy1746:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1747;

			case '\r':
				goto yy1749;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '=':
				goto yy1751;

			case '>':
				goto yy859;

			default:
				goto yy37;
		}

yy1747:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1747;

			case '\r':
				goto yy1749;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '=':
				goto yy1751;

			case '>':
				goto yy859;

			default:
				goto yy36;
		}

yy1749:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1747;

			case '\r':
				goto yy1749;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '=':
				goto yy1751;

			case '>':
				goto yy859;

			default:
				goto yy36;
		}

yy1751:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1751;

			case '\r':
				goto yy1753;

			case '"':
				goto yy1755;

			case '\'':
				goto yy876;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1753:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1751;

			case '\r':
				goto yy1753;

			case '"':
				goto yy1755;

			case '\'':
				goto yy876;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1755:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1756;

			default:
				goto yy875;
		}

yy1756:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1757;

			default:
				goto yy875;
		}

yy1757:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1758;

			default:
				goto yy875;
		}

yy1758:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1759;

			default:
				goto yy875;
		}

yy1759:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1760;

			default:
				goto yy875;
		}

yy1760:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1761;

			default:
				goto yy875;
		}

yy1761:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1762;

			default:
				goto yy875;
		}

yy1762:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1763;

			default:
				goto yy875;
		}

yy1763:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1764;

			case 'P':
			case 'p':
				goto yy1765;

			default:
				goto yy875;
		}

yy1764:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1781;

			default:
				goto yy875;
		}

yy1765:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy1766;

			default:
				goto yy875;
		}

yy1766:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1767;

			default:
				goto yy875;
		}

yy1767:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1768;

			default:
				goto yy875;
		}

yy1768:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1769;

			default:
				goto yy875;
		}

yy1769:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy1770;

			default:
				goto yy875;
		}

yy1770:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1771;

			default:
				goto yy875;
		}

yy1771:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1772;

			default:
				goto yy875;
		}

yy1772:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1773;

			default:
				goto yy875;
		}

yy1773:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1774;

			default:
				goto yy875;
		}

yy1774:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1775;

			default:
				goto yy875;
		}

yy1775:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1776;

			default:
				goto yy875;
		}

yy1776:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1777;

			default:
				goto yy875;
		}

yy1777:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1778;

			default:
				goto yy875;
		}

yy1778:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1779;

			default:
				goto yy875;
		}

yy1779:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1780;

			default:
				goto yy875;
		}

yy1780:
		yych = *++YYCURSOR;
		goto yy875;
yy1781:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1782;

			default:
				goto yy875;
		}

yy1782:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1783;

			default:
				goto yy875;
		}

yy1783:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy1784;

			default:
				goto yy875;
		}

yy1784:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1785;

			default:
				goto yy875;
		}

yy1785:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1786;

			default:
				goto yy875;
		}

yy1786:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1787;

			default:
				goto yy875;
		}

yy1787:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1788;

			default:
				goto yy875;
		}

yy1788:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1789;

			default:
				goto yy875;
		}

yy1789:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1790;

			default:
				goto yy875;
		}

yy1790:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1791;

			default:
				goto yy875;
		}

yy1791:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1792;

			default:
				goto yy875;
		}

yy1792:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1793;

			default:
				goto yy875;
		}

yy1793:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1794;

			default:
				goto yy875;
		}

yy1794:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1795;

			default:
				goto yy875;
		}

yy1795:
		yych = *++YYCURSOR;
		goto yy875;
yy1796:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1797;

			default:
				goto yy1678;
		}

yy1797:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1798;

			default:
				goto yy1678;
		}

yy1798:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy1799;

			default:
				goto yy1678;
		}

yy1799:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1800;

			default:
				goto yy1678;
		}

yy1800:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1801;

			default:
				goto yy1678;
		}

yy1801:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1802;

			default:
				goto yy1678;
		}

yy1802:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1803;

			default:
				goto yy1678;
		}

yy1803:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1804;

			default:
				goto yy1678;
		}

yy1804:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1805;

			default:
				goto yy1678;
		}

yy1805:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1806;

			default:
				goto yy1678;
		}

yy1806:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1807;

			default:
				goto yy1678;
		}

yy1807:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1808;

			default:
				goto yy1678;
		}

yy1808:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1809;

			default:
				goto yy1678;
		}

yy1809:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1810;

			default:
				goto yy1678;
		}

yy1810:
		yych = *++YYCURSOR;
		goto yy1678;
yy1811:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1669;

			case '\r':
				goto yy1671;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1663;

			case '=':
				goto yy1673;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy1812;

			default:
				goto yy37;
		}

yy1812:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1813;

			case '\r':
				goto yy1815;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1663;

			case '=':
				goto yy1817;

			case '>':
				goto yy778;

			case 'E':
			case 'e':
				goto yy1701;

			case 'T':
			case 't':
				goto yy1667;

			default:
				goto yy37;
		}

yy1813:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1813;

			case '\r':
				goto yy1815;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '=':
				goto yy1817;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy777;

			default:
				goto yy36;
		}

yy1815:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1813;

			case '\r':
				goto yy1815;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '=':
				goto yy1817;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy777;

			default:
				goto yy36;
		}

yy1817:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1817;

			case '\r':
				goto yy1819;

			case '"':
				goto yy1821;

			case '\'':
				goto yy1679;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1819:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1817;

			case '\r':
				goto yy1819;

			case '"':
				goto yy1821;

			case '\'':
				goto yy1679;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1821:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1822;

			default:
				goto yy1678;
		}

yy1822:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1823;

			default:
				goto yy1678;
		}

yy1823:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1824;

			default:
				goto yy1678;
		}

yy1824:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1825;

			default:
				goto yy1678;
		}

yy1825:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1826;

			default:
				goto yy1678;
		}

yy1826:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1827;

			default:
				goto yy1678;
		}

yy1827:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1828;

			default:
				goto yy1678;
		}

yy1828:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1829;

			default:
				goto yy1678;
		}

yy1829:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1830;

			case 'P':
			case 'p':
				goto yy1831;

			default:
				goto yy1678;
		}

yy1830:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1852;

			default:
				goto yy1678;
		}

yy1831:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy1832;

			default:
				goto yy1678;
		}

yy1832:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1833;

			default:
				goto yy1678;
		}

yy1833:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1834;

			default:
				goto yy1678;
		}

yy1834:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1835;

			default:
				goto yy1678;
		}

yy1835:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy1836;

			default:
				goto yy1678;
		}

yy1836:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1837;

			default:
				goto yy1678;
		}

yy1837:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1838;

			default:
				goto yy1678;
		}

yy1838:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1839;

			default:
				goto yy1678;
		}

yy1839:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1840;

			default:
				goto yy1678;
		}

yy1840:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1841;

			default:
				goto yy1678;
		}

yy1841:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1842;

			default:
				goto yy1678;
		}

yy1842:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1843;

			default:
				goto yy1678;
		}

yy1843:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1844;

			default:
				goto yy1678;
		}

yy1844:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1845;

			default:
				goto yy1678;
		}

yy1845:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1846;

			default:
				goto yy1678;
		}

yy1846:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy1847;

			default:
				goto yy1678;
		}

yy1847:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1848;

			case '\r':
				goto yy1850;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '>':
				goto yy1544;

			case 'T':
			case 't':
				goto yy1547;

			default:
				goto yy37;
		}

yy1848:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1848;

			case '\r':
				goto yy1850;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy1547;

			default:
				goto yy36;
		}

yy1850:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1848;

			case '\r':
				goto yy1850;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy1547;

			default:
				goto yy36;
		}

yy1852:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1853;

			default:
				goto yy1678;
		}

yy1853:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1854;

			default:
				goto yy1678;
		}

yy1854:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy1855;

			default:
				goto yy1678;
		}

yy1855:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1856;

			default:
				goto yy1678;
		}

yy1856:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1857;

			default:
				goto yy1678;
		}

yy1857:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1858;

			default:
				goto yy1678;
		}

yy1858:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1859;

			default:
				goto yy1678;
		}

yy1859:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1860;

			default:
				goto yy1678;
		}

yy1860:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1861;

			default:
				goto yy1678;
		}

yy1861:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1862;

			default:
				goto yy1678;
		}

yy1862:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1863;

			default:
				goto yy1678;
		}

yy1863:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1864;

			default:
				goto yy1678;
		}

yy1864:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1865;

			default:
				goto yy1678;
		}

yy1865:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1866;

			default:
				goto yy1678;
		}

yy1866:
		yych = *++YYCURSOR;
		goto yy1678;
yy1867:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy53;

			case '\r':
				goto yy55;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '=':
				goto yy57;

			case 'T':
			case 't':
				goto yy1868;

			default:
				goto yy37;
		}

yy1868:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1869;

			case '\r':
				goto yy1871;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '=':
				goto yy1873;

			case 'E':
			case 'e':
				goto yy62;

			case 'T':
			case 't':
				goto yy60;

			default:
				goto yy37;
		}

yy1869:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1869;

			case '\r':
				goto yy1871;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy1873;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy85;

			default:
				goto yy36;
		}

yy1871:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1869;

			case '\r':
				goto yy1871;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy1873;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy85;

			default:
				goto yy36;
		}

yy1873:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1873;

			case '\r':
				goto yy1875;

			case '"':
				goto yy1877;

			case '\'':
				goto yy74;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1875:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1873;

			case '\r':
				goto yy1875;

			case '"':
				goto yy1877;

			case '\'':
				goto yy74;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1877:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1878;

			default:
				goto yy1303;
		}

yy1878:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1879;

			default:
				goto yy1303;
		}

yy1879:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1880;

			default:
				goto yy1303;
		}

yy1880:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1881;

			default:
				goto yy1303;
		}

yy1881:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1882;

			default:
				goto yy1303;
		}

yy1882:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1883;

			default:
				goto yy1303;
		}

yy1883:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1884;

			default:
				goto yy1303;
		}

yy1884:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1885;

			default:
				goto yy1303;
		}

yy1885:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1886;

			case 'P':
			case 'p':
				goto yy1887;

			default:
				goto yy1303;
		}

yy1886:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2444;

			default:
				goto yy1303;
		}

yy1887:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy1888;

			default:
				goto yy1303;
		}

yy1888:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1889;

			default:
				goto yy1303;
		}

yy1889:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1890;

			default:
				goto yy1303;
		}

yy1890:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1891;

			default:
				goto yy1303;
		}

yy1891:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy1892;

			default:
				goto yy1303;
		}

yy1892:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1893;

			default:
				goto yy1303;
		}

yy1893:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1894;

			default:
				goto yy1303;
		}

yy1894:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1895;

			default:
				goto yy1303;
		}

yy1895:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1896;

			default:
				goto yy1303;
		}

yy1896:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1897;

			default:
				goto yy1303;
		}

yy1897:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1898;

			default:
				goto yy1303;
		}

yy1898:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1899;

			default:
				goto yy1303;
		}

yy1899:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1900;

			default:
				goto yy1303;
		}

yy1900:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1901;

			default:
				goto yy1303;
		}

yy1901:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1902;

			default:
				goto yy1303;
		}

yy1902:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy1903;

			default:
				goto yy1303;
		}

yy1903:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1904;

			case '\r':
				goto yy1906;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1909;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy1908;

			default:
				goto yy37;
		}

yy1904:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1904;

			case '\r':
				goto yy1906;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1909;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy1908;

			default:
				goto yy36;
		}

yy1906:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1904;

			case '\r':
				goto yy1906;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1909;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy1908;

			default:
				goto yy36;
		}

yy1908:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1912;

			case '\r':
				goto yy1914;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1909;

			case '=':
				goto yy1916;

			case '>':
				goto yy1911;

			case 'E':
			case 'e':
				goto yy2283;

			case 'T':
			case 't':
				goto yy1918;

			default:
				goto yy37;
		}

yy1909:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1912;

			case '\r':
				goto yy1914;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1909;

			case '/':
				goto yy38;

			case '=':
				goto yy1916;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy1918;

			default:
				goto yy36;
		}

yy1911:
		yych = *++YYCURSOR;
		goto yy608;
yy1912:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1912;

			case '\r':
				goto yy1914;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '=':
				goto yy1916;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy2051;

			default:
				goto yy36;
		}

yy1914:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1912;

			case '\r':
				goto yy1914;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '=':
				goto yy1916;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy2051;

			default:
				goto yy36;
		}

yy1916:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1916;

			case '\r':
				goto yy2281;

			case '"':
				goto yy2166;

			case '\'':
				goto yy1932;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1918:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1912;

			case '\r':
				goto yy1914;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1909;

			case '/':
				goto yy38;

			case '=':
				goto yy1916;

			case '>':
				goto yy1911;

			case 'E':
			case 'e':
				goto yy1920;

			case 'T':
			case 't':
				goto yy1918;

			default:
				goto yy36;
		}

yy1920:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1912;

			case '\r':
				goto yy1914;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy1909;

			case '/':
				goto yy38;

			case '=':
				goto yy1916;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy1918;

			case 'X':
			case 'x':
				goto yy1921;

			default:
				goto yy36;
		}

yy1921:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1912;

			case '\r':
				goto yy1914;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1909;

			case '/':
				goto yy38;

			case '=':
				goto yy1916;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy1922;

			default:
				goto yy36;
		}

yy1922:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1923;

			case '\r':
				goto yy1925;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1909;

			case '/':
				goto yy38;

			case '=':
				goto yy1927;

			case '>':
				goto yy1911;

			case 'E':
			case 'e':
				goto yy1920;

			case 'T':
			case 't':
				goto yy1918;

			default:
				goto yy36;
		}

yy1923:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1923;

			case '\r':
				goto yy1925;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '=':
				goto yy1927;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy2051;

			default:
				goto yy36;
		}

yy1925:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1923;

			case '\r':
				goto yy1925;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '=':
				goto yy1927;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy2051;

			default:
				goto yy36;
		}

yy1927:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1927;

			case '\r':
				goto yy1929;

			case '"':
				goto yy1931;

			case '\'':
				goto yy1932;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1929:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1927;

			case '\r':
				goto yy1929;

			case '"':
				goto yy1931;

			case '\'':
				goto yy1932;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy1931:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2168;

			default:
				goto yy2167;
		}

yy1932:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy1935;

			case '/':
				goto yy1937;

			case '>':
				goto yy1934;

			default:
				goto yy1932;
		}

yy1934:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy1943;
yy1935:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1935;

			case '\r':
				goto yy2047;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy2051;

			default:
				goto yy36;
		}

yy1937:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy1935;

			case '/':
				goto yy1937;

			case '>':
				goto yy1939;

			default:
				goto yy1932;
		}

yy1939:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy1943;
yy1940:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1940;

			case '\r':
				goto yy1944;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1947;

			case '>':
				goto yy1946;

			case 'T':
			case 't':
				goto yy1949;

			default:
				goto yy9;
		}

yy1942:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1943:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy1940;

			default:
				goto yy1942;
		}

yy1944:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1940;

			case '\r':
				goto yy1944;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1947;

			case '>':
				goto yy1946;

			case 'T':
			case 't':
				goto yy1949;

			default:
				goto yy9;
		}

yy1946:
		yych = *++YYCURSOR;
		goto yy608;
yy1947:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1951;

			case '\r':
				goto yy1953;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1947;

			case '=':
				goto yy1955;

			case '>':
				goto yy1946;

			default:
				goto yy9;
		}

yy1949:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy1947;

			case 'E':
			case 'e':
				goto yy1950;

			default:
				goto yy1952;
		}

yy1950:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy1947;

			case 'X':
			case 'x':
				goto yy1967;

			default:
				goto yy1952;
		}

yy1951:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1952:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1951;

			case '\r':
				goto yy1953;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1947;

			case '=':
				goto yy1955;

			case '>':
				goto yy1946;

			default:
				goto yy9;
		}

yy1953:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1951;

			case '\r':
				goto yy1953;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1947;

			case '=':
				goto yy1955;

			case '>':
				goto yy1946;

			default:
				goto yy9;
		}

yy1955:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1955;

			case '\r':
				goto yy1957;

			case '"':
				goto yy1959;

			case '\'':
				goto yy1961;

			default:
				goto yy9;
		}

yy1957:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1955;

			case '\r':
				goto yy1957;

			case '"':
				goto yy1959;

			case '\'':
				goto yy1961;

			default:
				goto yy9;
		}

yy1959:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1960:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy1963;

			default:
				goto yy1959;
		}

yy1961:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1962:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy1963;

			default:
				goto yy1961;
		}

yy1963:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1963;

			case '\r':
				goto yy1965;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1947;

			case '>':
				goto yy1946;

			default:
				goto yy9;
		}

yy1965:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1963;

			case '\r':
				goto yy1965;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1947;

			case '>':
				goto yy1946;

			default:
				goto yy9;
		}

yy1967:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy1947;

			case 'T':
			case 't':
				goto yy1968;

			default:
				goto yy1952;
		}

yy1968:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy1947;

			default:
				goto yy1970;
		}

yy1969:
		++YYCURSOR;
		yych = *YYCURSOR;
yy1970:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1969;

			case '\r':
				goto yy1971;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1947;

			case '=':
				goto yy1973;

			case '>':
				goto yy1946;

			default:
				goto yy9;
		}

yy1971:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1969;

			case '\r':
				goto yy1971;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1947;

			case '=':
				goto yy1973;

			case '>':
				goto yy1946;

			default:
				goto yy9;
		}

yy1973:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1973;

			case '\r':
				goto yy1975;

			case '"':
				goto yy1977;

			case '\'':
				goto yy1961;

			default:
				goto yy9;
		}

yy1975:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1973;

			case '\r':
				goto yy1975;

			case '"':
				goto yy1977;

			case '\'':
				goto yy1961;

			default:
				goto yy9;
		}

yy1977:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1978;

			default:
				goto yy1960;
		}

yy1978:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1979;

			default:
				goto yy1960;
		}

yy1979:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1980;

			default:
				goto yy1960;
		}

yy1980:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1981;

			default:
				goto yy1960;
		}

yy1981:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1982;

			default:
				goto yy1960;
		}

yy1982:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy1983;

			default:
				goto yy1960;
		}

yy1983:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1984;

			default:
				goto yy1960;
		}

yy1984:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1985;

			default:
				goto yy1960;
		}

yy1985:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1986;

			case 'P':
			case 'p':
				goto yy1987;

			default:
				goto yy1960;
		}

yy1986:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2008;

			default:
				goto yy1960;
		}

yy1987:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy1988;

			default:
				goto yy1960;
		}

yy1988:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1989;

			default:
				goto yy1960;
		}

yy1989:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy1990;

			default:
				goto yy1960;
		}

yy1990:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy1991;

			default:
				goto yy1960;
		}

yy1991:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy1992;

			default:
				goto yy1960;
		}

yy1992:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1993;

			default:
				goto yy1960;
		}

yy1993:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy1994;

			default:
				goto yy1960;
		}

yy1994:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1995;

			default:
				goto yy1960;
		}

yy1995:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy1996;

			default:
				goto yy1960;
		}

yy1996:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy1997;

			default:
				goto yy1960;
		}

yy1997:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy1998;

			default:
				goto yy1960;
		}

yy1998:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy1999;

			default:
				goto yy1960;
		}

yy1999:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2000;

			default:
				goto yy1960;
		}

yy2000:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2001;

			default:
				goto yy1960;
		}

yy2001:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2002;

			default:
				goto yy1960;
		}

yy2002:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2003;

			default:
				goto yy1960;
		}

yy2003:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy642;

			default:
				goto yy2005;
		}

yy2004:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2005:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2004;

			case '\r':
				goto yy2006;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy643;

			case '>':
				goto yy1946;

			default:
				goto yy9;
		}

yy2006:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2004;

			case '\r':
				goto yy2006;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy643;

			case '>':
				goto yy1946;

			default:
				goto yy9;
		}

yy2008:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2009;

			default:
				goto yy1960;
		}

yy2009:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2010;

			default:
				goto yy1960;
		}

yy2010:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy2011;

			default:
				goto yy1960;
		}

yy2011:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2012;

			default:
				goto yy1960;
		}

yy2012:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2013;

			default:
				goto yy1960;
		}

yy2013:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2014;

			default:
				goto yy1960;
		}

yy2014:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2015;

			default:
				goto yy1960;
		}

yy2015:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2016;

			default:
				goto yy1960;
		}

yy2016:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2017;

			default:
				goto yy1960;
		}

yy2017:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2018;

			default:
				goto yy1960;
		}

yy2018:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2019;

			default:
				goto yy1960;
		}

yy2019:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2020;

			default:
				goto yy1960;
		}

yy2020:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2021;

			default:
				goto yy1960;
		}

yy2021:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2022;

			default:
				goto yy1960;
		}

yy2022:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2023;

			default:
				goto yy1960;
		}

yy2023:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy2030;

			default:
				goto yy2025;
		}

yy2024:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2025:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2024;

			case '\r':
				goto yy2026;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2028;

			case '>':
				goto yy1946;

			default:
				goto yy9;
		}

yy2026:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2024;

			case '\r':
				goto yy2026;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2028;

			case '>':
				goto yy1946;

			default:
				goto yy9;
		}

yy2028:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2031;

			case '\r':
				goto yy2033;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2028;

			case '=':
				goto yy2035;

			case '>':
				goto yy2030;

			default:
				goto yy9;
		}

yy2030:
		yych = *++YYCURSOR;
		goto yy608;
yy2031:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2031;

			case '\r':
				goto yy2033;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2028;

			case '=':
				goto yy2035;

			case '>':
				goto yy2030;

			default:
				goto yy9;
		}

yy2033:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2031;

			case '\r':
				goto yy2033;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2028;

			case '=':
				goto yy2035;

			case '>':
				goto yy2030;

			default:
				goto yy9;
		}

yy2035:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2035;

			case '\r':
				goto yy2037;

			case '"':
				goto yy2039;

			case '\'':
				goto yy2041;

			default:
				goto yy9;
		}

yy2037:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2035;

			case '\r':
				goto yy2037;

			case '"':
				goto yy2039;

			case '\'':
				goto yy2041;

			default:
				goto yy9;
		}

yy2039:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2040:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2043;

			default:
				goto yy2039;
		}

yy2041:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2042:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2043;

			default:
				goto yy2041;
		}

yy2043:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2043;

			case '\r':
				goto yy2045;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2028;

			case '>':
				goto yy2030;

			default:
				goto yy9;
		}

yy2045:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2043;

			case '\r':
				goto yy2045;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2028;

			case '>':
				goto yy2030;

			default:
				goto yy9;
		}

yy2047:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1935;

			case '\r':
				goto yy2047;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy2051;

			default:
				goto yy36;
		}

yy2049:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2052;

			case '\r':
				goto yy2054;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '/':
				goto yy38;

			case '=':
				goto yy2056;

			case '>':
				goto yy1911;

			default:
				goto yy36;
		}

yy2051:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2052;

			case '\r':
				goto yy2054;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '=':
				goto yy2056;

			case '>':
				goto yy1911;

			case 'E':
			case 'e':
				goto yy2058;

			default:
				goto yy37;
		}

yy2052:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2052;

			case '\r':
				goto yy2054;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '=':
				goto yy2056;

			case '>':
				goto yy1911;

			default:
				goto yy36;
		}

yy2054:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2052;

			case '\r':
				goto yy2054;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '=':
				goto yy2056;

			case '>':
				goto yy1911;

			default:
				goto yy36;
		}

yy2056:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2056;

			case '\r':
				goto yy2163;

			case '"':
				goto yy2080;

			case '\'':
				goto yy2070;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2058:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2052;

			case '\r':
				goto yy2054;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy2049;

			case '=':
				goto yy2056;

			case '>':
				goto yy1911;

			case 'X':
			case 'x':
				goto yy2059;

			default:
				goto yy37;
		}

yy2059:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2052;

			case '\r':
				goto yy2054;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '=':
				goto yy2056;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy2060;

			default:
				goto yy37;
		}

yy2060:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2061;

			case '\r':
				goto yy2063;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '=':
				goto yy2065;

			case '>':
				goto yy1911;

			default:
				goto yy37;
		}

yy2061:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2061;

			case '\r':
				goto yy2063;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '=':
				goto yy2065;

			case '>':
				goto yy1911;

			default:
				goto yy36;
		}

yy2063:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2061;

			case '\r':
				goto yy2063;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '=':
				goto yy2065;

			case '>':
				goto yy1911;

			default:
				goto yy36;
		}

yy2065:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2065;

			case '\r':
				goto yy2067;

			case '"':
				goto yy2069;

			case '\'':
				goto yy2070;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2067:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2065;

			case '\r':
				goto yy2067;

			case '"':
				goto yy2069;

			case '\'':
				goto yy2070;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2069:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2082;

			default:
				goto yy2081;
		}

yy2070:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2075;

			case '/':
				goto yy2072;

			case '>':
				goto yy2074;

			default:
				goto yy2070;
		}

yy2072:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2075;

			case '/':
				goto yy2072;

			case '>':
				goto yy2079;

			default:
				goto yy2070;
		}

yy2074:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy1962;
yy2075:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2075;

			case '\r':
				goto yy2077;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '>':
				goto yy1911;

			default:
				goto yy36;
		}

yy2077:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2075;

			case '\r':
				goto yy2077;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '>':
				goto yy1911;

			default:
				goto yy36;
		}

yy2079:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy1962;
yy2080:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2081:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2075;

			case '/':
				goto yy2083;

			case '>':
				goto yy2085;

			default:
				goto yy2080;
		}

yy2082:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2087;

			default:
				goto yy2081;
		}

yy2083:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2075;

			case '/':
				goto yy2083;

			case '>':
				goto yy2086;

			default:
				goto yy2080;
		}

yy2085:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy1960;
yy2086:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy1960;
yy2087:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2088;

			default:
				goto yy2081;
		}

yy2088:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2089;

			default:
				goto yy2081;
		}

yy2089:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2090;

			default:
				goto yy2081;
		}

yy2090:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2091;

			default:
				goto yy2081;
		}

yy2091:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2092;

			default:
				goto yy2081;
		}

yy2092:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2093;

			default:
				goto yy2081;
		}

yy2093:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2094;

			case 'P':
			case 'p':
				goto yy2095;

			default:
				goto yy2081;
		}

yy2094:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2116;

			default:
				goto yy2081;
		}

yy2095:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy2096;

			default:
				goto yy2081;
		}

yy2096:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2097;

			default:
				goto yy2081;
		}

yy2097:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2098;

			default:
				goto yy2081;
		}

yy2098:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2099;

			default:
				goto yy2081;
		}

yy2099:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy2100;

			default:
				goto yy2081;
		}

yy2100:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2101;

			default:
				goto yy2081;
		}

yy2101:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2102;

			default:
				goto yy2081;
		}

yy2102:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2103;

			default:
				goto yy2081;
		}

yy2103:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2104;

			default:
				goto yy2081;
		}

yy2104:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2105;

			default:
				goto yy2081;
		}

yy2105:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2106;

			default:
				goto yy2081;
		}

yy2106:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2107;

			default:
				goto yy2081;
		}

yy2107:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2108;

			default:
				goto yy2081;
		}

yy2108:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2109;

			default:
				goto yy2081;
		}

yy2109:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2110;

			default:
				goto yy2081;
		}

yy2110:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2111;

			default:
				goto yy2081;
		}

yy2111:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2112;

			case '\r':
				goto yy2114;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '>':
				goto yy607;

			default:
				goto yy37;
		}

yy2112:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2112;

			case '\r':
				goto yy2114;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '>':
				goto yy1911;

			default:
				goto yy36;
		}

yy2114:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2112;

			case '\r':
				goto yy2114;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '>':
				goto yy1911;

			default:
				goto yy36;
		}

yy2116:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2117;

			default:
				goto yy2081;
		}

yy2117:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2118;

			default:
				goto yy2081;
		}

yy2118:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy2119;

			default:
				goto yy2081;
		}

yy2119:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2120;

			default:
				goto yy2081;
		}

yy2120:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2121;

			default:
				goto yy2081;
		}

yy2121:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2122;

			default:
				goto yy2081;
		}

yy2122:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2123;

			default:
				goto yy2081;
		}

yy2123:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2124;

			default:
				goto yy2081;
		}

yy2124:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2125;

			default:
				goto yy2081;
		}

yy2125:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2126;

			default:
				goto yy2081;
		}

yy2126:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2127;

			default:
				goto yy2081;
		}

yy2127:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2128;

			default:
				goto yy2081;
		}

yy2128:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2129;

			default:
				goto yy2081;
		}

yy2129:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2130;

			default:
				goto yy2081;
		}

yy2130:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2131;

			default:
				goto yy2081;
		}

yy2131:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2133;

			case '\r':
				goto yy2135;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2137;

			case '>':
				goto yy2132;

			default:
				goto yy37;
		}

yy2132:
		yych = *++YYCURSOR;
		goto yy608;
yy2133:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2133;

			case '\r':
				goto yy2135;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2137;

			case '>':
				goto yy1911;

			default:
				goto yy36;
		}

yy2135:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2133;

			case '\r':
				goto yy2135;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2137;

			case '>':
				goto yy1911;

			default:
				goto yy36;
		}

yy2137:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2139;

			case '\r':
				goto yy2141;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2137;

			case '/':
				goto yy38;

			case '=':
				goto yy2143;

			case '>':
				goto yy2132;

			default:
				goto yy36;
		}

yy2139:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2139;

			case '\r':
				goto yy2141;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2137;

			case '=':
				goto yy2143;

			case '>':
				goto yy2132;

			default:
				goto yy36;
		}

yy2141:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2139;

			case '\r':
				goto yy2141;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2137;

			case '=':
				goto yy2143;

			case '>':
				goto yy2132;

			default:
				goto yy36;
		}

yy2143:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2143;

			case '\r':
				goto yy2145;

			case '"':
				goto yy2147;

			case '\'':
				goto yy2149;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2145:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2143;

			case '\r':
				goto yy2145;

			case '"':
				goto yy2147;

			case '\'':
				goto yy2149;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2147:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2148:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2154;

			case '/':
				goto yy2159;

			case '>':
				goto yy2161;

			default:
				goto yy2147;
		}

yy2149:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2154;

			case '/':
				goto yy2151;

			case '>':
				goto yy2153;

			default:
				goto yy2149;
		}

yy2151:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2154;

			case '/':
				goto yy2151;

			case '>':
				goto yy2158;

			default:
				goto yy2149;
		}

yy2153:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy2042;
yy2154:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2154;

			case '\r':
				goto yy2156;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2137;

			case '>':
				goto yy2132;

			default:
				goto yy36;
		}

yy2156:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2154;

			case '\r':
				goto yy2156;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2137;

			case '>':
				goto yy2132;

			default:
				goto yy36;
		}

yy2158:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy2042;
yy2159:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2154;

			case '/':
				goto yy2159;

			case '>':
				goto yy2162;

			default:
				goto yy2147;
		}

yy2161:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy2040;
yy2162:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy2040;
yy2163:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2056;

			case '\r':
				goto yy2163;

			case '"':
				goto yy2080;

			case '\'':
				goto yy2070;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2165:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy2173;
yy2166:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2167:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy1935;

			case '/':
				goto yy2169;

			case '>':
				goto yy2165;

			default:
				goto yy2166;
		}

yy2168:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2174;

			default:
				goto yy2167;
		}

yy2169:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy1935;

			case '/':
				goto yy2169;

			case '>':
				goto yy2171;

			default:
				goto yy2166;
		}

yy2171:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy2173;
yy2172:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2173:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy1940;

			default:
				goto yy2172;
		}

yy2174:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2175;

			default:
				goto yy2167;
		}

yy2175:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2176;

			default:
				goto yy2167;
		}

yy2176:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2177;

			default:
				goto yy2167;
		}

yy2177:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2178;

			default:
				goto yy2167;
		}

yy2178:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2179;

			default:
				goto yy2167;
		}

yy2179:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2180;

			default:
				goto yy2167;
		}

yy2180:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2181;

			case 'P':
			case 'p':
				goto yy2182;

			default:
				goto yy2167;
		}

yy2181:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2203;

			default:
				goto yy2167;
		}

yy2182:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy2183;

			default:
				goto yy2167;
		}

yy2183:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2184;

			default:
				goto yy2167;
		}

yy2184:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2185;

			default:
				goto yy2167;
		}

yy2185:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2186;

			default:
				goto yy2167;
		}

yy2186:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy2187;

			default:
				goto yy2167;
		}

yy2187:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2188;

			default:
				goto yy2167;
		}

yy2188:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2189;

			default:
				goto yy2167;
		}

yy2189:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2190;

			default:
				goto yy2167;
		}

yy2190:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2191;

			default:
				goto yy2167;
		}

yy2191:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2192;

			default:
				goto yy2167;
		}

yy2192:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2193;

			default:
				goto yy2167;
		}

yy2193:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2194;

			default:
				goto yy2167;
		}

yy2194:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2195;

			default:
				goto yy2167;
		}

yy2195:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2196;

			default:
				goto yy2167;
		}

yy2196:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2197;

			default:
				goto yy2167;
		}

yy2197:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2198;

			default:
				goto yy2167;
		}

yy2198:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2199;

			case '\r':
				goto yy2201;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '>':
				goto yy607;

			case 'T':
			case 't':
				goto yy606;

			default:
				goto yy37;
		}

yy2199:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2199;

			case '\r':
				goto yy2201;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy606;

			default:
				goto yy36;
		}

yy2201:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2199;

			case '\r':
				goto yy2201;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy604;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy606;

			default:
				goto yy36;
		}

yy2203:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2204;

			default:
				goto yy2167;
		}

yy2204:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2205;

			default:
				goto yy2167;
		}

yy2205:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy2206;

			default:
				goto yy2167;
		}

yy2206:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2207;

			default:
				goto yy2167;
		}

yy2207:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2208;

			default:
				goto yy2167;
		}

yy2208:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2209;

			default:
				goto yy2167;
		}

yy2209:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2210;

			default:
				goto yy2167;
		}

yy2210:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2211;

			default:
				goto yy2167;
		}

yy2211:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2212;

			default:
				goto yy2167;
		}

yy2212:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2213;

			default:
				goto yy2167;
		}

yy2213:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2214;

			default:
				goto yy2167;
		}

yy2214:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2215;

			default:
				goto yy2167;
		}

yy2215:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2216;

			default:
				goto yy2167;
		}

yy2216:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2217;

			default:
				goto yy2167;
		}

yy2217:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2218;

			default:
				goto yy2167;
		}

yy2218:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2219;

			case '\r':
				goto yy2221;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2137;

			case '>':
				goto yy2132;

			case 'T':
			case 't':
				goto yy2223;

			default:
				goto yy37;
		}

yy2219:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2219;

			case '\r':
				goto yy2221;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2137;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy2223;

			default:
				goto yy36;
		}

yy2221:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2219;

			case '\r':
				goto yy2221;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2137;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy2223;

			default:
				goto yy36;
		}

yy2223:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2139;

			case '\r':
				goto yy2141;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2137;

			case '=':
				goto yy2143;

			case '>':
				goto yy2132;

			case 'E':
			case 'e':
				goto yy2224;

			default:
				goto yy37;
		}

yy2224:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2139;

			case '\r':
				goto yy2141;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy2137;

			case '=':
				goto yy2143;

			case '>':
				goto yy2132;

			case 'X':
			case 'x':
				goto yy2225;

			default:
				goto yy37;
		}

yy2225:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2139;

			case '\r':
				goto yy2141;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2137;

			case '=':
				goto yy2143;

			case '>':
				goto yy2132;

			case 'T':
			case 't':
				goto yy2226;

			default:
				goto yy37;
		}

yy2226:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2227;

			case '\r':
				goto yy2229;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2137;

			case '=':
				goto yy2231;

			case '>':
				goto yy2132;

			default:
				goto yy37;
		}

yy2227:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2227;

			case '\r':
				goto yy2229;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2137;

			case '=':
				goto yy2231;

			case '>':
				goto yy2132;

			default:
				goto yy36;
		}

yy2229:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2227;

			case '\r':
				goto yy2229;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2137;

			case '=':
				goto yy2231;

			case '>':
				goto yy2132;

			default:
				goto yy36;
		}

yy2231:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2231;

			case '\r':
				goto yy2233;

			case '"':
				goto yy2235;

			case '\'':
				goto yy2149;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2233:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2231;

			case '\r':
				goto yy2233;

			case '"':
				goto yy2235;

			case '\'':
				goto yy2149;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2235:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2236;

			default:
				goto yy2148;
		}

yy2236:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2237;

			default:
				goto yy2148;
		}

yy2237:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2238;

			default:
				goto yy2148;
		}

yy2238:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2239;

			default:
				goto yy2148;
		}

yy2239:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2240;

			default:
				goto yy2148;
		}

yy2240:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2241;

			default:
				goto yy2148;
		}

yy2241:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2242;

			default:
				goto yy2148;
		}

yy2242:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2243;

			default:
				goto yy2148;
		}

yy2243:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2244;

			case 'P':
			case 'p':
				goto yy2245;

			default:
				goto yy2148;
		}

yy2244:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2266;

			default:
				goto yy2148;
		}

yy2245:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy2246;

			default:
				goto yy2148;
		}

yy2246:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2247;

			default:
				goto yy2148;
		}

yy2247:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2248;

			default:
				goto yy2148;
		}

yy2248:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2249;

			default:
				goto yy2148;
		}

yy2249:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy2250;

			default:
				goto yy2148;
		}

yy2250:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2251;

			default:
				goto yy2148;
		}

yy2251:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2252;

			default:
				goto yy2148;
		}

yy2252:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2253;

			default:
				goto yy2148;
		}

yy2253:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2254;

			default:
				goto yy2148;
		}

yy2254:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2255;

			default:
				goto yy2148;
		}

yy2255:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2256;

			default:
				goto yy2148;
		}

yy2256:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2257;

			default:
				goto yy2148;
		}

yy2257:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2258;

			default:
				goto yy2148;
		}

yy2258:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2259;

			default:
				goto yy2148;
		}

yy2259:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2260;

			default:
				goto yy2148;
		}

yy2260:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2261;

			default:
				goto yy2148;
		}

yy2261:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2262;

			case '\r':
				goto yy2264;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '>':
				goto yy703;

			default:
				goto yy37;
		}

yy2262:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2262;

			case '\r':
				goto yy2264;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '>':
				goto yy2132;

			default:
				goto yy36;
		}

yy2264:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2262;

			case '\r':
				goto yy2264;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy708;

			case '>':
				goto yy2132;

			default:
				goto yy36;
		}

yy2266:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2267;

			default:
				goto yy2148;
		}

yy2267:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2268;

			default:
				goto yy2148;
		}

yy2268:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy2269;

			default:
				goto yy2148;
		}

yy2269:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2270;

			default:
				goto yy2148;
		}

yy2270:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2271;

			default:
				goto yy2148;
		}

yy2271:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2272;

			default:
				goto yy2148;
		}

yy2272:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2273;

			default:
				goto yy2148;
		}

yy2273:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2274;

			default:
				goto yy2148;
		}

yy2274:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2275;

			default:
				goto yy2148;
		}

yy2275:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2276;

			default:
				goto yy2148;
		}

yy2276:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2277;

			default:
				goto yy2148;
		}

yy2277:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2278;

			default:
				goto yy2148;
		}

yy2278:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2279;

			default:
				goto yy2148;
		}

yy2279:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2280;

			default:
				goto yy2148;
		}

yy2280:
		yych = *++YYCURSOR;
		goto yy2148;
yy2281:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy1916;

			case '\r':
				goto yy2281;

			case '"':
				goto yy2166;

			case '\'':
				goto yy1932;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2283:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1912;

			case '\r':
				goto yy1914;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy1909;

			case '=':
				goto yy1916;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy1918;

			case 'X':
			case 'x':
				goto yy2284;

			default:
				goto yy37;
		}

yy2284:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy1912;

			case '\r':
				goto yy1914;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1909;

			case '=':
				goto yy1916;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy2285;

			default:
				goto yy37;
		}

yy2285:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2286;

			case '\r':
				goto yy2288;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1909;

			case '=':
				goto yy2290;

			case '>':
				goto yy1911;

			case 'E':
			case 'e':
				goto yy1920;

			case 'T':
			case 't':
				goto yy1918;

			default:
				goto yy37;
		}

yy2286:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2286;

			case '\r':
				goto yy2288;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '=':
				goto yy2290;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy2051;

			default:
				goto yy36;
		}

yy2288:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2286;

			case '\r':
				goto yy2288;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '=':
				goto yy2290;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy2051;

			default:
				goto yy36;
		}

yy2290:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2290;

			case '\r':
				goto yy2292;

			case '"':
				goto yy2294;

			case '\'':
				goto yy1932;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2292:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2290;

			case '\r':
				goto yy2292;

			case '"':
				goto yy2294;

			case '\'':
				goto yy1932;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2294:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2295;

			default:
				goto yy2167;
		}

yy2295:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2296;

			default:
				goto yy2167;
		}

yy2296:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2297;

			default:
				goto yy2167;
		}

yy2297:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2298;

			default:
				goto yy2167;
		}

yy2298:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2299;

			default:
				goto yy2167;
		}

yy2299:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2300;

			default:
				goto yy2167;
		}

yy2300:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2301;

			default:
				goto yy2167;
		}

yy2301:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2302;

			default:
				goto yy2167;
		}

yy2302:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2304;

			case 'P':
			case 'p':
				goto yy2303;

			default:
				goto yy2167;
		}

yy2303:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy2429;

			default:
				goto yy2167;
		}

yy2304:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2305;

			default:
				goto yy2167;
		}

yy2305:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2306;

			default:
				goto yy2167;
		}

yy2306:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2307;

			default:
				goto yy2167;
		}

yy2307:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy2308;

			default:
				goto yy2167;
		}

yy2308:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2309;

			default:
				goto yy2167;
		}

yy2309:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2310;

			default:
				goto yy2167;
		}

yy2310:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2311;

			default:
				goto yy2167;
		}

yy2311:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2312;

			default:
				goto yy2167;
		}

yy2312:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2313;

			default:
				goto yy2167;
		}

yy2313:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2314;

			default:
				goto yy2167;
		}

yy2314:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2315;

			default:
				goto yy2167;
		}

yy2315:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2316;

			default:
				goto yy2167;
		}

yy2316:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2317;

			default:
				goto yy2167;
		}

yy2317:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2318;

			default:
				goto yy2167;
		}

yy2318:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2319;

			default:
				goto yy2167;
		}

yy2319:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2320;

			default:
				goto yy2167;
		}

yy2320:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2322;

			case '\r':
				goto yy2324;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2326;

			case '>':
				goto yy2321;

			case 'T':
			case 't':
				goto yy2328;

			default:
				goto yy37;
		}

yy2321:
		yych = *++YYCURSOR;
		goto yy608;
yy2322:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2322;

			case '\r':
				goto yy2324;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2326;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy2328;

			default:
				goto yy36;
		}

yy2324:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2322;

			case '\r':
				goto yy2324;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2326;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy2328;

			default:
				goto yy36;
		}

yy2326:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2330;

			case '\r':
				goto yy2332;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2326;

			case '/':
				goto yy38;

			case '=':
				goto yy2334;

			case '>':
				goto yy2321;

			default:
				goto yy36;
		}

yy2328:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2330;

			case '\r':
				goto yy2332;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2326;

			case '=':
				goto yy2334;

			case '>':
				goto yy2321;

			case 'E':
			case 'e':
				goto yy2329;

			default:
				goto yy37;
		}

yy2329:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2330;

			case '\r':
				goto yy2332;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy2326;

			case '=':
				goto yy2334;

			case '>':
				goto yy2321;

			case 'X':
			case 'x':
				goto yy2373;

			default:
				goto yy37;
		}

yy2330:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2330;

			case '\r':
				goto yy2332;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2326;

			case '=':
				goto yy2334;

			case '>':
				goto yy2321;

			default:
				goto yy36;
		}

yy2332:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2330;

			case '\r':
				goto yy2332;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2326;

			case '=':
				goto yy2334;

			case '>':
				goto yy2321;

			default:
				goto yy36;
		}

yy2334:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2334;

			case '\r':
				goto yy2336;

			case '"':
				goto yy2338;

			case '\'':
				goto yy2340;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2336:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2334;

			case '\r':
				goto yy2336;

			case '"':
				goto yy2338;

			case '\'':
				goto yy2340;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2338:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2339:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2345;

			case '/':
				goto yy2369;

			case '>':
				goto yy2371;

			default:
				goto yy2338;
		}

yy2340:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2345;

			case '/':
				goto yy2342;

			case '>':
				goto yy2344;

			default:
				goto yy2340;
		}

yy2342:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2345;

			case '/':
				goto yy2342;

			case '>':
				goto yy2368;

			default:
				goto yy2340;
		}

yy2344:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy2352;
yy2345:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2345;

			case '\r':
				goto yy2347;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2326;

			case '>':
				goto yy2321;

			default:
				goto yy36;
		}

yy2347:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2345;

			case '\r':
				goto yy2347;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2326;

			case '>':
				goto yy2321;

			default:
				goto yy36;
		}

yy2349:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2349;

			case '\r':
				goto yy2353;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2356;

			case '>':
				goto yy2355;

			default:
				goto yy9;
		}

yy2351:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2352:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2349;

			default:
				goto yy2351;
		}

yy2353:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2349;

			case '\r':
				goto yy2353;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2356;

			case '>':
				goto yy2355;

			default:
				goto yy9;
		}

yy2355:
		yych = *++YYCURSOR;
		goto yy608;
yy2356:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2358;

			case '\r':
				goto yy2360;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2356;

			case '=':
				goto yy2362;

			case '>':
				goto yy2355;

			default:
				goto yy9;
		}

yy2358:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2358;

			case '\r':
				goto yy2360;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2356;

			case '=':
				goto yy2362;

			case '>':
				goto yy2355;

			default:
				goto yy9;
		}

yy2360:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2358;

			case '\r':
				goto yy2360;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2356;

			case '=':
				goto yy2362;

			case '>':
				goto yy2355;

			default:
				goto yy9;
		}

yy2362:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2362;

			case '\r':
				goto yy2364;

			case '"':
				goto yy2366;

			case '\'':
				goto yy2351;

			default:
				goto yy9;
		}

yy2364:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2362;

			case '\r':
				goto yy2364;

			case '"':
				goto yy2366;

			case '\'':
				goto yy2351;

			default:
				goto yy9;
		}

yy2366:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2367:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2349;

			default:
				goto yy2366;
		}

yy2368:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy2352;
yy2369:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2345;

			case '/':
				goto yy2369;

			case '>':
				goto yy2372;

			default:
				goto yy2338;
		}

yy2371:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy2367;
yy2372:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy2367;
yy2373:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2330;

			case '\r':
				goto yy2332;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2326;

			case '=':
				goto yy2334;

			case '>':
				goto yy2321;

			case 'T':
			case 't':
				goto yy2374;

			default:
				goto yy37;
		}

yy2374:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2375;

			case '\r':
				goto yy2377;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2326;

			case '=':
				goto yy2379;

			case '>':
				goto yy2321;

			default:
				goto yy37;
		}

yy2375:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2375;

			case '\r':
				goto yy2377;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2326;

			case '=':
				goto yy2379;

			case '>':
				goto yy2321;

			default:
				goto yy36;
		}

yy2377:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2375;

			case '\r':
				goto yy2377;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2326;

			case '=':
				goto yy2379;

			case '>':
				goto yy2321;

			default:
				goto yy36;
		}

yy2379:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2379;

			case '\r':
				goto yy2381;

			case '"':
				goto yy2383;

			case '\'':
				goto yy2340;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2381:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2379;

			case '\r':
				goto yy2381;

			case '"':
				goto yy2383;

			case '\'':
				goto yy2340;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2383:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2384;

			default:
				goto yy2339;
		}

yy2384:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2385;

			default:
				goto yy2339;
		}

yy2385:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2386;

			default:
				goto yy2339;
		}

yy2386:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2387;

			default:
				goto yy2339;
		}

yy2387:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2388;

			default:
				goto yy2339;
		}

yy2388:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2389;

			default:
				goto yy2339;
		}

yy2389:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2390;

			default:
				goto yy2339;
		}

yy2390:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2391;

			default:
				goto yy2339;
		}

yy2391:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2392;

			case 'P':
			case 'p':
				goto yy2393;

			default:
				goto yy2339;
		}

yy2392:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2414;

			default:
				goto yy2339;
		}

yy2393:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy2394;

			default:
				goto yy2339;
		}

yy2394:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2395;

			default:
				goto yy2339;
		}

yy2395:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2396;

			default:
				goto yy2339;
		}

yy2396:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2397;

			default:
				goto yy2339;
		}

yy2397:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy2398;

			default:
				goto yy2339;
		}

yy2398:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2399;

			default:
				goto yy2339;
		}

yy2399:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2400;

			default:
				goto yy2339;
		}

yy2400:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2401;

			default:
				goto yy2339;
		}

yy2401:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2402;

			default:
				goto yy2339;
		}

yy2402:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2403;

			default:
				goto yy2339;
		}

yy2403:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2404;

			default:
				goto yy2339;
		}

yy2404:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2405;

			default:
				goto yy2339;
		}

yy2405:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2406;

			default:
				goto yy2339;
		}

yy2406:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2407;

			default:
				goto yy2339;
		}

yy2407:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2408;

			default:
				goto yy2339;
		}

yy2408:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2409;

			default:
				goto yy2339;
		}

yy2409:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2410;

			case '\r':
				goto yy2412;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '>':
				goto yy1544;

			default:
				goto yy37;
		}

yy2410:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2410;

			case '\r':
				goto yy2412;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '>':
				goto yy2321;

			default:
				goto yy36;
		}

yy2412:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2410;

			case '\r':
				goto yy2412;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '>':
				goto yy2321;

			default:
				goto yy36;
		}

yy2414:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2415;

			default:
				goto yy2339;
		}

yy2415:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2416;

			default:
				goto yy2339;
		}

yy2416:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy2417;

			default:
				goto yy2339;
		}

yy2417:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2418;

			default:
				goto yy2339;
		}

yy2418:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2419;

			default:
				goto yy2339;
		}

yy2419:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2420;

			default:
				goto yy2339;
		}

yy2420:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2421;

			default:
				goto yy2339;
		}

yy2421:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2422;

			default:
				goto yy2339;
		}

yy2422:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2423;

			default:
				goto yy2339;
		}

yy2423:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2424;

			default:
				goto yy2339;
		}

yy2424:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2425;

			default:
				goto yy2339;
		}

yy2425:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2426;

			default:
				goto yy2339;
		}

yy2426:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2427;

			default:
				goto yy2339;
		}

yy2427:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2428;

			default:
				goto yy2339;
		}

yy2428:
		yych = *++YYCURSOR;
		goto yy2339;
yy2429:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2430;

			default:
				goto yy2167;
		}

yy2430:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2431;

			default:
				goto yy2167;
		}

yy2431:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2432;

			default:
				goto yy2167;
		}

yy2432:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy2433;

			default:
				goto yy2167;
		}

yy2433:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2434;

			default:
				goto yy2167;
		}

yy2434:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2435;

			default:
				goto yy2167;
		}

yy2435:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2436;

			default:
				goto yy2167;
		}

yy2436:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2437;

			default:
				goto yy2167;
		}

yy2437:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2438;

			default:
				goto yy2167;
		}

yy2438:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2439;

			default:
				goto yy2167;
		}

yy2439:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2440;

			default:
				goto yy2167;
		}

yy2440:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2441;

			default:
				goto yy2167;
		}

yy2441:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2442;

			default:
				goto yy2167;
		}

yy2442:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2443;

			default:
				goto yy2167;
		}

yy2443:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2198;

			default:
				goto yy2167;
		}

yy2444:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2445;

			default:
				goto yy1303;
		}

yy2445:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2446;

			default:
				goto yy1303;
		}

yy2446:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy2447;

			default:
				goto yy1303;
		}

yy2447:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2448;

			default:
				goto yy1303;
		}

yy2448:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2449;

			default:
				goto yy1303;
		}

yy2449:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2450;

			default:
				goto yy1303;
		}

yy2450:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2451;

			default:
				goto yy1303;
		}

yy2451:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2452;

			default:
				goto yy1303;
		}

yy2452:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2453;

			default:
				goto yy1303;
		}

yy2453:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2454;

			default:
				goto yy1303;
		}

yy2454:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2455;

			default:
				goto yy1303;
		}

yy2455:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2456;

			default:
				goto yy1303;
		}

yy2456:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2457;

			default:
				goto yy1303;
		}

yy2457:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2458;

			default:
				goto yy1303;
		}

yy2458:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2459;

			default:
				goto yy1303;
		}

yy2459:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2460;

			case '\r':
				goto yy2462;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2465;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2464;

			default:
				goto yy37;
		}

yy2460:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2460;

			case '\r':
				goto yy2462;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2465;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy2464;

			default:
				goto yy36;
		}

yy2462:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2460;

			case '\r':
				goto yy2462;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2465;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy2464;

			default:
				goto yy36;
		}

yy2464:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2468;

			case '\r':
				goto yy2470;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2465;

			case '=':
				goto yy2472;

			case '>':
				goto yy2467;

			case 'E':
			case 'e':
				goto yy2839;

			case 'T':
			case 't':
				goto yy2474;

			default:
				goto yy37;
		}

yy2465:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2468;

			case '\r':
				goto yy2470;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2465;

			case '/':
				goto yy38;

			case '=':
				goto yy2472;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2474;

			default:
				goto yy36;
		}

yy2467:
		yych = *++YYCURSOR;
		goto yy779;
yy2468:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2468;

			case '\r':
				goto yy2470;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '=':
				goto yy2472;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2607;

			default:
				goto yy36;
		}

yy2470:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2468;

			case '\r':
				goto yy2470;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '=':
				goto yy2472;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2607;

			default:
				goto yy36;
		}

yy2472:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2472;

			case '\r':
				goto yy2837;

			case '"':
				goto yy2722;

			case '\'':
				goto yy2488;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2474:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2468;

			case '\r':
				goto yy2470;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2465;

			case '/':
				goto yy38;

			case '=':
				goto yy2472;

			case '>':
				goto yy2467;

			case 'E':
			case 'e':
				goto yy2476;

			case 'T':
			case 't':
				goto yy2474;

			default:
				goto yy36;
		}

yy2476:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2468;

			case '\r':
				goto yy2470;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy2465;

			case '/':
				goto yy38;

			case '=':
				goto yy2472;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2474;

			case 'X':
			case 'x':
				goto yy2477;

			default:
				goto yy36;
		}

yy2477:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2468;

			case '\r':
				goto yy2470;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2465;

			case '/':
				goto yy38;

			case '=':
				goto yy2472;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2478;

			default:
				goto yy36;
		}

yy2478:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2479;

			case '\r':
				goto yy2481;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2465;

			case '/':
				goto yy38;

			case '=':
				goto yy2483;

			case '>':
				goto yy2467;

			case 'E':
			case 'e':
				goto yy2476;

			case 'T':
			case 't':
				goto yy2474;

			default:
				goto yy36;
		}

yy2479:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2479;

			case '\r':
				goto yy2481;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '=':
				goto yy2483;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2607;

			default:
				goto yy36;
		}

yy2481:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2479;

			case '\r':
				goto yy2481;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '=':
				goto yy2483;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2607;

			default:
				goto yy36;
		}

yy2483:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2483;

			case '\r':
				goto yy2485;

			case '"':
				goto yy2487;

			case '\'':
				goto yy2488;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2485:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2483;

			case '\r':
				goto yy2485;

			case '"':
				goto yy2487;

			case '\'':
				goto yy2488;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2487:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2724;

			default:
				goto yy2723;
		}

yy2488:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2491;

			case '/':
				goto yy2493;

			case '>':
				goto yy2490;

			default:
				goto yy2488;
		}

yy2490:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy2499;
yy2491:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2491;

			case '\r':
				goto yy2603;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2607;

			default:
				goto yy36;
		}

yy2493:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2491;

			case '/':
				goto yy2493;

			case '>':
				goto yy2495;

			default:
				goto yy2488;
		}

yy2495:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy2499;
yy2496:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2496;

			case '\r':
				goto yy2500;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2503;

			case '>':
				goto yy2502;

			case 'T':
			case 't':
				goto yy2505;

			default:
				goto yy9;
		}

yy2498:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2499:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2496;

			default:
				goto yy2498;
		}

yy2500:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2496;

			case '\r':
				goto yy2500;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2503;

			case '>':
				goto yy2502;

			case 'T':
			case 't':
				goto yy2505;

			default:
				goto yy9;
		}

yy2502:
		yych = *++YYCURSOR;
		goto yy779;
yy2503:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2507;

			case '\r':
				goto yy2509;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2503;

			case '=':
				goto yy2511;

			case '>':
				goto yy2502;

			default:
				goto yy9;
		}

yy2505:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy2503;

			case 'E':
			case 'e':
				goto yy2506;

			default:
				goto yy2508;
		}

yy2506:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy2503;

			case 'X':
			case 'x':
				goto yy2523;

			default:
				goto yy2508;
		}

yy2507:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2508:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2507;

			case '\r':
				goto yy2509;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2503;

			case '=':
				goto yy2511;

			case '>':
				goto yy2502;

			default:
				goto yy9;
		}

yy2509:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2507;

			case '\r':
				goto yy2509;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2503;

			case '=':
				goto yy2511;

			case '>':
				goto yy2502;

			default:
				goto yy9;
		}

yy2511:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2511;

			case '\r':
				goto yy2513;

			case '"':
				goto yy2515;

			case '\'':
				goto yy2517;

			default:
				goto yy9;
		}

yy2513:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2511;

			case '\r':
				goto yy2513;

			case '"':
				goto yy2515;

			case '\'':
				goto yy2517;

			default:
				goto yy9;
		}

yy2515:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2516:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2519;

			default:
				goto yy2515;
		}

yy2517:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2518:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2519;

			default:
				goto yy2517;
		}

yy2519:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2519;

			case '\r':
				goto yy2521;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2503;

			case '>':
				goto yy2502;

			default:
				goto yy9;
		}

yy2521:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2519;

			case '\r':
				goto yy2521;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2503;

			case '>':
				goto yy2502;

			default:
				goto yy9;
		}

yy2523:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy2503;

			case 'T':
			case 't':
				goto yy2524;

			default:
				goto yy2508;
		}

yy2524:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy2503;

			default:
				goto yy2526;
		}

yy2525:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2526:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2525;

			case '\r':
				goto yy2527;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2503;

			case '=':
				goto yy2529;

			case '>':
				goto yy2502;

			default:
				goto yy9;
		}

yy2527:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2525;

			case '\r':
				goto yy2527;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2503;

			case '=':
				goto yy2529;

			case '>':
				goto yy2502;

			default:
				goto yy9;
		}

yy2529:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2529;

			case '\r':
				goto yy2531;

			case '"':
				goto yy2533;

			case '\'':
				goto yy2517;

			default:
				goto yy9;
		}

yy2531:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2529;

			case '\r':
				goto yy2531;

			case '"':
				goto yy2533;

			case '\'':
				goto yy2517;

			default:
				goto yy9;
		}

yy2533:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2534;

			default:
				goto yy2516;
		}

yy2534:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2535;

			default:
				goto yy2516;
		}

yy2535:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2536;

			default:
				goto yy2516;
		}

yy2536:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2537;

			default:
				goto yy2516;
		}

yy2537:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2538;

			default:
				goto yy2516;
		}

yy2538:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2539;

			default:
				goto yy2516;
		}

yy2539:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2540;

			default:
				goto yy2516;
		}

yy2540:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2541;

			default:
				goto yy2516;
		}

yy2541:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2542;

			case 'P':
			case 'p':
				goto yy2543;

			default:
				goto yy2516;
		}

yy2542:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2583;

			default:
				goto yy2516;
		}

yy2543:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy2544;

			default:
				goto yy2516;
		}

yy2544:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2545;

			default:
				goto yy2516;
		}

yy2545:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2546;

			default:
				goto yy2516;
		}

yy2546:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2547;

			default:
				goto yy2516;
		}

yy2547:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy2548;

			default:
				goto yy2516;
		}

yy2548:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2549;

			default:
				goto yy2516;
		}

yy2549:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2550;

			default:
				goto yy2516;
		}

yy2550:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2551;

			default:
				goto yy2516;
		}

yy2551:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2552;

			default:
				goto yy2516;
		}

yy2552:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2553;

			default:
				goto yy2516;
		}

yy2553:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2554;

			default:
				goto yy2516;
		}

yy2554:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2555;

			default:
				goto yy2516;
		}

yy2555:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2556;

			default:
				goto yy2516;
		}

yy2556:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2557;

			default:
				goto yy2516;
		}

yy2557:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2558;

			default:
				goto yy2516;
		}

yy2558:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2559;

			default:
				goto yy2516;
		}

yy2559:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy2566;

			default:
				goto yy2561;
		}

yy2560:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2561:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2560;

			case '\r':
				goto yy2562;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2564;

			case '>':
				goto yy2502;

			default:
				goto yy9;
		}

yy2562:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2560;

			case '\r':
				goto yy2562;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2564;

			case '>':
				goto yy2502;

			default:
				goto yy9;
		}

yy2564:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2567;

			case '\r':
				goto yy2569;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2564;

			case '=':
				goto yy2571;

			case '>':
				goto yy2566;

			default:
				goto yy9;
		}

yy2566:
		yych = *++YYCURSOR;
		goto yy779;
yy2567:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2567;

			case '\r':
				goto yy2569;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2564;

			case '=':
				goto yy2571;

			case '>':
				goto yy2566;

			default:
				goto yy9;
		}

yy2569:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2567;

			case '\r':
				goto yy2569;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2564;

			case '=':
				goto yy2571;

			case '>':
				goto yy2566;

			default:
				goto yy9;
		}

yy2571:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2571;

			case '\r':
				goto yy2573;

			case '"':
				goto yy2575;

			case '\'':
				goto yy2577;

			default:
				goto yy9;
		}

yy2573:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2571;

			case '\r':
				goto yy2573;

			case '"':
				goto yy2575;

			case '\'':
				goto yy2577;

			default:
				goto yy9;
		}

yy2575:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2576:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2579;

			default:
				goto yy2575;
		}

yy2577:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2578:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2579;

			default:
				goto yy2577;
		}

yy2579:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2579;

			case '\r':
				goto yy2581;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2564;

			case '>':
				goto yy2566;

			default:
				goto yy9;
		}

yy2581:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2579;

			case '\r':
				goto yy2581;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2564;

			case '>':
				goto yy2566;

			default:
				goto yy9;
		}

yy2583:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2584;

			default:
				goto yy2516;
		}

yy2584:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2585;

			default:
				goto yy2516;
		}

yy2585:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy2586;

			default:
				goto yy2516;
		}

yy2586:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2587;

			default:
				goto yy2516;
		}

yy2587:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2588;

			default:
				goto yy2516;
		}

yy2588:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2589;

			default:
				goto yy2516;
		}

yy2589:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2590;

			default:
				goto yy2516;
		}

yy2590:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2591;

			default:
				goto yy2516;
		}

yy2591:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2592;

			default:
				goto yy2516;
		}

yy2592:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2593;

			default:
				goto yy2516;
		}

yy2593:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2594;

			default:
				goto yy2516;
		}

yy2594:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2595;

			default:
				goto yy2516;
		}

yy2595:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2596;

			default:
				goto yy2516;
		}

yy2596:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2597;

			default:
				goto yy2516;
		}

yy2597:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2598;

			default:
				goto yy2516;
		}

yy2598:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy813;

			default:
				goto yy2600;
		}

yy2599:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2600:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2599;

			case '\r':
				goto yy2601;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy814;

			case '>':
				goto yy2502;

			default:
				goto yy9;
		}

yy2601:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2599;

			case '\r':
				goto yy2601;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy814;

			case '>':
				goto yy2502;

			default:
				goto yy9;
		}

yy2603:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2491;

			case '\r':
				goto yy2603;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2607;

			default:
				goto yy36;
		}

yy2605:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2608;

			case '\r':
				goto yy2610;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '/':
				goto yy38;

			case '=':
				goto yy2612;

			case '>':
				goto yy2467;

			default:
				goto yy36;
		}

yy2607:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2608;

			case '\r':
				goto yy2610;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '=':
				goto yy2612;

			case '>':
				goto yy2467;

			case 'E':
			case 'e':
				goto yy2614;

			default:
				goto yy37;
		}

yy2608:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2608;

			case '\r':
				goto yy2610;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '=':
				goto yy2612;

			case '>':
				goto yy2467;

			default:
				goto yy36;
		}

yy2610:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2608;

			case '\r':
				goto yy2610;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '=':
				goto yy2612;

			case '>':
				goto yy2467;

			default:
				goto yy36;
		}

yy2612:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2612;

			case '\r':
				goto yy2719;

			case '"':
				goto yy2636;

			case '\'':
				goto yy2626;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2614:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2608;

			case '\r':
				goto yy2610;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy2605;

			case '=':
				goto yy2612;

			case '>':
				goto yy2467;

			case 'X':
			case 'x':
				goto yy2615;

			default:
				goto yy37;
		}

yy2615:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2608;

			case '\r':
				goto yy2610;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '=':
				goto yy2612;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2616;

			default:
				goto yy37;
		}

yy2616:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2617;

			case '\r':
				goto yy2619;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '=':
				goto yy2621;

			case '>':
				goto yy2467;

			default:
				goto yy37;
		}

yy2617:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2617;

			case '\r':
				goto yy2619;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '=':
				goto yy2621;

			case '>':
				goto yy2467;

			default:
				goto yy36;
		}

yy2619:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2617;

			case '\r':
				goto yy2619;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '=':
				goto yy2621;

			case '>':
				goto yy2467;

			default:
				goto yy36;
		}

yy2621:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2621;

			case '\r':
				goto yy2623;

			case '"':
				goto yy2625;

			case '\'':
				goto yy2626;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2623:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2621;

			case '\r':
				goto yy2623;

			case '"':
				goto yy2625;

			case '\'':
				goto yy2626;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2625:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2638;

			default:
				goto yy2637;
		}

yy2626:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2631;

			case '/':
				goto yy2628;

			case '>':
				goto yy2630;

			default:
				goto yy2626;
		}

yy2628:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2631;

			case '/':
				goto yy2628;

			case '>':
				goto yy2635;

			default:
				goto yy2626;
		}

yy2630:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy2518;
yy2631:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2631;

			case '\r':
				goto yy2633;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '>':
				goto yy2467;

			default:
				goto yy36;
		}

yy2633:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2631;

			case '\r':
				goto yy2633;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '>':
				goto yy2467;

			default:
				goto yy36;
		}

yy2635:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy2518;
yy2636:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2637:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2631;

			case '/':
				goto yy2639;

			case '>':
				goto yy2641;

			default:
				goto yy2636;
		}

yy2638:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2643;

			default:
				goto yy2637;
		}

yy2639:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2631;

			case '/':
				goto yy2639;

			case '>':
				goto yy2642;

			default:
				goto yy2636;
		}

yy2641:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy2516;
yy2642:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy2516;
yy2643:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2644;

			default:
				goto yy2637;
		}

yy2644:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2645;

			default:
				goto yy2637;
		}

yy2645:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2646;

			default:
				goto yy2637;
		}

yy2646:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2647;

			default:
				goto yy2637;
		}

yy2647:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2648;

			default:
				goto yy2637;
		}

yy2648:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2649;

			default:
				goto yy2637;
		}

yy2649:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2650;

			case 'P':
			case 'p':
				goto yy2651;

			default:
				goto yy2637;
		}

yy2650:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2699;

			default:
				goto yy2637;
		}

yy2651:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy2652;

			default:
				goto yy2637;
		}

yy2652:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2653;

			default:
				goto yy2637;
		}

yy2653:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2654;

			default:
				goto yy2637;
		}

yy2654:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2655;

			default:
				goto yy2637;
		}

yy2655:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy2656;

			default:
				goto yy2637;
		}

yy2656:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2657;

			default:
				goto yy2637;
		}

yy2657:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2658;

			default:
				goto yy2637;
		}

yy2658:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2659;

			default:
				goto yy2637;
		}

yy2659:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2660;

			default:
				goto yy2637;
		}

yy2660:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2661;

			default:
				goto yy2637;
		}

yy2661:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2662;

			default:
				goto yy2637;
		}

yy2662:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2663;

			default:
				goto yy2637;
		}

yy2663:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2664;

			default:
				goto yy2637;
		}

yy2664:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2665;

			default:
				goto yy2637;
		}

yy2665:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2666;

			default:
				goto yy2637;
		}

yy2666:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2667;

			default:
				goto yy2637;
		}

yy2667:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2669;

			case '\r':
				goto yy2671;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2673;

			case '>':
				goto yy2668;

			default:
				goto yy37;
		}

yy2668:
		yych = *++YYCURSOR;
		goto yy779;
yy2669:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2669;

			case '\r':
				goto yy2671;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2673;

			case '>':
				goto yy2467;

			default:
				goto yy36;
		}

yy2671:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2669;

			case '\r':
				goto yy2671;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2673;

			case '>':
				goto yy2467;

			default:
				goto yy36;
		}

yy2673:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2675;

			case '\r':
				goto yy2677;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2673;

			case '/':
				goto yy38;

			case '=':
				goto yy2679;

			case '>':
				goto yy2668;

			default:
				goto yy36;
		}

yy2675:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2675;

			case '\r':
				goto yy2677;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2673;

			case '=':
				goto yy2679;

			case '>':
				goto yy2668;

			default:
				goto yy36;
		}

yy2677:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2675;

			case '\r':
				goto yy2677;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2673;

			case '=':
				goto yy2679;

			case '>':
				goto yy2668;

			default:
				goto yy36;
		}

yy2679:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2679;

			case '\r':
				goto yy2681;

			case '"':
				goto yy2683;

			case '\'':
				goto yy2685;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2681:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2679;

			case '\r':
				goto yy2681;

			case '"':
				goto yy2683;

			case '\'':
				goto yy2685;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2683:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2684:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2690;

			case '/':
				goto yy2695;

			case '>':
				goto yy2697;

			default:
				goto yy2683;
		}

yy2685:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2690;

			case '/':
				goto yy2687;

			case '>':
				goto yy2689;

			default:
				goto yy2685;
		}

yy2687:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2690;

			case '/':
				goto yy2687;

			case '>':
				goto yy2694;

			default:
				goto yy2685;
		}

yy2689:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy2578;
yy2690:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2690;

			case '\r':
				goto yy2692;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2673;

			case '>':
				goto yy2668;

			default:
				goto yy36;
		}

yy2692:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2690;

			case '\r':
				goto yy2692;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2673;

			case '>':
				goto yy2668;

			default:
				goto yy36;
		}

yy2694:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy2578;
yy2695:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2690;

			case '/':
				goto yy2695;

			case '>':
				goto yy2698;

			default:
				goto yy2683;
		}

yy2697:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy2576;
yy2698:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy2576;
yy2699:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2700;

			default:
				goto yy2637;
		}

yy2700:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2701;

			default:
				goto yy2637;
		}

yy2701:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy2702;

			default:
				goto yy2637;
		}

yy2702:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2703;

			default:
				goto yy2637;
		}

yy2703:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2704;

			default:
				goto yy2637;
		}

yy2704:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2705;

			default:
				goto yy2637;
		}

yy2705:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2706;

			default:
				goto yy2637;
		}

yy2706:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2707;

			default:
				goto yy2637;
		}

yy2707:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2708;

			default:
				goto yy2637;
		}

yy2708:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2709;

			default:
				goto yy2637;
		}

yy2709:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2710;

			default:
				goto yy2637;
		}

yy2710:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2711;

			default:
				goto yy2637;
		}

yy2711:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2712;

			default:
				goto yy2637;
		}

yy2712:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2713;

			default:
				goto yy2637;
		}

yy2713:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2714;

			default:
				goto yy2637;
		}

yy2714:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2715;

			case '\r':
				goto yy2717;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '>':
				goto yy778;

			default:
				goto yy37;
		}

yy2715:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2715;

			case '\r':
				goto yy2717;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '>':
				goto yy2467;

			default:
				goto yy36;
		}

yy2717:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2715;

			case '\r':
				goto yy2717;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '>':
				goto yy2467;

			default:
				goto yy36;
		}

yy2719:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2612;

			case '\r':
				goto yy2719;

			case '"':
				goto yy2636;

			case '\'':
				goto yy2626;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2721:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy2729;
yy2722:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2723:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2491;

			case '/':
				goto yy2725;

			case '>':
				goto yy2721;

			default:
				goto yy2722;
		}

yy2724:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2730;

			default:
				goto yy2723;
		}

yy2725:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2491;

			case '/':
				goto yy2725;

			case '>':
				goto yy2727;

			default:
				goto yy2722;
		}

yy2727:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy2729;
yy2728:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2729:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2496;

			default:
				goto yy2728;
		}

yy2730:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2731;

			default:
				goto yy2723;
		}

yy2731:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2732;

			default:
				goto yy2723;
		}

yy2732:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2733;

			default:
				goto yy2723;
		}

yy2733:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2734;

			default:
				goto yy2723;
		}

yy2734:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2735;

			default:
				goto yy2723;
		}

yy2735:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2736;

			default:
				goto yy2723;
		}

yy2736:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2737;

			case 'P':
			case 'p':
				goto yy2738;

			default:
				goto yy2723;
		}

yy2737:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2817;

			default:
				goto yy2723;
		}

yy2738:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy2739;

			default:
				goto yy2723;
		}

yy2739:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2740;

			default:
				goto yy2723;
		}

yy2740:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2741;

			default:
				goto yy2723;
		}

yy2741:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2742;

			default:
				goto yy2723;
		}

yy2742:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy2743;

			default:
				goto yy2723;
		}

yy2743:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2744;

			default:
				goto yy2723;
		}

yy2744:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2745;

			default:
				goto yy2723;
		}

yy2745:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2746;

			default:
				goto yy2723;
		}

yy2746:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2747;

			default:
				goto yy2723;
		}

yy2747:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2748;

			default:
				goto yy2723;
		}

yy2748:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2749;

			default:
				goto yy2723;
		}

yy2749:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2750;

			default:
				goto yy2723;
		}

yy2750:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2751;

			default:
				goto yy2723;
		}

yy2751:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2752;

			default:
				goto yy2723;
		}

yy2752:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2753;

			default:
				goto yy2723;
		}

yy2753:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2754;

			default:
				goto yy2723;
		}

yy2754:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2755;

			case '\r':
				goto yy2757;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2673;

			case '>':
				goto yy2668;

			case 'T':
			case 't':
				goto yy2759;

			default:
				goto yy37;
		}

yy2755:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2755;

			case '\r':
				goto yy2757;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2673;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2759;

			default:
				goto yy36;
		}

yy2757:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2755;

			case '\r':
				goto yy2757;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2673;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2759;

			default:
				goto yy36;
		}

yy2759:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2675;

			case '\r':
				goto yy2677;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2673;

			case '=':
				goto yy2679;

			case '>':
				goto yy2668;

			case 'E':
			case 'e':
				goto yy2760;

			default:
				goto yy37;
		}

yy2760:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2675;

			case '\r':
				goto yy2677;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy2673;

			case '=':
				goto yy2679;

			case '>':
				goto yy2668;

			case 'X':
			case 'x':
				goto yy2761;

			default:
				goto yy37;
		}

yy2761:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2675;

			case '\r':
				goto yy2677;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2673;

			case '=':
				goto yy2679;

			case '>':
				goto yy2668;

			case 'T':
			case 't':
				goto yy2762;

			default:
				goto yy37;
		}

yy2762:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2763;

			case '\r':
				goto yy2765;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2673;

			case '=':
				goto yy2767;

			case '>':
				goto yy2668;

			default:
				goto yy37;
		}

yy2763:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2763;

			case '\r':
				goto yy2765;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2673;

			case '=':
				goto yy2767;

			case '>':
				goto yy2668;

			default:
				goto yy36;
		}

yy2765:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2763;

			case '\r':
				goto yy2765;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2673;

			case '=':
				goto yy2767;

			case '>':
				goto yy2668;

			default:
				goto yy36;
		}

yy2767:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2767;

			case '\r':
				goto yy2769;

			case '"':
				goto yy2771;

			case '\'':
				goto yy2685;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2769:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2767;

			case '\r':
				goto yy2769;

			case '"':
				goto yy2771;

			case '\'':
				goto yy2685;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2771:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2772;

			default:
				goto yy2684;
		}

yy2772:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2773;

			default:
				goto yy2684;
		}

yy2773:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2774;

			default:
				goto yy2684;
		}

yy2774:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2775;

			default:
				goto yy2684;
		}

yy2775:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2776;

			default:
				goto yy2684;
		}

yy2776:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2777;

			default:
				goto yy2684;
		}

yy2777:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2778;

			default:
				goto yy2684;
		}

yy2778:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2779;

			default:
				goto yy2684;
		}

yy2779:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2780;

			case 'P':
			case 'p':
				goto yy2781;

			default:
				goto yy2684;
		}

yy2780:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2797;

			default:
				goto yy2684;
		}

yy2781:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy2782;

			default:
				goto yy2684;
		}

yy2782:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2783;

			default:
				goto yy2684;
		}

yy2783:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2784;

			default:
				goto yy2684;
		}

yy2784:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2785;

			default:
				goto yy2684;
		}

yy2785:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy2786;

			default:
				goto yy2684;
		}

yy2786:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2787;

			default:
				goto yy2684;
		}

yy2787:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2788;

			default:
				goto yy2684;
		}

yy2788:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2789;

			default:
				goto yy2684;
		}

yy2789:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2790;

			default:
				goto yy2684;
		}

yy2790:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2791;

			default:
				goto yy2684;
		}

yy2791:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2792;

			default:
				goto yy2684;
		}

yy2792:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2793;

			default:
				goto yy2684;
		}

yy2793:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2794;

			default:
				goto yy2684;
		}

yy2794:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2795;

			default:
				goto yy2684;
		}

yy2795:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2796;

			default:
				goto yy2684;
		}

yy2796:
		yych = *++YYCURSOR;
		goto yy2684;
yy2797:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2798;

			default:
				goto yy2684;
		}

yy2798:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2799;

			default:
				goto yy2684;
		}

yy2799:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy2800;

			default:
				goto yy2684;
		}

yy2800:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2801;

			default:
				goto yy2684;
		}

yy2801:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2802;

			default:
				goto yy2684;
		}

yy2802:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2803;

			default:
				goto yy2684;
		}

yy2803:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2804;

			default:
				goto yy2684;
		}

yy2804:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2805;

			default:
				goto yy2684;
		}

yy2805:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2806;

			default:
				goto yy2684;
		}

yy2806:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2807;

			default:
				goto yy2684;
		}

yy2807:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2808;

			default:
				goto yy2684;
		}

yy2808:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2809;

			default:
				goto yy2684;
		}

yy2809:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2810;

			default:
				goto yy2684;
		}

yy2810:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2811;

			default:
				goto yy2684;
		}

yy2811:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2812;

			default:
				goto yy2684;
		}

yy2812:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2813;

			case '\r':
				goto yy2815;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '>':
				goto yy859;

			default:
				goto yy37;
		}

yy2813:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2813;

			case '\r':
				goto yy2815;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '>':
				goto yy2668;

			default:
				goto yy36;
		}

yy2815:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2813;

			case '\r':
				goto yy2815;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy864;

			case '>':
				goto yy2668;

			default:
				goto yy36;
		}

yy2817:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2818;

			default:
				goto yy2723;
		}

yy2818:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2819;

			default:
				goto yy2723;
		}

yy2819:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy2820;

			default:
				goto yy2723;
		}

yy2820:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2821;

			default:
				goto yy2723;
		}

yy2821:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2822;

			default:
				goto yy2723;
		}

yy2822:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2823;

			default:
				goto yy2723;
		}

yy2823:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2824;

			default:
				goto yy2723;
		}

yy2824:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2825;

			default:
				goto yy2723;
		}

yy2825:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2826;

			default:
				goto yy2723;
		}

yy2826:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2827;

			default:
				goto yy2723;
		}

yy2827:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2828;

			default:
				goto yy2723;
		}

yy2828:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2829;

			default:
				goto yy2723;
		}

yy2829:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2830;

			default:
				goto yy2723;
		}

yy2830:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2831;

			default:
				goto yy2723;
		}

yy2831:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2832;

			default:
				goto yy2723;
		}

yy2832:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2833;

			case '\r':
				goto yy2835;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '>':
				goto yy778;

			case 'T':
			case 't':
				goto yy777;

			default:
				goto yy37;
		}

yy2833:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2833;

			case '\r':
				goto yy2835;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy777;

			default:
				goto yy36;
		}

yy2835:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2833;

			case '\r':
				goto yy2835;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy775;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy777;

			default:
				goto yy36;
		}

yy2837:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2472;

			case '\r':
				goto yy2837;

			case '"':
				goto yy2722;

			case '\'':
				goto yy2488;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2839:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2468;

			case '\r':
				goto yy2470;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy2465;

			case '=':
				goto yy2472;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2474;

			case 'X':
			case 'x':
				goto yy2840;

			default:
				goto yy37;
		}

yy2840:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2468;

			case '\r':
				goto yy2470;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2465;

			case '=':
				goto yy2472;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2841;

			default:
				goto yy37;
		}

yy2841:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2842;

			case '\r':
				goto yy2844;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2465;

			case '=':
				goto yy2846;

			case '>':
				goto yy2467;

			case 'E':
			case 'e':
				goto yy2476;

			case 'T':
			case 't':
				goto yy2474;

			default:
				goto yy37;
		}

yy2842:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2842;

			case '\r':
				goto yy2844;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '=':
				goto yy2846;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2607;

			default:
				goto yy36;
		}

yy2844:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2842;

			case '\r':
				goto yy2844;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '=':
				goto yy2846;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2607;

			default:
				goto yy36;
		}

yy2846:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2846;

			case '\r':
				goto yy2848;

			case '"':
				goto yy2850;

			case '\'':
				goto yy2488;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2848:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2846;

			case '\r':
				goto yy2848;

			case '"':
				goto yy2850;

			case '\'':
				goto yy2488;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2850:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2851;

			default:
				goto yy2723;
		}

yy2851:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2852;

			default:
				goto yy2723;
		}

yy2852:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2853;

			default:
				goto yy2723;
		}

yy2853:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2854;

			default:
				goto yy2723;
		}

yy2854:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2855;

			default:
				goto yy2723;
		}

yy2855:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2856;

			default:
				goto yy2723;
		}

yy2856:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2857;

			default:
				goto yy2723;
		}

yy2857:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2858;

			default:
				goto yy2723;
		}

yy2858:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2860;

			case 'P':
			case 'p':
				goto yy2859;

			default:
				goto yy2723;
		}

yy2859:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy2876;

			default:
				goto yy2723;
		}

yy2860:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2861;

			default:
				goto yy2723;
		}

yy2861:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2862;

			default:
				goto yy2723;
		}

yy2862:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2863;

			default:
				goto yy2723;
		}

yy2863:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy2864;

			default:
				goto yy2723;
		}

yy2864:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2865;

			default:
				goto yy2723;
		}

yy2865:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2866;

			default:
				goto yy2723;
		}

yy2866:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2867;

			default:
				goto yy2723;
		}

yy2867:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2868;

			default:
				goto yy2723;
		}

yy2868:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2869;

			default:
				goto yy2723;
		}

yy2869:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2870;

			default:
				goto yy2723;
		}

yy2870:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2871;

			default:
				goto yy2723;
		}

yy2871:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2872;

			default:
				goto yy2723;
		}

yy2872:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2873;

			default:
				goto yy2723;
		}

yy2873:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2874;

			default:
				goto yy2723;
		}

yy2874:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2875;

			default:
				goto yy2723;
		}

yy2875:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2832;

			default:
				goto yy2723;
		}

yy2876:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2877;

			default:
				goto yy2723;
		}

yy2877:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2878;

			default:
				goto yy2723;
		}

yy2878:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2879;

			default:
				goto yy2723;
		}

yy2879:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy2880;

			default:
				goto yy2723;
		}

yy2880:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2881;

			default:
				goto yy2723;
		}

yy2881:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2882;

			default:
				goto yy2723;
		}

yy2882:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2883;

			default:
				goto yy2723;
		}

yy2883:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2884;

			default:
				goto yy2723;
		}

yy2884:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2885;

			default:
				goto yy2723;
		}

yy2885:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2886;

			default:
				goto yy2723;
		}

yy2886:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2887;

			default:
				goto yy2723;
		}

yy2887:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2888;

			default:
				goto yy2723;
		}

yy2888:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2889;

			default:
				goto yy2723;
		}

yy2889:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2890;

			default:
				goto yy2723;
		}

yy2890:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2891;

			default:
				goto yy2723;
		}

yy2891:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2893;

			case '\r':
				goto yy2895;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2897;

			case '>':
				goto yy2892;

			case 'T':
			case 't':
				goto yy2899;

			default:
				goto yy37;
		}

yy2892:
		yych = *++YYCURSOR;
		goto yy608;
yy2893:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2893;

			case '\r':
				goto yy2895;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2897;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2899;

			default:
				goto yy36;
		}

yy2895:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2893;

			case '\r':
				goto yy2895;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2897;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2899;

			default:
				goto yy36;
		}

yy2897:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2901;

			case '\r':
				goto yy2903;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2897;

			case '/':
				goto yy38;

			case '=':
				goto yy2905;

			case '>':
				goto yy2892;

			default:
				goto yy36;
		}

yy2899:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2901;

			case '\r':
				goto yy2903;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2897;

			case '=':
				goto yy2905;

			case '>':
				goto yy2892;

			case 'E':
			case 'e':
				goto yy2900;

			default:
				goto yy37;
		}

yy2900:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2901;

			case '\r':
				goto yy2903;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy2897;

			case '=':
				goto yy2905;

			case '>':
				goto yy2892;

			case 'X':
			case 'x':
				goto yy2944;

			default:
				goto yy37;
		}

yy2901:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2901;

			case '\r':
				goto yy2903;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2897;

			case '=':
				goto yy2905;

			case '>':
				goto yy2892;

			default:
				goto yy36;
		}

yy2903:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2901;

			case '\r':
				goto yy2903;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2897;

			case '=':
				goto yy2905;

			case '>':
				goto yy2892;

			default:
				goto yy36;
		}

yy2905:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2905;

			case '\r':
				goto yy2907;

			case '"':
				goto yy2909;

			case '\'':
				goto yy2911;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2907:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2905;

			case '\r':
				goto yy2907;

			case '"':
				goto yy2909;

			case '\'':
				goto yy2911;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2909:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2910:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2916;

			case '/':
				goto yy2940;

			case '>':
				goto yy2942;

			default:
				goto yy2909;
		}

yy2911:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2916;

			case '/':
				goto yy2913;

			case '>':
				goto yy2915;

			default:
				goto yy2911;
		}

yy2913:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2916;

			case '/':
				goto yy2913;

			case '>':
				goto yy2939;

			default:
				goto yy2911;
		}

yy2915:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy2923;
yy2916:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2916;

			case '\r':
				goto yy2918;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2897;

			case '>':
				goto yy2892;

			default:
				goto yy36;
		}

yy2918:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2916;

			case '\r':
				goto yy2918;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2897;

			case '>':
				goto yy2892;

			default:
				goto yy36;
		}

yy2920:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2920;

			case '\r':
				goto yy2924;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2927;

			case '>':
				goto yy2926;

			default:
				goto yy9;
		}

yy2922:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2923:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy2920;

			default:
				goto yy2922;
		}

yy2924:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2920;

			case '\r':
				goto yy2924;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2927;

			case '>':
				goto yy2926;

			default:
				goto yy9;
		}

yy2926:
		yych = *++YYCURSOR;
		goto yy608;
yy2927:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2929;

			case '\r':
				goto yy2931;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2927;

			case '=':
				goto yy2933;

			case '>':
				goto yy2926;

			default:
				goto yy9;
		}

yy2929:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2929;

			case '\r':
				goto yy2931;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2927;

			case '=':
				goto yy2933;

			case '>':
				goto yy2926;

			default:
				goto yy9;
		}

yy2931:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2929;

			case '\r':
				goto yy2931;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2927;

			case '=':
				goto yy2933;

			case '>':
				goto yy2926;

			default:
				goto yy9;
		}

yy2933:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2933;

			case '\r':
				goto yy2935;

			case '"':
				goto yy2937;

			case '\'':
				goto yy2922;

			default:
				goto yy9;
		}

yy2935:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2933;

			case '\r':
				goto yy2935;

			case '"':
				goto yy2937;

			case '\'':
				goto yy2922;

			default:
				goto yy9;
		}

yy2937:
		++YYCURSOR;
		yych = *YYCURSOR;
yy2938:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2920;

			default:
				goto yy2937;
		}

yy2939:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy2923;
yy2940:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy2916;

			case '/':
				goto yy2940;

			case '>':
				goto yy2943;

			default:
				goto yy2909;
		}

yy2942:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy2938;
yy2943:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy2938;
yy2944:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2901;

			case '\r':
				goto yy2903;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2897;

			case '=':
				goto yy2905;

			case '>':
				goto yy2892;

			case 'T':
			case 't':
				goto yy2945;

			default:
				goto yy37;
		}

yy2945:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2946;

			case '\r':
				goto yy2948;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2897;

			case '=':
				goto yy2950;

			case '>':
				goto yy2892;

			default:
				goto yy37;
		}

yy2946:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2946;

			case '\r':
				goto yy2948;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2897;

			case '=':
				goto yy2950;

			case '>':
				goto yy2892;

			default:
				goto yy36;
		}

yy2948:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2946;

			case '\r':
				goto yy2948;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2897;

			case '=':
				goto yy2950;

			case '>':
				goto yy2892;

			default:
				goto yy36;
		}

yy2950:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2950;

			case '\r':
				goto yy2952;

			case '"':
				goto yy2954;

			case '\'':
				goto yy2911;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2952:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2950;

			case '\r':
				goto yy2952;

			case '"':
				goto yy2954;

			case '\'':
				goto yy2911;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy2954:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2955;

			default:
				goto yy2910;
		}

yy2955:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2956;

			default:
				goto yy2910;
		}

yy2956:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2957;

			default:
				goto yy2910;
		}

yy2957:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2958;

			default:
				goto yy2910;
		}

yy2958:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2959;

			default:
				goto yy2910;
		}

yy2959:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy2960;

			default:
				goto yy2910;
		}

yy2960:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2961;

			default:
				goto yy2910;
		}

yy2961:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2962;

			default:
				goto yy2910;
		}

yy2962:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2963;

			case 'P':
			case 'p':
				goto yy2964;

			default:
				goto yy2910;
		}

yy2963:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2980;

			default:
				goto yy2910;
		}

yy2964:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy2965;

			default:
				goto yy2910;
		}

yy2965:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2966;

			default:
				goto yy2910;
		}

yy2966:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2967;

			default:
				goto yy2910;
		}

yy2967:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy2968;

			default:
				goto yy2910;
		}

yy2968:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy2969;

			default:
				goto yy2910;
		}

yy2969:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2970;

			default:
				goto yy2910;
		}

yy2970:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy2971;

			default:
				goto yy2910;
		}

yy2971:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2972;

			default:
				goto yy2910;
		}

yy2972:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2973;

			default:
				goto yy2910;
		}

yy2973:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2974;

			default:
				goto yy2910;
		}

yy2974:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2975;

			default:
				goto yy2910;
		}

yy2975:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2976;

			default:
				goto yy2910;
		}

yy2976:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2977;

			default:
				goto yy2910;
		}

yy2977:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2978;

			default:
				goto yy2910;
		}

yy2978:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2979;

			default:
				goto yy2910;
		}

yy2979:
		yych = *++YYCURSOR;
		goto yy2910;
yy2980:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2981;

			default:
				goto yy2910;
		}

yy2981:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2982;

			default:
				goto yy2910;
		}

yy2982:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy2983;

			default:
				goto yy2910;
		}

yy2983:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2984;

			default:
				goto yy2910;
		}

yy2984:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2985;

			default:
				goto yy2910;
		}

yy2985:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy2986;

			default:
				goto yy2910;
		}

yy2986:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2987;

			default:
				goto yy2910;
		}

yy2987:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2988;

			default:
				goto yy2910;
		}

yy2988:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2989;

			default:
				goto yy2910;
		}

yy2989:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2990;

			default:
				goto yy2910;
		}

yy2990:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy2991;

			default:
				goto yy2910;
		}

yy2991:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy2992;

			default:
				goto yy2910;
		}

yy2992:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy2993;

			default:
				goto yy2910;
		}

yy2993:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy2994;

			default:
				goto yy2910;
		}

yy2994:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy2995;

			default:
				goto yy2910;
		}

yy2995:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy2996;

			case '\r':
				goto yy2998;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '>':
				goto yy1544;

			default:
				goto yy37;
		}

yy2996:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2996;

			case '\r':
				goto yy2998;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '>':
				goto yy2892;

			default:
				goto yy36;
		}

yy2998:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy2996;

			case '\r':
				goto yy2998;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1545;

			case '>':
				goto yy2892;

			default:
				goto yy36;
		}

yy3000:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy57;

			case '\r':
				goto yy3000;

			case '"':
				goto yy1302;

			case '\'':
				goto yy74;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3002:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy50;

			case '\r':
				goto yy3002;

			case '"':
				goto yy3004;

			case '\'':
				goto yy3006;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3004:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3009;

			case '/':
				goto yy3149;

			case '>':
				goto yy3148;

			default:
				goto yy3004;
		}

yy3006:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3009;

			case '/':
				goto yy3011;

			case '>':
				goto yy3008;

			default:
				goto yy3006;
		}

yy3008:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy3017;
yy3009:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3009;

			case '\r':
				goto yy3083;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy3085;

			default:
				goto yy36;
		}

yy3011:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3009;

			case '/':
				goto yy3011;

			case '>':
				goto yy3013;

			default:
				goto yy3006;
		}

yy3013:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy3017;
yy3014:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3014;

			case '\r':
				goto yy3018;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy933;

			case 'T':
			case 't':
				goto yy3020;

			default:
				goto yy9;
		}

yy3016:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3017:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3014;

			default:
				goto yy3016;
		}

yy3018:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3014;

			case '\r':
				goto yy3018;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy933;

			case 'T':
			case 't':
				goto yy3020;

			default:
				goto yy9;
		}

yy3020:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy933;

			case 'E':
			case 'e':
				goto yy3021;

			case 'T':
			case 't':
				goto yy935;

			default:
				goto yy938;
		}

yy3021:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy933;

			case 'T':
			case 't':
				goto yy935;

			case 'X':
			case 'x':
				goto yy3022;

			default:
				goto yy938;
		}

yy3022:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy933;

			case 'T':
			case 't':
				goto yy3023;

			default:
				goto yy938;
		}

yy3023:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy933;

			case 'E':
			case 'e':
				goto yy945;

			case 'T':
			case 't':
				goto yy935;

			default:
				goto yy3025;
		}

yy3024:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3025:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3024;

			case '\r':
				goto yy3026;

			case '=':
				goto yy3028;

			case 'T':
			case 't':
				goto yy270;

			default:
				goto yy9;
		}

yy3026:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3024;

			case '\r':
				goto yy3026;

			case '=':
				goto yy3028;

			case 'T':
			case 't':
				goto yy270;

			default:
				goto yy9;
		}

yy3028:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3028;

			case '\r':
				goto yy3030;

			case '"':
				goto yy3032;

			case '\'':
				goto yy266;

			default:
				goto yy9;
		}

yy3030:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3028;

			case '\r':
				goto yy3030;

			case '"':
				goto yy3032;

			case '\'':
				goto yy266;

			default:
				goto yy9;
		}

yy3032:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3033;

			default:
				goto yy337;
		}

yy3033:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3034;

			default:
				goto yy337;
		}

yy3034:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3035;

			default:
				goto yy337;
		}

yy3035:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3036;

			default:
				goto yy337;
		}

yy3036:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3037;

			default:
				goto yy337;
		}

yy3037:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3038;

			default:
				goto yy337;
		}

yy3038:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3039;

			default:
				goto yy337;
		}

yy3039:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3040;

			default:
				goto yy337;
		}

yy3040:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3042;

			case 'P':
			case 'p':
				goto yy3041;

			default:
				goto yy337;
		}

yy3041:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy3063;

			default:
				goto yy337;
		}

yy3042:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3043;

			default:
				goto yy337;
		}

yy3043:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3044;

			default:
				goto yy337;
		}

yy3044:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3045;

			default:
				goto yy337;
		}

yy3045:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy3046;

			default:
				goto yy337;
		}

yy3046:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3047;

			default:
				goto yy337;
		}

yy3047:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3048;

			default:
				goto yy337;
		}

yy3048:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3049;

			default:
				goto yy337;
		}

yy3049:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3050;

			default:
				goto yy337;
		}

yy3050:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3051;

			default:
				goto yy337;
		}

yy3051:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3052;

			default:
				goto yy337;
		}

yy3052:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3053;

			default:
				goto yy337;
		}

yy3053:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3054;

			default:
				goto yy337;
		}

yy3054:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3055;

			default:
				goto yy337;
		}

yy3055:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3056;

			default:
				goto yy337;
		}

yy3056:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3057;

			default:
				goto yy337;
		}

yy3057:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy3058;

			default:
				goto yy337;
		}

yy3058:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy2502;

			default:
				goto yy3060;
		}

yy3059:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3060:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3059;

			case '\r':
				goto yy3061;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2503;

			case 'T':
			case 't':
				goto yy2505;

			default:
				goto yy9;
		}

yy3061:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3059;

			case '\r':
				goto yy3061;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2503;

			case 'T':
			case 't':
				goto yy2505;

			default:
				goto yy9;
		}

yy3063:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3064;

			default:
				goto yy337;
		}

yy3064:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3065;

			default:
				goto yy337;
		}

yy3065:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3066;

			default:
				goto yy337;
		}

yy3066:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy3067;

			default:
				goto yy337;
		}

yy3067:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3068;

			default:
				goto yy337;
		}

yy3068:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3069;

			default:
				goto yy337;
		}

yy3069:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3070;

			default:
				goto yy337;
		}

yy3070:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3071;

			default:
				goto yy337;
		}

yy3071:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3072;

			default:
				goto yy337;
		}

yy3072:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3073;

			default:
				goto yy337;
		}

yy3073:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3074;

			default:
				goto yy337;
		}

yy3074:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3075;

			default:
				goto yy337;
		}

yy3075:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3076;

			default:
				goto yy337;
		}

yy3076:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3077;

			default:
				goto yy337;
		}

yy3077:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy3078;

			default:
				goto yy337;
		}

yy3078:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy1946;

			default:
				goto yy3080;
		}

yy3079:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3080:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3079;

			case '\r':
				goto yy3081;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1947;

			case 'T':
			case 't':
				goto yy1949;

			default:
				goto yy9;
		}

yy3081:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3079;

			case '\r':
				goto yy3081;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy1947;

			case 'T':
			case 't':
				goto yy1949;

			default:
				goto yy9;
		}

yy3083:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3009;

			case '\r':
				goto yy3083;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy3085;

			default:
				goto yy36;
		}

yy3085:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy89;

			case '\r':
				goto yy91;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy93;

			case 'E':
			case 'e':
				goto yy3086;

			case 'T':
			case 't':
				goto yy87;

			default:
				goto yy37;
		}

yy3086:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy89;

			case '\r':
				goto yy91;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy93;

			case 'T':
			case 't':
				goto yy87;

			case 'X':
			case 'x':
				goto yy3087;

			default:
				goto yy37;
		}

yy3087:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy89;

			case '\r':
				goto yy91;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy93;

			case 'T':
			case 't':
				goto yy3088;

			default:
				goto yy37;
		}

yy3088:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3089;

			case '\r':
				goto yy3091;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy3093;

			case 'E':
			case 'e':
				goto yy339;

			case 'T':
			case 't':
				goto yy87;

			default:
				goto yy37;
		}

yy3089:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3089;

			case '\r':
				goto yy3091;

			case '/':
				goto yy38;

			case '=':
				goto yy3093;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy108;

			default:
				goto yy36;
		}

yy3091:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3089;

			case '\r':
				goto yy3091;

			case '/':
				goto yy38;

			case '=':
				goto yy3093;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy108;

			default:
				goto yy36;
		}

yy3093:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3093;

			case '\r':
				goto yy3095;

			case '"':
				goto yy3097;

			case '\'':
				goto yy99;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3095:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3093;

			case '\r':
				goto yy3095;

			case '"':
				goto yy3097;

			case '\'':
				goto yy99;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3097:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3098;

			default:
				goto yy98;
		}

yy3098:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3099;

			default:
				goto yy98;
		}

yy3099:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3100;

			default:
				goto yy98;
		}

yy3100:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3101;

			default:
				goto yy98;
		}

yy3101:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3102;

			default:
				goto yy98;
		}

yy3102:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3103;

			default:
				goto yy98;
		}

yy3103:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3104;

			default:
				goto yy98;
		}

yy3104:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3105;

			default:
				goto yy98;
		}

yy3105:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3107;

			case 'P':
			case 'p':
				goto yy3106;

			default:
				goto yy98;
		}

yy3106:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy3128;

			default:
				goto yy98;
		}

yy3107:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3108;

			default:
				goto yy98;
		}

yy3108:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3109;

			default:
				goto yy98;
		}

yy3109:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3110;

			default:
				goto yy98;
		}

yy3110:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy3111;

			default:
				goto yy98;
		}

yy3111:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3112;

			default:
				goto yy98;
		}

yy3112:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3113;

			default:
				goto yy98;
		}

yy3113:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3114;

			default:
				goto yy98;
		}

yy3114:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3115;

			default:
				goto yy98;
		}

yy3115:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3116;

			default:
				goto yy98;
		}

yy3116:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3117;

			default:
				goto yy98;
		}

yy3117:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3118;

			default:
				goto yy98;
		}

yy3118:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3119;

			default:
				goto yy98;
		}

yy3119:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3120;

			default:
				goto yy98;
		}

yy3120:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3121;

			default:
				goto yy98;
		}

yy3121:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3122;

			default:
				goto yy98;
		}

yy3122:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy3123;

			default:
				goto yy98;
		}

yy3123:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3124;

			case '\r':
				goto yy3126;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '>':
				goto yy2467;

			case 'T':
			case 't':
				goto yy2607;

			default:
				goto yy37;
		}

yy3124:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3124;

			case '\r':
				goto yy3126;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy2607;

			default:
				goto yy36;
		}

yy3126:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3124;

			case '\r':
				goto yy3126;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2605;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy2607;

			default:
				goto yy36;
		}

yy3128:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3129;

			default:
				goto yy98;
		}

yy3129:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3130;

			default:
				goto yy98;
		}

yy3130:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3131;

			default:
				goto yy98;
		}

yy3131:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy3132;

			default:
				goto yy98;
		}

yy3132:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3133;

			default:
				goto yy98;
		}

yy3133:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3134;

			default:
				goto yy98;
		}

yy3134:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3135;

			default:
				goto yy98;
		}

yy3135:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3136;

			default:
				goto yy98;
		}

yy3136:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3137;

			default:
				goto yy98;
		}

yy3137:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3138;

			default:
				goto yy98;
		}

yy3138:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3139;

			default:
				goto yy98;
		}

yy3139:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3140;

			default:
				goto yy98;
		}

yy3140:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3141;

			default:
				goto yy98;
		}

yy3141:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3142;

			default:
				goto yy98;
		}

yy3142:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy3143;

			default:
				goto yy98;
		}

yy3143:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3144;

			case '\r':
				goto yy3146;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '>':
				goto yy1911;

			case 'T':
			case 't':
				goto yy2051;

			default:
				goto yy37;
		}

yy3144:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3144;

			case '\r':
				goto yy3146;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy2051;

			default:
				goto yy36;
		}

yy3146:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3144;

			case '\r':
				goto yy3146;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy2049;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy2051;

			default:
				goto yy36;
		}

yy3148:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy3153;
yy3149:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3009;

			case '/':
				goto yy3149;

			case '>':
				goto yy3151;

			default:
				goto yy3004;
		}

yy3151:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy3153;
yy3152:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3153:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3014;

			default:
				goto yy3152;
		}

yy3154:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy53;

			case '\r':
				goto yy55;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy48;

			case '=':
				goto yy57;

			case 'T':
			case 't':
				goto yy60;

			case 'X':
			case 'x':
				goto yy3155;

			default:
				goto yy37;
		}

yy3155:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy53;

			case '\r':
				goto yy55;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '=':
				goto yy57;

			case 'T':
			case 't':
				goto yy3156;

			default:
				goto yy37;
		}

yy3156:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3157;

			case '\r':
				goto yy3159;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy48;

			case '=':
				goto yy3161;

			case 'E':
			case 'e':
				goto yy62;

			case 'T':
			case 't':
				goto yy60;

			default:
				goto yy37;
		}

yy3157:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3157;

			case '\r':
				goto yy3159;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy3161;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy85;

			default:
				goto yy36;
		}

yy3159:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3157;

			case '\r':
				goto yy3159;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy83;

			case '=':
				goto yy3161;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy85;

			default:
				goto yy36;
		}

yy3161:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3161;

			case '\r':
				goto yy3163;

			case '"':
				goto yy3165;

			case '\'':
				goto yy74;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3163:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3161;

			case '\r':
				goto yy3163;

			case '"':
				goto yy3165;

			case '\'':
				goto yy74;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3165:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3166;

			default:
				goto yy1303;
		}

yy3166:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3167;

			default:
				goto yy1303;
		}

yy3167:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3168;

			default:
				goto yy1303;
		}

yy3168:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3169;

			default:
				goto yy1303;
		}

yy3169:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3170;

			default:
				goto yy1303;
		}

yy3170:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3171;

			default:
				goto yy1303;
		}

yy3171:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3172;

			default:
				goto yy1303;
		}

yy3172:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3173;

			default:
				goto yy1303;
		}

yy3173:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3175;

			case 'P':
			case 'p':
				goto yy3174;

			default:
				goto yy1303;
		}

yy3174:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy4084;

			default:
				goto yy1303;
		}

yy3175:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3176;

			default:
				goto yy1303;
		}

yy3176:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3177;

			default:
				goto yy1303;
		}

yy3177:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3178;

			default:
				goto yy1303;
		}

yy3178:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy3179;

			default:
				goto yy1303;
		}

yy3179:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3180;

			default:
				goto yy1303;
		}

yy3180:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3181;

			default:
				goto yy1303;
		}

yy3181:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3182;

			default:
				goto yy1303;
		}

yy3182:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3183;

			default:
				goto yy1303;
		}

yy3183:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3184;

			default:
				goto yy1303;
		}

yy3184:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3185;

			default:
				goto yy1303;
		}

yy3185:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3186;

			default:
				goto yy1303;
		}

yy3186:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3187;

			default:
				goto yy1303;
		}

yy3187:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3188;

			default:
				goto yy1303;
		}

yy3188:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3189;

			default:
				goto yy1303;
		}

yy3189:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3190;

			default:
				goto yy1303;
		}

yy3190:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy3191;

			default:
				goto yy1303;
		}

yy3191:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3194;

			case '\r':
				goto yy3196;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3198;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3200;

			default:
				goto yy37;
		}

yy3192:
		++YYCURSOR;
yy3193: {
			return ITMZ_TOPIC_METADATA;
		}
yy3194:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3194;

			case '\r':
				goto yy3196;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3198;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy3200;

			default:
				goto yy36;
		}

yy3196:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3194;

			case '\r':
				goto yy3196;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3198;

			case '>':
				goto yy40;

			case 'T':
			case 't':
				goto yy3200;

			default:
				goto yy36;
		}

yy3198:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3204;

			case '\r':
				goto yy3206;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3198;

			case '/':
				goto yy38;

			case '=':
				goto yy3208;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3202;

			default:
				goto yy36;
		}

yy3200:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3204;

			case '\r':
				goto yy3206;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3198;

			case '=':
				goto yy3208;

			case '>':
				goto yy3192;

			case 'E':
			case 'e':
				goto yy3201;

			case 'T':
			case 't':
				goto yy3202;

			default:
				goto yy37;
		}

yy3201:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3204;

			case '\r':
				goto yy3206;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy3198;

			case '=':
				goto yy3208;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3202;

			case 'X':
			case 'x':
				goto yy3723;

			default:
				goto yy37;
		}

yy3202:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3204;

			case '\r':
				goto yy3206;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3198;

			case '/':
				goto yy38;

			case '=':
				goto yy3208;

			case '>':
				goto yy3192;

			case 'E':
			case 'e':
				goto yy3499;

			case 'T':
			case 't':
				goto yy3202;

			default:
				goto yy36;
		}

yy3204:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3204;

			case '\r':
				goto yy3206;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '=':
				goto yy3208;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3225;

			default:
				goto yy36;
		}

yy3206:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3204;

			case '\r':
				goto yy3206;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '=':
				goto yy3208;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3225;

			default:
				goto yy36;
		}

yy3208:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3208;

			case '\r':
				goto yy3210;

			case '"':
				goto yy3212;

			case '\'':
				goto yy3214;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3210:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3208;

			case '\r':
				goto yy3210;

			case '"':
				goto yy3212;

			case '\'':
				goto yy3214;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3212:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3213:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3219;

			case '/':
				goto yy3493;

			case '>':
				goto yy3495;

			default:
				goto yy3212;
		}

yy3214:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3219;

			case '/':
				goto yy3216;

			case '>':
				goto yy3218;

			default:
				goto yy3214;
		}

yy3216:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3219;

			case '/':
				goto yy3216;

			case '>':
				goto yy3492;

			default:
				goto yy3214;
		}

yy3218:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy3426;
yy3219:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3219;

			case '\r':
				goto yy3221;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3225;

			default:
				goto yy36;
		}

yy3221:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3219;

			case '\r':
				goto yy3221;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3225;

			default:
				goto yy36;
		}

yy3223:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3227;

			case '\r':
				goto yy3229;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '/':
				goto yy38;

			case '=':
				goto yy3231;

			case '>':
				goto yy3192;

			default:
				goto yy36;
		}

yy3225:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3227;

			case '\r':
				goto yy3229;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '=':
				goto yy3231;

			case '>':
				goto yy3192;

			case 'E':
			case 'e':
				goto yy3226;

			default:
				goto yy37;
		}

yy3226:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3227;

			case '\r':
				goto yy3229;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy3223;

			case '=':
				goto yy3231;

			case '>':
				goto yy3192;

			case 'X':
			case 'x':
				goto yy3270;

			default:
				goto yy37;
		}

yy3227:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3227;

			case '\r':
				goto yy3229;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '=':
				goto yy3231;

			case '>':
				goto yy3192;

			default:
				goto yy36;
		}

yy3229:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3227;

			case '\r':
				goto yy3229;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '=':
				goto yy3231;

			case '>':
				goto yy3192;

			default:
				goto yy36;
		}

yy3231:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3231;

			case '\r':
				goto yy3233;

			case '"':
				goto yy3235;

			case '\'':
				goto yy3237;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3233:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3231;

			case '\r':
				goto yy3233;

			case '"':
				goto yy3235;

			case '\'':
				goto yy3237;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3235:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3236:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3242;

			case '/':
				goto yy3266;

			case '>':
				goto yy3268;

			default:
				goto yy3235;
		}

yy3237:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3242;

			case '/':
				goto yy3239;

			case '>':
				goto yy3241;

			default:
				goto yy3237;
		}

yy3239:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3242;

			case '/':
				goto yy3239;

			case '>':
				goto yy3265;

			default:
				goto yy3237;
		}

yy3241:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy3249;
yy3242:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3242;

			case '\r':
				goto yy3244;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '>':
				goto yy3192;

			default:
				goto yy36;
		}

yy3244:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3242;

			case '\r':
				goto yy3244;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '>':
				goto yy3192;

			default:
				goto yy36;
		}

yy3246:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3246;

			case '\r':
				goto yy3250;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3253;

			case '>':
				goto yy3252;

			default:
				goto yy9;
		}

yy3248:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3249:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3246;

			default:
				goto yy3248;
		}

yy3250:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3246;

			case '\r':
				goto yy3250;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3253;

			case '>':
				goto yy3252;

			default:
				goto yy9;
		}

yy3252:
		yych = *++YYCURSOR;
		goto yy3193;
yy3253:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3255;

			case '\r':
				goto yy3257;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3253;

			case '=':
				goto yy3259;

			case '>':
				goto yy3252;

			default:
				goto yy9;
		}

yy3255:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3256:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3255;

			case '\r':
				goto yy3257;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3253;

			case '=':
				goto yy3259;

			case '>':
				goto yy3252;

			default:
				goto yy9;
		}

yy3257:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3255;

			case '\r':
				goto yy3257;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3253;

			case '=':
				goto yy3259;

			case '>':
				goto yy3252;

			default:
				goto yy9;
		}

yy3259:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3259;

			case '\r':
				goto yy3261;

			case '"':
				goto yy3263;

			case '\'':
				goto yy3248;

			default:
				goto yy9;
		}

yy3261:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3259;

			case '\r':
				goto yy3261;

			case '"':
				goto yy3263;

			case '\'':
				goto yy3248;

			default:
				goto yy9;
		}

yy3263:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3264:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3246;

			default:
				goto yy3263;
		}

yy3265:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy3249;
yy3266:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3242;

			case '/':
				goto yy3266;

			case '>':
				goto yy3269;

			default:
				goto yy3235;
		}

yy3268:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy3264;
yy3269:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy3264;
yy3270:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3227;

			case '\r':
				goto yy3229;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '=':
				goto yy3231;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3271;

			default:
				goto yy37;
		}

yy3271:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3272;

			case '\r':
				goto yy3274;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '=':
				goto yy3276;

			case '>':
				goto yy3192;

			default:
				goto yy37;
		}

yy3272:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3272;

			case '\r':
				goto yy3274;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '=':
				goto yy3276;

			case '>':
				goto yy3192;

			default:
				goto yy36;
		}

yy3274:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3272;

			case '\r':
				goto yy3274;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '=':
				goto yy3276;

			case '>':
				goto yy3192;

			default:
				goto yy36;
		}

yy3276:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3276;

			case '\r':
				goto yy3278;

			case '"':
				goto yy3280;

			case '\'':
				goto yy3237;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3278:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3276;

			case '\r':
				goto yy3278;

			case '"':
				goto yy3280;

			case '\'':
				goto yy3237;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3280:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3281;

			default:
				goto yy3236;
		}

yy3281:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3282;

			default:
				goto yy3236;
		}

yy3282:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3283;

			default:
				goto yy3236;
		}

yy3283:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3284;

			default:
				goto yy3236;
		}

yy3284:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3285;

			default:
				goto yy3236;
		}

yy3285:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3286;

			default:
				goto yy3236;
		}

yy3286:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3287;

			default:
				goto yy3236;
		}

yy3287:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3288;

			default:
				goto yy3236;
		}

yy3288:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3289;

			case 'P':
			case 'p':
				goto yy3290;

			default:
				goto yy3236;
		}

yy3289:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3357;

			default:
				goto yy3236;
		}

yy3290:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy3291;

			default:
				goto yy3236;
		}

yy3291:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3292;

			default:
				goto yy3236;
		}

yy3292:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3293;

			default:
				goto yy3236;
		}

yy3293:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3294;

			default:
				goto yy3236;
		}

yy3294:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy3295;

			default:
				goto yy3236;
		}

yy3295:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3296;

			default:
				goto yy3236;
		}

yy3296:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3297;

			default:
				goto yy3236;
		}

yy3297:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3298;

			default:
				goto yy3236;
		}

yy3298:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3299;

			default:
				goto yy3236;
		}

yy3299:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3300;

			default:
				goto yy3236;
		}

yy3300:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3301;

			default:
				goto yy3236;
		}

yy3301:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3302;

			default:
				goto yy3236;
		}

yy3302:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3303;

			default:
				goto yy3236;
		}

yy3303:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3304;

			default:
				goto yy3236;
		}

yy3304:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3305;

			default:
				goto yy3236;
		}

yy3305:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy3306;

			default:
				goto yy3236;
		}

yy3306:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3307;

			case '\r':
				goto yy3309;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3312;

			case '>':
				goto yy3311;

			default:
				goto yy37;
		}

yy3307:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3307;

			case '\r':
				goto yy3309;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3312;

			case '>':
				goto yy3192;

			default:
				goto yy36;
		}

yy3309:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3307;

			case '\r':
				goto yy3309;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3312;

			case '>':
				goto yy3192;

			default:
				goto yy36;
		}

yy3311:
		yych = *++YYCURSOR;
		goto yy3193;
yy3312:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3314;

			case '\r':
				goto yy3316;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3312;

			case '/':
				goto yy38;

			case '=':
				goto yy3318;

			case '>':
				goto yy3311;

			default:
				goto yy36;
		}

yy3314:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3314;

			case '\r':
				goto yy3316;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3312;

			case '=':
				goto yy3318;

			case '>':
				goto yy3311;

			default:
				goto yy36;
		}

yy3316:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3314;

			case '\r':
				goto yy3316;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3312;

			case '=':
				goto yy3318;

			case '>':
				goto yy3311;

			default:
				goto yy36;
		}

yy3318:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3318;

			case '\r':
				goto yy3320;

			case '"':
				goto yy3322;

			case '\'':
				goto yy3324;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3320:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3318;

			case '\r':
				goto yy3320;

			case '"':
				goto yy3322;

			case '\'':
				goto yy3324;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3322:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3323:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3327;

			case '/':
				goto yy3354;

			case '>':
				goto yy3353;

			default:
				goto yy3322;
		}

yy3324:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3327;

			case '/':
				goto yy3329;

			case '>':
				goto yy3326;

			default:
				goto yy3324;
		}

yy3326:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy3335;
yy3327:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3327;

			case '\r':
				goto yy3351;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3312;

			case '>':
				goto yy3311;

			default:
				goto yy36;
		}

yy3329:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3327;

			case '/':
				goto yy3329;

			case '>':
				goto yy3331;

			default:
				goto yy3324;
		}

yy3331:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy3335;
yy3332:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3332;

			case '\r':
				goto yy3336;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3339;

			case '>':
				goto yy3338;

			default:
				goto yy9;
		}

yy3334:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3335:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3332;

			default:
				goto yy3334;
		}

yy3336:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3332;

			case '\r':
				goto yy3336;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3339;

			case '>':
				goto yy3338;

			default:
				goto yy9;
		}

yy3338:
		yych = *++YYCURSOR;
		goto yy3193;
yy3339:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3341;

			case '\r':
				goto yy3343;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3339;

			case '=':
				goto yy3345;

			case '>':
				goto yy3338;

			default:
				goto yy9;
		}

yy3341:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3341;

			case '\r':
				goto yy3343;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3339;

			case '=':
				goto yy3345;

			case '>':
				goto yy3338;

			default:
				goto yy9;
		}

yy3343:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3341;

			case '\r':
				goto yy3343;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3339;

			case '=':
				goto yy3345;

			case '>':
				goto yy3338;

			default:
				goto yy9;
		}

yy3345:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3345;

			case '\r':
				goto yy3347;

			case '"':
				goto yy3349;

			case '\'':
				goto yy3334;

			default:
				goto yy9;
		}

yy3347:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3345;

			case '\r':
				goto yy3347;

			case '"':
				goto yy3349;

			case '\'':
				goto yy3334;

			default:
				goto yy9;
		}

yy3349:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3350:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3332;

			default:
				goto yy3349;
		}

yy3351:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3327;

			case '\r':
				goto yy3351;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3312;

			case '>':
				goto yy3311;

			default:
				goto yy36;
		}

yy3353:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy3350;
yy3354:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3327;

			case '/':
				goto yy3354;

			case '>':
				goto yy3356;

			default:
				goto yy3322;
		}

yy3356:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy3350;
yy3357:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3358;

			default:
				goto yy3236;
		}

yy3358:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3359;

			default:
				goto yy3236;
		}

yy3359:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy3360;

			default:
				goto yy3236;
		}

yy3360:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3361;

			default:
				goto yy3236;
		}

yy3361:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3362;

			default:
				goto yy3236;
		}

yy3362:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3363;

			default:
				goto yy3236;
		}

yy3363:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3364;

			default:
				goto yy3236;
		}

yy3364:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3365;

			default:
				goto yy3236;
		}

yy3365:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3366;

			default:
				goto yy3236;
		}

yy3366:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3367;

			default:
				goto yy3236;
		}

yy3367:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3368;

			default:
				goto yy3236;
		}

yy3368:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3369;

			default:
				goto yy3236;
		}

yy3369:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3370;

			default:
				goto yy3236;
		}

yy3370:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3371;

			default:
				goto yy3236;
		}

yy3371:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy3372;

			default:
				goto yy3236;
		}

yy3372:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3373;

			case '\r':
				goto yy3375;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3378;

			case '>':
				goto yy3377;

			default:
				goto yy37;
		}

yy3373:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3373;

			case '\r':
				goto yy3375;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3378;

			case '>':
				goto yy3192;

			default:
				goto yy36;
		}

yy3375:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3373;

			case '\r':
				goto yy3375;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3378;

			case '>':
				goto yy3192;

			default:
				goto yy36;
		}

yy3377:
		yych = *++YYCURSOR;
		goto yy3193;
yy3378:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3380;

			case '\r':
				goto yy3382;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3378;

			case '/':
				goto yy38;

			case '=':
				goto yy3384;

			case '>':
				goto yy3377;

			default:
				goto yy36;
		}

yy3380:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3380;

			case '\r':
				goto yy3382;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3378;

			case '=':
				goto yy3384;

			case '>':
				goto yy3377;

			default:
				goto yy36;
		}

yy3382:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3380;

			case '\r':
				goto yy3382;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3378;

			case '=':
				goto yy3384;

			case '>':
				goto yy3377;

			default:
				goto yy36;
		}

yy3384:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3384;

			case '\r':
				goto yy3386;

			case '"':
				goto yy3388;

			case '\'':
				goto yy3390;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3386:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3384;

			case '\r':
				goto yy3386;

			case '"':
				goto yy3388;

			case '\'':
				goto yy3390;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3388:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3389:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3393;

			case '/':
				goto yy3420;

			case '>':
				goto yy3419;

			default:
				goto yy3388;
		}

yy3390:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3393;

			case '/':
				goto yy3395;

			case '>':
				goto yy3392;

			default:
				goto yy3390;
		}

yy3392:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy3401;
yy3393:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3393;

			case '\r':
				goto yy3417;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3378;

			case '>':
				goto yy3377;

			default:
				goto yy36;
		}

yy3395:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3393;

			case '/':
				goto yy3395;

			case '>':
				goto yy3397;

			default:
				goto yy3390;
		}

yy3397:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy3401;
yy3398:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3398;

			case '\r':
				goto yy3402;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3405;

			case '>':
				goto yy3404;

			default:
				goto yy9;
		}

yy3400:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3401:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3398;

			default:
				goto yy3400;
		}

yy3402:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3398;

			case '\r':
				goto yy3402;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3405;

			case '>':
				goto yy3404;

			default:
				goto yy9;
		}

yy3404:
		yych = *++YYCURSOR;
		goto yy3193;
yy3405:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3407;

			case '\r':
				goto yy3409;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3405;

			case '=':
				goto yy3411;

			case '>':
				goto yy3404;

			default:
				goto yy9;
		}

yy3407:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3407;

			case '\r':
				goto yy3409;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3405;

			case '=':
				goto yy3411;

			case '>':
				goto yy3404;

			default:
				goto yy9;
		}

yy3409:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3407;

			case '\r':
				goto yy3409;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3405;

			case '=':
				goto yy3411;

			case '>':
				goto yy3404;

			default:
				goto yy9;
		}

yy3411:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3411;

			case '\r':
				goto yy3413;

			case '"':
				goto yy3415;

			case '\'':
				goto yy3400;

			default:
				goto yy9;
		}

yy3413:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3411;

			case '\r':
				goto yy3413;

			case '"':
				goto yy3415;

			case '\'':
				goto yy3400;

			default:
				goto yy9;
		}

yy3415:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3416:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3398;

			default:
				goto yy3415;
		}

yy3417:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3393;

			case '\r':
				goto yy3417;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3378;

			case '>':
				goto yy3377;

			default:
				goto yy36;
		}

yy3419:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy3416;
yy3420:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3393;

			case '/':
				goto yy3420;

			case '>':
				goto yy3422;

			default:
				goto yy3388;
		}

yy3422:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy3416;
yy3423:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3423;

			case '\r':
				goto yy3427;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3253;

			case '>':
				goto yy3252;

			case 'T':
			case 't':
				goto yy3429;

			default:
				goto yy9;
		}

yy3425:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3426:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3423;

			default:
				goto yy3425;
		}

yy3427:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3423;

			case '\r':
				goto yy3427;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3253;

			case '>':
				goto yy3252;

			case 'T':
			case 't':
				goto yy3429;

			default:
				goto yy9;
		}

yy3429:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy3253;

			case 'E':
			case 'e':
				goto yy3430;

			default:
				goto yy3256;
		}

yy3430:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy3253;

			case 'X':
			case 'x':
				goto yy3431;

			default:
				goto yy3256;
		}

yy3431:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy3253;

			case 'T':
			case 't':
				goto yy3432;

			default:
				goto yy3256;
		}

yy3432:
		yych = *++YYCURSOR;

		switch (yych) {
			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				goto yy3253;

			default:
				goto yy3434;
		}

yy3433:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3434:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3433;

			case '\r':
				goto yy3435;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3253;

			case '=':
				goto yy3437;

			case '>':
				goto yy3252;

			default:
				goto yy9;
		}

yy3435:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3433;

			case '\r':
				goto yy3435;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3253;

			case '=':
				goto yy3437;

			case '>':
				goto yy3252;

			default:
				goto yy9;
		}

yy3437:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3437;

			case '\r':
				goto yy3439;

			case '"':
				goto yy3441;

			case '\'':
				goto yy3248;

			default:
				goto yy9;
		}

yy3439:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3437;

			case '\r':
				goto yy3439;

			case '"':
				goto yy3441;

			case '\'':
				goto yy3248;

			default:
				goto yy9;
		}

yy3441:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3442;

			default:
				goto yy3264;
		}

yy3442:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3443;

			default:
				goto yy3264;
		}

yy3443:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3444;

			default:
				goto yy3264;
		}

yy3444:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3445;

			default:
				goto yy3264;
		}

yy3445:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3446;

			default:
				goto yy3264;
		}

yy3446:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3447;

			default:
				goto yy3264;
		}

yy3447:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3448;

			default:
				goto yy3264;
		}

yy3448:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3449;

			default:
				goto yy3264;
		}

yy3449:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3450;

			case 'P':
			case 'p':
				goto yy3451;

			default:
				goto yy3264;
		}

yy3450:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3472;

			default:
				goto yy3264;
		}

yy3451:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy3452;

			default:
				goto yy3264;
		}

yy3452:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3453;

			default:
				goto yy3264;
		}

yy3453:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3454;

			default:
				goto yy3264;
		}

yy3454:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3455;

			default:
				goto yy3264;
		}

yy3455:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy3456;

			default:
				goto yy3264;
		}

yy3456:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3457;

			default:
				goto yy3264;
		}

yy3457:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3458;

			default:
				goto yy3264;
		}

yy3458:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3459;

			default:
				goto yy3264;
		}

yy3459:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3460;

			default:
				goto yy3264;
		}

yy3460:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3461;

			default:
				goto yy3264;
		}

yy3461:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3462;

			default:
				goto yy3264;
		}

yy3462:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3463;

			default:
				goto yy3264;
		}

yy3463:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3464;

			default:
				goto yy3264;
		}

yy3464:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3465;

			default:
				goto yy3264;
		}

yy3465:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3466;

			default:
				goto yy3264;
		}

yy3466:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy3467;

			default:
				goto yy3264;
		}

yy3467:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy3338;

			default:
				goto yy3469;
		}

yy3468:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3469:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3468;

			case '\r':
				goto yy3470;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3339;

			case '>':
				goto yy3252;

			default:
				goto yy9;
		}

yy3470:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3468;

			case '\r':
				goto yy3470;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3339;

			case '>':
				goto yy3252;

			default:
				goto yy9;
		}

yy3472:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3473;

			default:
				goto yy3264;
		}

yy3473:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3474;

			default:
				goto yy3264;
		}

yy3474:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy3475;

			default:
				goto yy3264;
		}

yy3475:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3476;

			default:
				goto yy3264;
		}

yy3476:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3477;

			default:
				goto yy3264;
		}

yy3477:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3478;

			default:
				goto yy3264;
		}

yy3478:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3479;

			default:
				goto yy3264;
		}

yy3479:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3480;

			default:
				goto yy3264;
		}

yy3480:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3481;

			default:
				goto yy3264;
		}

yy3481:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3482;

			default:
				goto yy3264;
		}

yy3482:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3483;

			default:
				goto yy3264;
		}

yy3483:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3484;

			default:
				goto yy3264;
		}

yy3484:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3485;

			default:
				goto yy3264;
		}

yy3485:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3486;

			default:
				goto yy3264;
		}

yy3486:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy3487;

			default:
				goto yy3264;
		}

yy3487:
		yych = *++YYCURSOR;

		switch (yych) {
			case '>':
				goto yy3404;

			default:
				goto yy3489;
		}

yy3488:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3489:

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3488;

			case '\r':
				goto yy3490;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3405;

			case '>':
				goto yy3252;

			default:
				goto yy9;
		}

yy3490:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3488;

			case '\r':
				goto yy3490;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3405;

			case '>':
				goto yy3252;

			default:
				goto yy9;
		}

yy3492:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy3426;
yy3493:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3219;

			case '/':
				goto yy3493;

			case '>':
				goto yy3498;

			default:
				goto yy3212;
		}

yy3495:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy3497;
yy3496:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3497:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3423;

			default:
				goto yy3496;
		}

yy3498:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy3497;
yy3499:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3204;

			case '\r':
				goto yy3206;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy3198;

			case '/':
				goto yy38;

			case '=':
				goto yy3208;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3202;

			case 'X':
			case 'x':
				goto yy3500;

			default:
				goto yy36;
		}

yy3500:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3204;

			case '\r':
				goto yy3206;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3198;

			case '/':
				goto yy38;

			case '=':
				goto yy3208;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3501;

			default:
				goto yy36;
		}

yy3501:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3502;

			case '\r':
				goto yy3504;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3198;

			case '/':
				goto yy38;

			case '=':
				goto yy3506;

			case '>':
				goto yy3192;

			case 'E':
			case 'e':
				goto yy3499;

			case 'T':
			case 't':
				goto yy3202;

			default:
				goto yy36;
		}

yy3502:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3502;

			case '\r':
				goto yy3504;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '=':
				goto yy3506;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3225;

			default:
				goto yy36;
		}

yy3504:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3502;

			case '\r':
				goto yy3504;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '=':
				goto yy3506;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3225;

			default:
				goto yy36;
		}

yy3506:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3506;

			case '\r':
				goto yy3508;

			case '"':
				goto yy3510;

			case '\'':
				goto yy3214;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3508:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3506;

			case '\r':
				goto yy3508;

			case '"':
				goto yy3510;

			case '\'':
				goto yy3214;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3510:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3511;

			default:
				goto yy3213;
		}

yy3511:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3512;

			default:
				goto yy3213;
		}

yy3512:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3513;

			default:
				goto yy3213;
		}

yy3513:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3514;

			default:
				goto yy3213;
		}

yy3514:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3515;

			default:
				goto yy3213;
		}

yy3515:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3516;

			default:
				goto yy3213;
		}

yy3516:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3517;

			default:
				goto yy3213;
		}

yy3517:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3518;

			default:
				goto yy3213;
		}

yy3518:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3519;

			case 'P':
			case 'p':
				goto yy3520;

			default:
				goto yy3213;
		}

yy3519:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3645;

			default:
				goto yy3213;
		}

yy3520:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy3521;

			default:
				goto yy3213;
		}

yy3521:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3522;

			default:
				goto yy3213;
		}

yy3522:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3523;

			default:
				goto yy3213;
		}

yy3523:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3524;

			default:
				goto yy3213;
		}

yy3524:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy3525;

			default:
				goto yy3213;
		}

yy3525:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3526;

			default:
				goto yy3213;
		}

yy3526:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3527;

			default:
				goto yy3213;
		}

yy3527:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3528;

			default:
				goto yy3213;
		}

yy3528:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3529;

			default:
				goto yy3213;
		}

yy3529:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3530;

			default:
				goto yy3213;
		}

yy3530:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3531;

			default:
				goto yy3213;
		}

yy3531:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3532;

			default:
				goto yy3213;
		}

yy3532:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3533;

			default:
				goto yy3213;
		}

yy3533:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3534;

			default:
				goto yy3213;
		}

yy3534:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3535;

			default:
				goto yy3213;
		}

yy3535:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy3536;

			default:
				goto yy3213;
		}

yy3536:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3537;

			case '\r':
				goto yy3539;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3312;

			case '>':
				goto yy3311;

			case 'T':
			case 't':
				goto yy3541;

			default:
				goto yy37;
		}

yy3537:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3537;

			case '\r':
				goto yy3539;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3312;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3541;

			default:
				goto yy36;
		}

yy3539:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3537;

			case '\r':
				goto yy3539;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3312;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3541;

			default:
				goto yy36;
		}

yy3541:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3314;

			case '\r':
				goto yy3316;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3312;

			case '=':
				goto yy3318;

			case '>':
				goto yy3311;

			case 'E':
			case 'e':
				goto yy3542;

			default:
				goto yy37;
		}

yy3542:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3314;

			case '\r':
				goto yy3316;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy3312;

			case '=':
				goto yy3318;

			case '>':
				goto yy3311;

			case 'X':
			case 'x':
				goto yy3543;

			default:
				goto yy37;
		}

yy3543:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3314;

			case '\r':
				goto yy3316;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3312;

			case '=':
				goto yy3318;

			case '>':
				goto yy3311;

			case 'T':
			case 't':
				goto yy3544;

			default:
				goto yy37;
		}

yy3544:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3545;

			case '\r':
				goto yy3547;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3312;

			case '=':
				goto yy3549;

			case '>':
				goto yy3311;

			default:
				goto yy37;
		}

yy3545:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3545;

			case '\r':
				goto yy3547;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3312;

			case '=':
				goto yy3549;

			case '>':
				goto yy3311;

			default:
				goto yy36;
		}

yy3547:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3545;

			case '\r':
				goto yy3547;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3312;

			case '=':
				goto yy3549;

			case '>':
				goto yy3311;

			default:
				goto yy36;
		}

yy3549:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3549;

			case '\r':
				goto yy3551;

			case '"':
				goto yy3553;

			case '\'':
				goto yy3324;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3551:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3549;

			case '\r':
				goto yy3551;

			case '"':
				goto yy3553;

			case '\'':
				goto yy3324;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3553:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3554;

			default:
				goto yy3323;
		}

yy3554:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3555;

			default:
				goto yy3323;
		}

yy3555:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3556;

			default:
				goto yy3323;
		}

yy3556:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3557;

			default:
				goto yy3323;
		}

yy3557:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3558;

			default:
				goto yy3323;
		}

yy3558:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3559;

			default:
				goto yy3323;
		}

yy3559:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3560;

			default:
				goto yy3323;
		}

yy3560:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3561;

			default:
				goto yy3323;
		}

yy3561:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3562;

			case 'P':
			case 'p':
				goto yy3563;

			default:
				goto yy3323;
		}

yy3562:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3579;

			default:
				goto yy3323;
		}

yy3563:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy3564;

			default:
				goto yy3323;
		}

yy3564:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3565;

			default:
				goto yy3323;
		}

yy3565:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3566;

			default:
				goto yy3323;
		}

yy3566:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3567;

			default:
				goto yy3323;
		}

yy3567:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy3568;

			default:
				goto yy3323;
		}

yy3568:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3569;

			default:
				goto yy3323;
		}

yy3569:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3570;

			default:
				goto yy3323;
		}

yy3570:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3571;

			default:
				goto yy3323;
		}

yy3571:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3572;

			default:
				goto yy3323;
		}

yy3572:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3573;

			default:
				goto yy3323;
		}

yy3573:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3574;

			default:
				goto yy3323;
		}

yy3574:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3575;

			default:
				goto yy3323;
		}

yy3575:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3576;

			default:
				goto yy3323;
		}

yy3576:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3577;

			default:
				goto yy3323;
		}

yy3577:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3578;

			default:
				goto yy3323;
		}

yy3578:
		yych = *++YYCURSOR;
		goto yy3323;
yy3579:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3580;

			default:
				goto yy3323;
		}

yy3580:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3581;

			default:
				goto yy3323;
		}

yy3581:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy3582;

			default:
				goto yy3323;
		}

yy3582:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3583;

			default:
				goto yy3323;
		}

yy3583:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3584;

			default:
				goto yy3323;
		}

yy3584:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3585;

			default:
				goto yy3323;
		}

yy3585:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3586;

			default:
				goto yy3323;
		}

yy3586:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3587;

			default:
				goto yy3323;
		}

yy3587:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3588;

			default:
				goto yy3323;
		}

yy3588:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3589;

			default:
				goto yy3323;
		}

yy3589:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3590;

			default:
				goto yy3323;
		}

yy3590:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3591;

			default:
				goto yy3323;
		}

yy3591:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3592;

			default:
				goto yy3323;
		}

yy3592:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3593;

			default:
				goto yy3323;
		}

yy3593:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy3594;

			default:
				goto yy3323;
		}

yy3594:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3595;

			case '\r':
				goto yy3597;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3600;

			case '>':
				goto yy3599;

			default:
				goto yy37;
		}

yy3595:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3595;

			case '\r':
				goto yy3597;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3600;

			case '>':
				goto yy3311;

			default:
				goto yy36;
		}

yy3597:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3595;

			case '\r':
				goto yy3597;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3600;

			case '>':
				goto yy3311;

			default:
				goto yy36;
		}

yy3599:
		yych = *++YYCURSOR;
		goto yy3193;
yy3600:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3602;

			case '\r':
				goto yy3604;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3600;

			case '/':
				goto yy38;

			case '=':
				goto yy3606;

			case '>':
				goto yy3599;

			default:
				goto yy36;
		}

yy3602:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3602;

			case '\r':
				goto yy3604;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3600;

			case '=':
				goto yy3606;

			case '>':
				goto yy3599;

			default:
				goto yy36;
		}

yy3604:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3602;

			case '\r':
				goto yy3604;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3600;

			case '=':
				goto yy3606;

			case '>':
				goto yy3599;

			default:
				goto yy36;
		}

yy3606:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3606;

			case '\r':
				goto yy3608;

			case '"':
				goto yy3610;

			case '\'':
				goto yy3612;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3608:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3606;

			case '\r':
				goto yy3608;

			case '"':
				goto yy3610;

			case '\'':
				goto yy3612;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3610:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3615;

			case '/':
				goto yy3642;

			case '>':
				goto yy3641;

			default:
				goto yy3610;
		}

yy3612:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3615;

			case '/':
				goto yy3617;

			case '>':
				goto yy3614;

			default:
				goto yy3612;
		}

yy3614:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy3623;
yy3615:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3615;

			case '\r':
				goto yy3639;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3600;

			case '>':
				goto yy3599;

			default:
				goto yy36;
		}

yy3617:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3615;

			case '/':
				goto yy3617;

			case '>':
				goto yy3619;

			default:
				goto yy3612;
		}

yy3619:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy3623;
yy3620:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3620;

			case '\r':
				goto yy3624;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3627;

			case '>':
				goto yy3626;

			default:
				goto yy9;
		}

yy3622:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3623:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3620;

			default:
				goto yy3622;
		}

yy3624:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3620;

			case '\r':
				goto yy3624;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3627;

			case '>':
				goto yy3626;

			default:
				goto yy9;
		}

yy3626:
		yych = *++YYCURSOR;
		goto yy3193;
yy3627:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3629;

			case '\r':
				goto yy3631;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3627;

			case '=':
				goto yy3633;

			case '>':
				goto yy3626;

			default:
				goto yy9;
		}

yy3629:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3629;

			case '\r':
				goto yy3631;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3627;

			case '=':
				goto yy3633;

			case '>':
				goto yy3626;

			default:
				goto yy9;
		}

yy3631:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3629;

			case '\r':
				goto yy3631;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3627;

			case '=':
				goto yy3633;

			case '>':
				goto yy3626;

			default:
				goto yy9;
		}

yy3633:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3633;

			case '\r':
				goto yy3635;

			case '"':
				goto yy3637;

			case '\'':
				goto yy3622;

			default:
				goto yy9;
		}

yy3635:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3633;

			case '\r':
				goto yy3635;

			case '"':
				goto yy3637;

			case '\'':
				goto yy3622;

			default:
				goto yy9;
		}

yy3637:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3638:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3620;

			default:
				goto yy3637;
		}

yy3639:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3615;

			case '\r':
				goto yy3639;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3600;

			case '>':
				goto yy3599;

			default:
				goto yy36;
		}

yy3641:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy3638;
yy3642:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3615;

			case '/':
				goto yy3642;

			case '>':
				goto yy3644;

			default:
				goto yy3610;
		}

yy3644:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy3638;
yy3645:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3646;

			default:
				goto yy3213;
		}

yy3646:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3647;

			default:
				goto yy3213;
		}

yy3647:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy3648;

			default:
				goto yy3213;
		}

yy3648:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3649;

			default:
				goto yy3213;
		}

yy3649:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3650;

			default:
				goto yy3213;
		}

yy3650:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3651;

			default:
				goto yy3213;
		}

yy3651:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3652;

			default:
				goto yy3213;
		}

yy3652:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3653;

			default:
				goto yy3213;
		}

yy3653:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3654;

			default:
				goto yy3213;
		}

yy3654:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3655;

			default:
				goto yy3213;
		}

yy3655:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3656;

			default:
				goto yy3213;
		}

yy3656:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3657;

			default:
				goto yy3213;
		}

yy3657:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3658;

			default:
				goto yy3213;
		}

yy3658:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3659;

			default:
				goto yy3213;
		}

yy3659:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy3660;

			default:
				goto yy3213;
		}

yy3660:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3661;

			case '\r':
				goto yy3663;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3378;

			case '>':
				goto yy3377;

			case 'T':
			case 't':
				goto yy3665;

			default:
				goto yy37;
		}

yy3661:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3661;

			case '\r':
				goto yy3663;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3378;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3665;

			default:
				goto yy36;
		}

yy3663:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3661;

			case '\r':
				goto yy3663;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3378;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3665;

			default:
				goto yy36;
		}

yy3665:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3380;

			case '\r':
				goto yy3382;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3378;

			case '=':
				goto yy3384;

			case '>':
				goto yy3377;

			case 'E':
			case 'e':
				goto yy3666;

			default:
				goto yy37;
		}

yy3666:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3380;

			case '\r':
				goto yy3382;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy3378;

			case '=':
				goto yy3384;

			case '>':
				goto yy3377;

			case 'X':
			case 'x':
				goto yy3667;

			default:
				goto yy37;
		}

yy3667:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3380;

			case '\r':
				goto yy3382;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3378;

			case '=':
				goto yy3384;

			case '>':
				goto yy3377;

			case 'T':
			case 't':
				goto yy3668;

			default:
				goto yy37;
		}

yy3668:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3669;

			case '\r':
				goto yy3671;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3378;

			case '=':
				goto yy3673;

			case '>':
				goto yy3377;

			default:
				goto yy37;
		}

yy3669:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3669;

			case '\r':
				goto yy3671;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3378;

			case '=':
				goto yy3673;

			case '>':
				goto yy3377;

			default:
				goto yy36;
		}

yy3671:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3669;

			case '\r':
				goto yy3671;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3378;

			case '=':
				goto yy3673;

			case '>':
				goto yy3377;

			default:
				goto yy36;
		}

yy3673:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3673;

			case '\r':
				goto yy3675;

			case '"':
				goto yy3677;

			case '\'':
				goto yy3390;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3675:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3673;

			case '\r':
				goto yy3675;

			case '"':
				goto yy3677;

			case '\'':
				goto yy3390;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3677:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3678;

			default:
				goto yy3389;
		}

yy3678:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3679;

			default:
				goto yy3389;
		}

yy3679:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3680;

			default:
				goto yy3389;
		}

yy3680:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3681;

			default:
				goto yy3389;
		}

yy3681:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3682;

			default:
				goto yy3389;
		}

yy3682:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3683;

			default:
				goto yy3389;
		}

yy3683:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3684;

			default:
				goto yy3389;
		}

yy3684:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3685;

			default:
				goto yy3389;
		}

yy3685:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3686;

			case 'P':
			case 'p':
				goto yy3687;

			default:
				goto yy3389;
		}

yy3686:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3708;

			default:
				goto yy3389;
		}

yy3687:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy3688;

			default:
				goto yy3389;
		}

yy3688:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3689;

			default:
				goto yy3389;
		}

yy3689:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3690;

			default:
				goto yy3389;
		}

yy3690:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3691;

			default:
				goto yy3389;
		}

yy3691:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy3692;

			default:
				goto yy3389;
		}

yy3692:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3693;

			default:
				goto yy3389;
		}

yy3693:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3694;

			default:
				goto yy3389;
		}

yy3694:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3695;

			default:
				goto yy3389;
		}

yy3695:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3696;

			default:
				goto yy3389;
		}

yy3696:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3697;

			default:
				goto yy3389;
		}

yy3697:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3698;

			default:
				goto yy3389;
		}

yy3698:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3699;

			default:
				goto yy3389;
		}

yy3699:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3700;

			default:
				goto yy3389;
		}

yy3700:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3701;

			default:
				goto yy3389;
		}

yy3701:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3702;

			default:
				goto yy3389;
		}

yy3702:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy3703;

			default:
				goto yy3389;
		}

yy3703:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3704;

			case '\r':
				goto yy3706;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3600;

			case '>':
				goto yy3599;

			default:
				goto yy37;
		}

yy3704:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3704;

			case '\r':
				goto yy3706;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3600;

			case '>':
				goto yy3377;

			default:
				goto yy36;
		}

yy3706:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3704;

			case '\r':
				goto yy3706;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3600;

			case '>':
				goto yy3377;

			default:
				goto yy36;
		}

yy3708:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3709;

			default:
				goto yy3389;
		}

yy3709:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3710;

			default:
				goto yy3389;
		}

yy3710:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy3711;

			default:
				goto yy3389;
		}

yy3711:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3712;

			default:
				goto yy3389;
		}

yy3712:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3713;

			default:
				goto yy3389;
		}

yy3713:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3714;

			default:
				goto yy3389;
		}

yy3714:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3715;

			default:
				goto yy3389;
		}

yy3715:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3716;

			default:
				goto yy3389;
		}

yy3716:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3717;

			default:
				goto yy3389;
		}

yy3717:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3718;

			default:
				goto yy3389;
		}

yy3718:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3719;

			default:
				goto yy3389;
		}

yy3719:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3720;

			default:
				goto yy3389;
		}

yy3720:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3721;

			default:
				goto yy3389;
		}

yy3721:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3722;

			default:
				goto yy3389;
		}

yy3722:
		yych = *++YYCURSOR;
		goto yy3389;
yy3723:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3204;

			case '\r':
				goto yy3206;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3198;

			case '=':
				goto yy3208;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3724;

			default:
				goto yy37;
		}

yy3724:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3725;

			case '\r':
				goto yy3727;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3198;

			case '=':
				goto yy3729;

			case '>':
				goto yy3192;

			case 'E':
			case 'e':
				goto yy3499;

			case 'T':
			case 't':
				goto yy3202;

			default:
				goto yy37;
		}

yy3725:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3725;

			case '\r':
				goto yy3727;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '=':
				goto yy3729;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3225;

			default:
				goto yy36;
		}

yy3727:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3725;

			case '\r':
				goto yy3727;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3223;

			case '=':
				goto yy3729;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3225;

			default:
				goto yy36;
		}

yy3729:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3729;

			case '\r':
				goto yy3731;

			case '"':
				goto yy3733;

			case '\'':
				goto yy3214;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3731:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3729;

			case '\r':
				goto yy3731;

			case '"':
				goto yy3733;

			case '\'':
				goto yy3214;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3733:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3734;

			default:
				goto yy3213;
		}

yy3734:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3735;

			default:
				goto yy3213;
		}

yy3735:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3736;

			default:
				goto yy3213;
		}

yy3736:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3737;

			default:
				goto yy3213;
		}

yy3737:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3738;

			default:
				goto yy3213;
		}

yy3738:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3739;

			default:
				goto yy3213;
		}

yy3739:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3740;

			default:
				goto yy3213;
		}

yy3740:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3741;

			default:
				goto yy3213;
		}

yy3741:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3742;

			case 'P':
			case 'p':
				goto yy3743;

			default:
				goto yy3213;
		}

yy3742:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3914;

			default:
				goto yy3213;
		}

yy3743:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy3744;

			default:
				goto yy3213;
		}

yy3744:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3745;

			default:
				goto yy3213;
		}

yy3745:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3746;

			default:
				goto yy3213;
		}

yy3746:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3747;

			default:
				goto yy3213;
		}

yy3747:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy3748;

			default:
				goto yy3213;
		}

yy3748:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3749;

			default:
				goto yy3213;
		}

yy3749:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3750;

			default:
				goto yy3213;
		}

yy3750:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3751;

			default:
				goto yy3213;
		}

yy3751:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3752;

			default:
				goto yy3213;
		}

yy3752:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3753;

			default:
				goto yy3213;
		}

yy3753:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3754;

			default:
				goto yy3213;
		}

yy3754:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3755;

			default:
				goto yy3213;
		}

yy3755:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3756;

			default:
				goto yy3213;
		}

yy3756:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3757;

			default:
				goto yy3213;
		}

yy3757:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3758;

			default:
				goto yy3213;
		}

yy3758:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy3759;

			default:
				goto yy3213;
		}

yy3759:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3760;

			case '\r':
				goto yy3762;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3765;

			case '>':
				goto yy3764;

			case 'T':
			case 't':
				goto yy3767;

			default:
				goto yy37;
		}

yy3760:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3760;

			case '\r':
				goto yy3762;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3765;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3767;

			default:
				goto yy36;
		}

yy3762:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3760;

			case '\r':
				goto yy3762;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3765;

			case '>':
				goto yy3192;

			case 'T':
			case 't':
				goto yy3767;

			default:
				goto yy36;
		}

yy3764:
		yych = *++YYCURSOR;
		goto yy3193;
yy3765:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3768;

			case '\r':
				goto yy3770;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3765;

			case '/':
				goto yy38;

			case '=':
				goto yy3772;

			case '>':
				goto yy3764;

			default:
				goto yy36;
		}

yy3767:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3768;

			case '\r':
				goto yy3770;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3765;

			case '=':
				goto yy3772;

			case '>':
				goto yy3764;

			case 'E':
			case 'e':
				goto yy3774;

			default:
				goto yy37;
		}

yy3768:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3768;

			case '\r':
				goto yy3770;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3765;

			case '=':
				goto yy3772;

			case '>':
				goto yy3764;

			default:
				goto yy36;
		}

yy3770:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3768;

			case '\r':
				goto yy3770;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3765;

			case '=':
				goto yy3772;

			case '>':
				goto yy3764;

			default:
				goto yy36;
		}

yy3772:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3772;

			case '\r':
				goto yy3912;

			case '"':
				goto yy3815;

			case '\'':
				goto yy3786;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3774:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3768;

			case '\r':
				goto yy3770;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'y':
			case 'z':
				goto yy3765;

			case '=':
				goto yy3772;

			case '>':
				goto yy3764;

			case 'X':
			case 'x':
				goto yy3775;

			default:
				goto yy37;
		}

yy3775:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3768;

			case '\r':
				goto yy3770;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3765;

			case '=':
				goto yy3772;

			case '>':
				goto yy3764;

			case 'T':
			case 't':
				goto yy3776;

			default:
				goto yy37;
		}

yy3776:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3777;

			case '\r':
				goto yy3779;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3765;

			case '=':
				goto yy3781;

			case '>':
				goto yy3764;

			default:
				goto yy37;
		}

yy3777:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3777;

			case '\r':
				goto yy3779;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3765;

			case '=':
				goto yy3781;

			case '>':
				goto yy3764;

			default:
				goto yy36;
		}

yy3779:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3777;

			case '\r':
				goto yy3779;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3765;

			case '=':
				goto yy3781;

			case '>':
				goto yy3764;

			default:
				goto yy36;
		}

yy3781:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3781;

			case '\r':
				goto yy3783;

			case '"':
				goto yy3785;

			case '\'':
				goto yy3786;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3783:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3781;

			case '\r':
				goto yy3783;

			case '"':
				goto yy3785;

			case '\'':
				goto yy3786;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3785:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3817;

			default:
				goto yy3816;
		}

yy3786:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3791;

			case '/':
				goto yy3788;

			case '>':
				goto yy3790;

			default:
				goto yy3786;
		}

yy3788:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3791;

			case '/':
				goto yy3788;

			case '>':
				goto yy3814;

			default:
				goto yy3786;
		}

yy3790:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy3798;
yy3791:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3791;

			case '\r':
				goto yy3793;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3765;

			case '>':
				goto yy3764;

			default:
				goto yy36;
		}

yy3793:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3791;

			case '\r':
				goto yy3793;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3765;

			case '>':
				goto yy3764;

			default:
				goto yy36;
		}

yy3795:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3795;

			case '\r':
				goto yy3799;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3802;

			case '>':
				goto yy3801;

			default:
				goto yy9;
		}

yy3797:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3798:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3795;

			default:
				goto yy3797;
		}

yy3799:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3795;

			case '\r':
				goto yy3799;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3802;

			case '>':
				goto yy3801;

			default:
				goto yy9;
		}

yy3801:
		yych = *++YYCURSOR;
		goto yy3193;
yy3802:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3804;

			case '\r':
				goto yy3806;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3802;

			case '=':
				goto yy3808;

			case '>':
				goto yy3801;

			default:
				goto yy9;
		}

yy3804:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3804;

			case '\r':
				goto yy3806;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3802;

			case '=':
				goto yy3808;

			case '>':
				goto yy3801;

			default:
				goto yy9;
		}

yy3806:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3804;

			case '\r':
				goto yy3806;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3802;

			case '=':
				goto yy3808;

			case '>':
				goto yy3801;

			default:
				goto yy9;
		}

yy3808:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3808;

			case '\r':
				goto yy3810;

			case '"':
				goto yy3812;

			case '\'':
				goto yy3797;

			default:
				goto yy9;
		}

yy3810:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3808;

			case '\r':
				goto yy3810;

			case '"':
				goto yy3812;

			case '\'':
				goto yy3797;

			default:
				goto yy9;
		}

yy3812:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3813:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3795;

			default:
				goto yy3812;
		}

yy3814:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy3798;
yy3815:
		++YYCURSOR;
		yych = *YYCURSOR;
yy3816:

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3791;

			case '/':
				goto yy3818;

			case '>':
				goto yy3820;

			default:
				goto yy3815;
		}

yy3817:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3822;

			default:
				goto yy3816;
		}

yy3818:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3791;

			case '/':
				goto yy3818;

			case '>':
				goto yy3821;

			default:
				goto yy3815;
		}

yy3820:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy3813;
yy3821:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy43;
		}

		goto yy3813;
yy3822:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3823;

			default:
				goto yy3816;
		}

yy3823:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3824;

			default:
				goto yy3816;
		}

yy3824:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3825;

			default:
				goto yy3816;
		}

yy3825:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'G':
			case 'g':
				goto yy3826;

			default:
				goto yy3816;
		}

yy3826:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3827;

			default:
				goto yy3816;
		}

yy3827:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3828;

			default:
				goto yy3816;
		}

yy3828:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3829;

			case 'P':
			case 'p':
				goto yy3830;

			default:
				goto yy3816;
		}

yy3829:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3846;

			default:
				goto yy3816;
		}

yy3830:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'R':
			case 'r':
				goto yy3831;

			default:
				goto yy3816;
		}

yy3831:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3832;

			default:
				goto yy3816;
		}

yy3832:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3833;

			default:
				goto yy3816;
		}

yy3833:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'M':
			case 'm':
				goto yy3834;

			default:
				goto yy3816;
		}

yy3834:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'B':
			case 'b':
				goto yy3835;

			default:
				goto yy3816;
		}

yy3835:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3836;

			default:
				goto yy3816;
		}

yy3836:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'E':
			case 'e':
				goto yy3837;

			default:
				goto yy3816;
		}

yy3837:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3838;

			default:
				goto yy3816;
		}

yy3838:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3839;

			default:
				goto yy3816;
		}

yy3839:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3840;

			default:
				goto yy3816;
		}

yy3840:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3841;

			default:
				goto yy3816;
		}

yy3841:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3842;

			default:
				goto yy3816;
		}

yy3842:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3843;

			default:
				goto yy3816;
		}

yy3843:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3844;

			default:
				goto yy3816;
		}

yy3844:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3845;

			default:
				goto yy3816;
		}

yy3845:
		yych = *++YYCURSOR;
		goto yy3816;
yy3846:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3847;

			default:
				goto yy3816;
		}

yy3847:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3848;

			default:
				goto yy3816;
		}

yy3848:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'D':
			case 'd':
				goto yy3849;

			default:
				goto yy3816;
		}

yy3849:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3850;

			default:
				goto yy3816;
		}

yy3850:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3851;

			default:
				goto yy3816;
		}

yy3851:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'A':
			case 'a':
				goto yy3852;

			default:
				goto yy3816;
		}

yy3852:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3853;

			default:
				goto yy3816;
		}

yy3853:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3854;

			default:
				goto yy3816;
		}

yy3854:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3855;

			default:
				goto yy3816;
		}

yy3855:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3856;

			default:
				goto yy3816;
		}

yy3856:
		yych = *++YYCURSOR;

		switch (yych) {
			case '&':
				goto yy3857;

			default:
				goto yy3816;
		}

yy3857:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'L':
			case 'l':
				goto yy3858;

			default:
				goto yy3816;
		}

yy3858:
		yych = *++YYCURSOR;

		switch (yych) {
			case 'T':
			case 't':
				goto yy3859;

			default:
				goto yy3816;
		}

yy3859:
		yych = *++YYCURSOR;

		switch (yych) {
			case ';':
				goto yy3860;

			default:
				goto yy3816;
		}

yy3860:
		yych = *++YYCURSOR;

		switch (yych) {
			case '"':
				goto yy3861;

			default:
				goto yy3816;
		}

yy3861:
		yych = *++YYCURSOR;

		switch (yych) {
			case '\t':
			case '\n':
			case ' ':
				goto yy3863;

			case '\r':
				goto yy3865;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3867;

			case '>':
				goto yy3862;

			default:
				goto yy37;
		}

yy3862:
		yych = *++YYCURSOR;
		goto yy3193;
yy3863:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3863;

			case '\r':
				goto yy3865;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3867;

			case '>':
				goto yy3764;

			default:
				goto yy36;
		}

yy3865:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3863;

			case '\r':
				goto yy3865;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3867;

			case '>':
				goto yy3764;

			default:
				goto yy36;
		}

yy3867:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3869;

			case '\r':
				goto yy3871;

			case '-':
			case '.':
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3867;

			case '/':
				goto yy38;

			case '=':
				goto yy3873;

			case '>':
				goto yy3862;

			default:
				goto yy36;
		}

yy3869:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3869;

			case '\r':
				goto yy3871;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3867;

			case '=':
				goto yy3873;

			case '>':
				goto yy3862;

			default:
				goto yy36;
		}

yy3871:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3869;

			case '\r':
				goto yy3871;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3867;

			case '=':
				goto yy3873;

			case '>':
				goto yy3862;

			default:
				goto yy36;
		}

yy3873:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3873;

			case '\r':
				goto yy3875;

			case '"':
				goto yy3877;

			case '\'':
				goto yy3879;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3875:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3873;

			case '\r':
				goto yy3875;

			case '"':
				goto yy3877;

			case '\'':
				goto yy3879;

			case '/':
				goto yy38;

			case '>':
				goto yy40;

			default:
				goto yy36;
		}

yy3877:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '"':
				goto yy3884;

			case '/':
				goto yy3908;

			case '>':
				goto yy3910;

			default:
				goto yy3877;
		}

yy3879:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3884;

			case '/':
				goto yy3881;

			case '>':
				goto yy3883;

			default:
				goto yy3879;
		}

yy3881:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\'':
				goto yy3884;

			case '/':
				goto yy3881;

			case '>':
				goto yy3907;

			default:
				goto yy3879;
		}

yy3883:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);

		if (yych <= 0x00) {
			goto yy41;
		}

		goto yy3891;
yy3884:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3884;

			case '\r':
				goto yy3886;

			case '/':
				goto yy38;

			case ':':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':
				goto yy3867;

			case '>':
				goto yy3862;

			default:
				goto yy36;
		}

yy3886:
		++YYCURSOR;
		yych = *YYCURSOR;

		switch (yych) {
			case 0x00:
				goto yy9;

			case '\t':
			case '\n':
			case ' ':
				goto yy3884;

			case '\r':
				go