<?PHP // functions.php

function print_heading($text="", $image="", $imagelink="", $imagetitle="", $target="") {
    echo "<TABLE CELLPADDING=0 CELLSPACING=0 WIDTH=100%><TR>";
    echo "<TD><FONT SIZE=3><B>$text</B></FONT></TD>\n";
    if ($image) {
        echo "<TD><A ";
        if ($target) {
            echo "TARGET=\"$target\" ";
        }
        echo "TITLE=\"$imagetitle\" HREF=\"$imagelink\"><IMG ALIGN=RIGHT BORDER=0 SRC=\"$image\"></A></TD>";
    }
    echo "</TR></TABLE><HR>";
}

function print_header($meta="") {
    global $bgcolor, $textcolor, $linkcolor, $vlinkcolor;
    global $USERNAME, $sitename;

    echo "<HTML>\n";
    echo "<HEAD>\n";
    echo "<TITLE>$sitename: $USERNAME</TITLE>";
    echo "<link REL=stylesheet HREF=styles.css>\n";
    echo "$meta";
    echo "</HEAD>\n";
    echo "<BODY BGCOLOR=\"$bgcolor\" TEXT=\"$textcolor\" LINK=\"$linkcolor\" VLINK=\"$vlinkcolor\">\n";
}

function print_rating ($current, $mode, $album, $track="") {
   $common = "tracks.php?mode=$mode&album=$album&track=$track&rate=";

   $options = array ("SUPERB", "GOOD", "NEUTRAL", "BAD", "AWFUL", "UNHEARD");

   $name = "a".$album."t".$track;

   echo "<FORM NAME=\"$name\" TARGET=\"mp3tracks\">";
   echo "<SELECT NAME=popup TARGET=mp3tracks onChange=\"window.location=document.$name.popup.options[document.$name.popup.selectedIndex].value\">\n";
   foreach ($options as $value) {
      echo "   <OPTION VALUE=\"$common$value\"";
      if ($value == $current) {
         echo " SELECTED";
      }
      echo ">$value</OPTION>\n";
   }
   echo "</SELECT></FORM>";
}


/////////////////////////////////////////////////////////////////////////
// mserv functions, adapted from mp3kd by Kai Duebbert <kai@duebbert.de>
/////////////////////////////////////////////////////////////////////////

function unqueue( $album, $track ) {
	$result_array = mserv( "unqueue $album $track" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		/* Success */
		case "254":
			$i = 0;
			$result = array(
				"MESSAGE" => $result_array[++$i],
				"ALBUM_NO" => $result_array[++$i],
				"SONG_NO" => $result_array[++$i],
				"ARTIST" => $result_array[++$i],
				"SONG" => $result_array[++$i]
			);
			break;
		/* Error message */
		case "409":
		case "503":
			$result = array(
				"MESSAGE" => $result_array[1],
			);
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function unqueue: " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}


function queue( $album="", $track="" ) {
	$result_array = mserv( "queue $album $track" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		/* Success */
		case "247":
			$result = array(
				"MESSAGE" => $result_array[1],
			);
			$i = 2;
			while ( $i < count( $result_array )-1 ) {
				$result[] = array(
					"USER" => $result_array[$i++],
					"ALBUM_NO" => $result_array[$i++],
					"SONG_NO" => $result_array[$i++],
					"ARTIST" => $result_array[$i++],
					"SONG" => $result_array[$i++],
					"RATING" => $result_array[$i++]
				);
			}
			break;
		/* Can't add to queue */
		case "510":
		/* No files in queue */
		case "404":
			$result = array(
				"MESSAGE" => $result_array[1],
			);
			break;
		/* List queue */
		case "225":
			$result = array(
				"MESSAGE" => $result_array[1],
			);
			$i = 2;
            $queuecount=0;
			while ( $i < count( $result_array )-1 ) {
				$result[$queuecount] = array(
					"USER" => $result_array[$i++],
					"ALBUM_NO" => $result_array[$i++],
					"TRACK_NO" => $result_array[$i++],
					"ARTIST" => $result_array[$i++],
					"TRACK" => $result_array[$i++],
					"RATING" => $result_array[$i++],
					"LENGTH" => $result_array[$i++]
				);
                $queuecount++;
			}
            $result["QUEUECOUNT"] = $queuecount;
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function queue: " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}

function top() {
	$result_array = mserv( "top" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		/* Success */
		case "234":
			$result = array(
				"MESSAGE" => $result_array[1],
			);
			$i = 2;
            $topcount=0;
			while ( $i < count( $result_array )-1 ) {
				$result[$topcount] = array(
					"PROB" => $result_array[$i++],
					"ALBUM_NO" => $result_array[$i++],
					"TRACK_NO" => $result_array[$i++],
					"ARTIST" => $result_array[$i++],
					"TRACK" => $result_array[$i++],
					"RATING" => $result_array[$i++],
					"LENGTH" => $result_array[$i++]
				);
                $topcount++;
			}
            $result["TOPCOUNT"] = $topcount;
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function queue: " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}

function history() {
	$result_array = mserv( "history" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		/* Success */
		case "241":
			$result = array(
				"MESSAGE" => $result_array[1],
			);
			$i = 2;
            $historycount=0;
			while ( $i < count( $result_array )-1 ) {
				$result[$historycount] = array(
					"USER" => $result_array[$i++],
					"ALBUM_NO" => $result_array[$i++],
					"TRACK_NO" => $result_array[$i++],
					"ARTIST" => $result_array[$i++],
					"TRACK" => $result_array[$i++],
					"RATING" => $result_array[$i++]
				);
                $historycount++;
			}
            $result["HISTORYCOUNT"] = $historycount;
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function queue: " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}


function search( $query ) {
error_log("===[DEBUG]===: $query");
	$result_array = mserv( "search $query" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		/* Success */
		case "243":
			$result = array(
				"MESSAGE" => $result_array[1],
			);
			$i = 2;
            $searchcount=0;
			while ( $i < count( $result_array )-1 ) {
				$result[$searchcount] = array(
					"ALBUM_NO" => $result_array[$i++],
					"TRACK_NO" => $result_array[$i++],
					"ARTIST" => $result_array[$i++],
					"TRACK" => $result_array[$i++],
					"RATING" => $result_array[$i++],
					"LENGTH" => $result_array[$i++]
				);
                $searchcount++;
			}
			break;
		/* Nothing found. */
		case "520":
			$result = array(
				"MESSAGE" => $result_array[1]
			);
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function search: " . $result_array[count($result_array)-1]);
			break;
	}
	$result["SEARCHCOUNT"] = $searchcount;
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}


function next_track() {
	$result_array = mserv( "next" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		/* Success */
		case "240":
			$result = array(
				"MESSAGE" => $result_array[1],
				"ALBUM_NO" => $result_array[2],
				"TRACK_NO" => $result_array[3],
				"ARTIST" => $result_array[4],
				"TITLE" => $result_array[5]
			);
			break;
		/* No more songs to be played. */
		case "403":
			global $playing;
			$playing = false;
			$result = array(
				"MESSAGE" => $result_array[1]
			);
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function next_track: " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}


function status() {
	$result_array = mserv( "status" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		/* Playing a song */
		case "222":
			$result = array(
				"FILTER" => $result_array[2],
				"TRACK_INCLUDE" => $result_array[3],
				"TRACK_EXCLUDE" => $result_array[4],
				"ALBUM_NO" => $result_array[5],
				"TRACK_NO" => $result_array[6],
				"ARTIST" => $result_array[7],
				"TITLE" => $result_array[8],
				"DATE" => $result_array[9],
				"CURRENT_POS" => $result_array[10],
				"RANDOM" => $result_array[11],
				"RANDOM_WEIGHT" => $result_array[12]
			);
			global $playing;
			$playing = true;
			break;
		/* Pausing a song */
		case "223":
			$result = array(
				"FILTER" => $result_array[2],
				"TRACK_INCLUDE" => $result_array[3],
				"TRACK_EXCLUDE" => $result_array[4],
				"ALBUM_NO" => $result_array[5],
				"TRACK_NO" => $result_array[6],
				"ARTIST" => $result_array[7],
				"TITLE" => $result_array[8],
				"DATE" => $result_array[9],
				"CURRENT_POS" => $result_array[10],
				"RANDOM" => $result_array[11],
				"RANDOM_WEIGHT" => $result_array[12]
			);
			global $pausing;
			$pausing = true;
			break;
		/* Nothing playing */
		case "224":
			$result = array(
				"FILTER" => $result_array[2],
				"TRACK_INCLUDE" => $result_array[3],
				"TRACK_EXCLUDE" => $result_array[4],
				"RANDOM" => $result_array[5],
				"RANDOM_WEIGHT" => $result_array[6]
			);
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function status: " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}


function filter($filter) {  // Sets filter pattern
	$result_array = mserv( "filter $filter" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		/* Filter set OK */
		case "269":
			$result = array(
				"TRACK_INCLUDE" => $result_array[2],
				"TRACK_EXCLUDE" => $result_array[3]
			);
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function ratings: " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}

function ratings() {  // Gets ratings for the current song
	$result_array = mserv( "ratings" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		/* Rating of a song */
		case "229":
			$result = array(
				"ALBUM_NO" => $result_array[2],
				"SONG_NO" => $result_array[3],
				"ARTIST" => $result_array[4],
				"TITLE" => $result_array[5]
			);
			// TODO: Only first user is evaluated!
			if ( count( $result_array ) > 7 ) {
				$result["USER"] = $result_array[6];
				$result["RATING"] = $result_array[7];
				$result["TIME"] = $result_array[8];
			}
			else
				$result["RATING"] = "NOT RATED";
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function ratings: " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}


function info($album="", $track="") {  // Get information about the song playing.
	$result_array = mserv( "info $album $track" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		/* Info of a song */
		case "246":
			$result = array(
				"ALBUM_NO" => $result_array[2],
				"SONG_NO"  => $result_array[3],
				"ALBUM_ARTIST" => $result_array[4],
				"ALBUM" => $result_array[5],
				"ARTIST" => $result_array[6],
				"TRACK" => $result_array[7],
				"YEAR" => $result_array[8],
				"UNKNOWN3" => $result_array[9], // TODO
				"LAST_PLAYED" => $result_array[10],
				"UNKNOWN1" => $result_array[11], // TODO
				"UNKNOWN2" => $result_array[12], //TODO
				"RATING" => $result_array[13],
				"GENRE" => $result_array[14],
				"FILTER" => $result_array[15],
				"LENGTH" => $result_array[16],
				"COMMENT" => $result_array[17]
			);
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function info: " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}


function albums() {  // Return a list of all albums
	$result_array = mserv( "albums" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		case "227":
            $count = count($result_array);
            $i=2;
            $albumcount = 0;
            while ($i < $count) {
                $albumnum  = $result_array[$i];
                $albumname = $result_array[$i+2];
                $result["$albumnum"] = $albumname;
                $albumcount++;
                $i = $i + 3;
            }
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function info: " . $result_array[count($result_array)-1]);
			break;
	}
	$result["ALBUMCOUNT"] = $albumcount;
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}

function tracks($album) {  // Return a list of all tracks on an album
	$result_array = mserv("tracks $album");
	$status_code = $result_array[0];
	switch( $status_code ) {
		case "228":
            $count = count($result_array) - 1;
            $result["ALBUMNAME"] = $result_array[4];
            $i=5;
            $trackcount = 0;
            while ($i < $count) {
                $track["ALBUM"] = $result_array[$i];
                $track["NUM"] = $result_array[$i+1];
                $track["ARTIST"] = $result_array[$i+2];
                $track["TITLE"] = $result_array[$i+3];
                $track["RATING"] = $result_array[$i+4];
                $track["TIME"] = $result_array[$i+5];
                $result["$trackcount"] = $track;
                $trackcount++;
                $i = $i + 6;
            }
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function info: " . $result_array[count($result_array)-1]);
			break;
	}
	$result["TRACKCOUNT"] = $trackcount;
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}


function play() {	
	$result_array = mserv( "play" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		/* Play a song */
		case "230":
		/* Already playing */
		case "402":
			$result = array(
				"ALBUM_NO" => $result_array[2],
				"TRACK_NO" => $result_array[3],
				"ARTIST" => $result_array[4],
				"TITLE" => $result_array[5]
			);
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function play(): " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}


function volume($volume="") {	
	$result_array = mserv( "volume $volume" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		case "235":   // print volume
			$result["VOLUME"] = $result_array[2];
			break;
		case "255":   // set volume
			$result["VOLUME"] = $result_array[2];
            break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function play(): " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}


function bass($bass="") {	
	$result_array = mserv( "bass $bass" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		case "235":   // print volume
			$result["BASS"] = $result_array[2];
			break;
		case "255":   // set volume
			$result["BASS"] = $result_array[2];
            break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function play(): " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}


function treble($treble="") {	
	$result_array = mserv( "treble $treble" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		case "235":   // print volume
			$result["TREBLE"] = $result_array[2];
			break;
		case "255":   // set volume
			$result["TREBLE"] = $result_array[2];
            break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function play(): " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}


function rate( $album, $track, $state ) {
	$result_array = mserv( "rate $album $track $state" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		case "270":
			$result = array(
				"USER" => $result_array[2],
				"ALBUM_NO" => $result_array[3],
				"TRACK_NO" => $result_array[4],
				"ARTIST" => $result_array[5],
				"TITLE" => $result_array[6],
				"RATING" => $result_array[7]
			);
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function rate(): " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}


function stop() {
	$result_array = mserv( "stop" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		/* Stop playing */
		case "231":
			$result = array(
				"ALBUM_NO" => $result_array[2],
				"SONG_NO" => $result_array[3],
				"ARTIST" => $result_array[4],
				"TITLE" => $result_array[5]
			);
			break;
		/* Stop was pressed, while nothing playing. */
		case "401":
			$result = status();
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function stop(): " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}


function pause() {
	$result_array = mserv( "pause" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		/* Pause playing */
		case "232":
		/* Already paused. */
		case "406":
			global $pausing;
			$result = status();
			$pausing = true;
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function pause(): " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}



function add_genre( $new, $album, $track )
{
	$info = info();
	$old = $info["GENRE"];
	$result_array = mserv( "set genre $album $track $old,$new" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		/* Already paused. */
		case "263":
			$result = status();
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function add_genre(): " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}


function del_genre( $del, $album, $track )
{
	$info = info();
	$old = $info["GENRE"] . ",";
	$genres = ereg_replace( "$del,", "", $old );
	$genres = ereg_replace( ",$", "", $genres );
	$result_array = mserv( "set genre $album $track $genres" );
	$status_code = $result_array[0];
	switch( $status_code ) {
		/* Already paused. */
		case "263":
			$result = status();
			break;
		default:
			error_log("===[ERROR]===: Don't know what to do!? Function add_genre(): " . $result_array[count($result_array)-1]);
			break;
	}
	$result["STATUS"] = $status_code;
	$result["COMPLETE_MESSAGE"] = $result_array[count($result_array)-1];
	return $result;
}


function get_genres() {  // Get all of our genres (playlists!)
	global $playlist_prefix;
	$result_array = mserv( "x genres" );
	return $result_array;
}


function mserv( $cmd ) {
// Executes mservcmd and returns the result in an array.
// Last field of array is the unedited result message.
	global $MSERVCMD;

	$cmd = escapeshellarg( $cmd );
	$result = `$MSERVCMD $cmd`;
    //echo "$MSERVCMD $cmd`";
	$result_array = preg_split( "/[\t\n]/", trim( $result ) );
	$result_array[count($result_array)] = $result;
	return $result_array;
}

