/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#define packMC(hue,sat,bri) ((hue << 8) | (sat << 4) | bri)

#define packRGB(r,g,b) ((r << 8) | (g << 4) | b)

#define unpackMC(c,hue,sat,bri) {\
	hue = ( c >> 8 ) & 0xf;\
	sat = ( c >> 4 ) & 0xf;\
	bri = c & 0xf;\
}

#define unpackRGB(c,r,g,b) {\
	r = ( c >> 8 ) & 0xf;\
	g = ( c >> 4 ) & 0xf;\
	b = c & 0xf;\
}

int mc_to_rgb(int c);
int mc_from_rgb(int c);

#define MCH_RED		0		/*  */
#define MCH_ORANGE	1		/*  */
#define MCH_YELLOW	2		/*  */
#define MCH_YELLOWGREEN	3		/*  */
#define MCH_GREEN	4		/*   */
#define MCH_CYAN	6		/* 忧   */
#define MCH_BLUE	8		/*  */
#define MCH_VIOLET	9		/*  */
#define MCH_MAGENTA	10		/* ֻ */



#define COLOR_RED		packMC(MCH_RED,10,10)
#define COLOR_ORANGE		packMC(MCH_ORANGE,10,10)
#define COLOR_YELLOW		packMC(MCH_YELLOW,10,10)
#define COLOR_GREEN		packMC(MCH_GREEN,10,10)
#define COLOR_BLUE		packMC(MCH_BLUE,10,10)
#define COLOR_VIOLET		packMC(MCH_VIOLET,10,10)
#define COLOR_PINK		packMC(MCH_MAGENTA,10,10)
#define COLOR_ORANGE		packMC(MCH_ORANGE,10,10)
#define COLOR_BROWN		packMC(MCH_ORANGE,5,5)


