/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

/*
 * MGL1 for Win32  version 1.7
 *                                        
 *   Copyright(C) 2000
 *     Satofumi Tanaka (satofumi@po.incl.ne.jp)"
 */

#include <windows.h>

static int show_mouse=0;
const static int same_format=0;
#define MD_PUT_SCANSEGMENT(dst_y,dst_x,src,nbytes)
#define NO_VIRTUAL_CONSOLE
#define MD_PUT_PIXSTREAM2 md_put_pixstream24
#define MD_PUT_PIXSTREAM4 md_put_pixstream24
#define MD_PUT_PIXSTREAM8 md_put_pixstream8
#define MD_PUT_PIXSTREAM16 md_put_pixstream24

static int winNum = 0;

static BOOL sIsGraphOpened=FALSE;
static char szMainClass[] = "MainClass";
static char mgl32_progname[] = "mgl2 for Cygwin";
static HWND hMainWnd;
static HDC hSaveDC;
static HBITMAP hSaveBitmap;
static LPBYTE lpSaveBMP;

static HINSTANCE gHThisInst;
static HINSTANCE gHPreInst;
static LPSTR gLpszArgs;
static int gNWinMode;
static MSG gLpMsg;

static int gArgc;
static char **gArgv;

static int sIsRedraw = 0;
static int sRMinX;
static int sRMaxX;
static int sRMinY;
static int sRMaxY;

static int ctable_r[4096];
static int ctable_g[4096];
static int ctable_b[4096];

struct cygwin_mouse_t {
	int x;
	int y;
	int btn_l;
	int btn_r;
};

static struct cygwin_mouse_t sMouse;
static struct cygwin_mouse_t sMouseSave;


void
cygwin_rec_point(int x, int y)
{
	if (!sIsRedraw) {
		sRMinX = x;
		sRMaxX = x;
		sRMinY = y;
		sRMaxY = y;
		sIsRedraw = 1;
		return;
	}

	if (x < sRMinX) sRMinX = x;
	if (x > sRMaxX) sRMaxX = x;
	if (y < sRMinY) sRMinY = y;
	if (y > sRMaxY) sRMaxY = y;
}

void
CreateArg()
{
	char *buf;
	int i;

	gArgc = 1;
	buf = strtok( gLpszArgs, " " );
	/* ץο */
	while( buf ) {
		gArgc++;
		buf = strtok( NULL, " " );
	}
	/* ץѥݥ󥿤 */
	gArgv = (char **)calloc( gArgc, sizeof(char *) );
	if( gArgc<2 ) return;        /* no option */
	/* ץγ */
	for( i=1; i<gArgc; i++ ) {
		if( !(*gLpszArgs) ) gLpszArgs++;
		gArgv[i] = gLpszArgs;
		while( *gLpszArgs ) gLpszArgs++;
	}
	return;
}

void
FreeArg()
{
	int i;
	for( i=0; i<gArgc; i++ )
		free( gArgv[i] );
}

void
SetupCTable()
{
	int i;
	int r, g, b;

	if(depth != 16)
		return;

	for(i = 0; i < 1024 * 3; i++) {
		unpackRGB(mc_to_rgb(i), r, g, b);
		ctable_r[i] = r << 4;
		ctable_g[i] = g << 4;
		ctable_b[i] = b << 4;
	}
}

/* MglDIBSetup
 * DIB Υåȥå
 */
LPBITMAPINFO
MglDIBSetup(int width, int height)
{
	int i, bitcount, bmpdepth;
	LPBYTE lpBuf;
	LPBITMAPINFO lpDIB;
	RGBQUAD *lpRGB;

	bitcount = GetDeviceCaps(hSaveDC, BITSPIXEL) * GetDeviceCaps(hSaveDC, PLANES);

	switch(bitcount) {
		case 16:
		case 24:
			/* fall through */
		case 32:
			depth = 16;
			bmpdepth = 32;
			break;

		default:
			depth = 8;
			bmpdepth = 8;
			break;
	}

	lpBuf=GlobalAlloc /* ģɣѥ */
		( GPTR, sizeof(BITMAPINFO)+256*sizeof(RGBQUAD) );

	lpDIB=(LPBITMAPINFO)lpBuf; /* ģɣѥʬ */
	lpRGB=(RGBQUAD*)(lpBuf+sizeof(BITMAPINFOHEADER));

	lpDIB->bmiHeader.biSize=sizeof(BITMAPINFOHEADER); /* BITMAPINFO¤ */
	lpDIB->bmiHeader.biWidth = width;
	lpDIB->bmiHeader.biHeight= -1 * height;
	lpDIB->bmiHeader.biPlanes=1;	//GetDeviceCaps(hSaveDC, PLANES);
	lpDIB->bmiHeader.biBitCount=bmpdepth;	//bitcount;
	lpDIB->bmiHeader.biCompression=BI_RGB;
	lpDIB->bmiHeader.biSizeImage=0;
	lpDIB->bmiHeader.biXPelsPerMeter=0;
	lpDIB->bmiHeader.biYPelsPerMeter=0;
	lpDIB->bmiHeader.biClrUsed=0;
	lpDIB->bmiHeader.biClrImportant=0;

	lpDIB->bmiColors[0]=lpRGB[0]; /* 顼ơ֥Ƭ */
	for (i=0;i<256;i++) {
#if 1
		int r, g, b;

		unpackRGB(mc_to_rgb(CONV_FROM_COL192(i)), r, g, b);
		lpRGB[i].rgbRed=r << 4;
		lpRGB[i].rgbGreen=g << 4;
		lpRGB[i].rgbBlue=b << 4;
#else
		lpRGB[i].rgbRed = i;
		lpRGB[i].rgbGreen = i;
		lpRGB[i].rgbBlue = i;
#endif
	}
	return lpDIB;
}


/* WinProc
 * ᥤ󥦥ɥؿ
 */
LRESULT CALLBACK
WinProc(HWND hMWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	HDC hDC;
	PAINTSTRUCT ps;

	switch (msg) {
		case WM_PAINT:
			hDC = BeginPaint( hMWnd, &ps);
			BitBlt( hDC,
				ps.rcPaint.left, ps.rcPaint.top,
				ps.rcPaint.right - ps.rcPaint.left + 1,
				ps.rcPaint.bottom- ps.rcPaint.top + 1,
				hSaveDC,
				ps.rcPaint.left, ps.rcPaint.top,
				SRCCOPY );
			EndPaint( hMWnd, &ps );
			sIsRedraw = 0;
			break;

		case WM_LBUTTONDOWN:
			SetCapture(hMWnd);
			sMouse.btn_l = 1;
			sMouse.x = LOWORD( lParam );
			sMouse.y = HIWORD( lParam );
			break;

		case WM_LBUTTONUP:
			ReleaseCapture();
			sMouse.btn_l = 0;
			sMouse.x = LOWORD( lParam );
			sMouse.y = HIWORD( lParam );
			break;

		case WM_MOUSEMOVE:
			sMouse.x = LOWORD( lParam );
			sMouse.y = HIWORD( lParam );
			break;

		case WM_DESTROY:
			DeleteObject( hSaveBitmap );
			DeleteDC( hSaveDC );
			PostQuitMessage(0);
			break;

		default:
			return(DefWindowProc(hMWnd, msg, wParam, lParam));
	}
	return 0;
}

static int
CreateMGLWindow()
{
	WNDCLASSEX MainWnd;

	SCREEN_WIDTH=640;
	SCREEN_HEIGHT=480;

	if (!gHPreInst) {
		/* MainWindow  */
		MainWnd.lpszClassName	= szMainClass;
		MainWnd.lpfnWndProc	= WinProc;
		MainWnd.hInstance	= gHThisInst;
		MainWnd.style		= 0;
		MainWnd.cbSize		= sizeof(WNDCLASSEX);
		MainWnd.hIcon		= LoadIcon(gHThisInst, "MglIcon");
		MainWnd.hIconSm		= LoadIcon(gHThisInst, "MglIcon");
		MainWnd.hCursor		= LoadCursor(NULL, IDC_ARROW);
		MainWnd.lpszMenuName	= "MglMenu";
		MainWnd.cbClsExtra	= 0;
		MainWnd.cbWndExtra	= 0;
		MainWnd.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		/* MainWindow Ͽ */
		if (!RegisterClassEx(&MainWnd)) return FALSE;
	}
	/* MainWindow  */
	hMainWnd = CreateWindow(
		szMainClass,		/* ɥ饹̾ */
		mgl32_progname,		/* ץ */
		WS_OVERLAPPEDWINDOW,	/*  */
		CW_USEDEFAULT,		/* Xɸ */
		CW_USEDEFAULT,		/* Yɸ */
		SCREEN_WIDTH,		/*  */
		SCREEN_HEIGHT,		/* ⤵ */
		HWND_DESKTOP,		/* ƥɥ */
		NULL,			/* ˥塼 */
		gHThisInst,		/* 󥹥 */
		NULL			/* ɲð */
	);
	/* MainWindow ɽ */
	ShowWindow(hMainWnd, gNWinMode);
	UpdateWindow(hMainWnd);
	return TRUE;
}

int WINAPI
WinMain(HINSTANCE hThisInst, HINSTANCE hPreInst, LPSTR lpszArgs, int nWinMode)
{
	int result;

	gHThisInst = hThisInst;
	gHPreInst = hPreInst;
	gLpszArgs = lpszArgs;
	gNWinMode = nWinMode;
	CreateArg();

	result = mgl_main(gArgc, gArgv);

	FreeArg();
	return result;
}


static void MD_GRAPH_MODE()
{
}

static void MD_TEXT_MODE()
{
}

static int MD_INIT()
{
	HDC hDC;
	RECT rc;
	HBRUSH hBrush;
	PAINTSTRUCT ps;
	LPBITMAPINFO lpDIB;

	printf("md_cygwin init\n");

	CreateMGLWindow();

	/* for Win32 */
	/* DC κ */
	hDC = BeginPaint( hMainWnd, &ps);
	hSaveDC = CreateCompatibleDC( hDC );
	/* hSaveDC  DIBSection  */
	lpDIB = MglDIBSetup( SCREEN_WIDTH, SCREEN_HEIGHT );/* DIB κ */
		hSaveBitmap =
		CreateDIBSection(hDC,lpDIB,DIB_RGB_COLORS,(void **)&lpSaveBMP,NULL,0);
	SelectObject( hSaveDC, hSaveBitmap );
	hBrush = GetStockObject( BLACK_BRUSH );
	SelectObject( hSaveDC, hBrush );
	PatBlt( hSaveDC, 0,0,SCREEN_WIDTH,SCREEN_HEIGHT, PATCOPY );/*  */
	EndPaint( hMainWnd, &ps );
	/* Window κŬ */
	GetWindowRect(hMainWnd, &rc);
	rc.right = rc.left + SCREEN_WIDTH;
	rc.bottom= rc.top  + SCREEN_HEIGHT;
	AdjustWindowRect( &rc, WS_OVERLAPPEDWINDOW, TRUE );
	SetWindowPos( hMainWnd, HWND_TOP,
		0,0,
		rc.right-rc.left, 
		rc.bottom-rc.top,
		SWP_NOMOVE
	);
	/* ץѹ */
	SetWindowText( hMainWnd, mgl32_progname );
	/*  */
	InvalidateRect( hMainWnd, NULL, FALSE );

	rotated = 0;
	sIsGraphOpened = TRUE;

	sMouse.x = 0;
	sMouse.y = 0;
	sMouse.btn_l = 0;
	sMouse.btn_r = 0;
	sMouseSave = sMouse;

	SetupCTable();

	return 0;
}


static void MD_TERM() 
{
	printf("md_term\n");
}


static void  MD_SET_MOUSEXY(int x, int y)
{
}

static int  MD_MOUSE_EVENT()
{
	RECT rect;
	
	rect.left = sRMinX;
	rect.top = sRMinY;
	rect.right = sRMaxX + 1;
	rect.bottom = sRMaxY + 1;
	InvalidateRect( hMainWnd, &rect, FALSE );

	if(GetMessage(&gLpMsg, NULL, 0, 0)) {
		TranslateMessage(&gLpMsg);
		DispatchMessage(&gLpMsg);
	} else {
		exit(1);
	}
	return 1;
}

static int MD_MOUSE_X() {return (sMouse.x);}
static int MD_MOUSE_Y() {return (sMouse.y);}
static int MD_MOUSE_BUTTON() {return (sMouse.btn_l);}

static void md_put_pixstream8(int x,int y,int *buf,int xs,int dir,int op) {
	char *lpbmp;
	int c;

	lpbmp = ((char *) lpSaveBMP) + y * SCREEN_WIDTH + x;
	while(0 < xs--) {
		c = *buf++ & 0x0fff;
		*lpbmp++ = CONV_TO_COL192(c);
		cygwin_rec_point(x++, y);
	}
}

static void md_put_pixstream24(int x,int y,int *buf,int xs,int dir,int op) {
	int *lpbmp;
	int c;

	lpbmp = ((int *) lpSaveBMP) + y * SCREEN_WIDTH + x;
	while(0 < xs--) {
		c = *buf++ & 0x0fff;
		*lpbmp++ = ctable_r[c] << 16 | ctable_g[c] << 8 |  ctable_b[c];
		cygwin_rec_point(x++, y);
	}
}
