/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#include <stdio.h>
#include "mgl2.h"

void set_font(int size,int type) {
	mgl_fe->_set_font(current_screen,size,type);
}

int load_font(char *fname, int width, int height) {
	return mgl_fe->_load_font(fname,width,height);
}

void draw_font(int x, int y, int code, int dir) {
	mgl_fe->_draw_font(current_screen,x,y,code,dir);
}

/* x,y 顢str ʸ褷ޤ
        ) x,y ϡʸκκɸǤ
*/
void draw_string(int x, int y, char *str, int dir) {
	int code;
	int d = 0;
	while (*str) {
		d = 0;
		if (*str & 0x80) {
			if (*(unsigned char *)str == 0x8e) {
				code = (*str++ << 8) & 0xffff;
				code |= *str++ & 0xff;
				mgl_fe->_draw_font(current_screen,x,y,code,dir);
				d = pen_font->width/2;
			}else{
				code = (*str++ << 8) & 0xffff;
				code |= *str++ & 0xff;
				mgl_fe->_draw_font(current_screen,x,y,code,dir);
				d = pen_font->width;
			}
		} else {
			mgl_fe->_draw_font(current_screen,x,y,*str++ & 0xff,dir);
			d += pen_font->width/2;
		}
		switch(dir) {
		case DIR_NORTH:
			x += d;
			break;
		case DIR_WEST:
			y -= d;
			break;
		case DIR_SOUTH:
			x -= d;
			break;
		case DIR_EAST:
			y += d;
		}
	}
	return;
}


void mgl2_set_font(struct screen *s,int size,int type) {
	mgl_fe->_set_font(s,size,type);
}

void mgl2_draw_font(struct screen *s,int x, int y, int code, int dir) {
	mgl_fe->_draw_font(s,x,y,code,dir);
}

void mgl2_draw_string(struct screen *s,int x, int y, char *str, int dir) {
	int code;
	int d = 0;
	while (*str) {
		d = 0;
		if (*str & 0x80) {
			if (*(unsigned char *)str == 0x8e) {
				code = (*str++ << 8) & 0xffff;
				code |= *str++ & 0xff;
				mgl_fe->_draw_font(s,x,y,code,dir);
				d = s->_pen_font.width/2;
			}else{
				code = (*str++ << 8) & 0xffff;
				code |= *str++ & 0xff;
				mgl_fe->_draw_font(s,x,y,code,dir);
				d = s->_pen_font.width;
			}
		} else {
			mgl_fe->_draw_font(s,x,y,*str++ & 0xff,dir);
			d += s->_pen_font.width/2;
		}
		switch(dir) {
		case DIR_NORTH:
			x += d;
			break;
		case DIR_WEST:
			y -= d;
			break;
		case DIR_SOUTH:
			x -= d;
			break;
		case DIR_EAST:
			y += d;
		}
	}
	return;
}

