/* 
pixel 

[0][1][2][3][4][5][6][7]

normal order
             MSB      LSB
p[0]         [3][2][1][0]
p[1]         [7][6][5][4]


reversed order
             MSB      LSB
p[0]         [0][1][2][3]
p[1]         [4][5][6][7]


normal color
	0  -> BALCK  3 -> WHITE
reversed color
	0  -> WHITE  3 -> BLACK
*/

#define ORD2_NORMAL	0
#define ORD2_REVERSE	1
#define COL2_NORMAL	0
#define COL2_REVERSE	1


static char fb2_ctable[256];
static char *fb2_base;
static int fb2_rowbytes;

static fb2_setup_ctable(int revord,int revcol) {
	int x,c;
	int in,out;
	for (in=0; in<256; in++) {
		out = 0;
		for (x=0; x<4; x++) {
			c = (in >> (x*2)) & 0x3;
			if (revcol) c = 3 - c;
			if (revord) {
			    out <<= 2;
			    out |= c;
			} else {
			    out >>= 2;
			    out |= (c << 6);
			}
		}
		fb2_ctable[in] = out;
	}
        return;
}

static fb2_setup(char *base,int rowbytes,int revord,int revcol) {
	fb2_base = base;
	fb2_rowbytes = rowbytes;
	fb2_setup_ctable(revord,revcol);
}

static void fb2_put_pixstream(int x,int y,int *buf,int xs,int dir, int op) {
	char *pcolor;
	int i;
	int c1,c2;
	xs /= 4;
	pcolor = fb2_base + fb2_rowbytes * y + x/4;
	for (i=0; i< xs; i++,pcolor++) {
		c1 = ((buf[0] & 0x0c) >> 2)
		   | ((buf[1] & 0x0c)     )
		   | ((buf[2] & 0x0c) << 2)
		   | ((buf[3] & 0x0c) << 4);
		*pcolor = fb2_ctable[c1] ;
		buf += 4;
	}
}

static inline void fb2_put_scansegment(int dst_y, int dst_x, char* src, int nbytes){
    memcpy(fb2_base + fb2_rowbytes * dst_y + dst_x, src, nbytes);
}
