/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#define get_key_nodelay	em_get_key_nodelay
#define screen_switch	em_screen_switch
#define unget_key	em_unget_key
#define rec_point	em_rec_point
#define rp_wrap		em_rp_wrap
#define vk_cur		em_vk_cur
#define vk_pressed	em_vk_pressed
#define vk_free		em_vk_free
#define vk_root		em_vk_root
#define vkp		em_vkp
#define vk_rev		em_vk_rev
#define bg_screen	em_bg_screen
#define fg_screen	em_fg_screen
#define bgmode		em_bgmode
#define key_buf		em_key_buf
#define key_buf_cnt	em_key_buf_cnt
#define r_rect		em_r_rect
#define r_minx		em_r_minx
#define r_maxx		em_r_maxx
#define r_miny		em_r_miny
#define r_maxy		em_r_maxy
#define create_physical_screen em_create_physical_screen
#define delayed_key mgl_delayed_key
#define dk_limit mgl_dk_limit
#define put_key		em_put_key
#define put_key_delay	em_put_key_delay
#define put_key_xy	em_put_key_xy

extern struct screen *physical_screen;
extern int bgmode;
extern struct screen *bg_screen;
extern struct screen *fg_screen;

extern int im_mode;

extern struct key_buf {
        int code;
        short x,y;
} key_buf[100];
extern int key_buf_cnt;

extern int delayed_key;
extern long long dk_limit;

extern void put_key(int c);
extern void put_key_xy(struct virtual_key *v,int c,int x,int y);

extern struct virtual_key *vk_root,*vk_free;
extern struct virtual_key *vk_cur;
extern struct virtual_key *vkp;
extern int vk_pressed;

extern int vk_search(struct virtual_key *p, int x,int y);

extern int vk_match(struct virtual_key *p,int x,int y);

extern int vk_rev;

extern void vk_reverse(struct virtual_key *p,int mode);
extern void vk_init();

extern int r_rect;
extern int r_minx;
extern int r_maxx;
extern int r_miny;
extern int r_maxy;

extern int (*mgl_calibrate_ctrl)(int,int *,int);

#define MGL_CALIBRATE_GET	1
#define MGL_CALIBRATE_SET	2
#define MGL_CALIBRATE_RESET	3

extern void mgl_add_term_func(void (*func)(),void *arg);
extern void mgl_add_atfork_func(void (*func)(),void *arg);
