/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

struct screen *de_create_memscreen(int xs,int ys,char *bitmap,int op);
struct screen *de_create_subscreen(struct screen *org,int x,int y,int xs,int ys,int opt);
void de_free_screen(struct screen *s);

#define current_screen	mgl_current_screen
#define pen_color	mgl_pen_color

#define cde(name)	self->name

#ifdef MGL_PREFIX
#define create_subscreen		cde(_create_subscreen)
#define free_screen			cde(_free_screen)
#define put_pixel			cde(_put_pixel)
#define get_pixel			cde(_get_pixel)
#define set_color			cde(_set_color)
#define draw_pixel			cde(_draw_pixel)
#define draw_line			cde(_draw_line)
#define draw_line_vertical		cde(_draw_line_vertical)
#define draw_line_horizontal		cde(_draw_line_horizontal)
#define clear_screen			cde(_clear_screen)
#define get_pixstream			cde(_get_pixstream)
#define put_pixstream			cde(_put_pixstream)
#define put_pixstream_rect		cde(_put_pixstream_rect)

#define bitblt				cde(_bitblt)
#define bitblt_scroll_forward		cde(_bitblt_scroll_forward)
#define bitblt_scroll_backward		cde(_bitblt_scroll_backward)
#define bitblt_copy			cde(_bitblt_copy)
#define bitblt_reserved_mask		cde(_bitblt_reserved_mask)
#define bitblt_reserved_masktile	cde(_bitblt_reserved_masktile)

#endif

#define CLIP_POINT(scr,x,y) if ((scr)->need_clipping >= 1) {\
	 if ((x < 0) || (x >= (scr)->width)\
	    || (y < 0) || (y >= (scr)->height)) {\
		return;\
	 }\
}

#if 0
#define CLIP_VLINE(scr,x1,y1,x2,y2) 
#define CLIP_HLINE(scr,x1,y1,x2,y2) 
#define CLIP_PIXSTREAM(scr,x,y,buf,length,dir,x1,y1,x2,y2) 
#define CLIP_BITBLT(dst,dx,dy,src,sx,sy,xsize,ysize) 
#else
#define CLIP_VLINE(scr,x1,y1,x2,y2) if ((scr)->need_clipping >= 1) {\
	if ((x1 < 0) || (x1 >= (scr)->width)) return;\
	if ((y2 < 0) || (y1 >= (scr)->height)) return;\
	if (y1 < 0) y1 = 0;\
	if (y2 >= (scr)->height) y2 = (scr)->height-1;\
}

#define CLIP_HLINE(scr,x1,y1,x2,y2) if ((scr)->need_clipping >= 1) {\
	if ((y1 < 0) || (y1 >= (scr)->height)) return;\
	if ((x2 < 0) || (x1 >= (scr)->width)) return;\
	if (x1 < 0) x1 = 0;\
	if (x2 >= (scr)->width) x2 = (scr)->width-1;\
}

#define CLIP_PIXSTREAM(scr,x,y,buf,length,dir,x1,y1,x2,y2) \
if ((scr)->need_clipping >= 1) {\
	switch(dir & 3) {\
	case DIR_NORTH:\
		x1 = x;\
		y1 = y;\
		x2 = x + length;\
		y2 = y;\
		if ((y1 < 0) || (y1 >= (scr)->height)) return;\
		if ((x2 < 0) || (x1 >= (scr)->width)) return;\
		if (x1 < 0) {\
			buf += -x1;\
			length -= -x1;\
			x2 += x1;\
			x = x1 = 0;\
		}\
		if (x2 >= (scr)->width) {\
			length -= x2 - ((scr)->width-1);\
			x2 = ((scr)->width-1);\
		}\
		if (length <= 0) return;\
		break;\
	case DIR_WEST:\
		x1 = x;\
		y1 = y - length;\
		x2 = x;\
		y2 = y;\
		if ((x1 < 0) || (x1 >= (scr)->width)) return;\
		if ((y2 < 0) || (y1 >= (scr)->height)) return;\
		if (y1 < 0) {\
			length -= -y1;\
			y1 = 0;\
		}\
		if (y2 >= (scr)->height) {\
			buf += y2 - ((scr)->height-1);\
			length -= y2 - ((scr)->height-1);\
			y = y2 = ((scr)->height-1);\
		}\
		if (length <= 0) return;\
		break;\
	case DIR_SOUTH:\
		x1 = x - length;\
		y1 = y;\
		x2 = x;\
		y2 = y;\
		if ((y1 < 0) || (y1 >= (scr)->height)) return;\
		if ((x2 < 0) || (x1 >= (scr)->width)) return;\
		if (x1 < 0) {\
			length -= -x1;\
			x1 = 0;\
		}\
		if (x2 >= (scr)->width) {\
			buf += x2 - ((scr)->width-1);\
			length -= x2 - ((scr)->width-1);\
			x = x2 = ((scr)->width-1);\
		}\
		if (length <= 0) return;\
		break;\
	case DIR_EAST:\
		x1 = x;\
		y1 = y;\
		x2 = x;\
		y2 = y += length;\
		if ((x1 < 0) || (x1 >= (scr)->width)) return;\
		if ((y2 < 0) || (y1 >= (scr)->height)) return;\
		if (y1 < 0) {\
			buf += -y1;\
			length -= -y1;\
			y2 += y1;\
			y = y1 = 0;\
		}\
		if (y2 >= (scr)->height) {\
			length -= y2 - ((scr)->height-1);\
			y2 = ((scr)->height-1);\
		}\
		if (length <= 0) return;\
		break;\
	}\
}

#define CLIP_BITBLT(dst,dx,dy,src,sx,sy,xsize,ysize) \
if ((dst)->need_clipping >= 1) {\
	if (dx >= dst->width) return;\
	if (dy >= dst->height) return;\
	if (dx + xsize < 0) return;\
	if (dy + ysize < 0) return;\
	if (dx < 0) {\
		xsize -= -dx;\
		sx -= dx;\
		dx = 0;\
	}\
	if (dy < 0) {\
		ysize -= dx;\
		sy -= dy;\
		dy = 0;\
	}\
	if (dx + xsize >= dst->width) {\
		xsize = dst->width - dx;\
	}\
	if (dy + ysize >= dst->height) {\
		ysize = dst->height - dy;\
	}\
	if (src->type & ST_RESERVEOP) {\
		op = src->op;\
	}\
	if ((xsize < 0) || (ysize < 0)) return;\
	if (op & BLT_TILING) {\
		while (sx < 0) {\
			sx += src->width-1;\
		}\
		while (sx >= src->width) {\
			sx -= src->width-1;\
		}\
		while (sy < 0) {\
			sy += src->height-1;\
		}\
		while (sy >= src->height) {\
			sy -= src->height-1;\
		}\
	} else {\
		if (sx >= src->width) return;\
		if (sy >= src->height) return;\
		if (sx + xsize < 0) return;\
		if (sy + ysize < 0) return;\
		if (sx < 0) {\
			xsize -= -sx;\
			dx -= sx;\
			sx = 0;\
		}\
		if (sy < 0) {\
			ysize -= sx;\
			dy -= sy;\
			sy = 0;\
		}\
		if (sx + xsize >= src->width) {\
			xsize = src->width - sx;\
		}\
		if (sy + ysize >= src->height) {\
			ysize = src->height - sy;\
		}\
		if ((xsize < 0) || (ysize < 0)) return;\
	}\
}\
if ((src)->need_clipping >= 1) {\
	if (op & BLT_TILING) {\
		while (sx < 0) {\
			sx += src->width-1;\
		}\
		while (sx >= src->width) {\
			sx -= src->width-1;\
		}\
		while (sy < 0) {\
			sy += src->height-1;\
		}\
		while (sy >= src->height) {\
			sy -= src->height-1;\
		}\
	} else {\
		if (sx >= src->width) return;\
		if (sy >= src->height) return;\
		if (sx + xsize < 0) return;\
		if (sy + ysize < 0) return;\
		if (sx < 0) {\
			xsize -= -sx;\
			dx -= sx;\
			sx = 0;\
		}\
		if (sy < 0) {\
			ysize -= sx;\
			dy -= sy;\
			sy = 0;\
		}\
		if (sx + xsize >= src->width) {\
			xsize = src->width - sx;\
		}\
		if (sy + ysize >= src->height) {\
			ysize = src->height - sy;\
		}\
		if ((xsize < 0) || (ysize < 0)) return;\
	}\
}

#endif
