/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

static int
sym_convert(int sym) {
	switch(sym) {

	case 0x02: return MGL_SKM_SHIFT;
	case 0x03: return MGL_SKM_RSHIFT;
	case 0x04: return MGL_SKM_CAPS;
	case 0x05: return MK_NUMLOCK;
	case 0x06: return MKE_SCRLOCK;
	case 0x07: return MGL_SKM_ALT;
	case 0x09: return MGL_SKM_CTRL;
	case 0x80: return MGL_SKM_RCTRL;
	case 0x81: return MGL_SKM_RALT;
	case 0x4b: return MK_HOME;
	case 0x4c: return MK_UP;
	case 0x4d: return MK_PAGE_UP;
	case 0x4e: return MKE_MINUS;
	case 0x4f: return MK_LEFT;
	case 0x50: return MK_DEL;
	case 0x51: return MK_RIGHT;
	case 0x52: return MKE_PLUS;
	case 0x53: return MK_END;
	case 0x54: return MK_DOWN;
	case 0x55: return MK_PAGE_DOWN;
	case 0x56: return MK_INS;

	case 0x1b: return MK_F1;
	case 0x1c: return MK_F2;
	case 0x1d: return MK_F3;
	case 0x1e: return MK_F4;
	case 0x1f: return MK_F5;
	case 0x20: return MK_F6;
	case 0x21: return MK_F7;
	case 0x22: return MK_F8;
	case 0x23: return MK_F9;
	case 0x24: return MK_F10;
	case 0x25: return MK_F11;
	case 0x26: return MK_F12;
	case 0x27: return MKE_F13;
	case 0x28: return MKE_F14;
	case 0x29: return MKE_F15;
	case 0x2a: return MKE_F16;
	case 0x2b: return MKE_F17;
	case 0x2c: return MKE_F18;
	case 0x2d: return MKE_F19;
	case 0x2e: return MKE_F20;
	case 0x2f: return MKE_F21;
	case 0x30: return MKE_F22;
	case 0x31: return MKE_F23;
	case 0x32: return MKE_F24;
	}
	return 0;
}

static int create_keymap() {
	keymap_t map;
	int ret;
	int i,n;
	int sym1,sym2;

	mk_init();

	ret = ioctl(mgl_keyboard_fd, GIO_KEYMAP, &map);
	if (ret < 0) {
		perror("GIO_KEYMAP");
		return (-1);
        }
	n = map.n_keys;
	if (n >128) n = 128;
	
	for (i=0; i<= n; i++) {
		switch (i) {
		case 0:
			sym1 = sym2 = MK_NONE; break;
		case MGL_EXKEY_KANJI:
			sym1 = sym2 = MKE_HENKAN; break;
		case MGL_EXKEY_MUHENKAN:
			sym1 = sym2 = MKE_MUHENKAN; break;
		case MGL_EXKEY_PAUSE:
			sym1 = sym2 = MKE_PAUSE; break;
		case MGL_KEY_MENU:
			sym1 = sym2 = MGL_SKM_MENU; break;
		case MGL_EXKEY_RMENU:
			sym1 = sym2 = MGL_SKM_RMENU; break;
		case MGL_EXKEY_SELECT:
			sym1 = sym2 = MKE_SELECT; break;
		default:
		    if (map.key[i].spcl & 0x80) {
			sym1 = sym_convert(map.key[i].map[0]);
		    } else { /* normal symbol */
			sym1 = map.key[i].map[0];
		    }
		    if (map.key[i].spcl & 0x40) {
			sym2 = sym_convert(map.key[i].map[1]);
		    } else { /* normal symbol */
			sym2 = map.key[i].map[1];
		    }
		}
		if (sym1 == 0) sym1 = MK_NONE;
		if (sym2 == 0) sym2 = MK_NONE;
		mgl_keymap[i][0] = sym1;
		mgl_keymap[i][1] = sym2;
		switch(sym1) {
		case MK_F1: mgl_keymap[i][2] = MKE_CONSOLE_1; break;
		case MK_F2: mgl_keymap[i][2] = MKE_CONSOLE_2; break;
		case MK_F3: mgl_keymap[i][2] = MKE_CONSOLE_3; break;
		case MK_F4: mgl_keymap[i][2] = MKE_CONSOLE_4; break;
		case MK_F5: mgl_keymap[i][2] = MKE_CONSOLE_5; break;
		case MK_F6: mgl_keymap[i][2] = MKE_CONSOLE_6; break;
		case MK_F7: mgl_keymap[i][2] = MKE_CONSOLE_7; break;
		case MK_F8: mgl_keymap[i][2] = MKE_CONSOLE_8; break;
		case MK_F9: mgl_keymap[i][2] = MKE_CONSOLE_9; break;
		case MK_F10: mgl_keymap[i][2] = MKE_CONSOLE_10; break;
		}
	}
#if 0
mk_dump_keymap("xkeymap");
#endif
	mk_create_raw_keymap();
	modify_keymap_for_mglsvr();
#if 0
mk_dump_keymap("mglmap ");
#endif
}
