/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <stdio.h>
#include "mgl2.h"
#include "mglkey.h"

struct key {
	int code, y,x;
	char *ident;
};

struct key keys_jp[] = {
/*   1:   ESC */	{	1,	0,0	,"ESC"},
/*  41:   ZEN_HAN */	{	41,	0,1	,"ZEN"},
/*  59:   F1 */		{	59,	0,2	,"F1 "},
/*  60:   F2 */		{	60,	0,3	,"F2 "},
/*  61:   F3 */		{	61,	0,4	,"F3 "},
/*  62:   F4 */		{	62,	0,5	,"F4 "},
/*  63:   F5 */		{	63,	0,6	,"F5 "},
/*  64:   F6 */		{	64,	0,7	,"F6 "},
/*  65:   F7 */		{	65,	0,8	,"F7 "},
/*  66:   F8 */		{	66,	0,9	,"F8 "},
/*  67:   F9 */		{	67,	0,10	,"F9 "},
/*  69:   F10 */	{	68,	0,11	,"F10"},
/*  96:   PgUp */	{	96,	0,12	,"PgU"},
/* 101:   PgDown */	{	101,	0,13	,"PgD"},
/* 103:   Del */	{	103,	0,14	,"Del"},
/*   2:   1! */		{	2,	1,0	,"1! "},
/*   3:   2" */		{	3,	1,1	,"2\" "},
/*   4:   3# */		{	4,	1,2	,"3# "},
/*   5:   4$ */		{	5,	1,3	,"4$ "},
/*   6:   5% */		{	6,	1,4	,"5% "},
/*   7:   6& */		{	7,	1,5	,"6& "},
/*   8:   7' */		{	8,	1,6	,"7' "},
/*   9:   8( */		{	9,	1,7	,"8( "},
/*  10:   9) */		{	10,	1,8	,"9) "},
/*  11:   0~ */		{	11,	1,9	,"0~ "},
/*  12:   -= */		{	12,	1,10	,"-= "},
/*  13:   ^~ */		{	13,	1,11	,"^~ "},
/* 125:   \| */		{	125,	1,12	,"\\| "},
/*  14:   BS */		{	14,	1,13	,"BS "},
/*  15:   TAB */	{	15,	2,0	,"TAB"},
/*  16:   Q */		{	16,	2,1	," Q "},
/*  17:   W */		{	17,	2,2	," W "},
/*  18:   E */		{	18,	2,3	," E "},
/*  19:   R */		{	19,	2,4	," R "},
/*  20:   T */		{	20,	2,5	," T "},
/*  21:   Y */		{	21,	2,6	," Y "},
/*  22:   U */		{	22,	2,7	," U "},
/*  23:   I */		{	23,	2,8	," I "},
/*  24:   O */		{	24,	2,9	," O "},
/*  25:   P */		{	25,	2,10	," P "},
/*  26:   @` */		{	26,	2,11	,"@` "},
/*  27:   [{ */		{	27,	2,12	," [ "},
/*  28:   ENTER */	{	28,	2,13	,"ENT"},
/*  58:   Ctrl_L */	{	58,	3,0	,"CTL"},
/*  30:   A */		{	30,	3,1	," A "},
/*  31:   S */		{	31,	3,2	," S "},
/*  32:   D */		{	32,	3,3	," D "},
/*  33:   F */		{	33,	3,4	," F "},
/*  34:   G */		{	34,	3,5	," G "},
/*  35:   H */		{	35,	3,6	," H "},
/*  36:   J */		{	36,	3,7	," J "},
/*  37:   K */		{	37,	3,8	," K "},
/*  38:   L */		{	38,	3,9	," L "},
/*  39:   ;+ */		{	39,	3,10	,";+ "},
/*  40:   :* */		{	40,	3,11	,":* "},
/*  43:   ]} */		{	43,	3,12	," ] "},
/*  42:   Shift_L */	{	42,	4,0	,"SFT"},
/*  44:   Z */		{	44,	4,1	," Z "},
/*  45:   X */		{	45,	4,2	," X "},
/*  46:   C */		{	46,	4,3	," C "},
/*  47:   V */		{	47,	4,4	," V "},
/*  48:   B */		{	48,	4,5	," B "},
/*  49:   N */		{	49,	4,6	," N "},	
/*  50:   M */		{	50,	4,7	," M "},
/*  51:   ,< */		{	51,	4,8	,",< "},
/*  52:   .> */		{	52,	4,9	,".> "},
/*  53:   /? */		{	53,	4,10	,"/? "},
/* 115:   \_ */		{	115,	4,11	,"\\_ "},
/*  95:   UP */		{	95,	4,12	,"UP "},
/*  54:   Shift_R */	{	54,	4,13	,"SFT"},
/*  29:   Caps_Lock */	{	29,	5,0	,"CL "},
/*  56:   Alt_L */	{	56,	5,1	,"ALT"},
/*  57:   SPACE */	{	57,	5,6	,"SP "},
/*  97:   Left */	{	97,	5,10	,"LFT"},
/* 100:   Down */	{	100,	5,11	,"DWN"},
/*  98:   Right */	{	98,	5,12	,"RIT"},
};

struct key keys_us[] = {
/*   1:   ESC */	{	1,	0,0	,"ESC"},
/*  41:   `   */	{	41,	0,1	," ` "},
/*  59:   F1 */		{	59,	0,2	,"F1 "},
/*  60:   F2 */		{	60,	0,3	,"F2 "},
/*  61:   F3 */		{	61,	0,4	,"F3 "},
/*  62:   F4 */		{	62,	0,5	,"F4 "},
/*  63:   F5 */		{	63,	0,6	,"F5 "},
/*  64:   F6 */		{	64,	0,7	,"F6 "},
/*  65:   F7 */		{	65,	0,8	,"F7 "},
/*  66:   F8 */		{	66,	0,9	,"F8 "},
/*  67:   F9 */		{	67,	0,10	,"F9 "},
/*  69:   F10 */	{	68,	0,11	,"F10"},
/*  96:   PgUp */	{	96,	0,12	,"PgU"},
/* 101:   PgDown */	{	101,	0,13	,"PgD"},
/* 103:   Del */	{	103,	0,14	,"Del"},
/*   2:   1 */		{	2,	1,0	,"1! "},
/*   3:   2 */		{	3,	1,1	,"2@ "},
/*   4:   3 */		{	4,	1,2	,"3# "},
/*   5:   4 */		{	5,	1,3	,"4$ "},
/*   6:   5 */		{	6,	1,4	,"5% "},
/*   7:   6 */		{	7,	1,5	,"6^ "},
/*   8:   7 */		{	8,	1,6	,"7& "},
/*   9:   8 */		{	9,	1,7	,"8* "},
/*  10:   9 */		{	10,	1,8	,"9( "},
/*  11:   0 */		{	11,	1,9	,"0)"},
/*  12:   -  */		{	12,	1,10	,"-_ "},
/*  13:   = */		{	13,	1,11	,"=+ "},
/*  43:   \| */		{	43,	1,12	,"\\| "},
/*  14:   BS */		{	14,	1,13	,"BS "},
/*  15:   TAB */	{	15,	2,0	,"TAB"},
/*  16:   Q */		{	16,	2,1	," Q "},
/*  17:   W */		{	17,	2,2	," W "},
/*  18:   E */		{	18,	2,3	," E "},
/*  19:   R */		{	19,	2,4	," R "},
/*  20:   T */		{	20,	2,5	," T "},
/*  21:   Y */		{	21,	2,6	," Y "},
/*  22:   U */		{	22,	2,7	," U "},
/*  23:   I */		{	23,	2,8	," I "},
/*  24:   O */		{	24,	2,9	," O "},
/*  25:   P */		{	25,	2,10	," P "},
/*  26:   [ */		{	26,	2,11	," [ "},
/*  27:   ] */		{	27,	2,12	," ] "},
/*  28:   ENTER */	{	28,	2,13	,"ENT"},
/*  58:   Ctrl_L */	{	58,	3,0	,"CTL"},
/*  30:   A */		{	30,	3,1	," A "},
/*  31:   S */		{	31,	3,2	," S "},
/*  32:   D */		{	32,	3,3	," D "},
/*  33:   F */		{	33,	3,4	," F "},
/*  34:   G */		{	34,	3,5	," G "},
/*  35:   H */		{	35,	3,6	," H "},
/*  36:   J */		{	36,	3,7	," J "},
/*  37:   K */		{	37,	3,8	," K "},
/*  38:   L */		{	38,	3,9	," L "},
/*  39:   ; */		{	39,	3,10	,";: "},
/*  40:   : */		{	40,	3,11	,",\" "},
/*  42:   Shift_L */	{	42,	4,0	,"SFT"},
/*  44:   Z */		{	44,	4,1	," Z "},
/*  45:   X */		{	45,	4,2	," X "},
/*  46:   C */		{	46,	4,3	," C "},
/*  47:   V */		{	47,	4,4	," V "},
/*  48:   B */		{	48,	4,5	," B "},
/*  49:   N */		{	49,	4,6	," N "},	
/*  50:   M */		{	50,	4,7	," M "},
/*  51:   ,< */		{	51,	4,8	,",< "},
/*  52:   .> */		{	52,	4,9	,".> "},
/*  53:   /? */		{	53,	4,10	,"/? "},
/*  95:   UP */		{	95,	4,12	,"UP "},
/*  54:   Shift_R */	{	54,	4,13	,"SFT"},
/*  29:   Caps_Lock */	{	29,	5,0	,"CL "},
/*  56:   Alt_L */	{	56,	5,1	,"ALT"},
/*  57:   SPACE */	{	57,	5,6	,"SP "},
/*  97:   Left */	{	97,	5,10	,"LFT"},
/* 100:   Down */	{	100,	5,11	,"DWN"},
/*  98:   Right */	{	98,	5,12	,"RIT"},
};

struct key *keys;
int key_num;

int code_2_key[256];

int main(argc,argv) int argc; char *argv[]; {
	char buf[256];
	char sym1[32],sym2[32],sym3[32];
	struct textscreen *t;
	int c;
	int i;
	int x,y;
	int us = 0,jp = 0;
	if ((argc > 1) && (!strcmp(argv[1],"us"))) {
		us = 1;
	}
	if ((argc > 1) && (!strcmp(argv[1],"jp"))) {
		jp = 1;
	}

	open_graph();
	set_font(12,0);
	set_color(COLOR_WHITE);
	clear_screen();

	keys = keys_jp;
	key_num = sizeof(keys_jp)/sizeof(keys_jp[0]); 

        mgl_get_keymap(MGL_KEY_2,sym1,sym2,sym3);
	if (!us && !jp) {
		if (!strcmp(sym1,"2") && (!strcmp(sym2,"at")))
			us = 1;
		else
			jp = 1;
	}
	if (us) {
		keys = keys_us;
		key_num = sizeof(keys_us)/sizeof(keys_us[0]); 
	}

	for (i=0; i<256; i++) {
		code_2_key[i] = -1;
	}
	set_color(COLOR_BLACK);
	for (i=0; i< key_num; i++) {
		code_2_key[keys[i].code] = i;
		x = keys[i].x;
		y = keys[i].y;
		draw_rect(10 + x * 30,30 + y * 20, 30, 20); 
		draw_string(10 + x * 30 + 2, 30 + y * 20 + 4, keys[i].ident, DIR_NORTH);
	}
	set_color(COLOR_BLACK);
	mgl_set_keymode(MGL_SK_RAW);

	while (1) {
		c = get_key(-1);
		sprintf(buf,"* %03d *  button %d",c & 0x7f,mgl_button_shift);
		set_color(COLOR_WHITE);
		fill_rect(0,0,180,16);
		set_color(COLOR_BLACK);
		draw_string(0,0,buf,DIR_NORTH);
		//printf("%3d %s\n",c & 0x7f,(c & 0x80)?"Release":"Press");
		i = code_2_key[c & 0x7f];
		if (i >= 0) {
			x = keys[i].x;
			y = keys[i].y;
			set_color((c & 0x80)?COLOR_LIGHTGRAY:COLOR_BLACK);
			fill_rect(10 + x * 30+1,30 + y * 20+1, 30-2, 20-2); 
			set_color((c & 0x80)?COLOR_BLACK:COLOR_WHITE);
			draw_string(10 + x * 30 + 2, 30 + y * 20 + 4, keys[i].ident, DIR_NORTH);
		}
		if (c == 0x81) break;
	}
}
