INSTALL=install
MAKEDEPEND=sh ../conf/mkdep.sh
INCS_X11= -I/usr/X11R6/include

ELFENV=$(shell ../conf/iself.sh)

LIBS_X11= -L/usr/X11R6/lib -lX11
ifeq (${SUPPORT_X_KEYMOUSE},y)
LIBS_X11 += -lXtst -lXext
endif

ifeq (${MGL_MACHINE},MGL_MACHINE_SVGA)
    INCS_CONS= -I/usr/local/include
    LIBS_CONS= -L/usr/local/lib -lvga
endif

ifndef LIBS_IM
    INCS_IM= -I/usr/local/include
    LIBS_IM= -L/usr/local/lib  -lcanna
endif

SHLIB_CFLAGS=-fpic -DPIC
MGLPIC_CFLAGS= ${SHLIB_CFLAGS}
ifeq (${ELFENV},1)
    SHLIB_LD=${CC}
    SHLIB_LDFLAGS = -shared
    MGLPIC_LDFLAGS= ${SHLIB_LDFLAGS} -Wl,-soname,libmgl2.so.${VER}
else
    SHLIB_LD=${LD}
    SHLIB_LDFLAGS = -Bshareable
    MGLPIC_LDFLAGS= ${SHLIB_LDFLAGS}
endif
MGLPIC_LD= ${SHLIB_LD}

DEFAULT_LIBS = 

ifdef OBJS_X11
    DEFAULT_LIBS += ${LIBS_X11}
endif
ifdef OBJS_CONS
    DEFAULT_LIBS += ${LIBS_CONS}
endif

ifdef IM_STATIC
    DEFAULT_LIBS += ${LIBS_IM}
endif

LIBS_MDATE= -lkvm

ifdef MGL_INSTALLED
    INCS_MGL = -I${MGL_HEADER_DIR}
    ifeq (${ELFENV},1)
	LIBS_MGL = -L${MGL_LIB_DIR} -lmgl2
    else
	LIBS_MGL = -L${MGL_LIB_DIR} -L/usr/X11R6/lib -L/usr/local/lib  -lmgl2
    endif
else
    INCS_MGL = -I${SRCDIR}
    LIBS_MGL = -L${SRCDIR} -lmgl2 ${DEFAULT_LIBS}
endif

ifneq (${ELFENV},1)
    SYM_PREFIX=yes
endif

PRIV_ROOT=	-o root -g bin -m 4555
PRIV_BIN=	-o bin -g bin -m 555
PRIV_KMEM=	-o bin -g kmem -m 2555
PRIV_FILE=	-o bin -g bin -m 444


