#include "mgl2.h"
#ifdef USE_OS_METHOD
#include <sys/types.h>
#include <time.h>
#include <dev/wscons/wsconsio.h>
#endif

#define MAX_DATA	4000
#define OFFSET 24

#ifndef NULL
#define NULL (void *)0
#endif

#ifdef USE_OS_METHOD
struct wsmouse_calibcoords newcalib;
#else
int data[64];
#endif

int sample_cnt;

draw_plus(struct textscreen *ts,int x,int y) {
	int c;
	int gx,gy;
	char buf[256];

	gx = gy = 0;
	set_color(COLOR_REVERSE);

	fill_rect(x-1,y-10,3,21);
	fill_rect(x-10,y-1,21,3);

	while ((c = get_key(-1)) != 033) {
		if (c == MK_V1) {	/* down */
			gx = vk_x;
			gy = vk_y;
		}
		if (c == MK_V2) {	/* up */
			break;
		}
	}

	fill_rect(x-1,y-10,3,21);
	fill_rect(x-10,y-1,21,3);

	set_color(COLOR_BLACK);
#ifdef USE_OS_METHOD
	newcalib.samples[sample_cnt].x = x;
	newcalib.samples[sample_cnt].y = y;
	newcalib.samples[sample_cnt].rawx = gx;
	newcalib.samples[sample_cnt].rawy = gy;
#else
	data[sample_cnt * 4+2   ] = x;
	data[sample_cnt * 4+2 +1] = y;
	data[sample_cnt * 4+2 +2] = gx;
	data[sample_cnt * 4+2 +3] = gy;
#endif
	sample_cnt++;
	sprintf(buf,"\n(%d,%d) -> (%d,%d)",x,y,gx,gy);
	ts_put_string(ts,buf,0);
}

main() {
	int h;
	struct textscreen *ts;
	struct virtual_key *v;
#ifdef USE_OS_METHOD
	struct wsmouse_calibcoords savecalib;
	extern int mgl_mouse_fd;
#else
	int save_data[64];
#endif
	int i,ret;

	if (!open_graph()) {
		exit(1);
	}

#ifdef USE_OS_METHOD
	ret = ioctl(mgl_mouse_fd,WSMOUSEIO_GCALIBCOORDS,&savecalib);
	if (ret < 0) {
		perror("(1)WSMOUSEIO_GCALIBCOORDS");
		exit(1);
	}
	memset(&newcalib,0,sizeof(newcalib));
	newcalib.minx = 0;
	newcalib.miny = 0;
	newcalib.maxx = SCREEN_WIDTH;
	newcalib.maxy = SCREEN_HEIGHT;
	newcalib.samplelen = WSMOUSE_CALIBCOORDS_RESET;

	ret = ioctl(mgl_mouse_fd,WSMOUSEIO_SCALIBCOORDS,&newcalib);
	if (ret < 0) {
		perror("(2)WSMOUSEIO_SCALIBCOORDS");
		exit(1);
	}
#else
	ret = mgl_calibrate_start(save_data, 64);
	if (ret < 0) {
		exit(1);
	}
#endif
	v = create_virtual_key3(0,0,MAX_DATA,MAX_DATA,
		MK_V1,MK_V0,MK_V2);
	vk_attach(NULL,v);
	ts = create_textscreen(NULL,OFFSET*2,OFFSET
			,SCREEN_WIDTH-OFFSET*4,SCREEN_HEIGHT-OFFSET*2,0);
retry:
	set_color(COLOR_WHITE);
	clear_screen();
	set_color(COLOR_BLACK);

	ts_clear(ts);
	ts_goto(ts,0,0);
	ts_put_string(ts,"֥졼Ԥޤ",0);
	ts_put_string(ts,"ܤǼ줿Ȥ򥿥åפƤ",0);

	sample_cnt = 0;
	draw_plus(ts,SCREEN_WIDTH/2,SCREEN_HEIGHT/2);
	draw_plus(ts,OFFSET,OFFSET);
	draw_plus(ts,OFFSET,SCREEN_HEIGHT-OFFSET);
	draw_plus(ts,SCREEN_WIDTH-OFFSET,SCREEN_HEIGHT-OFFSET);
	draw_plus(ts,SCREEN_WIDTH-OFFSET,OFFSET);

	set_color(COLOR_BLACK);
	ts_put_string(ts,"\nOK ʤ ꥿ ",0);
	ts_put_string(ts,"󥻥뤹ʤ ESC  ",0);
	ts_put_string(ts,"ʤϤ¾Υ򲡤Ƥ",0);
	ret = get_key(-1);
	if (ret == '\033') goto recover;
	if ((ret != '\r') && (ret != '\n')) goto retry;

#ifdef USE_OS_METHOD
	newcalib.samplelen = sample_cnt;
	ret = ioctl(mgl_mouse_fd,WSMOUSEIO_SCALIBCOORDS,&newcalib);
	if (ret < 0) {
		perror("(2)WSMOUSEIO_SCALIBCOORDS");
		goto recover;
	}
#else
	data[0] = MGL_CT_SAMPLE;
	data[1] = sample_cnt;
	if (data[0] != save_data[0]) {
		if (change_type(data,save_data[0]) < 0) goto recover;
	}
	ret = mgl_calibrate_end(data);
	if (ret < 0) goto recover;
#endif
	exit(0);
recover:
#ifdef USE_OS_METHOD
	ioctl(mgl_mouse_fd,WSMOUSEIO_SCALIBCOORDS,&savecalib);
#else
	mgl_calibrate_end(save_data);
#endif
	exit(1);
}

#include "mra.c"

change_type(int *data, int type) {
	int a,b,c,d,e,f,s;
	int i;
	s = 0x10000;

	if (type != MGL_CT_FORMULA) return -1;

	if (mra_Y_AX1_BX2_C(data+2, 4 * sizeof(int),
			data+4, 4 * sizeof(int),
			data+5, 4 * sizeof(int),
			data[1],s, &a,&b,&c) ||
	    mra_Y_AX1_BX2_C(data+3, 4 * sizeof(int),
			data+4, 4 * sizeof(int),
			data+5, 4 * sizeof(int),
			data[1],s, &d,&e,&f)) {
		return -1;
	}
	c *= s;
	f *= s;
	data[0] = MGL_CT_FORMULA;
	data[1] = 7;
	i = 2;
	data[i++] = a;
	data[i++] = b;
	data[i++] = c;
	data[i++] = d;
	data[i++] = e;
	data[i++] = f;
	data[i++] = s;
	return 0;
}
