/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2011 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: map-event.c,v 1.7 2011/01/09 01:58:25 bowkenken Exp $
***************************************************************/

/***************************************************************
* ޥåס٥
***************************************************************/

#define	MAP_EVENT_C
#include	"inc.h"

/***************************************************************/

#define	MAP_EVENT_MAX_N	(10 + ('z' - 'a' + 1))

static map_event_func_t	map_event_func[MAP_EVENT_MAX_N];
check_memory_def( check_memory_map_event_c_map_event_func )
static pos_t	map_event_pos[MAP_EVENT_MAX_N];
check_memory_def( check_memory_map_event_c_map_event_pos )

/***************************************************************
* ޥåס٥Ȥꥻå
***************************************************************/

void	reset_map_event( void )
{
	reset_map_event_func();
	reset_map_event_pos();
}

/***************************************************************
* ޥåס٥ȤΥХåꥻå
***************************************************************/

void	reset_map_event_func( void )
{
	long	i;

	for( i = 0; i < MAP_EVENT_MAX_N; i++ )
		map_event_func[i] = NULL;
}

/***************************************************************
* ޥåס٥Ȥκɸꥻå
***************************************************************/

void	reset_map_event_pos( void )
{
	long	i;

	for( i = 0; i < MAP_EVENT_MAX_N; i++ ){
		map_event_pos[i].x = MAP_DEL_X;
		map_event_pos[i].y = MAP_DEL_Y;
	}
}

/***************************************************************
* ޥåפΥ٥ȤåƥХå¹
* long x : X ɸ
* long y : Y ɸ
***************************************************************/

void	chk_map_event( long x, long y )
{
	dun_t	*dun = get_dun();

	if( !clip_pos( x, y ) )
		return;
	if( dun->map.obj.mjr[y][x] != FACE_MJR_FLOOR )
		return;

	exec_map_event( dun->map.obj.mnr[y][x], x, y );
}

/***************************************************************
* ٥ȤΥХå¹
* char mnr : ޥåס٥ȼʸ
* long x : X ɸ
* long y : Y ɸ
***************************************************************/

void	exec_map_event( char mnr, long x, long y )
{
	map_event_func_t	func;

	func = get_map_event_func( mnr );
	if( func == NULL )
		return;

	(*func)( x, y );
}

/***************************************************************
* ơ֥뤫饳ХåϿ
* map_event_tab_t *tab : ơ֥
***************************************************************/

void	set_map_event_tab( map_event_tab_t *tab )
{
	long	i;

	if( tab == NULL )
		return;

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		if( tab[i].mnr == '\0' )
			break;

		set_map_event_func( tab[i].mnr, tab[i].func );
	}
}

/***************************************************************
* ХåϿ
* char mnr : ޥåס٥ȼʸ
* map_event_func_t func : Ͽ륳Хå
* return : ϿƤХå
***************************************************************/

map_event_func_t	set_map_event_func(
	char mnr, map_event_func_t func
)
{
	long	n;
	map_event_func_t	pre;

	n = cv_face_to_map_event_n( mnr );
	if( n < 0 )
		return NULL;

	pre = map_event_func[n];
	map_event_func[n] = func;
	return pre;
}

/***************************************************************
* Хå֤
* char mnr : ޥåס٥ȼʸ
* return : ϿƤ륳Хå
***************************************************************/

map_event_func_t	get_map_event_func( char mnr )
{
	long	n;

	n = cv_face_to_map_event_n( mnr );
	if( n < 0 )
		return NULL;

	return map_event_func[n];
}

/***************************************************************
* ٥Ȥκɸ
* char mnr : ޥåס٥ȼʸ
* long x : X ɸ
* long y : Y ɸ
***************************************************************/

void	set_map_event_pos( char mnr, long x, long y )
{
	long	n;

	n = cv_face_to_map_event_n( mnr );
	if( n < 0 )
		return;

	map_event_pos[n].x = x;
	map_event_pos[n].y = y;
}

/***************************************************************
* ٥Ȥκɸ֤
* char mnr : ޥåס٥ȼʸ
* return : ٥Ȥκɸ
***************************************************************/

pos_t	get_map_event_pos( char mnr )
{
	long	n;
	pos_t	pos;

	pos.x = MAP_DEL_X;
	pos.y = MAP_DEL_Y;

	n = cv_face_to_map_event_n( mnr );
	if( n < 0 )
		return pos;

	return map_event_pos[n];
}

/***************************************************************
* ʸ饤٥ֹѴ
* char mnr : ޥåס٥ȼʸ
* return : ٥ֹ
***************************************************************/

long	cv_face_to_map_event_n( char mnr )
{
	long	n;

	if( ('0' <= mnr) && (mnr <= '9') )
		n = mnr - '0';
	else if( ('a' <= mnr) && (mnr <= 'z') )
		n = mnr - 'a' + 10;
	else
		return -1;

	if( n < 0 )
		return -1;
	if( n >= MAP_EVENT_MAX_N )
		return -1;

	return n;
}

/***************************************************************
* ꡼å
***************************************************************/

void	check_memory_map_event_c( void )
{
	check_memory( check_memory_map_event_c_map_event_func,
			"map-event.c: map_event_func" );
	check_memory( check_memory_map_event_c_map_event_pos,
			"map-event.c: map_event_pos" );
}
