/* $Id: gic_debug.h,v 1.5 2004/10/16 21:26:42 cegger Exp $
******************************************************************************

   LibGIC debugging macros

   Copyright (C) 1998	Marcus Sundberg		[marcus@ggi-project.org]
   Copyright (C) 1999	Andreas Beck		[becka@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_INTERNAL_GIC_DEBUG_H
#define _GGI_INTERNAL_GIC_DEBUG_H

#include <stdio.h>
#include <stdarg.h>


__BEGIN_DECLS

/* Exported variables */
GGIGICAPIVAR uint32  _gicDebugState;
GGIGICAPIVAR int     _gicDebugSync;
__END_DECLS

/* Debugging types
 * bit 0 is reserved! */

#define GICDEBUG_CORE		(1<<1)	/*   2 */
#define GICDEBUG_MISC		(1<<5)	/*  32 */
#define GICDEBUG_LIBS		(1<<6)	/*  64 */
#define GICDEBUG_EVENTS		(1<<7)	/* 128 */

#define GICDEBUG_ALL	0xffffffff

#ifdef __GNUC__

#ifdef DEBUG
#define GICDPRINT(args...)	  if (_gicDebugState) { ggDPrintf(_gicDebugSync,"LibGIC",args); }
#define GICDPRINT_CORE(args...)   if (_gicDebugState & GICDEBUG_CORE) { ggDPrintf(_gicDebugSync,"LibGIC",args); }
#define GICDPRINT_MISC(args...)   if (_gicDebugState & GICDEBUG_MISC) { ggDPrintf(_gicDebugSync,"LibGIC",args); }
#define GICDPRINT_LIBS(args...)	  if (_gicDebugState & GICDEBUG_LIBS) { ggDPrintf(_gicDebugSync,"LibGIC",args); }
#define GICDPRINT_EVENTS(args...) if (_gicDebugState & GICDEBUG_EVENTS) { ggDPrintf(_gicDebugSync,"LibGIC",args); }
#else /* DEBUG */
#define GICDPRINT(args...)		do{}while(0)
#define GICDPRINT_CORE(args...)		do{}while(0)
#define GICDPRINT_MISC(args...)		do{}while(0)
#define GICDPRINT_LIBS(args...)		do{}while(0)
#define GICDPRINT_EVENTS(args...)	do{}while(0)
#endif /* DEBUG */

#else /* __GNUC__ */

static inline void GICDPRINT(const char *form,...)
{
#ifdef DEBUG
	if (_gicDebugState) {
		va_list args;

		fprintf(stderr, "LibGIC: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gicDebugSync) fflush(stderr);
	}
#endif
}

static inline void GICDPRINT_CORE(const char *form,...)
{
#ifdef DEBUG
	if (_gicDebugState & GICDEBUG_CORE) {
		va_list args;

		fprintf(stderr, "LibGIC: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gicDebugSync) fflush(stderr);
	}
#endif
}

static inline void GICDPRINT_MISC(const char *form,...)
{
#ifdef DEBUG
	if (_gicDebugState & GICDEBUG_MISC) {
		va_list args;

		fprintf(stderr, "LibGIC: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gicDebugSync) fflush(stderr);
	}
#endif
}

static inline void GICDPRINT_LIBS(const char *form,...)
{
#ifdef DEBUG
	if (_gicDebugState & GICDEBUG_LIBS) {
		va_list args;

		fprintf(stderr, "LibGIC: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gicDebugSync) fflush(stderr);
	}
#endif
}

static inline void GICDPRINT_EVENTS(const char *form,...)
{
#ifdef DEBUG
	if (_gicDebugState & GICDEBUG_EVENTS) {
		va_list args;

		fprintf(stderr, "LibGIC: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gicDebugSync) fflush(stderr);
	}
#endif
}

#endif /* __GNUC__ */

#ifdef DEBUG
#define LIBGIC_ASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"LIBGIC:%s:%d: INTERNAL ERROR: %s\n",__FILE__,__LINE__,str); \
	exit(1); \
} }
#define LIBGIC_APPASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"LIBGIC:%s:%d: APPLICATION ERROR: %s\n",__FILE__,__LINE__,str); \
	exit(1); \
} }
#else /* DEBUG */
#define LIBGIC_ASSERT(x,str)	do{}while(0)
#define LIBGIC_APPASSERT(x,str)	do{}while(0)
#endif /* DEBUG */

#endif /* _GGI_INTERNAL_GIC_DEBUG_H */
