/**
 * @file module.h Module API
 * 
 * $Id: curl.c,v 1.8 2003/01/01 06:22:34 chipx86 Exp $
 *
 * @Copyright (C) 2001-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libcomprex/internal.h>

#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>

static CxStatus
schemeGet(const char *scheme, const char *path, const char *outFilename)
{
	FILE     *fp;
	CURL     *curl;
	CURLcode  res;
	char     *url;

	MEM_CHECK(url = (char *)malloc((strlen(scheme) + strlen(path) + 2) *
								   sizeof(char)));

	sprintf(url, "%s:%s", scheme, path);

	fp = fopen(outFilename, "w");

	if (fp == NULL)
		return CX_ERROR;
	
	curl = curl_easy_init();
	
	if (curl == NULL)
		return CX_ERROR;

	curl_easy_setopt(curl, CURLOPT_URL, url);
	curl_easy_setopt(curl, CURLOPT_NOPROGRESS, 1);
	curl_easy_setopt(curl, CURLOPT_MUTE, 1);
	curl_easy_setopt(curl, CURLOPT_FILE, fp);
	
	res = curl_easy_perform(curl);
	
	/* We should break this down a bit so we can return CX_FILE_NOT_FOUND */
	if (res != CURLE_OK)
		return CX_ERROR;
	
	fclose(fp);

	curl_easy_cleanup(curl);

	free(url);

	return CX_SUCCESS;
}

static char
schemeSupports(const char *scheme)
{
	if (!strcasecmp(scheme, "http")   ||
		!strcasecmp(scheme, "ftp")    ||
		!strcasecmp(scheme, "https")  ||
		!strcasecmp(scheme, "ftps")   ||
		!strcasecmp(scheme, "gopher") ||
		!strcasecmp(scheme, "telnet") ||
		!strcasecmp(scheme, "dict")   ||
		!strcasecmp(scheme, "ldap"))
	{
		return 1;
	}

	return 0;
}

static CxSchemeOps ops =
{
	schemeGet,        /* get      */
	schemeSupports    /* supports */
};

static void
__moduleInit(CxModuleType type)
{
}

CX_INIT_SCHEME_MODULE(curl, __moduleInit, ops)
