 /**
 * @file zip.h Zip functions and structures
 * 
 * $Id: zip.h,v 1.8 2003/01/01 06:22:34 chipx86 Exp $
 *
 * @Copyright (C) 2001-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _MOD_ZIP_H_
#define _MOD_ZIP_H_

#include "deflate.h"
#include "header.h"
#include "utils.h"
#include "extra.h"

/* Macros used to test some of the general purpose flags */
#define ZIP_IS_ENCRYPTED(x) (x & 1)
#define ZIP_COMPRESSION_LEVEL(x) ((x >> 1) & 3)
#define ZIP_HAS_DATADESCRIPTOR(x) ((x & 8))
#define ZIP_ENHANCED_DEFLATION(x) ((x & 16))
#define ZIP_FILE_IS_PATCH_DATA(x) ((x & 32))
#define ZIP_CX_IS_TYPE(x, y) ((x & y))
/* enum used to store the compression level of the archived file
 * ZIP_COMPRESSION_LEVEL will generate either be 0, 1, 2, or 3; further
 * it is useful in this context _only_ if the compression method
 * was delfation
 */
typedef enum
{
	ZIP_NORMAL_CX,
	ZIP_MAX_CX,
	ZIP_FAST_CX,
	ZIP_SUPERFAST_CX
} ZipCxLevel;

/* enum used to store the type of compression used in each archived file
 * Each file can have it's own unique compression method
 */
typedef enum 
{
	ZIP_NO_COMPRESSION,
	ZIP_SHRUNK,
	ZIP_REDUX_1,
	ZIP_REDUX_2,
	ZIP_REDUX_3,
	ZIP_REDUX_4,
	ZIP_IMPLODED,
	ZIP_TOKEN,
	ZIP_DEFLATED,
	ZIP_DEFLATE64,
	ZIP_PKWARE_IMPLODE
} ZipCxMethod;

typedef struct
{
	int startOffset;
	int curOffset;
	ZipCxMethod compression;
	size_t (*callback)(void *ptr, size_t size, size_t nmemb, CxFP *fp);
	z_stream cx_stream;
	unsigned short flag;
} ZipFile;

#endif /* _MOD_ZIP_H_ */
