/**
 * @file utils.c Ar utility functions
 * 
 * $Id: utils.c,v 1.2 2003/01/01 06:22:31 chipx86 Exp $
 *
 * @Copyright (C) 1999-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libcomprex/internal.h>
#include "ar.h"

/* ASCII Octal to Integer */
int
cxArOctalToInt(const char *oct)
{
	int i;

	sscanf(oct, "%o", &i);

	return i;
}

/* ASCII Decimal to Integer */
int
cxArDecToInt(const char *dec)
{
	int i;

	sscanf(dec, "%d", &i);

	return i;
}

