/**
 * @file showtree.c Displays the archive as a tree.
 * 
 * $Id: showtree.c,v 1.2 2003/01/01 06:22:31 chipx86 Exp $
 *
 * @Copyright (C) 2001-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libcomprex/comprex.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef WITH_LEAKBUG
# include <leakbug.h>
#endif

void
showLevel(int level)
{
	int i;

	for (i = 0; i < level; i++)
		printf("|    ");
}

void
showDirectory(CxArchive *archive, CxDirectory *dir, int level)
{
	CxDirectory *subdir;
	CxFile      *file;

	/* First the directories. */
	for (subdir = cxGetFirstSubDir(dir);
		 subdir != NULL;
		 subdir = cxGetNextDir(subdir))
	{
		showLevel(level);

		printf("|-- %s\n", cxGetDirName(subdir));

		showDirectory(archive, subdir, level + 1);
	}

	/* Then the files. */
	for (file = cxGetFirstFile(dir);
		 file != NULL;
		 file = cxGetNextFile(file))
	{
		showLevel(level);

		printf("|-- %s\n", cxGetFileName(file));
	}

	showLevel(level);
	printf("\n");
}

int
main(int argc, char **argv)
{
	CxArchive *archive;

	if (argc < 2)
	{
		printf("You must specify a filename!\n");
		exit(1);
	}
	
	archive = cxOpenArchive(argv[1]);

	if (archive == NULL)
	{
		printf("Unable to open the archive!\n");
		exit(1);
	}

	printf("/\n");
	showDirectory(archive, cxGetArchiveRoot(archive), 0);

	cxCloseArchive(archive);

	/* Clean up everything. We're done with libcomprex. */
	cxCleanup();

#ifdef WITH_LEAKBUG
	lbDumpLeaks();
#endif

	return 0;
}
