#include "buffer.h"
#include "caldate.h"
#include "error.h"
#include "getln.h"
#include "leapsecs.h"
#include "stralloc.h"
#include "strerr.h"
#include "tai.h"

/* XXX: breaks tai encapsulation */

/* XXX: output here has to be binary; DOS redirection uses ASCII */

#define FATAL "leapsecs: fatal: "

static stralloc line = {0};

void main(void)
{
  struct caldate cd;
  struct tai t;
  char x[TAI_PACK];
  long leaps = 0;
  int match = 1;

  while (match) {
    if (-1 == getln(buffer_0, &line, &match, '\n'))
      strerr_die2sys(111,FATAL,"read error: ");
    if (stralloc_starts(&line, "+"))
      if (caldate_scan(line.s + 1,&cd)) {
        t.x = (caldate_mjd(&cd) + 1) * 86400ULL + 4611686014920671114ULL + leaps++;
        tai_pack(x,&t);
        buffer_putflush(buffer_1, x, TAI_PACK);
      }
  }

  _exit(0);
}
