/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*  This file is part of jcabc2ps,
*  Copyright (C) 1996,1997,1998  Michael Methfessel
*  Copyright (C) 1999, 2001, 2002, 2003 John Chambers
*  See file jcabc2ps.c for details.
*/

#include "jcabc2ps.h"
#include "macro.h"

Macro *macrolist = 0;

Macro * parse_macro()
{	char *F="parse_macro";
	Macro *r=0, *mp;
	char *sp, *np, *vp;
	int   c, dup, i;
	V3 "%s: Line: \"%s\"\n",F,line.v V;
	sp = (line.l >1 && line.v[0] == 'U' && line.v[1] == ':') ? line.v+2 : line.v;
	while ((c = *sp) && isspace(c)) sp++;
	V3 "%s: Macro \"%s\"\n",F,sp V;
	unless (isalpha(c)) {
		V1 "Invalid macro name  \"%s\"\n",F,sp V;
		return r;
	}
	np = sp;		// Macro name
	while ((c = *sp) && isalpha(c)) sp++;
	if ((c = *sp) && (isspace(c) || c == '=')) *sp++ = 0;
	vp = sp;
	V3 "%s: Macro name \"%s\" value \"%s\"\n",F,np,vp V;
	unless (mp = (Macro*)Malloc(sizeof(Macro),"Macro")) {
		V1 "%s: ### Can't get %d bytes for Macro ###\n",F,sizeof(Macro) V;
		return 0;
	}
	setStr(&mp->name ,np,-1); V3 "%s: Macro name  \"%s\"\n",F,mp->name.v V;
	setStr(&mp->value,vp,-1); V3 "%s: Macro value \"%s\"\n",F,mp->value.v V;
	V3 "%s: Macro \"%s\"=\"%s\"\n",F,mp->name.v,mp->value.v V;
	mp->next = macrolist;	// Insert at start of macro list
	macrolist = r = mp;
	if (vb > 4) {
		V5 "Macros:\n" V;
		for (mp = macrolist; mp; mp = mp->next) {
			V5 "\t%s = \"%s\"\n",mp->name.v,mp->value.v V;
		}
	}
	return r;
}

void doMacro()
{	char *F="doMacro";
	V5 "%s: Called.\n",F V;
	V5 "%s: Not implemeted yet.\n",F V;
}
