#include "jcabc2ps.h"

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Make sure that a Str has at least n bytes allocated.
*/
Str *minStr(
	Str *sp,
	int  n)
{	Str *r=0;
	char *F="minStr";
	if (!sp) {
		V1 "%s:### minstr(%08X,%d) called ###\n",F,sp,n V;
		return 0;
	}
	if (sp->v) {
		if (n < sp->l) return sp;
		if (n < sp->m) return sp;
	}
	++ n;		// Paranoia
	if (sp->v && sp->m) {	// Was it allocated?
		sp->v = (char*)memBlock(sp->v,sp->m,n,"minStr-grow");
	} else {		// Not allocated yet
		sp->v = (char*)memBlock(0,0,n,"minStr-init");
	}
	unless (sp->v) {
		V1 "%s: ### OUT OF MEMORY (minStr can't get %d bytes) ###\n",F,n+1 V;
		return 0;
	}
	sp->m = n;		// Use the requested length as the allocated length
	return sp;
}

