#include "jcabc2ps.h"

int mempad = 0;		// Pad chars to add to mallocs

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Allocate, reallocate or free a chunk of memory.  This  is  a  debug  wrapper
* around  the  library  malloc() functions.   We now support three different ways
* of allocating memory, depending on the variable.
*/
void* memBlock(
	void*  ptr,		// Block to reallocate, if any
	size_t oldsize,	// Size of old block
	size_t newsize,	// Min size of new block
	char*  dsc)		// Description, for messages
{	void*  val=0;
	int    i;
	char*  F="memBlock";
	V3 "%s: ptr=%X oldsize=%d newsize=%d mempad=%d \"%s\"\n"
		,F,ptr,oldsize,newsize,mempad,dsc V;
	newsize += mempad;
	unless (ptr || newsize>0) return val;
	unless (dsc) dsc = "???";
	unless (ptr) {	// No old block; allocate a new one.
		if (newsize == 0) {
			V6 "%s: No old block; no new block requested.\n" V;
			return val;
		}
		V6 "%s: malloc(%d) for \"%s\"\n",newsize,dsc V;
		unless (val = (void*)malloc(newsize)) {
			V1 "%s: ### Can't get %d bytes [OUT OF MEMORY]\n",F,newsize V;
			return 0;
		}
		V6 "%s: Got %08X for \"%s\"\n",F,val,dsc V;
		bzero(val,newsize);
		return val;
	}
//	if (chkchunks) chkblock(ptr,oldsize,"old memchunk");	// Sanity test
	unless (newsize > 0) {	// Just free the old block
		free(ptr);
		return val;
	}
	V5 "%s: Enlarge: %08lX (%s) from %d to %d bytes.\n",F,ptr,dsc,oldsize,newsize V;
	unless (val = (void*)malloc(newsize)) {
		V1 "%s: ### Can't enlarge %08lX (%s) from %d to %d bytes [OUT OF MEMORY]\n",F,
			ptr,dsc,oldsize,newsize V;
		return 0;
	}
	bcopy(ptr,val,oldsize);
//	if (chkchunks) chkblock(val,newsize,"new memchunk");
	bzero(ptr+oldsize,oldsize-newsize);
	V5 "%s: Enlarged %08lX (%s) from %d to %d bytes.\n",F,ptr,dsc,oldsize,newsize V;
	free(ptr);
	V5 "%s: Return %08X newsize=%d for \"%s\"\n",F,val,newsize,dsc V;
	return val;
}

