NAME
  jcabc2ps - JC's ABC music to PostScript converter

SYNOPSIS
  jcabc2ps [option].. file..

REQUIRES

DESCRIPTION
  This is a clone of Michael Methfessel's abc2ps program, with  a  number  of
  additional  capabilities.   One  significant  change for users is that this
  version now writes to standard output by default, so you can write:
      jcabc2ps JoesJig.abc | lpr
  And, since the .abc suffix is assumed, this can be further shortened to
      jcabc2ps JoesJig | lpr
  This also greatly simplifies further processing by other PostScript  tools,
  since  jcabc2ps  may  be  used  in  pipelines  like  a normal unix "filter"
  program.

  The command line may contain one or more file names, which are scanned  for
  ABC tunes. Text outside of tunes (except for %% lines described below) will
  be ignored.  The tunes will be converted  to  conventional  muisic  "staff"
  notation  in  the form of PostScript, which may be sent to most printers or
  incorporated into documents by many word processing programs.

OPTIONS
  There are a lot of command-line options. They start with a '-' or '+' flag.
  The  original  program  was somewhat inconsistent in how it used these; the
  scheme has been simplified so that '-' now means "no" or "off" or "disable"
  and '+' means "yes" or "on" or "enable".

  Some of the options are not fully understood yet ...

    -b
       Don't break at line ends.  Lines that end  with  '\'  (backslash)  are
       considered to be continued.  (default)
    +b
       Break at line ends. All line ends are treated as end of staff, whether
       or not they end with '\'.

    -c
       Don't continue lines.  Line ends are honored as end of  staff,  unless
       they end with '\' (backslash).  (default)
    +c
       Continue lines.  Line ends are ignored, as if they all ended with '\'.
       The program generates staff breaks automatically.

    +i
       Interactive, described below.  [Interactive mode  hasn't  been  tested
       much since some of the major jcabc2ps extensions were added.]

    -o
       No postscript output.  This is useful for debugging purposes.
    +o <file>
       Output file.  Write the PostScript output to the named file.  The file
       name  may  immediately  follow  the 'o' or may be a separate argument.
       Note that this option is rarely needed, now that  jcabc2ps  writes  to
       standard output by default.

    -n
       Don't historical notes and other optional stuff.  (default)
    +n
       Print historical notes and other stuff at the bottom of each tune.

    -x
       Don't print index numbers.
    +x
       Print index numbers before the titles.

    +1
       One tune per page.

    -A
      Don't select all tunes; honor other selectors. (default)
    +A
      selects all tunes, overriding other selectors

    +a x
       Set the maximal amount of permitted  shrinking  to  x,  where  x  lies
       between 0 and 1.

    +B n
       Try to typeset with n bars on each line.
       [What is a "bar" isn't clearly understood.  More work should be done
       in this area.]

    +C
       ___

    +D <arg>
       ___

    +d <arg>
       ___

    +E
       ___

    +e selector1 selector2 ...
       Select specific tunes from the files, where each selector is a set  of
       xref  numbers or a pattern.  With -o, this will list only the selected
       tunes found in the files.  With +o, output is generated only  for  the
       selected tunes.

       To list selected tunes:
          abc2ps book1 -e 1-3 5,20- 'House*' Hall
       
       This selects xref numbers 1 to 3, 5, and 20 and above, as well  as  those
       tunes  whose  title  either  starts  with  "House" or contains the string
       "Hall". A pattern without wildcards such as 'Hall' is treated as '*Hall*'

       Optionally, the search can be done on other fields using these  flags  in
       place of -e:
          flag -R    seaches the rhythm field
          flag -C    searches the composer field
          flag -S    searches the source field.
          flag -T    seaches the title field (default)

       Thus          
          abc2ps book1 -C "John"
          selects all tunes whose composer string contains "John".
       If  the  -C  flag  is used, the composer field is also displayed when the
       file are listed.  The same goes for the flags -R and -S.

    +f
       ___

    -F
       Don't read format files. (Default is to read only "fonts.fmt".)
    +F file
       Read file.fmt and extract formatting instructions.

    +g shrink|space|stretch|fill
       sets the "glue mode". The default mode is fill, which fills the staff.
       This  flag  is useful when changing the layout parameters, to see what
       effect the changes have for each mode separately.

    +H
       Dump all the formatting options, in the form used in .fmt files.  This
       should  be placed after any F options, to show the final result.  This
       output may be written to a .fmt file for further use.

    +h
       Help. Print a summary of the command line.

    +I
       ___

    +k <arg>
       ___

    +l
       ___

    +m mmm
       sets the left margin to mmm points.

    +N
       ___

    +P
       ___

    +p
       generates pretty output, with more whitespace  between  tunes,  larger
       fonts  for  titles,  and larger music symbols.  By default, the layout
       squeezes the tunes to reduce the number of pages.

    +Q <arg>
       ___

    +q <arg>
       ___

    +R
       ___

    +S
       ___

    +s xxx
       scales the music output  by  factor  xxx.   At  present,  the  minimal
       significant  difference  in  scale  factors  is  0.05.  A scale factor
       greater than 1.00 will give very large staffs and notes.

    +T
       ___

    +t <arg>
       ___

    +V 
       shows the version number.

    +v n
       sets the verbosity for output to the screen  to  n.   -v0  gives  very
       little, -v1,v2,v3..  show successively more information.  Verbosity >=
       10 is for debugging.  The verbose output is written to stderr.

    +w www
       sets the width of the staff to www points.

    +X <arg>
       ___

    +Y <arg>
       ___

INTERACTIVE
  
  If the command list contains the flag +i, abc2ps runs in interactive  mode.
  This  makes  it  possible  to  build up an output file piece by piece.  The
  disadvantage is that you have to start over if you make a mistake.
  
  Interactive mode is started with
  
        abc2ps +i
  
  The program then prompts for input with the line
  
        select tunes:
  
  The response should be a row of arguments, which are treated in exactly the
  same  way  as in the non-interactive mode.  The only difference is that the
  input is not first run  through  the  shell,  so  that  wildcards  are  not
  expanded  and  quotes  are  not  removed.  Consequently Jig* should be used
  instead of 'Jig*' etc. when specifying strings for selection, and filenames
  must be written out in full.
  
  To exit from interactive mode, enter 'q', 'quit' or an empty input.
  
  For example, a "session" could look like this:
  
        abc2ps +i                start abc2ps interactively
        book1                    list tunes in book1.abc
        book1 -e 1-10            list tunes with xrefs 1-10 in book1
        book1 -e 1-10 -o         write these to Out.ps
        book2                    list tunes in book2.abc
        book2 -e House -o        write tunes with 'House' in the title
        quit                     exit abc2ps
  
  
  To make things easier, there are three special characters:
        ?   shows the last input used;
        !   at the start of line is substituted by the last files used;
        *   at the start of line is substituted by the last input.
  
  This means that the same effect as above can be obtained  in  shorter  form
  like this:
  
        abc2ps +i                start abc2ps interactively
        book1                    list tunes
        ! 1-10                   equivalent to 'book1 1-10'
        * -o                     equivalent to 'book1 1-10 -o'
        book2                    list tunes in book2.abc
        ! -e House -o            equivalent to 'book2 -e House -o'
        q                        exit abc2ps
  
  Note that the -e flag is not needed in the line  '*  1-10'  because  it  is
  clear that '1-10' is a selector (see above).
  
  
  Another  point  is  that  if  additional  flags  are  used  when   starting
  interactively,  these  function  as defaults for the interactive mode.  For
  example, by starting the program with
  
        abc2ps +io
  
  all selected tunes are immediately written to the output file.  The program
  usage  is  then  very  similar  to  that of abc2mtex.  Of course, it is not
  possible to list the file contents (to help choose among the  titles)  when
  using the program in this way.
  
  In interactive mode, flags +o -E can be used  as  before  to  redirect  the
  output. When switching to another output file, the previous file is closed.
  Switching back to the same file later will overwrite the file.


PARAMETERS

RETURNS
  The exit status is an indication of how the program failed. Zero means that
  it thinks it succeeded.

  [We should document the non-zero failure codes.]

BUGS

SEE ALSO

LICENSE
  This program is distributed under the  terms  of  the  GNU  General  Public
  License.  You may use the program as you wish, including selling it as part
  of a larger package of (music) software.  But you must also make the source
  code available to anyone who asks for it, or tell them where to get it.  As
  of this writing, one such place is
    http://trillian.mit.edu/~jc/music/abc/src/
  Any of the files with "jcabc2ps" in the name is a version of this program.

AUTHORS
  Michael Methfessel
  John Chambers <jc@trillian.mit.edu>

