/*-
 * Copyright (c) 2003-2004 Andrey Simonenko
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *   @(#)$Id: parser.h,v 1.2 2011/01/23 18:42:35 simon Exp $
 */

#ifndef IPA_PARSER_H
#define IPA_PARSER_H

enum {
	TOKEN_ID_SECTION_BEGIN = 0,	/*  0 | Begin of a section. */
	TOKEN_ID_SECTION_END,		/*  1 | End of a section. */
	TOKEN_ID_PARAMETER		/*  2 | A parameter. */
};

extern ipa_mem_type *m_parser;
extern char	*parser_str_buf;

extern unsigned int parser_token_id;
extern char	*parser_token;
extern char	*parser_args;
extern size_t	parser_args_len;
extern int	parser_nargs;

/*
 * Pb (parser buffer).
 */
struct parser_pb {
	SLIST_ENTRY(parser_pb) link;	/* For list building.		*/
	unsigned char	*buf;		/* Character buffer.		*/
	size_t		buf_off;	/* Current pb position.		*/
	size_t		buf_nread;	/* Number of chars in pb.	*/
	size_t		buf_size;	/* Size of buf.			*/
	char		*fname;		/* File name or NULL.		*/
	const char	*sname;		/* Symbol name or NULL.		*/
	FILE		*fp;		/* File handler or NULL.	*/
	long		foff;		/* File offset.			*/
	unsigned int	lineno;		/* Line number in a file.	*/
};

extern void	(*parser_vlogmsgx)(const char *, va_list);

extern int	parser_init(void);
extern int	parser_deinit(void);
extern int	parser_read_string(void);

extern struct parser_pb *parser_new_pb(size_t);
extern struct parser_pb *parser_pop_pb(void);
extern struct parser_pb *parser_top_pb(void);
extern int	parser_push_pb(struct parser_pb *);

extern int	parser_arg_is_str(void);
extern int	parser_buf_is_str(const char *);
extern char	*parser_strdup(char *, void *);
extern char	*parser_stringify(const char *);

extern int	parser_local_sym_add(char *, char *, int);
extern int	parser_local_sym_del(const char *);
extern int	parser_global_sym_add(char *, char *, int);
extern int	parser_global_sym_del(const char *);

#endif /* !IPA_PARSER_H */
