/*-
 * Copyright (c) 2003 Andrey Simonenko
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *   @(#)$Id: dlapi.h,v 1.2 2011/01/23 18:42:34 simon Exp $
 */

#ifndef IPA_DLAPI_H
#define IPA_DLAPI_H

#ifdef USE_LIBLTDL

/*
 * Use libtool's ltdl library.
 */

#include <ltdl.h>

typedef lt_dlhandle	dl_handle;

#define HAVE_DL_INIT
#define HAVE_DL_EXIT

#define dl_init		lt_dlinit
#define dl_exit		lt_dlexit
#define dl_open(x)	lt_dlopen(x)
#define dl_sym(x, y)	lt_dlsym((x), (y))
#define dl_close(x)	lt_dlclose(x)
#define dl_error	lt_dlerror

#else /* !USE_LIBLTDL */

/*
 * Use dlopen interface.
 */

#include <dlfcn.h>

#ifdef RTLD_LAZY
# define MY_RTLD_LAZY RTLD_LAZY
#else
# define MY_RTLD_LAZY 0
#endif /* RTLD_LAZY */

typedef void *		dl_handle;

#define dl_open(x)	dlopen((x), MY_RTLD_LAZY)
#define dl_sym(x, y)	dlsym((x), (y))
#define dl_close(x)	dlclose(x)
#define dl_error()	dlerror()

#endif /* USE_LIBLTDL */

#endif /* !IPA_DLAPI_H */
