/*-
 * Copyright (c) 2005 Andrey Simonenko
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *   @(#)$Id: ipastat_limits.h,v 1.2 2011/01/23 18:42:35 simon Exp $
 */

#ifndef IPASTAT_LIMITS_H
#define IPASTAT_LIMITS_H

#ifdef WITH_LIMITS

#ifndef LIMIT_NSIZE
# define LIMIT_NSIZE	30
#endif

#ifndef LIMIT_NALLOC
# define LIMIT_NALLOC	20
#endif

struct rule;
struct opt_rule;

#define LIMIT_FREE_NAME 0x01		/* Free 'name' in struct limit{} */

/*
 * limit{} section
 */
struct limit {
	STAILQ_ENTRY(limit) link;	/* Link for list of limits. */

	char		*name;		/* Name of this limit. */
	char		*info;		/* Info for this limit. */
	unsigned int	no;		/* Limit ordinal number. */

	const struct st_list *st_list;	/* { st_list } */

	unsigned int	free_mask;	/* LIMIT_FREE_xxx bits. */

	int		inited;		/* Set if limit was initialized. */
};

/*
 * List of all limits in one rule.
 */
STAILQ_HEAD(limits_list, limit);

/*
 * Limit in query: -q ... -l <name>
 */
struct opt_limit {
	STAILQ_ENTRY(opt_limit) link;	/* For list building. */

	const char	*name;		/* -l <name> */
	struct limit	*limit;		/* Corresponding limit structure. */

	const struct opt_st *opt_st;	/* Corresponding -s ... */

	void		 *data;		/* Opaque data. */
};

/*
 * Several limits in query: -q ... -l <name1> -l <name2> ...
 */
STAILQ_HEAD(opt_limits, opt_limit);

extern signed char dynamic_limits;

extern ipa_mzone *limit_mzone;

extern struct limit *alloc_limit(void);

extern int	init_limits(const struct opt_rule *);
extern int	deinit_limits(const struct opt_rule *);

extern void	free_limits(struct limits_list *);
extern int	copy_limits(struct rule *, const struct limits_list *);

extern int	opt_limit_add(const char *);
extern int	opt_limits_parse(const struct opt_rule *);
extern void	opt_limits_free(const struct opt_limits *);

extern struct limit *limit_by_name(const struct rule *, const char *);

#endif /* WITH_LIMITS */

extern char	has_opt_limits;

#endif /* !IPASTAT_LIMITS_H */
