/*-
 * Copyright (c) 2004 Andrey Simonenko
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *   @(#)$Id: ipactl.h,v 1.2 2011/01/23 18:42:35 simon Exp $
 */

#ifndef IPACTL_H
#define IPACTL_H

/*
 * Protocol version.
 */
#define CTL_PROTOCOL_VERSION	2

/*
 * Control commands answers codes.
 */
#define CTL_ANS_DONE			 0 /* Command succeeded.	*/
#define CTL_ANS_SYSTEM_ERROR		 1 /* System error occurred.	*/
#define CTL_ANS_WRONG_COMMAND		 2 /* Wrong command.		*/
#define CTL_ANS_ILLEGAL_NAME		 3 /* Illegal name.		*/
#define CTL_ANS_DENIED			 4 /* Command was denied.	*/
#define CTL_ANS_UNKNOWN_AUTORULE	 5 /* Unknown autorule name.	*/
#define CTL_ANS_UNKNOWN_RULE		 6 /* Unknown rule name.	*/
#define CTL_ANS_UNKNOWN_LIMIT		 7 /* Unknown limit name.	*/
#define CTL_ANS_UNKNOWN_THRESHOLD	 8 /* Unknown threshold name.	*/
#define CTL_ANS_CANNOT_MODIFY		 9 /* Cannot modify value.	*/
#define CTL_ANS_CANNOT_EXPIRE		10 /* Cannot expire limit.	*/
#define CTL_ANS_CANNOT_RESTART		11 /* Cannot restart limit.	*/
#define CTL_ANS_CANNOT_CREATE		12 /* Cannot create rule.	*/
#define CTL_ANS_CANNOT_DELETE		13 /* Cannot delete rule.	*/

#define CTL_MAX_ANS	CTL_ANS_CANNOT_DELETE

/* Max length of mzone name. */
#define CTL_MZONE_NAME_LEN	30

/* Max length of mzone description. */
#define CTL_MZONE_DESC_LEN	40

/* Max length of marray name. */
#define CTL_MARRAY_NAME_LEN	30

/* Max length of marray description. */
#define CTL_MARRAY_DESC_LEN	40

/* Max length of memory type name. */
#define CTL_MEM_TYPE_NAME_LEN	30

/* Max length of memory type description. */
#define CTL_MEM_TYPE_DESC_LEN	40

/*
 * Control commands query codes.
 */
#define CTL_CMD_STATUS			0
#define CTL_CMD_MEMORY			1
#define CTL_CMD_DUMP			2
#define CTL_CMD_FREEZE			3
#define CTL_CMD_RESTART			4
#define CTL_CMD_EXPIRE			5
#define CTL_CMD_SET			6
#define CTL_CMD_CREATE			7
#define CTL_CMD_DELETE			8

#define CTL_MAX_CMD	CTL_CMD_DELETE

#define CTL_CFLAG_WAIT			0x0001
#define CTL_CFLAG_AUTORULE		0x0002
#define CTL_CFLAG_RULE			0x0004
#define CTL_CFLAG_LIMIT			0x0008
#define CTL_CFLAG_THRESHOLD		0x0010
#define CTL_CFLAG_VALUE1		0x0020
#define CTL_CFLAG_VALUE1_INC		0x0040
#define CTL_CFLAG_VALUE1_DEC		0x0080
#define CTL_CFLAG_VALUE2		0x0100
#define CTL_CFLAG_VALUE2_INC		0x0200
#define CTL_CFLAG_VALUE2_DEC		0x0400

#define CTL_ALL_CFLAGS (	  \
	CTL_CFLAG_WAIT		| \
	CTL_CFLAG_AUTORULE	| \
	CTL_CFLAG_RULE		| \
	CTL_CFLAG_LIMIT		| \
	CTL_CFLAG_THRESHOLD	| \
	CTL_CFLAG_VALUE1	| \
	CTL_CFLAG_VALUE1_INC	| \
	CTL_CFLAG_VALUE1_DEC	| \
	CTL_CFLAG_VALUE2	| \
	CTL_CFLAG_VALUE2_INC	| \
	CTL_CFLAG_VALUE2_DEC)

/*
 * Control command query.
 */
struct ctl_cmdq {
	unsigned int	ver;		/* Version of protocol.		*/
	unsigned int	cmd;		/* Command code.		*/
	unsigned int	flags;		/* Command flags.		*/
	size_t		size;		/* Size of next data.		*/
};

struct ctl_cmdq_val {
	uint64_t	value1;		/* Value1.			*/
	uint64_t	value2;		/* Value2.			*/
};

/*
 * Control command answer.
 */
struct ctl_cmda {
	unsigned int	result;		/* Result of control command.	*/
	size_t		size;		/* Size of next data.		*/
};

struct ctl_cmda_all_status {
	unsigned int	nac_mods;	/* Number of ac_mods.		*/
	unsigned int	ndb_mods;	/* Number of db_mods.		*/
	unsigned int	nautorules;	/* Number of autorules.		*/
	unsigned int	nstatrules;	/* Number of static rules.	*/
	unsigned int	ndynrules;	/* Number of dynamic rules.	*/
	unsigned int	nstatlimits;	/* Number of static limits.	*/
	unsigned int	ndynlimits;	/* Number of dynamic limits.	*/
	unsigned int	nstatsublimits;	/* Number of static sublimits.	*/
	unsigned int	ndynsublimits;	/* Number of dynamic sublimits.	*/
	unsigned int	nstatthresholds;/* Number of static thresholds.	*/
	unsigned int	ndynthresholds;	/* Number of dynamic thresholds.*/
};

struct ctl_cmda_autorule_status {
	unsigned int	nrules;		/* Number of its dynamic rules.	*/
	char		active;		/* Set if active.		*/
};

struct ctl_cmda_rule_status {
	unsigned int	nlimits;	/* Number of limits.		*/
	unsigned int	nsublimits;	/* Number of sublimits.		*/
	unsigned int	nthresholds;	/* Number of thresholds.	*/
	char		dynamic;	/* Set if dynamic.		*/
	char		active;		/* Set if active.		*/
};

struct ctl_cmda_limit_status {
	ipa_tm		tm;		/* Limit event date.		*/
	uint64_t	value1;		/* Limit value.			*/
	uint64_t	value2;		/* Limit counter.		*/
	unsigned int	nsublimits;	/* Number of sublimits.		*/
	unsigned char	value_type;	/* Type of values.		*/
	char		value2_sign;	/* Set if value2 is negative.	*/
	char		reached;	/* Set if reached.		*/
	char		dynamic;	/* Set if dynamic.		*/
	char		active;		/* Set if active.		*/
};

struct ctl_cmda_threshold_status {
	ipa_tm		tm[2];		/* Time window.			*/
	uint64_t	value1;		/* Threshold value.		*/
	uint64_t	value2;		/* Threshold counter.		*/
	uint64_t	deviation;	/* Threshold deviation.		*/
	unsigned char	value_type;	/* Type of values.		*/
	char		value2_sign;	/* Set if value2 is negative.	*/
	char		dynamic;	/* Set if dynamic.		*/
	char		active;		/* Set if active.		*/
};

struct ctl_cmda_memory {
	size_t		size;		/* Amount of allocated memory.	*/
	unsigned int	nmem_type;	/* Number of memory types.	*/
	unsigned int	nmzones;	/* Number of mzones.		*/
	unsigned int	nmarrays;	/* Number of marrays.		*/
};

struct ctl_cmda_mem_type {
	size_t		size;		/* Amount of allocated memory.	*/
	unsigned int	reqs;		/* Number of requests.		*/
	char	name[CTL_MEM_TYPE_NAME_LEN]; /* Name of memory type.	*/
	char	desc[CTL_MEM_TYPE_DESC_LEN]; /* Description.		*/
};

struct ctl_cmda_mzone {
	size_t		isize;		/* Size of one item.		*/
	size_t		pools_size;	/* Used memory by pools.	*/
	unsigned int	nused;		/* Number of used items.	*/
	unsigned int	nfree;		/* Number of free items.	*/
	unsigned int	reqs;		/* Number of requests.		*/
	char	name[CTL_MZONE_NAME_LEN]; /* Name of mzone.		*/
	char	desc[CTL_MZONE_DESC_LEN]; /* Description.		*/
};

struct ctl_cmda_marray {
	size_t		isize;		/* Size of one item.		*/
	size_t		arr_size;	/* Used memory by array.	*/
	size_t		bitmap_size;	/* Used memory by bitmap.	*/
	unsigned int	nused;		/* Number of used items.	*/
	unsigned int	nfree;		/* Number of free items.	*/
	unsigned int	reqs;		/* Number of requests.		*/
	char	name[CTL_MARRAY_NAME_LEN]; /* Name of marrays.		*/
	char	desc[CTL_MARRAY_DESC_LEN]; /* Description.		*/
};

struct ctl_cmda_set {
	uint64_t	value1;		/* Limit or threshold value.	*/
	uint64_t	value2;		/* Limit or threshold counter.	*/
	unsigned char	value_type;	/* Type of values.		*/
	char		value2_sign;	/* Set if value2 is negative.	*/
};

#endif /* !IPACTL_H */
