/*-
 * Copyright (c) 2004 Andrey Simonenko
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *  @(#)$Id: ipa_ctl.h,v 1.3 2011/01/23 18:42:34 simon Exp $
 */

#ifndef IPA_CTL_H
#define IPA_CTL_H

#include "ipactl.h"

/* ctl_socket_perm parameter default value. */
#define CTL_SOCKET_PERM_DEF	(S_IRUSR|S_IWUSR)

/* ctl_timeout parameter default value. */
#define CTL_TIMEOUT_DEF		10

/* ctl_query_max_size parameter default value. */
#define CTL_QUERY_MAX_SIZE	1024

#ifdef CTL_CHECK_CREDS

struct ctl_acl_elem {
	STAILQ_ENTRY(ctl_acl_elem) link;
	char		*user;		/* User name or NULL. */
	char		*group;		/* Group name or NULL. */
	int		allowed;	/* Set if allowed, else denied.	*/
};

struct ctl_acl_class {
	STAILQ_ENTRY(ctl_acl_class) link;
	STAILQ_HEAD(EMPTY, ctl_acl_elem) list; /* ctl_acl_elem list.	*/
	char		*class_name;	/* Class name. */
};

#define CTL_ACL_ELEM_NSIZE	10
#define CTL_ACL_ELEM_NALLOC	10

#define CTL_ACL_CLASS_NSIZE	10
#define CTL_ACL_CLASS_NALLOC	10

STAILQ_HEAD(ctl_acl_classes, ctl_acl_class);

extern ipa_mzone *ctl_acl_elem_mzone;
extern ipa_mzone *ctl_acl_class_mzone;
extern struct ctl_acl_classes ctl_acl_classes;
extern const struct ctl_acl_class *ctl_dump_acl;
extern const struct ctl_acl_class *ctl_freeze_acl;
extern const struct ctl_acl_class *ctl_stat_acl;
extern const struct ctl_acl_class *global_ctl_rule_acl;

#endif /* CTL_CHECK_CREDS */

#ifdef WITH_RULES
/*
 * Structure for "ictl" parameter.
 */
struct ictl {
	STAILQ_ENTRY(ictl) link;	/* For list building. */
	struct ctl_cmdq	cmdq;		/* Ready control query. */
	struct ctl_cmdq_val values;	/* Embedded values. */
	union {
		char	*name;		/* Rule name. */
		struct rule *ptr;	/* Pointer to rule. */
	} rule;
# ifdef WITH_LIMITS
	union {
		char	*name;		/* Limit name. */
		struct limit *ptr;	/* Pointer to limit. */
	} limit;
# endif
# ifdef WITH_THRESHOLDS
	union {
		char	*name;		/* Threshold name. */
		struct threshold *ptr;	/* Pointer to threshold. */
	} threshold;
# endif
	char		*str;		/* Command string. */
};

STAILQ_HEAD(ictl_list, ictl);

extern ipa_mzone *ictl_mzone;

extern int	setup_all_ictl(void);
extern int	run_ictl_list(const struct ictl_list *);
extern void	free_ictl_list(struct ictl_list *);

#endif /* WITH_RULES */

extern ipa_mem_type *m_ctl;

extern int	ctl_listenfd;

extern char	*ctl_socket_path;
extern mode_t	ctl_socket_perm;
extern size_t	ctl_query_max_size;
extern signed char ctl_enable;
extern signed char debug_ctl;
extern unsigned int ctl_timeout;

extern char	*ctl_socket_path_default;

extern int	init_ctl(void);
extern int	deinit_ctl(void);

extern int	ctl_query(void);
extern int	ctl_send_answer(void);

#endif /* !IPA_CTL_H */
