#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include "intel.h"



HEXFILE * open_hexfile (char *filename, char *mode)
{
	HEXFILE *fp;

	if ((fp = (HEXFILE *) malloc (sizeof (HEXFILE))) == NULL)
		return NULL;

	fp->adr = 0;
	fp->segment = 0;
	fp->checksum = 0;
	fp->dp = fp->dat;
	fp->ep = fp->dat;
	
	if (*mode == 'r')
		fp->mode = 'r';
	else
		fp->mode = 'w';
	
	if ((fp->fp = fopen (filename, mode)) == NULL) {
		free (fp);
		return NULL;
	}
	
	return fp;
}

void close_hexfile (HEXFILE * fp)
{
	fclose (fp->fp);
	free (fp);
}

int read_hexfile (HEXFILE * fp, int *data, unsigned long *adr)
{
	char ch;
	int n, x;
	int checksum, recordtype;
	unsigned long off;
	
	if (!(fp->dp < fp->ep)) {       /* Data in buffer ?? */
		/* No, fetch data */
		ch = fgetc (fp->fp);
		if (ch != ':')		/* Read ':' */
			return HEXERR;
		
		if (fscanf (fp->fp, "%02x%04lx%02x", &n, &off, &recordtype) != 3) /* read header */
			return HEXERR;
		
		checksum = (n + (off & 0xFF) + ((off >> 8) & 0xFF) + recordtype) & 0xFF;
		
		switch (recordtype) {
		case 0:		/* data record */
			fp->dp = fp->ep = fp->dat;	/* reset buffer */
			
			while (n--) {
				if (fscanf (fp->fp, "%02x", &x) != 1)	/* read data */
					return HEXERR;
				
				*fp->ep++ = x;	/* store data */
				checksum += x;
				checksum &= 0xFF;
			}
			
			if (fscanf (fp->fp, "%02x", &x) != 1)	/* read checksum */
				return HEXERR;
			
			checksum += x;
			
			if ((checksum & 0xFF) != 0)
				return HEXERR;
			
			while(isspace(ch = fgetc (fp->fp))) /* Discard \n */
				;
			
			ungetc(ch,fp->fp);
			
			fp->adr = fp->segment + off;
			break;
			
		case 1:		/* End of file record */
			if (fscanf (fp->fp, "%02x", &x) != 1)	/* checksum should be 0xFF */
				return HEXERR;
			return (x == 0xFF) ? HEXEOF : HEXERR;
			break;
			
		case 2:		/* Extended address record */
		case 4:		/* Extended linear address record */
			
			if (fscanf (fp->fp, "%04lx%02x", &fp->segment, &x) != 2)
				return HEXERR;
			
			checksum += (fp->segment & 0xFF) + (((fp->segment) >> 8) & 0xFF) + x;
			
			if ((checksum & 0xFF) != 0)
				return HEXERR;
			
			if (recordtype == 2)
				fp->segment <<= 4;
			else
				fp->segment <<= 16;
			
			while(isspace(ch = fgetc (fp->fp))) /* Discard \n */
				;
			
			ungetc(ch,fp->fp);
			
			return read_hexfile (fp, data, adr);   /* I bet you didn't expect that ! */
			break;
			
		default:		/* unknown record type */
			return HEXERR;
			break;
		}
	}
	
	*adr = fp->adr++;
	*data = *fp->dp++;
	return HEXOK;
}
