/* Copyright (c) 1990 by Carrick Sean Casey. */
/* $Id: strlist.c,v 1.13 2001/10/27 23:57:16 jwise Exp $ */
/* For copying and distribution information, see the file COPYING. */

/* routines to maintain a generic list of strings */

#include <string.h>
#include <fnmatch.h>
#include "externs.h"

void	strlinkhead (STRLIST *, STRLIST **, STRLIST **);
void	strunlink (STRLIST *, STRLIST **, STRLIST **);
STRLIST *strgetnode (char *, STRLIST *, int, int);

/* link node s to the head of the list */

void
strlinkhead(STRLIST *s, STRLIST **head, STRLIST **tail)
{
	if (*tail == 0) {
		s->prev = s->next = 0;
		*head = *tail = s;
	} else {
		(*head)->prev = s;
		s->prev = 0;
		s->next = *head;
		*head = s;
	}
}

/* unlink node s */

void
strunlink(STRLIST *s, STRLIST **head, STRLIST **tail)
{
	if (s->prev == 0)
		if (s->next) {
			*head = s->next;
			s->next->prev = 0;
		} else
			*tail = *head = 0;
	else if (s->next == 0)
		if (s->prev) {
			*tail = s->prev;
			s->prev->next = 0;
		} else
			*tail = *head = 0;
	else {
		s->prev->next = s->next;
		s->next->prev = s->prev;
	}
}

/* get the node in a STRLIST containing str */
/* if caseindep != 0, the searching is done case insensitive */
/* returns pointer on success, 0 on failure */

STRLIST *
strgetnode(char *str, STRLIST *head, int caseindep, int pattern)
{
	STRLIST *p;

	for (p = head; p; p = p->next) {
		if (!pattern) {
			if (caseindep) {
				if (!strcasecmp(str, p->str))
					break;
			} else if (!strcmp(str, p->str))
					break;
		} else if (!fnmatch(p->str, str, 0))
			break;
	}

	if (p)
		return(p);
	else
		return(0);
}
