/* return a remote connection's host name, or NULL if it */
/* can't be looked up */
/* $Id: getrname.c,v 1.24 2001/10/30 19:14:58 jwise Exp $ */
/* Copyright (c) 1988 Carrick Sean Casey. All rights reserved. */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <arpa/nameser.h>
#include <netdb.h>
#include <resolv.h>
#include <stdio.h>
#include <string.h>
#include "externs.h"

char	*getremotename (int);

char *
getremotename(int s)
{
	/* s is fd of connected socket */
	static char rname[LINE_SIZE];
	struct sockaddr_storage rs;
	socklen_t rs_size = sizeof(rs);

	/* Don't want to wast all our time in resolving stuff... */
	_res.retrans = 3;
	_res.retry = 2;

#ifdef VERBOSE
	info("retrans = %d, retry = %d, options = %ld", _res.retrans, _res.retry, _res.options);
	info("Starting hostname lookup");
#endif

	/* get address of remote user */
	/*LINTED*/
	if (getpeername(s, (struct sockaddr *)&rs, &rs_size) < 0) {
		perror("server: getpeername failed");
		return(NULL);
	}

	/*LINTED*/
	if (getnameinfo((struct sockaddr *)&rs, rs_size, rname, LINE_SIZE, NULL, 0, 0))
		rname[0]='\0';

	return(rname);
}
