/* types.h -- global data values.
 *
 * The original data structures were designed by Matthew Clegg, and
 * they made the rest of this program a lot easier.  Thank you Matt.
 */

#ifndef _BRIDGE_TYPES_H_
#define _BRIDGE_TYPES_H_
 
static char _TYPES_H_SCCSID[] = "@(#) types.h 1.2@(#)";	/* SCCS keywords */

/* constants for the player positions */ 

#define PLAYER_NORTH    0
#define PLAYER_EAST     1
#define PLAYER_SOUTH    2
#define PLAYER_WEST     3

/* Each suit is assigned an index, and each rank is also assigned an index.
 * This implicitly defines an index for each card, which is defined
 * as 13 * SUIT + RANK.
 */

/* The following constants identify the suits.  No Trump is treated as
 * a suit because it reduces the number of special cases which must be
 * handled in the bidding and the playing.
 */
 
#define SUIT_CLUBS	0
#define SUIT_DIAMONDS	1
#define SUIT_HEARTS	2
#define SUIT_SPADES	3

/* The ranks of the cards. */
#define RANK_TWO	0
#define RANK_THREE	1
#define RANK_FOUR	2
#define RANK_FIVE	3
#define RANK_SIX	4
#define RANK_SEVEN	5
#define RANK_EIGHT	6
#define RANK_NINE	7
#define RANK_TEN	8
#define RANK_JACK	9
#define RANK_QUEEN	10
#define RANK_KING	11
#define RANK_ACE	12

/* We represent both a deck of cards and a hand by an array of 52 elements,
 * where the array is indexed by card indices.  That is, to each card we
 * associate a unique integer in the range 0-51, and this "card index"
 * is used to reference an array representing a deal or a hand.  In the
 * case of a deal, the array contains thirteen elements which are 0,
 * thirteen which are 1, thirteen which are 2, and thirteen which are 3.
 * Thus an element of an array refers to the holder of that particular
 * card.  We represent a hand by an array where thirteen elements are 1
 * and the rest are 0.  Thus, an element of an array is TRUE exactly when
 * that particular card is in the hand.
 */

typedef char card_type;
typedef card_type deal [52];
typedef card_type hand [52];
 
typedef struct _point {
	int x;
	int y;
} POINT;

#ifdef _BRIDGE_
 
/* Character constants: */

char *suit_names [] =  {
	"C", "D", "H", "S", "NT"
};
char *rank_names [] =  {
	"2", "3", "4", "5", "6", "7", "8", "9", "T", "J", "Q", "K", "A"
};
 
/* The rotation of deals and vulnerabilities: */

int dealer_list [16] = {  
	PLAYER_NORTH, PLAYER_EAST, PLAYER_SOUTH, PLAYER_WEST,
	PLAYER_NORTH, PLAYER_EAST, PLAYER_SOUTH, PLAYER_WEST,
	PLAYER_NORTH, PLAYER_EAST, PLAYER_SOUTH, PLAYER_WEST,
    PLAYER_NORTH, PLAYER_EAST, PLAYER_SOUTH, PLAYER_WEST
};

int ns_vulnerability_list [16] = {
	0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0
};

int ew_vulnerability_list [16] = {
	0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 1
};

/* Mojo's print coordinates, these are a list of locations where a
 * particular suit will be printed relative to the upper left corner
 * of a single hand display.
 */

POINT suit_offsets[4][4] = {	/* [player][suit] */
	{
		{ 10, 3 },	/* [north][clubs]		*/
		{ 10, 2 },	/* [north][diamonds]	*/
		{ 10, 1 },	/* [north][hearts]		*/
		{ 10, 0 }	/* [north][spades]		*/
	}, {
		{ 15, 7 },	/* [east][clubs]		*/
		{ 15, 6 },	/* [east][diamonds]		*/
		{ 15, 5 },	/* [east][hearts]		*/
		{ 15, 4 }	/* [east][spades]		*/
	}, {
		{ 10, 11 },	/* [south][clubs]		*/
		{ 10, 10 },	/* [south][diamonds]	*/
		{ 10, 9 },	/* [south][hearts]		*/
		{ 10, 8 }	/* [south][spades]		*/
	}, {
		{ 0, 7 },	/* [west][clubs]		*/
		{ 0, 6 },	/* [west][diamonds]		*/
		{ 0, 5 },	/* [west][hearts]		*/
		{ 0, 4 }	/* [west][spades]		*/
	}
};

#else
 
/* Character constants: */
extern char *suit_names[], *rank_names[];

extern int dealer_list [], ns_vulnerability_list [], 
	ew_vulnerability_list [];

extern POINT suit_offsets[4][4];

#endif

#endif /* _TYPES_H_ */
