/* -*- Mode: C; c-basic-offset: 4 -*- */
/* GTK DBF Editor -- a simple dbf editor built with GTK+
 * Copyright (C) 2001 - 2012 Steffen Macke
 *
 * main.c: The main function
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glade/glade.h>
#include <libintl.h>

#ifdef G_OS_WIN32
#include <windows.h>
#include <stdio.h>
#endif

#include "callbacks.h"

enum
{
  DIA_DND_TYPE_URI_LIST
};

static GtkTargetEntry toolbox_target_table[] = {
  {"text/uri-list", 0, DIA_DND_TYPE_URI_LIST}
};

static guint toolbox_n_targets = (sizeof (toolbox_target_table) /
				  sizeof (toolbox_target_table[0]));

GladeXML *glade_xml;

int
main (int argc, char *argv[])
{
  gchar *path;
  gchar *gladepath;
  gchar *localedir;
  gchar *prgpath;
  GtkWidget *dbf_editor_window;

   /**
   * Locate glade file relative to executable.
   */
  path = g_path_get_dirname (argv[0]);
  if ((NULL == path) || (!g_path_is_absolute (path)))
    {
      prgpath = g_build_filename (g_get_current_dir (), argv[0], NULL);
      path = NULL;
      if (g_file_test (prgpath, G_FILE_TEST_IS_EXECUTABLE))
	{
	  path = g_path_get_dirname (prgpath);
	}
      else
	{
	  path = g_get_prgname ();
	  if (NULL != path)
	    prgpath = g_find_program_in_path (g_get_prgname ());
	  else
	    prgpath = g_find_program_in_path (argv[0]);
	  path = NULL;
	  if (NULL != prgpath)
	    path = g_path_get_dirname (prgpath);
	}
      if (NULL == path)
	{
	  g_printerr (gettext
		      ("ERROR: Could not locate gtkdbfeditor.glade."));
	  return (1);
	}
      gladepath =
	g_build_filename (path, "..", "share", "gtkdbfeditor",
			  "gtkdbfeditor.glade", NULL);
    }
  else
    gladepath =
      g_build_filename (path, "..", "share", "gtkdbfeditor",
			"gtkdbfeditor.glade", NULL);
  if (!g_file_test (gladepath, G_FILE_TEST_IS_REGULAR))
    {
      g_printerr (gettext ("ERROR: Could not locate gtkdbfeditor.glade."));
      return (1);
    }
    
  setlocale (LC_ALL, "");
  
  if (!g_file_test (LOCALEDIR, G_FILE_TEST_IS_DIR|G_FILE_TEST_EXISTS))
    {
	    localedir = g_build_filename (path, "..", "share", "locale", NULL);
  		bindtextdomain (PACKAGE, localedir);
    }
  else
    bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);
  bind_textdomain_codeset (PACKAGE, "UTF-8");


  gtk_set_locale ();
  gtk_init (&argc, &argv);

  glade_xml = glade_xml_new (gladepath, NULL, PACKAGE);
  if (NULL == glade_xml)
    {
      g_printerr (gettext ("ERROR: Could not open gtkdbfeditor.glade."));
      return (1);
    }
  glade_xml_signal_autoconnect (glade_xml);



  dbf_editor_window = glade_xml_get_widget (glade_xml, "dbf_editor_window");

  gtk_drag_dest_set (dbf_editor_window,
		     GTK_DEST_DEFAULT_ALL,
		     toolbox_target_table, toolbox_n_targets,
		     GDK_ACTION_COPY);
  g_signal_connect (GTK_OBJECT (dbf_editor_window), "drag_data_received", G_CALLBACK (dbf_dnd_file_drag_data_received), NULL);	/* userdata == NULL here intentionally */


  if (2 == argc)
    dbf_load_file (argv[1]);

  gtk_main ();
  return 0;
}


#ifdef G_OS_WIN32

#define __argc      (*__p___argc())	/* count of cmd line args */
#define __argv      (*__p___argv())	/* pointer to table of cmd line args */

int _stdcall
WinMain (struct HINSTANCE__ *hInstance,
	 struct HINSTANCE__ *hPrevInstance, char *lpszCmdLine, int nCmdShow)
{
  return main (__argc, __argv);
}

#endif
