/* -*- Mode: C; c-basic-offset: 4 -*- */
/* GTK DBF Editor -- a simple dbf editor built with GTK+
 * Copyright (C) 2001-2012 Steffen Macke
 *
 * callbacks.c: GTK+ callback handling
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdio.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "dbf.h"

/* close main window, exit application, if possible */
G_MODULE_EXPORT void
on_exit1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  application_is_closing = TRUE;
  if (dbf_can_close () == TRUE)
    {
      gtk_exit (0);
    }
}

/* close main window, exit application, if possible */
G_MODULE_EXPORT gboolean
on_dbf_editor_window_delete_event (GtkWidget * widget, GdkEvent * event,
				   gpointer user_data)
{
  application_is_closing = TRUE;
  if (dbf_can_close () == TRUE)
    {
      gtk_exit (0);
    }
  else
    {
      gtk_main ();
    }
  return FALSE;
}

/* save the dbf file */
G_MODULE_EXPORT void
on_save1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  dbf_save_file ();
}

/* display help */
G_MODULE_EXPORT void
on_help1_activate (GtkMenuItem * menuitem, gpointer user_data)
{

}

/* close the dbf file, save if necessary */
G_MODULE_EXPORT void
on_close1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *vbox_fields;

  if (dbf_can_close () == TRUE)
    {
      vbox_fields = glade_xml_get_widget (glade_xml, "vbox_fields");
      dbf_remove_widgets (GTK_BOX (vbox_fields));
      gtk_widget_reset_shapes (dbf_editor_window);
      dbf_close_file ();
      gtk_container_foreach (GTK_CONTAINER (glade_xml_get_widget (glade_xml,
								  (const gchar
								   *)
								  "hbox2")),
			     (GtkCallback) gtk_widget_set_sensitive, FALSE);
      window_display_status_message (dbf_editor_window, "");
    }
}

G_MODULE_EXPORT void
on_go_first_record_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *dbf_editor_window;

  dbf_editor_window = glade_xml_get_widget (glade_xml, "dbf_editor_window");
  dbf_display_record (dbf_editor_window, 0);
}

G_MODULE_EXPORT void
on_go_previous_record_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *dbf_editor_window;

  dbf_editor_window = glade_xml_get_widget (glade_xml, "dbf_editor_window");

  dbf_display_previous_record (dbf_editor_window);
}

G_MODULE_EXPORT void
on_go_next_record_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *dbf_editor_window;

  dbf_editor_window = glade_xml_get_widget (glade_xml, "dbf_editor_window");

  dbf_display_next_record (dbf_editor_window);
}

G_MODULE_EXPORT void
on_go_last_record_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *dbf_editor_window;

  dbf_editor_window = glade_xml_get_widget (glade_xml, "dbf_editor_window");
  dbf_display_last_record (dbf_editor_window);
}

G_MODULE_EXPORT void
on_add_record_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *dbf_editor_window;

  dbf_editor_window = glade_xml_get_widget (glade_xml, "dbf_editor_window");
  dbf_add_record (dbf_editor_window);
}

G_MODULE_EXPORT gboolean
on_entry1_focus_out_event (GtkWidget * widget, GdkEventFocus * event,
			   gpointer user_data)
{

  return FALSE;
}

G_MODULE_EXPORT void
on_button_save_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *dialog_dbf_has_changed;
  GtkWidget *vbox_fields;

  dialog_dbf_has_changed = glade_xml_get_widget (glade_xml,
						 "dialog_dbf_has_changed");
  gtk_widget_hide (dialog_dbf_has_changed);

  if (application_is_closing == TRUE)
    {
      dbf_close_file ();
      gtk_exit (0);
    }
  else
    {
      dbf_save_file ();

      vbox_fields = glade_xml_get_widget (glade_xml, "vbox_fields");
      dbf_remove_widgets (GTK_BOX (vbox_fields));
      gtk_widget_reset_shapes (dbf_editor_window);
      dbf_close_file ();
      gtk_container_foreach (GTK_CONTAINER (glade_xml_get_widget (glade_xml,
								  (const gchar
								   *)
								  "hbox2")),
			     (GtkCallback) gtk_widget_set_sensitive, FALSE);
      window_display_status_message (dbf_editor_window, "");
    }
}

G_MODULE_EXPORT void
on_button_no_save_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *dialog_dbf_has_changed;
  GtkWidget *vbox_fields;

  dialog_dbf_has_changed = glade_xml_get_widget (glade_xml,
						 "dialog_dbf_has_changed");
  gtk_widget_hide (dialog_dbf_has_changed);

  if (application_is_closing == TRUE)
    {
      gtk_exit (0);
    }
  else
    {

      vbox_fields = glade_xml_get_widget (glade_xml, "vbox_fields");
      dbf_remove_widgets (GTK_BOX (vbox_fields));
      gtk_widget_reset_shapes (dbf_editor_window);
      gtk_container_foreach (GTK_CONTAINER (glade_xml_get_widget (glade_xml,
								  (const gchar
								   *)
								  "hbox2")),
			     (GtkCallback) gtk_widget_set_sensitive, FALSE);
      window_display_status_message (dbf_editor_window, "");
      dbfh_file = NULL;
    }
}

/* cancel save and application closure */
G_MODULE_EXPORT void
on_button_cancel_save_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *dialog_dbf_has_changed;

  dialog_dbf_has_changed = glade_xml_get_widget (glade_xml,
						 "dialog_dbf_has_changed");
  gtk_widget_hide (dialog_dbf_has_changed);

  application_is_closing = FALSE;
}

G_MODULE_EXPORT void
on_Table_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWindow *table_window;

  table_window =
    GTK_WINDOW (glade_xml_get_widget (glade_xml, "table_window"));

  if (!GTK_WIDGET_VISIBLE (table_window))
    {
      gtk_widget_show (GTK_WIDGET (table_window));
    }
  else
    {
      gtk_widget_hide (GTK_WIDGET (table_window));
    }
}


G_MODULE_EXPORT void
dbf_dnd_file_drag_data_received (GtkWidget * widget,
				 GdkDragContext * context,
				 gint x,
				 gint y,
				 GtkSelectionData * data,
				 guint info, guint time)
{
  switch (context->action)
    {
    case GDK_ACTION_DEFAULT:
    case GDK_ACTION_COPY:
    case GDK_ACTION_MOVE:
    case GDK_ACTION_LINK:
    case GDK_ACTION_ASK:
    default:
      {
	gchar *sPath = NULL, *pFrom, *pTo;

	pFrom = g_strstr_len ((const gchar *) data->data, MAX_PATH, "file:");
	while (pFrom)
	  {
	    GError *error = NULL;

	    pTo = pFrom;
	    while (*pTo != 0 && *pTo != 0xd && *pTo != 0xa)
	      pTo++;
	    sPath = g_strndup (pFrom, pTo - pFrom);

	    /* format changed with Gtk+2.0, use conversion */
	    pFrom = g_filename_from_uri (sPath, NULL, &error);

	    dbf_load_file (pFrom);

	    g_free (pFrom);
	    g_free (sPath);


	    pFrom = g_strstr_len (pTo, MAX_PATH, "file:");
	  }			/* while */
	gtk_drag_finish (context, TRUE, FALSE, time);
      }
      break;
    }
  return;
}

G_MODULE_EXPORT void
on_filechooserdialog_open_show (GtkWidget * widget, gpointer user_data)
{
  GtkComboBox *combobox_encoding;
  GtkTreeIter iter;
  GtkTreeModel *model;
  GValue value = { 0 };
  gint c, column_count;

  combobox_encoding =
    GTK_COMBO_BOX (glade_xml_get_widget
		   (GLADE_XML (glade_xml), "combobox_encoding"));
  model = gtk_combo_box_get_model (combobox_encoding);
  column_count = gtk_tree_model_get_n_columns (model);
  if (gtk_tree_model_get_iter_first (model, &iter))
    {

      do
	{
	  for (c = 0; c < column_count; c++)
	    {
	      gtk_tree_model_get_value (model, &iter, c, &value);
	      if (0 ==
		  g_strncasecmp (g_value_get_string (&value), dbf_encoding,
				 255))
		{
		  gtk_combo_box_set_active_iter (combobox_encoding, &iter);
		  break;
		}
	    }
	}
      while (gtk_tree_model_iter_next (model, &iter));
    }
  if (gtk_combo_box_get_active_iter (combobox_encoding, &iter))
    {
      model = gtk_combo_box_get_model (combobox_encoding);
      gtk_tree_model_get (model, &iter, 0, &dbf_encoding, -1);
    }

}

G_MODULE_EXPORT void
on_dbf_file_selected (GtkFileChooserDialog * file_chooser, gpointer user_data)
{
  gchar *selected_filename;
  GtkComboBox *combobox_encoding;
  GtkTreeIter iter;
  GtkTreeModel *model;
  GValue value = { 0 };

  gtk_widget_hide (GTK_WIDGET (file_chooser));
  combobox_encoding =
    GTK_COMBO_BOX (glade_xml_get_widget
		   (GLADE_XML (glade_xml), "combobox_encoding"));
  if (gtk_combo_box_get_active_iter (combobox_encoding, &iter))
    {
      model = gtk_combo_box_get_model (combobox_encoding);
      gtk_tree_model_get_value (model, &iter, 0, &value);
      dbf_encoding = g_value_get_string (&value);
    }

  selected_filename
    = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (file_chooser));

  dbf_load_file (selected_filename);
}
