//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "wpt_type.h"


namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

Wpt_Type::Wpt_Type(const string &n, double lg, double lt, float a,
		   const string &c, const string &s, const string &o,
		   bool rtpoint)
  : name(n), comment(c), altitude(a), latitude(lt),
    longitude(lg), symbol(s), display_option(o), isvalid(false),
    isRoutepoint(rtpoint)
{
}


string Wpt_Type::os(void)
{
   string s;
   if(isRoutepoint)
      s  ="type=\"routepoint\"  " ;
   else
      s  ="type=\"waypoint\"  " ;
   if(name!="") s += "name=\"" +  name +  "\"  " ;
   if(comment!="") s += "comment=\"" + comment + "\"  ";
   if(altitude!=float(UNDEF_FLOAT)) s += "altitude=\"" + f2s(altitude,1) + "\"  ";
   if(latitude!=double(UNDEF_DOUBLE)) s += "latitude=\"" + GPDLineTool::d2s(latitude,5) + "\"  ";
   if(longitude!=double(UNDEF_DOUBLE)) s += "longitude=\"" + GPDLineTool::d2s(longitude,5) + "\"  ";
   if(symbol!="") s += "symbol=\"" + symbol + "\"  ";
   if(display_option!="") s += "display_option=\"" + display_option+ "\"  ";
   s+="\n";
   return s;
}

void Wpt_Type::os(ostream os)
{
   os << this->os();
}



Wpt_Type::Wpt_Type(void)
{
   clear();
}

void Wpt_Type::clear(void)
{
   isvalid = false;
   isRoutepoint=false;
   name ="";
   comment ="";
   latitude = UNDEF_DOUBLE;
   longitude = UNDEF_DOUBLE;
   symbol ="";
   display_option ="";
}


void Wpt_Type::set(Packet pk)
{
   if(pk.pid==Pid_Rte_Wpt_Data) isRoutepoint=true;
   else if(pk.pid==Pid_Wpt_Data) isRoutepoint=false;
}

Packet Wpt_Type::makePacket(void)
{
   Packet pk;
   if(isRoutepoint) pk.pid =  Pid_Rte_Wpt_Data ;
   else pk.pid =  Pid_Wpt_Data ;
   return pk;
}

void Wpt_Type::operator<<(string s)
{
   clear();
   set(s);
}

void Wpt_Type::set(string s)
{
   clear();
   setLine(s);

   string type=readValue("type");
   if(type=="routepoint") isRoutepoint=true;
   else if(type=="waypoint") isRoutepoint=false;
   
   name = readValue("name");
   comment = readValue("comment");
   altitude = s2f(readValue("altitude"));
   latitude = GPDLineTool::s2d(readValue("latitude"));
   longitude = GPDLineTool::s2d(readValue("longitude"));
   symbol = readValue("symbol");
   display_option = readValue("display_option");

}


double Wpt_Type::s2d(g_long sc)
{
   double deg;
   double conv=2;
   for(int i=1;i<=30;i++) conv*=2;

   deg = double(sc)*180/conv;
   return deg;
}

g_long Wpt_Type::d2s(double deg)
{
   g_long sc;
   double conv=2;
   for(int i=1;i<=30;i++) conv*=2;

   sc = g_long(deg*conv/double(180));
   return sc;
}


}

