//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "win32serial.h"

#ifdef HAVE_WINDOWS_H

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

Serial::Serial(void)
{
   device = "com1";   
   serial = INVALID_HANDLE_VALUE;
};


Serial::~Serial()
{
   closePort();
};

// *****************************************************************************
int Serial::writeByte(g_byte b)
{
//	cout << "try to send" << int(b) << endl;
   unsigned long len;
   if (WriteFile (serial, &b, 1, &len, NULL) == TRUE)
      return 1;
   return 0;

}


int Serial::readByte(g_byte &b)
{
   unsigned long len;
   if (ReadFile (serial, &b, 1, &len, NULL) == TRUE) 
   {	
//      cout << " received  " << int(b) << endl;
      return 1;
   }
   return -1;
}


// ******************************************************************************
void Serial::setDevice(string s)
{
   device = s;
};

void Serial::setSpeed(string s)
{
  // later 
};


int Serial::openPort()
{
   DCB portsettings;
   COMMTIMEOUTS timeouts;

   serial = CreateFile(device.c_str(),GENERIC_WRITE|GENERIC_READ,0,NULL,OPEN_EXISTING,0,NULL);
   if (serial == INVALID_HANDLE_VALUE) return -1;
  
   portsettings.DCBlength = sizeof (DCB);
   GetCommState (serial, &portsettings);
   portsettings.BaudRate = CBR_9600;
   portsettings.fBinary = TRUE;
   portsettings.fParity = TRUE;
   portsettings.fOutxCtsFlow = FALSE;
   portsettings.fOutxDsrFlow = FALSE;
   portsettings.fDtrControl = DTR_CONTROL_ENABLE;
   portsettings.fDsrSensitivity = FALSE;
   portsettings.fTXContinueOnXoff = TRUE;
   portsettings.fOutX = FALSE;
   portsettings.fInX = FALSE;
   portsettings.fErrorChar = FALSE;
   portsettings.fNull = FALSE;
   portsettings.fRtsControl = RTS_CONTROL_ENABLE;
   portsettings.fAbortOnError = FALSE;
   portsettings.ByteSize = 8;
   portsettings.Parity = NOPARITY;
   portsettings.StopBits = ONESTOPBIT;

   if (!SetCommState (serial, &portsettings)) {
      cerr <<  "Unable to set port settings!\n" << endl;
      CloseHandle(serial);
      return -2; } 

   GetCommTimeouts(serial, &timeouts);
   timeouts.ReadIntervalTimeout = V_TIME;
   timeouts.ReadTotalTimeoutConstant = 10;
   timeouts.ReadTotalTimeoutMultiplier =10;

   timeouts.WriteTotalTimeoutMultiplier = 10;
   timeouts.WriteTotalTimeoutConstant = 10;

   if (!SetCommTimeouts (serial, &timeouts)) {
      cerr <<  "Failed to set timeout values!\n" << endl ;
      CloseHandle (serial);
      return -3; }

   return 0;
}


void Serial::closePort()
{
   if (serial != INVALID_HANDLE_VALUE) 
   {
      CloseHandle(serial);
      serial = INVALID_HANDLE_VALUE; 
   }
} 


}
#endif
