//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "position.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

string Position::os(void)
{
   string s;
   s  ="type=\"position\"  " ;
   if(latitude!=double(UNDEF_DOUBLE)) s += "latitude=\"" + GPDLineTool::d2s(latitude) + "\"  ";
   if(longitude!=double(UNDEF_DOUBLE)) s += "longitude=\"" + GPDLineTool::d2s(longitude) + "\"  ";
   s+="\n";
   return s;
}

void Position::os(ostream os)
{
   os << this->os();
}


void Position::clear(void)
{
   latitude = UNDEF_DOUBLE;
   longitude = UNDEF_DOUBLE;
}

void Position::operator<<(string s)
{
   clear();
   set(s);
}


void Position::set(string s)
{
   clear();
   setLine(s);

   string type=readValue("type");
   if(type!="position") return;
   
   latitude = GPDLineTool::s2d(readValue("latitude"));
   longitude = GPDLineTool::s2d(readValue("longitude"));
}


}

