//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "gps.h"
#include "io.h"
#include "wpt_type.h"
#include "waypointlist.h"
#include "tracklist.h"
#include "date_time_type.h"

#include <string>
#include <fstream>
#include <signal.h>


using namespace std;
using namespace gpspoint2;




/// prints out help
void printHelp(void);

/// catches Signals and sets want_to_die
void signalhandler(int);

/// set by the signalhandler if SIGTERM or SIGINT comes in
int signl;

namespace gpspoint2{
extern bool quiet;
extern bool want_to_die;
}

/// main
int main(int argc, char *argv[])
{
   want_to_die=false;
   quiet = false;

   // signalhanler
   signal( SIGTERM, signalhandler );
   signal( SIGINT, signalhandler );

   Waypointlist waypointlist;
   Routelist routelist;
   Tracklist tracklist;
	Date_Time_Type datetime;

   string port="/dev/gps";
   string speed="9600";

// ########### get env Variables
	#if HAVE_STDLIB_H
	char *envvar;
	envvar=getenv("GPSPORT");
	if(envvar)
 		port=getenv("GPSPORT");
	#endif 

   string outfile="";
   string infile="";

   ostream * os;
   istream * is;

   IO io(waypointlist,routelist,tracklist);
 
   GPS gps;

// ********************************** get Options
   for(int i=0; i<argc; i++)
   {
      if (string(argv[i])=="-p" ||string(argv[i])=="--port" 
			||string(argv[i])=="-d" || string(argv[i])=="--device" ) 
         if(argc>i+1) port=argv[i+1];

      if ( string(argv[i])=="-s" ||  string(argv[i])=="--speed") 
         if(argc>i+1) speed=argv[i+1];

      if (string(argv[i])=="-q") quiet = true;

      if (string(argv[i])=="-if"|| string(argv[i])=="--input-file") 
         if(argc>i+1) infile=argv[i+1];

      if (string(argv[i])=="-of" || string(argv[i])=="--output-file" ) 
         if(argc>i+1) outfile=argv[i+1];
   }

// ********************************** set Options

   gps.setSpeed(speed);
   gps.setDevice(port);

   if(infile=="")
      is =  & cin;
   else
      is = new ifstream(infile.c_str());
      
   if(outfile=="")
      os = & cout;
   else
      os = new ofstream(outfile.c_str());
      

// *********************************** get actions

   bool
      DOWNLOAD_WAYPOINTS=false,
      DOWNLOAD_ROUTES=false,
      DOWNLOAD_TRACKS=false,
		DOWNLOAD_DATE_TIME=false,
      UPLOAD_WAYPOINTS=false,
      UPLOAD_ROUTES=false,
      UPLOAD_TRACKS=false,
      ABORT_TRANSFER=false,
      TEST=false,
      TURN_OFF=false,
      ABOUT=false,
      HELP=false, 
		PRINTVERSION=false;


   for(int i=0; i<argc; i++)
   {
      if(string(argv[i])==string("dw") || string(argv[i])==string("-dw") || string(argv[i])==string("--download-waypoints") )
         DOWNLOAD_WAYPOINTS=true;
      if(string(argv[i])==string("-uw") || string(argv[i])==string("--upload-waypoints"))
         UPLOAD_WAYPOINTS=true;
      if(string(argv[i])==string("-dr") || string(argv[i])==string("--download-routes"))
         DOWNLOAD_ROUTES=true;
      if(string(argv[i])==string("-dz") || string(argv[i])==string("--download-time"))
         DOWNLOAD_DATE_TIME=true;
      if(string(argv[i])==string("-ur") || string(argv[i])==string("--upload-routes"))
         UPLOAD_ROUTES=true;
      if(string(argv[i])==string("-dt") || string(argv[i])==string("--download-tracks"))
         DOWNLOAD_TRACKS=true;
      if(string(argv[i])==string("-ut") || string(argv[i])==string("--upload-tracks"))
         UPLOAD_TRACKS=true;
      if(string(argv[i])==string("-at") || string(argv[i])==string("--abort-transfer"))
         ABORT_TRANSFER=true;
      if(string(argv[i])==string("-i") || string(argv[i])==string("--info") ||
			string(argv[i])==string("-t") || string(argv[i])==string("--test"))
         TEST=true;
      if(string(argv[i])==string("-h") || string(argv[i])==string("--help"))
         HELP=true;
      if(string(argv[i])==string("-v") || string(argv[i])==string("--version"))
         PRINTVERSION=true;
      if(string(argv[i])==string("-o") || string(argv[i])==string("--off"))
         TURN_OFF=true;
   }

   if(!DOWNLOAD_WAYPOINTS && !UPLOAD_WAYPOINTS
      && !DOWNLOAD_ROUTES && !UPLOAD_ROUTES
      && !DOWNLOAD_TRACKS && !UPLOAD_TRACKS
		&& !DOWNLOAD_DATE_TIME
      && !ABORT_TRANSFER
      && !TEST
      && !TURN_OFF
      && !ABOUT 
		&& !PRINTVERSION
		) HELP=true;




// ********************************* action

   if(HELP) printHelp();

	if(PRINTVERSION) cerr << VERSION << endl;

   if(TEST) gps.printTest();

   if(UPLOAD_WAYPOINTS || UPLOAD_ROUTES || UPLOAD_TRACKS)
      if(!want_to_die) io << *is;

   if(UPLOAD_WAYPOINTS){
      if(!want_to_die) gps.uploadWaypoints(waypointlist);}

   if(UPLOAD_ROUTES){
      if(!want_to_die) gps.uploadRoutes(routelist);} 

   if(UPLOAD_TRACKS){
      if(!want_to_die) gps.uploadTracks(tracklist);}

   if(DOWNLOAD_WAYPOINTS) {
      if(!want_to_die) gps.downloadWaypoints(waypointlist);
      *os << waypointlist.os();}

   if(DOWNLOAD_ROUTES){
      if(!want_to_die) gps.downloadRoutes(routelist);
      *os << routelist.os();}

   if(DOWNLOAD_TRACKS){
      if(!want_to_die) gps.downloadTracks(tracklist);
      *os << tracklist.os();}

   if(DOWNLOAD_DATE_TIME){
      if(!want_to_die) gps.downloadDateTime(datetime);
      *os << datetime.os();}


   if(ABORT_TRANSFER) gps.abortTransfer();

   if(TURN_OFF){
      cerr << "turning off gps device" << endl;
      gps.turnOff();}

   if(want_to_die) cerr << endl
                        << "gpspoint interupted and terminated with signal #" 
                        << signl << endl;


	// clean
	if(outfile!="")
		delete (ofstream*) os;
	if(infile!="")
		delete (ifstream*) is;

}


// *********************************************

void printHelp(void)
{
   cerr << "   gpspoint [OPTIONS] COMMAND(S) [-if inputfile] [-of outputfile]\n" ;
   cerr << "   COMMANDS : -dw -uw -dr -ur -dt -ut -da -ua -t -o -i -h \n" ;
   cerr << "   OPTIONS : -p PORT -q " << endl;
	cerr << "   gpsoint "<< VERSION << " " <<endl; 
};


// **********************************************

void signalhandler(int parm)
{
   signl = parm;
   want_to_die = true;
}

